/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.example;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class RocketMQProducer {
    private static DefaultMQProducer producer;
    private static String firstTopic;
    private static String recvClientId;

    public static void main(String[] args) throws Exception {
        producer = new DefaultMQProducer("PID_TEST");
        producer.setNamesrvAddr(System.getenv("namesrv"));
        producer.start();
        for (int i = 0; i < 1000; ++i) {
            try {
                RocketMQProducer.sendMessage(i);
                Thread.sleep(1000L);
                RocketMQProducer.sendWithWildcardMessage(i);
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        producer.shutdown();
    }

    private static void setLmq(Message msg, Set<String> queues) {
        msg.putUserProperty("INNER_MULTI_DISPATCH", StringUtils.join((Iterable)queues.stream().map(s -> StringUtils.replace((String)s, (String)"/", (String)"%")).map(s -> "%LMQ%" + s).collect(Collectors.toSet()), (String)","));
    }

    private static void sendMessage(int i) throws MQBrokerException, RemotingException, InterruptedException, MQClientException {
        Message msg = new Message(firstTopic, "MQ2MQTT", ("MQ_" + System.currentTimeMillis() + "_" + i).getBytes(StandardCharsets.UTF_8));
        String secondTopic = "/r1";
        RocketMQProducer.setLmq(msg, new HashSet<String>(Arrays.asList(TopicUtils.wrapLmq((String)firstTopic, (String)secondTopic))));
        SendResult sendResult = producer.send(msg);
        System.out.println(RocketMQProducer.now() + "sendMessage: " + new String(msg.getBody()));
    }

    private static void sendWithWildcardMessage(int i) throws MQBrokerException, RemotingException, InterruptedException, MQClientException {
        Message msg = new Message(firstTopic, "MQ2MQTT", ("MQwc_" + System.currentTimeMillis() + "_" + i).getBytes(StandardCharsets.UTF_8));
        String secondTopic = "/r/wc";
        HashSet<String> lmqSet = new HashSet<String>();
        lmqSet.add(TopicUtils.wrapLmq((String)firstTopic, (String)secondTopic));
        lmqSet.addAll(RocketMQProducer.mapWildCardLmq(firstTopic, secondTopic));
        RocketMQProducer.setLmq(msg, lmqSet);
        SendResult sendResult = producer.send(msg);
        System.out.println(RocketMQProducer.now() + "sendWcMessage: " + new String(msg.getBody()));
    }

    private static Set<String> mapWildCardLmq(String firstTopic, String secondTopic) {
        return new HashSet<String>(Arrays.asList(TopicUtils.wrapLmq((String)firstTopic, (String)"/r/+")));
    }

    private static String now() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return sf.format(new Date()) + "\t";
    }

    static {
        firstTopic = System.getenv("firstTopic");
        recvClientId = "recv01";
    }
}

