/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent.disruptor;

import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.lmax.disruptor.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements ExceptionHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingExceptionHandler.class);

    public void handleEventException(Throwable ex, long sequence, Object event) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Exception processing: {} {}, {}.", new Object[]{sequence, event, StackTraceUtil.stackTrace(ex)});
        }
    }

    public void handleOnStartException(Throwable ex) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Exception during onStart(), {}.", (Object)StackTraceUtil.stackTrace(ex));
        }
    }

    public void handleOnShutdownException(Throwable ex) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Exception during onShutdown(), {}.", (Object)StackTraceUtil.stackTrace(ex));
        }
    }
}

