/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent;

import com.alipay.sofa.jraft.rhea.util.concurrent.AbstractRejectedExecutionHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

public class DiscardOldPolicyWithReport
extends AbstractRejectedExecutionHandler {
    public DiscardOldPolicyWithReport(String threadPoolName) {
        super(threadPoolName, false, "");
    }

    public DiscardOldPolicyWithReport(String threadPoolName, String dumpPrefixName) {
        super(threadPoolName, true, dumpPrefixName);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        LOG.error("Thread pool [{}] is exhausted! {}.", (Object)this.threadPoolName, (Object)e.toString());
        this.dumpJvmInfoIfNeeded();
        if (!e.isShutdown()) {
            BlockingQueue<Runnable> queue = e.getQueue();
            int discardSize = queue.size() >> 1;
            discardSize = discardSize <= 0 ? 1 : discardSize;
            for (int i = 0; i < discardSize; ++i) {
                queue.poll();
            }
            e.execute(r);
        }
    }
}

