/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

public final class VarInts {
    public static byte[] writeVarInt32(int value) {
        int position = 0;
        int size = VarInts.computeRawVarInt32Size(value);
        byte[] bytes = new byte[size];
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                bytes[position] = (byte)value;
                return bytes;
            }
            bytes[position++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int readVarInt32(byte[] bytes) {
        byte tmp;
        int position = 0;
        if ((tmp = bytes[position++]) >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if ((tmp = bytes[position++]) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = bytes[position++]) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = bytes[position++]) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = bytes[position++];
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (bytes[position++] < 0) continue;
                            return result;
                        }
                        throw new RuntimeException("encountered a malformed varInt");
                    }
                }
            }
        }
        return result;
    }

    public static byte[] writeVarInt64(long value) {
        int position = 0;
        int size = VarInts.computeRawVarInt64Size(value);
        byte[] bytes = new byte[size];
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                bytes[position] = (byte)value;
                return bytes;
            }
            bytes[position++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static long readVarInt64(byte[] bytes) {
        long result = 0L;
        int position = 0;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = bytes[position++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("encountered a malformed varInt");
    }

    public static int computeRawVarInt32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeRawVarInt64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value >>>= 14;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    private VarInts() {
    }
}

