/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.util.Clock;
import com.alipay.sofa.jraft.rhea.util.NetUtil;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.StringBuilderHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIdUtil {
    private static final Logger logger;
    private static final int MAX_PROCESS_ID = 0x400000;
    private static final char PID_FLAG = 'd';
    private static final String IP_16;
    private static final String PID;
    private static final long ID_BASE = 1000L;
    private static final long ID_MASK = 8191L;
    private static final AtomicLong sequence;

    public static String generateId() {
        return UniqueIdUtil.getId(IP_16, Clock.defaultClock().getTime(), UniqueIdUtil.getNextId());
    }

    private static String getHexProcessId(int pid) {
        if (pid < 0) {
            pid = 0;
        }
        if (pid > 65535) {
            String strPid = Integer.toString(pid);
            strPid = strPid.substring(strPid.length() - 4);
            pid = Integer.parseInt(strPid);
        }
        StringBuilder buf = new StringBuilder(Integer.toHexString(pid));
        while (buf.length() < 4) {
            buf.insert(0, "0");
        }
        return buf.toString();
    }

    private static int getProcessId() {
        String value;
        block6: {
            value = "";
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                value = runtime.getName();
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(), {}.", (Object)StackTraceUtil.stackTrace(t));
            }
        }
        int atIndex = value.indexOf(64);
        if (atIndex >= 0) {
            value = value.substring(0, atIndex);
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (pid < 0 || pid > 0x400000) {
            pid = ThreadLocalRandom.current().nextInt(0x400001);
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}.", (Object)value, (Object)pid);
        }
        return pid;
    }

    private static String getIp16(String ip) {
        String[] segments = ip.split("\\.");
        StringBuilder buf = StringBuilderHelper.get();
        for (String s : segments) {
            String hex = Integer.toHexString(Integer.parseInt(s));
            if (hex.length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    private static String getId(String ip16, long timestamp, long nextId) {
        return StringBuilderHelper.get().append(ip16).append(timestamp).append(nextId).append('d').append(PID).toString();
    }

    private static long getNextId() {
        return (sequence.incrementAndGet() & 0x1FFFL) + 1000L;
    }

    static {
        String pid;
        String ip16;
        logger = LoggerFactory.getLogger(UniqueIdUtil.class);
        sequence = new AtomicLong();
        try {
            String ip = NetUtil.getLocalAddress();
            ip16 = UniqueIdUtil.getIp16(ip);
        }
        catch (Throwable t) {
            ip16 = "ffffffff";
        }
        IP_16 = ip16;
        try {
            pid = UniqueIdUtil.getHexProcessId(UniqueIdUtil.getProcessId());
        }
        catch (Throwable t) {
            pid = "0000";
        }
        PID = pid;
    }
}

