/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.errors.InvalidIteratorVersion;
import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import com.alipay.sofa.jraft.rhea.storage.RocksRawKVStore;
import java.util.concurrent.locks.Lock;
import org.rocksdb.RocksIterator;

public class RocksKVIterator
implements KVIterator {
    private final RocksRawKVStore rocksRawKVStore;
    private final RocksIterator it;
    private final Lock dbReadLock;
    private final long dbVersion;

    public RocksKVIterator(RocksRawKVStore rocksRawKVStore, RocksIterator it, Lock dbReadLock, long dbVersion) {
        this.rocksRawKVStore = rocksRawKVStore;
        this.it = it;
        this.dbReadLock = dbReadLock;
        this.dbVersion = dbVersion;
    }

    @Override
    public boolean isValid() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            boolean bl = this.it.isValid();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void seekToFirst() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.seekToFirst();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void seekToLast() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.seekToLast();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void seek(byte[] target) {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.seek(target);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void seekForPrev(byte[] target) {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.seekForPrev(target);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void next() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.next();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void prev() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.prev();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public byte[] key() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            byte[] byArray = this.it.key();
            return byArray;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public byte[] value() {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            byte[] byArray = this.it.value();
            return byArray;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
        Lock readLock = this.dbReadLock;
        readLock.lock();
        try {
            this.ensureSafety();
            this.it.close();
        }
        finally {
            readLock.unlock();
        }
    }

    private void ensureSafety() {
        if (this.dbVersion != this.rocksRawKVStore.getDatabaseVersion()) {
            throw new InvalidIteratorVersion("current iterator is belong to the older version of db: " + this.dbVersion + ", the newest db version: " + this.rocksRawKVStore.getDatabaseVersion());
        }
    }
}

