/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;

public class MetricsKVClosureAdapter
implements KVStoreClosure {
    private final KVStoreClosure done;
    private final String regionId;
    private final byte kvOp;
    private final long keysCount;
    private final long bytesWritten;
    private final Timer.Context ctx;
    private final Timer.Context opCtx;

    public MetricsKVClosureAdapter(KVStoreClosure done, String regionId, byte kvOp, long keysCount, long bytesWritten, Timer.Context ctx) {
        this.done = done;
        this.regionId = regionId;
        this.kvOp = kvOp;
        this.keysCount = keysCount;
        this.bytesWritten = bytesWritten;
        this.ctx = ctx;
        this.opCtx = this.opTimeCtx(kvOp);
    }

    @Override
    public Errors getError() {
        if (this.done != null) {
            return this.done.getError();
        }
        return null;
    }

    @Override
    public void setError(Errors error) {
        if (this.done != null) {
            this.done.setError(error);
        }
    }

    @Override
    public Object getData() {
        if (this.done != null) {
            return this.done.getData();
        }
        return null;
    }

    @Override
    public void setData(Object data) {
        if (this.done != null) {
            this.done.setData(data);
        }
    }

    public void run(Status status) {
        try {
            if (this.done != null) {
                this.done.run(status);
            }
        }
        finally {
            if (status.isOk()) {
                this.doStatistics();
            }
            this.ctx.stop();
            this.opCtx.stop();
        }
    }

    private Timer.Context opTimeCtx(byte op) {
        return KVMetrics.timer("rhea-rpc-request-timer", this.regionId, KVOperation.opName(op)).time();
    }

    private void doStatistics() {
        String id = this.regionId;
        switch (this.kvOp) {
            case 1: 
            case 14: {
                KVMetrics.counter("rhea-region-keys-written", id).inc();
                KVMetrics.counter("rhea-region-bytes-written", id).inc(this.bytesWritten);
                break;
            }
            case 2: {
                KVMetrics.counter("rhea-region-keys-read", id).inc();
                byte[] bytes = (byte[])this.getData();
                if (bytes != null) {
                    KVMetrics.counter("rhea-region-bytes-read", id).inc((long)bytes.length);
                    break;
                }
                KVMetrics.counter("rhea-region-keys-written", id).inc();
                KVMetrics.counter("rhea-region-bytes-written", id).inc(this.bytesWritten);
                break;
            }
            case 3: 
            case 9: 
            case 15: {
                KVMetrics.counter("rhea-region-keys-written", id).inc();
                break;
            }
            case 4: {
                KVMetrics.counter("rhea-region-keys-written", id).inc(this.keysCount);
                KVMetrics.counter("rhea-region-bytes-written", id).inc(this.bytesWritten);
                break;
            }
            case 5: {
                break;
            }
            case 18: {
                KVMetrics.counter("rhea-region-keys-written", id).inc(this.keysCount);
                break;
            }
            case 6: 
            case 8: {
                KVMetrics.counter("rhea-region-keys-read", id).inc();
                KVMetrics.counter("rhea-region-keys-written", id).inc();
                KVMetrics.counter("rhea-region-bytes-read", id).inc(this.bytesWritten);
                KVMetrics.counter("rhea-region-bytes-written", id).inc(this.bytesWritten);
                break;
            }
            case 10: {
                KVMetrics.counter("rhea-region-keys-read", id).inc();
                byte[] data = (byte[])this.getData();
                if (data == null) break;
                KVMetrics.counter("rhea-region-bytes-read", id).inc((long)data.length);
                break;
            }
            case 11: {
                KVMetrics.counter("rhea-region-keys-read", id).inc(this.keysCount);
                Map data = (Map)this.getData();
                if (data == null) break;
                long bytesRead = 0L;
                for (byte[] bytes : data.values()) {
                    if (bytes == null) continue;
                    bytesRead += (long)bytes.length;
                }
                KVMetrics.counter("rhea-region-bytes-read", id).inc(bytesRead);
                break;
            }
            case 19: {
                KVMetrics.counter("rhea-region-keys-read", id).inc();
                break;
            }
            case 12: {
                List data = (List)this.getData();
                if (data == null) break;
                long bytesRead = 0L;
                for (KVEntry kvEntry : data) {
                    byte[] value = kvEntry.getValue();
                    if (value == null) continue;
                    bytesRead += (long)value.length;
                }
                KVMetrics.counter("rhea-region-keys-read", id).inc((long)data.size());
                KVMetrics.counter("rhea-region-bytes-read", id).inc(bytesRead);
                break;
            }
            case 13: {
                KVMetrics.counter("rhea-region-keys-read", id).inc();
                KVMetrics.counter("rhea-region-keys-written", id).inc();
                byte[] data = (byte[])this.getData();
                if (data != null) {
                    KVMetrics.counter("rhea-region-bytes-read", id).inc((long)data.length);
                }
                KVMetrics.counter("rhea-region-bytes-written", id).inc(this.bytesWritten);
                break;
            }
            case 17: {
                KVMetrics.counter("rhea-region-keys-read", id).inc();
                Boolean data = (Boolean)this.getData();
                if (data == null || !data.booleanValue()) break;
                KVMetrics.counter("rhea-region-keys-written", id).inc();
                KVMetrics.counter("rhea-region-bytes-written", id).inc(this.bytesWritten);
                break;
            }
        }
    }
}

