/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.options.MemoryDBOptions;
import com.alipay.sofa.jraft.rhea.storage.BatchRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.CASEntry;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.MemoryKVIterator;
import com.alipay.sofa.jraft.rhea.storage.MemoryKVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.Sequence;
import com.alipay.sofa.jraft.rhea.util.ByteArray;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.Pair;
import com.alipay.sofa.jraft.rhea.util.RegionHelper;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.codahale.metrics.Timer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryRawKVStore
extends BatchRawKVStore<MemoryDBOptions> {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryRawKVStore.class);
    private static final String SEQUENCE_DB = "sequenceDB";
    private static final String FENCING_KEY_DB = "fencingKeyDB";
    private static final String LOCKER_DB = "lockerDB";
    private static final String SEGMENT = "segment";
    private static final String TAIL_INDEX = "tailIndex";
    private static final byte DELIMITER = 44;
    private static final Comparator<byte[]> COMPARATOR = BytesUtil.getDefaultByteArrayComparator();
    private final ConcurrentNavigableMap<byte[], byte[]> defaultDB = new ConcurrentSkipListMap<byte[], byte[]>(COMPARATOR);
    private final Map<ByteArray, Long> sequenceDB = new ConcurrentHashMap<ByteArray, Long>();
    private final Map<ByteArray, Long> fencingKeyDB = new ConcurrentHashMap<ByteArray, Long>();
    private final Map<ByteArray, DistributedLock.Owner> lockerDB = new ConcurrentHashMap<ByteArray, DistributedLock.Owner>();
    private volatile MemoryDBOptions opts;

    public boolean init(MemoryDBOptions opts) {
        this.opts = opts;
        LOG.info("[MemoryRawKVStore] start successfully, options: {}.", (Object)opts);
        return true;
    }

    public void shutdown() {
        this.defaultDB.clear();
        this.sequenceDB.clear();
        this.fencingKeyDB.clear();
        this.lockerDB.clear();
    }

    @Override
    public KVIterator localIterator() {
        return new MemoryKVIterator(this.defaultDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(byte[] key, boolean readOnlySafe, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("GET");
        try {
            byte[] value = (byte[])this.defaultDB.get(key);
            MemoryRawKVStore.setSuccess(closure, value);
        }
        catch (Exception e) {
            LOG.error("Fail to [GET], key: [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setFailure(closure, "Fail to [GET]");
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multiGet(List<byte[]> keys, boolean readOnlySafe, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("MULTI_GET");
        try {
            HashMap<ByteArray, byte[]> resultMap = Maps.newHashMap();
            for (byte[] key : keys) {
                byte[] value = (byte[])this.defaultDB.get(key);
                if (value == null) continue;
                resultMap.put(ByteArray.wrap(key), value);
            }
            MemoryRawKVStore.setSuccess(closure, resultMap);
        }
        catch (Exception e) {
            LOG.error("Fail to [MULTI_GET], key size: [{}], {}.", (Object)keys.size(), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setFailure(closure, "Fail to [MULTI_GET]");
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void containsKey(byte[] key, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("CONTAINS_KEY");
        try {
            boolean exists = this.defaultDB.containsKey(key);
            MemoryRawKVStore.setSuccess(closure, exists);
        }
        catch (Exception e) {
            LOG.error("Fail to [CONTAINS_KEY], key: [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setFailure(closure, "Fail to [CONTAINS_KEY]");
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("SCAN");
        ArrayList<KVEntry> entries = Lists.newArrayList();
        int maxCount = this.normalizeLimit(limit);
        byte[] realStartKey = BytesUtil.nullToEmpty((byte[])startKey);
        SortedMap subMap = endKey == null ? this.defaultDB.tailMap((Object)realStartKey) : this.defaultDB.subMap((Object)realStartKey, (Object)endKey);
        try {
            for (Map.Entry entry : subMap.entrySet()) {
                entries.add(new KVEntry((byte[])entry.getKey(), returnValue ? (byte[])entry.getValue() : null));
                if (entries.size() < maxCount) continue;
                break;
            }
            MemoryRawKVStore.setSuccess(closure, entries);
        }
        catch (Exception e) {
            LOG.error("Fail to [SCAN], range: ['[{}, {})'], {}.", new Object[]{BytesUtil.toHex((byte[])startKey), BytesUtil.toHex((byte[])endKey), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setFailure(closure, "Fail to [SCAN]");
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("REVERSE_SCAN");
        ArrayList<KVEntry> entries = Lists.newArrayList();
        int maxCount = this.normalizeLimit(limit);
        byte[] realEndKey = BytesUtil.nullToEmpty((byte[])endKey);
        SortedMap subMap = startKey == null ? this.defaultDB.descendingMap().headMap(realEndKey) : this.defaultDB.descendingMap().subMap(startKey, realEndKey);
        try {
            for (Map.Entry entry : subMap.entrySet()) {
                entries.add(new KVEntry((byte[])entry.getKey(), returnValue ? (byte[])entry.getValue() : null));
                if (entries.size() < maxCount) continue;
                break;
            }
            MemoryRawKVStore.setSuccess(closure, entries);
        }
        catch (Exception e) {
            LOG.error("Fail to [REVERSE_SCAN], range: ['[{}, {})'], {}.", new Object[]{BytesUtil.toHex((byte[])startKey), BytesUtil.toHex((byte[])endKey), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setFailure(closure, "Fail to [REVERSE_SCAN]");
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSequence(byte[] seqKey, int step, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("GET_SEQUENCE");
        try {
            ByteArray wrappedKey = ByteArray.wrap(seqKey);
            Long startVal = this.sequenceDB.get(wrappedKey);
            startVal = startVal == null ? 0L : startVal;
            if (step < 0) {
                MemoryRawKVStore.setFailure(closure, "Fail to [GET_SEQUENCE], step must >= 0");
                return;
            }
            if (step == 0) {
                MemoryRawKVStore.setSuccess(closure, new Sequence(startVal, startVal));
                return;
            }
            long endVal = this.getSafeEndValueForSequence(startVal, step);
            if (startVal != endVal) {
                this.sequenceDB.put(wrappedKey, endVal);
            }
            MemoryRawKVStore.setSuccess(closure, new Sequence(startVal, endVal));
        }
        catch (Exception e) {
            LOG.error("Fail to [GET_SEQUENCE], [key = {}, step = {}], {}.", new Object[]{BytesUtil.toHex((byte[])seqKey), step, StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [GET_SEQUENCE]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSequence(byte[] seqKey, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("RESET_SEQUENCE");
        try {
            this.sequenceDB.remove(ByteArray.wrap(seqKey));
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [RESET_SEQUENCE], [key = {}], {}.", (Object)BytesUtil.toHex((byte[])seqKey), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setCriticalError(closure, "Fail to [RESET_SEQUENCE]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("PUT");
        try {
            this.defaultDB.put(key, value);
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [PUT], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [PUT]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAndPut(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("GET_PUT");
        try {
            byte[] prevVal = this.defaultDB.put(key, value);
            MemoryRawKVStore.setSuccess(closure, prevVal);
        }
        catch (Exception e) {
            LOG.error("Fail to [GET_PUT], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [GET_PUT]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compareAndPut(byte[] key, byte[] expect, byte[] update, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("COMPARE_PUT");
        try {
            byte[] actual = (byte[])this.defaultDB.get(key);
            if (Arrays.equals(expect, actual)) {
                this.defaultDB.put(key, update);
                MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
            } else {
                MemoryRawKVStore.setSuccess(closure, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            LOG.error("Fail to [COMPARE_PUT], [{}, {}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])expect), BytesUtil.toHex((byte[])update), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [COMPARE_PUT]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("MERGE");
        try {
            this.defaultDB.compute(key, (ignored, oldVal) -> {
                if (oldVal == null) {
                    return value;
                }
                byte[] newVal = new byte[((byte[])oldVal).length + 1 + value.length];
                System.arraycopy(oldVal, 0, newVal, 0, ((byte[])oldVal).length);
                newVal[oldVal.length] = 44;
                System.arraycopy(value, 0, newVal, ((byte[])oldVal).length + 1, value.length);
                return newVal;
            });
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [MERGE], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [MERGE]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(List<KVEntry> entries, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("PUT_LIST");
        try {
            for (KVEntry entry : entries) {
                this.defaultDB.put(entry.getKey(), entry.getValue());
            }
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Failed to [PUT_LIST], [size = {}], {}.", (Object)entries.size(), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setCriticalError(closure, "Fail to [PUT_LIST]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compareAndPutAll(List<CASEntry> entries, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("COMPARE_PUT_ALL");
        try {
            for (CASEntry entry : entries) {
                byte[] actual = (byte[])this.defaultDB.get(entry.getKey());
                if (Arrays.equals(entry.getExpect(), actual)) continue;
                MemoryRawKVStore.setSuccess(closure, Boolean.FALSE);
                return;
            }
            for (CASEntry entry : entries) {
                this.defaultDB.put(entry.getKey(), entry.getUpdate());
            }
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Failed to [COMPARE_PUT_ALL], [size = {}], {}.", (Object)entries.size(), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setCriticalError(closure, "Fail to [COMPARE_PUT_ALL]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putIfAbsent(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("PUT_IF_ABSENT");
        try {
            byte[] prevValue = this.defaultDB.putIfAbsent(key, value);
            MemoryRawKVStore.setSuccess(closure, prevValue);
        }
        catch (Exception e) {
            LOG.error("Fail to [PUT_IF_ABSENT], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [PUT_IF_ABSENT]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryLockWith(byte[] key, byte[] fencingKey, boolean keepLease, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("TRY_LOCK");
        try {
            DistributedLock.Owner owner;
            long now = acquirer.getLockingTimestamp();
            long timeoutMillis = acquirer.getLeaseMillis();
            ByteArray wrappedKey = ByteArray.wrap(key);
            DistributedLock.Owner prevOwner = this.lockerDB.get(wrappedKey);
            DistributedLock.OwnerBuilder builder = DistributedLock.newOwnerBuilder();
            if (prevOwner == null) {
                if (keepLease) {
                    owner = builder.id(acquirer.getId()).remainingMillis(DistributedLock.OwnerBuilder.KEEP_LEASE_FAIL).success(false).build();
                } else {
                    owner = builder.id(acquirer.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.FIRST_TIME_SUCCESS).fencingToken(this.getNextFencingToken(fencingKey)).acquires(1L).context(acquirer.getContext()).success(true).build();
                    this.lockerDB.put(wrappedKey, owner);
                }
            } else {
                long remainingMillis = prevOwner.getDeadlineMillis() - now;
                if (remainingMillis < 0L) {
                    if (keepLease) {
                        owner = builder.id(prevOwner.getId()).deadlineMillis(prevOwner.getDeadlineMillis()).remainingMillis(DistributedLock.OwnerBuilder.KEEP_LEASE_FAIL).context(prevOwner.getContext()).success(false).build();
                    } else {
                        owner = builder.id(acquirer.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.NEW_ACQUIRE_SUCCESS).fencingToken(this.getNextFencingToken(fencingKey)).acquires(1L).context(acquirer.getContext()).success(true).build();
                        this.lockerDB.put(wrappedKey, owner);
                    }
                } else {
                    boolean isReentrant = prevOwner.isSameAcquirer(acquirer);
                    if (isReentrant) {
                        if (keepLease) {
                            owner = builder.id(prevOwner.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.KEEP_LEASE_SUCCESS).fencingToken(prevOwner.getFencingToken()).acquires(prevOwner.getAcquires()).context(prevOwner.getContext()).success(true).build();
                            this.lockerDB.put(wrappedKey, owner);
                        } else {
                            owner = builder.id(prevOwner.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.REENTRANT_SUCCESS).fencingToken(prevOwner.getFencingToken()).acquires(prevOwner.getAcquires() + 1L).context(acquirer.getContext()).success(true).build();
                            this.lockerDB.put(wrappedKey, owner);
                        }
                    } else {
                        owner = builder.id(prevOwner.getId()).remainingMillis(remainingMillis).context(prevOwner.getContext()).success(false).build();
                        LOG.debug("Another locker [{}] is trying the existed lock [{}].", (Object)acquirer, (Object)prevOwner);
                    }
                }
            }
            MemoryRawKVStore.setSuccess(closure, owner);
        }
        catch (Exception e) {
            LOG.error("Fail to [TRY_LOCK], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), acquirer, StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [TRY_LOCK]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLockWith(byte[] key, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("RELEASE_LOCK");
        try {
            DistributedLock.Owner owner;
            ByteArray wrappedKey = ByteArray.wrap(key);
            DistributedLock.Owner prevOwner = this.lockerDB.get(wrappedKey);
            DistributedLock.OwnerBuilder builder = DistributedLock.newOwnerBuilder();
            if (prevOwner == null) {
                LOG.warn("Lock not exist: {}.", (Object)acquirer);
                owner = builder.id(acquirer.getId()).fencingToken(acquirer.getFencingToken()).acquires(0L).success(true).build();
            } else if (prevOwner.isSameAcquirer(acquirer)) {
                long acquires = prevOwner.getAcquires() - 1L;
                owner = builder.id(prevOwner.getId()).deadlineMillis(prevOwner.getDeadlineMillis()).fencingToken(prevOwner.getFencingToken()).acquires(acquires).context(prevOwner.getContext()).success(true).build();
                if (acquires <= 0L) {
                    this.lockerDB.remove(wrappedKey);
                } else {
                    this.lockerDB.put(wrappedKey, owner);
                }
            } else {
                owner = builder.id(prevOwner.getId()).fencingToken(prevOwner.getFencingToken()).acquires(prevOwner.getAcquires()).context(prevOwner.getContext()).success(false).build();
                LOG.warn("The lock owner is: [{}], [{}] could't release it.", (Object)prevOwner, (Object)acquirer);
            }
            MemoryRawKVStore.setSuccess(closure, owner);
        }
        catch (Exception e) {
            LOG.error("Fail to [RELEASE_LOCK], [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setCriticalError(closure, "Fail to [RELEASE_LOCK]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextFencingToken(byte[] fencingKey) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("FENCING_TOKEN");
        try {
            byte[] realKey = BytesUtil.nullToEmpty((byte[])fencingKey);
            long l = this.fencingKeyDB.compute(ByteArray.wrap(realKey), (key, prevVal) -> {
                if (prevVal == null) {
                    return 1L;
                }
                prevVal = prevVal + 1L;
                return prevVal;
            });
            return l;
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(byte[] key, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("DELETE");
        try {
            this.defaultDB.remove(key);
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [DELETE], [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setCriticalError(closure, "Fail to [DELETE]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRange(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("DELETE_RANGE");
        try {
            SortedMap subMap = this.defaultDB.subMap((Object)startKey, (Object)endKey);
            if (!subMap.isEmpty()) {
                subMap.clear();
            }
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [DELETE_RANGE], ['[{}, {})'], {}.", new Object[]{BytesUtil.toHex((byte[])startKey), BytesUtil.toHex((byte[])endKey), StackTraceUtil.stackTrace(e)});
            MemoryRawKVStore.setCriticalError(closure, "Fail to [DELETE_RANGE]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(List<byte[]> keys, KVStoreClosure closure) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("DELETE_LIST");
        try {
            for (byte[] key : keys) {
                this.defaultDB.remove(key);
            }
            MemoryRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Failed to [DELETE_LIST], [size = {}], {}.", (Object)keys.size(), (Object)StackTraceUtil.stackTrace(e));
            MemoryRawKVStore.setCriticalError(closure, "Fail to [DELETE_LIST]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getApproximateKeysInRange(byte[] startKey, byte[] endKey) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("APPROXIMATE_KEYS");
        try {
            byte[] realStartKey = BytesUtil.nullToEmpty((byte[])startKey);
            SortedMap subMap = endKey == null ? this.defaultDB.tailMap((Object)realStartKey) : this.defaultDB.subMap((Object)realStartKey, (Object)endKey);
            long l = subMap.size();
            return l;
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] jumpOver(byte[] startKey, long distance) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("JUMP_OVER");
        try {
            byte[] realStartKey = BytesUtil.nullToEmpty((byte[])startKey);
            SortedMap tailMap = this.defaultDB.tailMap((Object)realStartKey);
            if (tailMap.isEmpty()) {
                byte[] byArray = null;
                return byArray;
            }
            long approximateKeys = 0L;
            byte[] lastKey = null;
            Iterator iterator = tailMap.keySet().iterator();
            while (iterator.hasNext()) {
                byte[] key;
                lastKey = key = (byte[])iterator.next();
                if (++approximateKeys < distance) continue;
                break;
            }
            if (lastKey == null) {
                iterator = null;
                return iterator;
            }
            byte[] endKey = new byte[lastKey.length];
            System.arraycopy(lastKey, 0, endKey, 0, lastKey.length);
            byte[] byArray = endKey;
            return byArray;
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initFencingToken(byte[] parentKey, byte[] childKey) {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("INIT_FENCING_TOKEN");
        try {
            byte[] realKey = BytesUtil.nullToEmpty((byte[])parentKey);
            Long parentVal = this.fencingKeyDB.get(ByteArray.wrap(realKey));
            if (parentVal == null) {
                return;
            }
            this.fencingKeyDB.put(ByteArray.wrap(childKey), parentVal);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSnapshotSave(MemoryKVStoreSnapshotFile snapshotFile, String snapshotPath, Region region) throws Exception {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("SNAPSHOT_SAVE");
        try {
            String tempPath = snapshotPath + "_temp";
            File tempFile = new File(tempPath);
            FileUtils.deleteDirectory((File)tempFile);
            FileUtils.forceMkdir((File)tempFile);
            snapshotFile.writeToFile(tempPath, SEQUENCE_DB, new MemoryKVStoreSnapshotFile.SequenceDB(MemoryRawKVStore.subRangeMap(this.sequenceDB, region)));
            snapshotFile.writeToFile(tempPath, FENCING_KEY_DB, new MemoryKVStoreSnapshotFile.FencingKeyDB(MemoryRawKVStore.subRangeMap(this.fencingKeyDB, region)));
            snapshotFile.writeToFile(tempPath, LOCKER_DB, new MemoryKVStoreSnapshotFile.LockerDB(MemoryRawKVStore.subRangeMap(this.lockerDB, region)));
            int size = this.opts.getKeysPerSegment();
            ArrayList<Pair<byte[], byte[]>> segment = Lists.newArrayListWithCapacity(size);
            int index = 0;
            byte[] realStartKey = BytesUtil.nullToEmpty((byte[])region.getStartKey());
            byte[] endKey = region.getEndKey();
            SortedMap subMap = endKey == null ? this.defaultDB.tailMap((Object)realStartKey) : this.defaultDB.subMap((Object)realStartKey, (Object)endKey);
            for (Map.Entry entry : subMap.entrySet()) {
                segment.add(Pair.of(entry.getKey(), entry.getValue()));
                if (segment.size() < size) continue;
                snapshotFile.writeToFile(tempPath, SEGMENT + index++, new MemoryKVStoreSnapshotFile.Segment((List<Pair<byte[], byte[]>>)segment));
                segment.clear();
            }
            if (!segment.isEmpty()) {
                snapshotFile.writeToFile(tempPath, SEGMENT + index++, new MemoryKVStoreSnapshotFile.Segment((List<Pair<byte[], byte[]>>)segment));
                segment.clear();
            }
            snapshotFile.writeToFile(tempPath, TAIL_INDEX, new MemoryKVStoreSnapshotFile.TailIndex(--index));
            File destinationPath = new File(snapshotPath);
            FileUtils.deleteDirectory((File)destinationPath);
            FileUtils.moveDirectory((File)tempFile, (File)destinationPath);
        }
        finally {
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSnapshotLoad(MemoryKVStoreSnapshotFile snapshotFile, String snapshotPath) throws Exception {
        Timer.Context timeCtx = MemoryRawKVStore.getTimeContext("SNAPSHOT_LOAD");
        try {
            MemoryKVStoreSnapshotFile.SequenceDB sequenceDB = snapshotFile.readFromFile(snapshotPath, SEQUENCE_DB, MemoryKVStoreSnapshotFile.SequenceDB.class);
            MemoryKVStoreSnapshotFile.FencingKeyDB fencingKeyDB = snapshotFile.readFromFile(snapshotPath, FENCING_KEY_DB, MemoryKVStoreSnapshotFile.FencingKeyDB.class);
            MemoryKVStoreSnapshotFile.LockerDB lockerDB = snapshotFile.readFromFile(snapshotPath, LOCKER_DB, MemoryKVStoreSnapshotFile.LockerDB.class);
            this.sequenceDB.putAll((Map)sequenceDB.data());
            this.fencingKeyDB.putAll((Map)fencingKeyDB.data());
            this.lockerDB.putAll((Map)lockerDB.data());
            MemoryKVStoreSnapshotFile.TailIndex tailIndex = snapshotFile.readFromFile(snapshotPath, TAIL_INDEX, MemoryKVStoreSnapshotFile.TailIndex.class);
            int tail = (Integer)tailIndex.data();
            ArrayList<MemoryKVStoreSnapshotFile.Segment> segments = Lists.newArrayListWithCapacity(tail + 1);
            for (int i = 0; i <= tail; ++i) {
                MemoryKVStoreSnapshotFile.Segment segment = snapshotFile.readFromFile(snapshotPath, SEGMENT + i, MemoryKVStoreSnapshotFile.Segment.class);
                segments.add(segment);
            }
            for (MemoryKVStoreSnapshotFile.Segment segment : segments) {
                for (Pair p : (List)segment.data()) {
                    this.defaultDB.put((byte[])p.getKey(), (byte[])p.getValue());
                }
            }
        }
        finally {
            timeCtx.stop();
        }
    }

    static <V> Map<ByteArray, V> subRangeMap(Map<ByteArray, V> input, Region region) {
        if (RegionHelper.isSingleGroup(region)) {
            return input;
        }
        HashMap<ByteArray, V> output = new HashMap<ByteArray, V>();
        for (Map.Entry<ByteArray, V> entry : input.entrySet()) {
            ByteArray key = entry.getKey();
            if (!RegionHelper.isKeyInRegion(key.getBytes(), region)) continue;
            output.put(key, entry.getValue());
        }
        return output;
    }
}

