/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.options.configured;

import com.alipay.sofa.jraft.rhea.options.RegionRouteTableOptions;
import com.alipay.sofa.jraft.rhea.util.Configured;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.util.Requires;
import java.util.List;
import java.util.Map;

public final class MultiRegionRouteTableOptionsConfigured
implements Configured<List<RegionRouteTableOptions>> {
    private final Map<Long, RegionRouteTableOptions> optsTable;

    public static MultiRegionRouteTableOptionsConfigured newConfigured() {
        return new MultiRegionRouteTableOptionsConfigured(Maps.newHashMap());
    }

    public MultiRegionRouteTableOptionsConfigured withStartKey(Long regionId, String startKey) {
        this.getOrCreateOptsById(regionId).setStartKey(startKey);
        return this;
    }

    public MultiRegionRouteTableOptionsConfigured withStartKeyBytes(Long regionId, byte[] startKeyBytes) {
        this.getOrCreateOptsById(regionId).setStartKeyBytes(startKeyBytes);
        return this;
    }

    public MultiRegionRouteTableOptionsConfigured withEndKey(Long regionId, String endKey) {
        this.getOrCreateOptsById(regionId).setEndKey(endKey);
        return this;
    }

    public MultiRegionRouteTableOptionsConfigured withEndKeyBytes(Long regionId, byte[] endKeyBytes) {
        this.getOrCreateOptsById(regionId).setEndKeyBytes(endKeyBytes);
        return this;
    }

    public MultiRegionRouteTableOptionsConfigured withInitialServerList(Long regionId, String initialServerList) {
        this.getOrCreateOptsById(regionId).setInitialServerList(initialServerList);
        return this;
    }

    @Override
    public List<RegionRouteTableOptions> config() {
        return Lists.newArrayList(this.optsTable.values());
    }

    private RegionRouteTableOptions getOrCreateOptsById(Long regionId) {
        Requires.requireNonNull((Object)regionId, (String)"regionId");
        RegionRouteTableOptions opts = this.optsTable.get(regionId);
        if (opts != null) {
            return opts;
        }
        opts = new RegionRouteTableOptions();
        opts.setRegionId(regionId);
        this.optsTable.put(regionId, opts);
        return opts;
    }

    public MultiRegionRouteTableOptionsConfigured(Map<Long, RegionRouteTableOptions> optsTable) {
        this.optsTable = optsTable;
    }
}

