/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import apache.rocketmq.v2.Publishing;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.RetryPolicy;
import apache.rocketmq.v2.Settings;
import com.google.common.base.MoreObjects;
import com.google.protobuf.util.Durations;
import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.java.impl.ClientType;
import org.apache.rocketmq.client.java.impl.Settings;
import org.apache.rocketmq.client.java.impl.UserAgent;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.retry.ExponentialBackoffRetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingSettings
extends Settings {
    private static final Logger log = LoggerFactory.getLogger(PublishingSettings.class);
    private final Set<String> topics;
    private volatile int maxBodySizeBytes = 0x400000;
    private volatile boolean validateMessageType = true;

    public PublishingSettings(ClientId clientId, Endpoints accessPoint, ExponentialBackoffRetryPolicy retryPolicy, Duration requestTimeout, Set<String> topics) {
        super(clientId, ClientType.PRODUCER, accessPoint, retryPolicy, requestTimeout);
        this.topics = topics;
    }

    public int getMaxBodySizeBytes() {
        return this.maxBodySizeBytes;
    }

    public boolean isValidateMessageType() {
        return this.validateMessageType;
    }

    @Override
    public apache.rocketmq.v2.Settings toProtobuf() {
        Publishing publishing = Publishing.newBuilder().addAllTopics((Iterable)this.topics.stream().map(name -> Resource.newBuilder().setName(name).build()).collect(Collectors.toList())).setValidateMessageType(this.validateMessageType).build();
        Settings.Builder builder = apache.rocketmq.v2.Settings.newBuilder().setAccessPoint(this.accessPoint.toProtobuf()).setClientType(this.clientType.toProtobuf()).setRequestTimeout(Durations.fromNanos((long)this.requestTimeout.toNanos())).setPublishing(publishing);
        return builder.setBackoffPolicy(this.retryPolicy.toProtobuf()).setUserAgent(UserAgent.INSTANCE.toProtoBuf()).build();
    }

    @Override
    public void sync(apache.rocketmq.v2.Settings settings) {
        Settings.PubSubCase pubSubCase = settings.getPubSubCase();
        if (!Settings.PubSubCase.PUBLISHING.equals((Object)pubSubCase)) {
            log.error("[Bug] Issued settings not match with the client type, clientId={}, pubSubCase={}, clientType={}", new Object[]{this.clientId, pubSubCase, this.clientType});
            return;
        }
        RetryPolicy backoffPolicy = settings.getBackoffPolicy();
        Publishing publishing = settings.getPublishing();
        org.apache.rocketmq.client.java.retry.RetryPolicy exist = this.retryPolicy;
        this.retryPolicy = exist.inheritBackoff(backoffPolicy);
        this.validateMessageType = settings.getPublishing().getValidateMessageType();
        this.maxBodySizeBytes = publishing.getMaxBodySize();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("clientType", (Object)this.clientType).add("accessPoint", (Object)this.accessPoint).add("retryPolicy", (Object)this.retryPolicy).add("requestTimeout", (Object)this.requestTimeout).add("topics", this.topics).add("maxBodySizeBytes", this.maxBodySizeBytes).toString();
    }
}

