/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;

namespace Org.Apache.Rocketmq
{
    public class MetricHttpDelegatingHandler : DelegatingHandler
    {
        private readonly Client _client;

        public MetricHttpDelegatingHandler(Client client)
        {
            _client = client;
            InnerHandler = RpcClient.CreateHttpHandler();
        }

        protected override async Task<HttpResponseMessage> SendAsync(
            HttpRequestMessage request,
            CancellationToken cancellationToken)
        {
            var headers = Signature.Sign(_client);
            foreach (var (key, value) in headers)
            {
                // Add extra headers for auth.
                request.Headers.TryAddWithoutValidation(key, value);
            }

            return await base.SendAsync(request, cancellationToken);
        }
    }
}