/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class QpidPeersOnlyTrustManager
implements X509TrustManager {
    private final KeyStore ts;
    private final X509TrustManager delegate;
    final List<Certificate> trustedCerts = new ArrayList<Certificate>();

    public QpidPeersOnlyTrustManager(KeyStore ts, X509TrustManager trustManager) throws KeyStoreException {
        this.ts = ts;
        this.delegate = trustManager;
        Enumeration<String> aliases = this.ts.aliases();
        while (aliases.hasMoreElements()) {
            this.trustedCerts.add(ts.getCertificate(aliases.nextElement()));
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        for (Certificate serverTrustedCert : this.trustedCerts) {
            if (!chain[0].equals(serverTrustedCert)) continue;
            return;
        }
        throw new CertificateException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

