/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.AMQChannelClosedException;
import org.apache.qpid.AMQDisconnectedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.AMQInvalidRoutingKeyException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQQueueBrowser;
import org.apache.qpid.client.AMQTemporaryQueue;
import org.apache.qpid.client.AMQTemporaryTopic;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.Closeable;
import org.apache.qpid.client.QueueReceiverAdaptor;
import org.apache.qpid.client.QueueSenderAdapter;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.client.TopicPublisherAdapter;
import org.apache.qpid.client.TopicSubscriberAdaptor;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverNoopSupport;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.failover.FailoverRetrySupport;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AMQPEncodedListMessage;
import org.apache.qpid.client.message.AMQPEncodedMapMessage;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.CloseConsumerMessage;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.apache.qpid.client.message.JMSMapMessage;
import org.apache.qpid.client.message.JMSObjectMessage;
import org.apache.qpid.client.message.JMSStreamMessage;
import org.apache.qpid.client.message.JMSTextMessage;
import org.apache.qpid.client.message.MessageEncryptionHelper;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.client.message.UnprocessedMessage;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.client.messaging.address.Node;
import org.apache.qpid.client.util.FlowControllingBlockingQueue;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.jms.ListMessage;
import org.apache.qpid.jms.Session;
import org.apache.qpid.thread.Threading;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQSession<C extends BasicMessageConsumer, P extends BasicMessageProducer>
extends Closeable
implements Session,
QueueSession,
TopicSession {
    private static final Logger _logger = LoggerFactory.getLogger(AMQSession.class);
    public static final String DISPATCHER_SHUTDOWN_TIMEOUT_MS = "DISPATCHER_SHUTDOWN_TIMEOUT_MS";
    public static final String DISPATCHER_SHUTDOWN_TIMEOUT_MS_DEFAULT = "1000";
    public static final String STRICT_AMQP = "STRICT_AMQP";
    public static final String STRICT_AMQP_DEFAULT = "false";
    public static final String STRICT_AMQP_FATAL = "STRICT_AMQP_FATAL";
    public static final String STRICT_AMQP_FATAL_DEFAULT = "true";
    public static final String IMMEDIATE_PREFETCH = "IMMEDIATE_PREFETCH";
    public static final String IMMEDIATE_PREFETCH_DEFAULT = "false";
    private final boolean _declareQueues = Boolean.parseBoolean(System.getProperty("qpid.declare_queues", "true"));
    private final boolean _declareExchanges = Boolean.parseBoolean(System.getProperty("qpid.declare_exchanges", "true"));
    private final boolean _bindQueues = Boolean.parseBoolean(System.getProperty("qpid.bind_queues", "true"));
    private final boolean _useAMQPEncodedMapMessage;
    private final boolean _useAMQPEncodedStreamMessage;
    protected final boolean DAEMON_DISPATCHER_THREAD = Boolean.getBoolean("qpid.jms.daemon.dispatcher");
    private final Map<AMQDestination, WeakReference<AMQDestination>> _resolvedDestinations = Collections.synchronizedMap(new WeakHashMap());
    private final long _dispatcherShutdownTimeoutMs;
    private AMQConnection _connection;
    private final boolean _transacted;
    private final int _acknowledgeMode;
    private int _channelId;
    private int _ticket;
    private final int _prefetchHighMark;
    private final int _prefetchLowMark;
    private MessageListener _messageListener = null;
    private AtomicBoolean _startedAtLeastOnce = new AtomicBoolean(false);
    private final ConcurrentMap<String, TopicSubscriberAdaptor<C>> _subscriptions = new ConcurrentHashMap<String, TopicSubscriberAdaptor<C>>();
    private final ConcurrentMap<C, String> _reverseSubscriptionMap = new ConcurrentHashMap<C, String>();
    private final Lock _subscriberDetails = new ReentrantLock(true);
    private final Lock _subscriberAccess = new ReentrantLock(true);
    private final FlowControllingBlockingQueue<Dispatchable> _queue;
    private final AtomicLong _highestDeliveryTag = new AtomicLong(-1L);
    private final AtomicLong _rollbackMark = new AtomicLong(-1L);
    private ConcurrentLinkedQueue<Long> _prefetchedMessageTags = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> _unacknowledgedMessageTags = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> _deliveredMessageTags = new ConcurrentLinkedQueue();
    private volatile Dispatcher _dispatcher;
    private volatile Thread _dispatcherThread;
    private MessageFactoryRegistry _messageFactoryRegistry;
    private final Map<Long, MessageProducer> _producers = new ConcurrentHashMap<Long, MessageProducer>();
    private int _nextTag = 1;
    private final Map<String, C> _consumers = new ConcurrentHashMap<String, C>();
    private ConcurrentMap<Destination, AtomicInteger> _destinationConsumerCount = new ConcurrentHashMap<Destination, AtomicInteger>();
    private long _nextProducerId;
    private volatile boolean _sessionInRecovery;
    private volatile boolean _usingDispatcherForCleanup;
    private final AtomicBoolean _connectionStopped = new AtomicBoolean();
    private boolean _hasMessageListeners;
    private boolean _suspended;
    private final Object _suspensionLock = new Object();
    private final AtomicBoolean _firstDispatcher = new AtomicBoolean(true);
    private final boolean _immediatePrefetch;
    private final boolean _strictAMQP;
    private final boolean _strictAMQPFATAL;
    private final Lock _messageDeliveryLock = new ReentrantLock(true);
    private boolean _dirty;
    private boolean _failedOverDirty;
    private MessageEncryptionHelper _messageEncryptionHelper;
    private final ExecutorService _flowControlNoAckTaskPool;
    private static final Logger _dispatcherLogger = LoggerFactory.getLogger((String)"org.apache.qpid.client.AMQSession.Dispatcher");

    protected AtomicLong getHighestDeliveryTag() {
        return this._highestDeliveryTag;
    }

    protected ConcurrentLinkedQueue<Long> getPrefetchedMessageTags() {
        return this._prefetchedMessageTags;
    }

    protected ConcurrentLinkedQueue<Long> getUnacknowledgedMessageTags() {
        return this._unacknowledgedMessageTags;
    }

    protected ConcurrentLinkedQueue<Long> getDeliveredMessageTags() {
        return this._deliveredMessageTags;
    }

    protected Dispatcher getDispatcher() {
        return this._dispatcher;
    }

    protected Thread getDispatcherThread() {
        return this._dispatcherThread;
    }

    protected MessageFactoryRegistry getMessageFactoryRegistry() {
        return this._messageFactoryRegistry;
    }

    protected Collection<C> getConsumers() {
        return new ArrayList<C>(this._consumers.values());
    }

    protected void setUsingDispatcherForCleanup(boolean usingDispatcherForCleanup) {
        this._usingDispatcherForCleanup = usingDispatcherForCleanup;
    }

    protected boolean isImmediatePrefetch() {
        return this._immediatePrefetch;
    }

    abstract void handleNodeDelete(AMQDestination var1) throws QpidException;

    abstract void handleLinkDelete(AMQDestination var1) throws QpidException;

    protected AMQSession(AMQConnection con, int channelId, boolean transacted, int acknowledgeMode, int defaultPrefetchHighMark, int defaultPrefetchLowMark) {
        this._useAMQPEncodedMapMessage = con == null || !con.isUseLegacyMapMessageFormat();
        this._useAMQPEncodedStreamMessage = con != null && !con.isUseLegacyStreamMessageFormat();
        this._strictAMQP = Boolean.parseBoolean(System.getProperties().getProperty(STRICT_AMQP, "false"));
        this._strictAMQPFATAL = Boolean.parseBoolean(System.getProperties().getProperty(STRICT_AMQP_FATAL, STRICT_AMQP_FATAL_DEFAULT));
        this._immediatePrefetch = this._strictAMQP || Boolean.parseBoolean(System.getProperties().getProperty(IMMEDIATE_PREFETCH, "false"));
        this._dispatcherShutdownTimeoutMs = Integer.parseInt(System.getProperty(DISPATCHER_SHUTDOWN_TIMEOUT_MS, DISPATCHER_SHUTDOWN_TIMEOUT_MS_DEFAULT));
        this._connection = con;
        this._transacted = transacted;
        this._acknowledgeMode = transacted ? 0 : acknowledgeMode;
        this._messageEncryptionHelper = new MessageEncryptionHelper(this);
        this._channelId = channelId;
        this._messageFactoryRegistry = MessageFactoryRegistry.newDefaultRegistry(this);
        if (this._acknowledgeMode == 257) {
            this._prefetchHighMark = defaultPrefetchHighMark;
            this._prefetchLowMark = defaultPrefetchLowMark == defaultPrefetchHighMark && defaultPrefetchHighMark > 0 ? Math.max(defaultPrefetchHighMark / 2, 1) : defaultPrefetchLowMark;
            this._flowControlNoAckTaskPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "Connection_" + AMQSession.this._connection.getConnectionNumber() + "_session_" + AMQSession.this._channelId);
                    if (!thread.isDaemon()) {
                        thread.setDaemon(true);
                    }
                    return thread;
                }
            }, new ThreadPoolExecutor.DiscardPolicy());
            FlowControllingBlockingQueue.ThresholdListener listener = new FlowControllingBlockingQueue.ThresholdListener(){
                private final AtomicBoolean _suspendState = new AtomicBoolean();

                @Override
                public void aboveThreshold(int currentValue) {
                    if (!(AMQSession.this.isClosed() || AMQSession.this.isClosing() || this._suspendState.getAndSet(true))) {
                        _logger.debug("Above threshold ({}) so suspending channel. Current value is {}", (Object)AMQSession.this._prefetchHighMark, (Object)currentValue);
                        this.doSuspend();
                    }
                }

                @Override
                public void underThreshold(int currentValue) {
                    if (!AMQSession.this.isClosed() && !AMQSession.this.isClosing() && this._suspendState.getAndSet(false)) {
                        _logger.debug("Below threshold ({}) so unsuspending channel. Current value is {}", (Object)AMQSession.this._prefetchLowMark, (Object)currentValue);
                        this.doSuspend();
                    }
                }

                private void doSuspend() {
                    AMQSession.this._flowControlNoAckTaskPool.execute(new SuspenderRunner(this._suspendState));
                }
            };
            this._queue = new FlowControllingBlockingQueue(this._prefetchHighMark, this._prefetchLowMark, listener);
        } else {
            this._prefetchHighMark = defaultPrefetchHighMark;
            this._prefetchLowMark = defaultPrefetchLowMark;
            this._flowControlNoAckTaskPool = null;
            this._queue = new FlowControllingBlockingQueue(this._prefetchHighMark, null);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Created session:" + this);
        }
    }

    @Override
    public void close() throws JMSException {
        this.close(-1L);
    }

    public abstract QpidException getLastException();

    @Override
    public void checkNotClosed() throws JMSException {
        try {
            super.checkNotClosed();
        }
        catch (javax.jms.IllegalStateException ise) {
            QpidException ex = this.getLastException();
            if (ex != null) {
                int code = 0;
                if (ex instanceof AMQException) {
                    code = ((AMQException)ex).getErrorCode();
                }
                throw JMSExceptionHelper.chainJMSException((JMSException)((Object)new javax.jms.IllegalStateException("Session has been closed", code == 0 ? null : Integer.toString(code))), ex);
            }
            throw ise;
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkNotClosed();
        JMSBytesMessage msg = new JMSBytesMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public void acknowledge() throws javax.jms.IllegalStateException, JMSException {
        if (this.isClosed()) {
            throw new javax.jms.IllegalStateException("Session is already closed");
        }
        if (this.hasFailedOverDirty()) {
            this.recover();
            throw new javax.jms.IllegalStateException("has failed over");
        }
        try {
            this.acknowledgeImpl();
            this.markClean();
        }
        catch (TransportException e) {
            throw this.toJMSException("Exception while acknowledging message(s):" + e.getMessage(), e);
        }
    }

    public void setLegacyFieldsForQueueType(AMQDestination dest) {
        dest.setQueueName(dest.getAddressName());
        dest.setExchangeName("");
        dest.setExchangeClass("");
        dest.setRoutingKey(dest.getAMQQueueName());
    }

    public void setLegacyFieldsForTopicType(AMQDestination dest) {
        dest.setExchangeName(dest.getAddressName());
        Node node = dest.getNode();
        dest.setExchangeClass(node.getExchangeType() == null ? "topic" : node.getExchangeType());
        dest.setRoutingKey(dest.getSubject());
    }

    protected void verifySubject(AMQDestination dest) throws QpidException {
        if (dest.getSubject() == null || dest.getSubject().trim().equals("")) {
            if ("topic".equals(dest.getExchangeClass())) {
                dest.setRoutingKey("#");
                dest.setSubject(dest.getRoutingKey());
            } else {
                dest.setRoutingKey("");
                dest.setSubject("");
            }
        }
    }

    public abstract boolean isExchangeExist(AMQDestination var1, boolean var2) throws QpidException;

    public abstract boolean isQueueExist(AMQDestination var1, boolean var2) throws QpidException;

    public void resolveAddress(AMQDestination dest, boolean isConsumer, boolean noLocal) throws QpidException {
        if (this.isResolved(dest)) {
            return;
        }
        boolean assertNode = dest.getAssert() == AMQDestination.AddressOption.ALWAYS || isConsumer && dest.getAssert() == AMQDestination.AddressOption.RECEIVER || !isConsumer && dest.getAssert() == AMQDestination.AddressOption.SENDER;
        boolean createNode = dest.getCreate() == AMQDestination.AddressOption.ALWAYS || isConsumer && dest.getCreate() == AMQDestination.AddressOption.RECEIVER || !isConsumer && dest.getCreate() == AMQDestination.AddressOption.SENDER;
        int suppliedType = dest.getNode() == null ? 3 : dest.getNode().getType();
        int type = this.resolveAddressType(dest);
        switch (type) {
            case 1: {
                this.setLegacyFieldsForQueueType(dest);
                if (createNode) {
                    this.handleQueueNodeCreation(dest, noLocal);
                    break;
                }
                if (this.isQueueExist(dest, assertNode) || suppliedType == 1) break;
            }
            case 2: {
                if (suppliedType != 1) {
                    this.setLegacyFieldsForTopicType(dest);
                    if (createNode) {
                        this.verifySubject(dest);
                        this.handleExchangeNodeCreation(dest);
                        break;
                    }
                    if (this.isExchangeExist(dest, assertNode) || suppliedType == 2) {
                        this.verifySubject(dest);
                        break;
                    }
                }
            }
            default: {
                throw new QpidException("The name '" + dest.getAddressName() + "' supplied in the address doesn't resolve to an exchange or a queue");
            }
        }
        this.setResolved(dest);
    }

    void setResolved(AMQDestination dest) {
        this._resolvedDestinations.put(dest, new WeakReference<AMQDestination>(dest));
    }

    void setUnresolved(AMQDestination dest) {
        this._resolvedDestinations.remove(dest);
    }

    private void clearResolvedDestinations() {
        this._resolvedDestinations.clear();
    }

    boolean isResolved(AMQDestination dest) {
        AMQDestination resolvedDest;
        WeakReference<AMQDestination> resolvedDestRef = this._resolvedDestinations.get(dest);
        AMQDestination aMQDestination = resolvedDest = resolvedDestRef == null ? null : (AMQDestination)resolvedDestRef.get();
        if (resolvedDest == dest) {
            return true;
        }
        if (resolvedDest == null) {
            return false;
        }
        return Objects.equals(dest.getQueueName(), resolvedDest.getQueueName()) && Objects.equals(dest.getExchangeName(), resolvedDest.getExchangeName()) && Objects.equals(dest.getExchangeClass(), resolvedDest.getExchangeClass()) && Objects.equals(dest.getRoutingKey(), resolvedDest.getRoutingKey()) && Objects.equals(dest.getSubject(), resolvedDest.getSubject());
    }

    public abstract int resolveAddressType(AMQDestination var1) throws QpidException;

    protected abstract void acknowledgeImpl() throws JMSException;

    public abstract void acknowledgeMessage(long var1, boolean var3);

    public void bindQueue(String queueName, String routingKey, Map<String, Object> arguments, String exchangeName, AMQDestination destination) throws QpidException {
        this.bindQueue(queueName, routingKey, arguments, exchangeName, destination, false);
    }

    public void bindQueue(final String queueName, final String routingKey, final Map<String, Object> arguments, final String exchangeName, final AMQDestination destination, final boolean nowait) throws QpidException {
        new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

            @Override
            public Object execute() throws QpidException, FailoverException {
                AMQSession.this.sendQueueBind(queueName, routingKey, arguments, exchangeName, destination, nowait);
                return null;
            }
        }, this._connection).execute();
    }

    public void addBindingKey(C consumer, AMQDestination amqd, String routingKey) throws QpidException {
        if (((BasicMessageConsumer)consumer).getQueuename() != null) {
            this.bindQueue(((BasicMessageConsumer)consumer).getQueuename(), routingKey, new HashMap<String, Object>(), amqd.getExchangeName(), amqd);
        }
    }

    public abstract void sendQueueBind(String var1, String var2, Map<String, Object> var3, String var4, AMQDestination var5, boolean var6) throws QpidException, FailoverException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout) throws JMSException {
        this.setClosing(true);
        this.lockMessageDelivery();
        try {
            Object object = this.getFailoverMutex();
            synchronized (object) {
                this.close(timeout, true);
            }
        }
        finally {
            this.unlockMessageDelivery();
        }
    }

    private void close(long timeout, boolean sendClose) throws JMSException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Closing session: " + this);
        }
        if (!this.setClosed()) {
            this.setClosing(true);
            this.closeProducersAndConsumers(null);
            try {
                if ((!this._connection.isClosed() || this._connection.isClosing()) && sendClose) {
                    this.sendClose(timeout);
                }
            }
            catch (QpidException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Error closing session: " + e), e);
            }
            catch (FailoverException e) {
                _logger.debug("Got FailoverException during channel close, ignored as channel already marked as closed.");
            }
            catch (TransportException e) {
                throw this.toJMSException("Error closing session:" + e.getMessage(), e);
            }
            finally {
                this.shutdownFlowControlNoAckTaskPool();
                this._connection.deregisterSession(this._channelId);
            }
        }
    }

    public abstract void sendClose(long var1) throws QpidException, FailoverException;

    public void closed(Throwable e) throws JMSException {
        if (e instanceof AMQDisconnectedException) {
            this.stopDispatcherThread();
        }
        this.setClosing(e == null);
        if (!this.setClosed()) {
            QpidException amqe = e instanceof QpidException ? (QpidException)e : new QpidException("Closing session forcibly", e);
            this._connection.deregisterSession(this._channelId);
            this.closeProducersAndConsumers(amqe);
            this.shutdownFlowControlNoAckTaskPool();
        }
    }

    protected void stopDispatcherThread() {
        if (this._dispatcherThread != null) {
            this._dispatcherThread.interrupt();
        }
    }

    public void commit() throws JMSException {
        this.checkTransacted();
        if (this._failedOverDirty) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Session " + this._channelId + " was dirty whilst failing over. Rolling back.");
            }
            this.rollback();
            throw new TransactionRolledBackException("Connection failover has occured with uncommitted transaction activity.The session transaction was rolled back.");
        }
        try {
            this.commitImpl();
            this.markClean();
        }
        catch (QpidException e) {
            throw this.toJMSException("Exception during commit: " + e.getMessage() + (e.getCause() == null ? "" : " (Caused by : " + e.getCause() + ")"), e);
        }
        catch (FailoverException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Fail-over interrupted commit. Status of the commit is uncertain."), e);
        }
        catch (TransportException e) {
            throw this.toJMSException("Session exception occurred while trying to commit: " + e.getMessage(), e);
        }
    }

    protected abstract void commitImpl() throws QpidException, FailoverException, TransportException;

    public void confirmConsumerCancelled(String consumerTag) {
        BasicMessageConsumer consumer = (BasicMessageConsumer)this._consumers.get(consumerTag);
        if (consumer != null) {
            if (!consumer.isBrowseOnly()) {
                if (this._dispatcher != null) {
                    _logger.debug("Dispatcher is not null");
                } else {
                    _logger.debug("Dispatcher is null so created stopped dispatcher");
                    this.startDispatcherIfNecessary(true);
                }
                this.rejectPending(consumer);
            } else if (consumer.isAutoClose()) {
                if (consumer.isClosed()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Closing consumer:" + consumer.debugIdentity());
                    }
                    this.deregisterConsumer(consumer);
                } else {
                    this._queue.add(new CloseConsumerMessage(consumer));
                }
            }
        }
    }

    private void rejectPending(C consumer) {
        ((BasicMessageConsumer)consumer).releasePendingMessages();
        this.rejectMessagesForConsumerTag(((BasicMessageConsumer)consumer).getConsumerTag());
        ((BasicMessageConsumer)consumer).markClosed();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.isStrictAMQP()) {
            throw new UnsupportedOperationException();
        }
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.isStrictAMQP()) {
            throw new UnsupportedOperationException();
        }
        this.checkNotClosed();
        this.checkValidQueue(queue);
        return new AMQQueueBrowser(this, queue, messageSelector);
    }

    protected MessageConsumer createBrowserConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, noLocal, false, messageSelector, null, true, true);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, false, destination instanceof Topic, null, null, this.isBrowseOnlyDestination(destination), false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, false, destination instanceof Topic, messageSelector, null, this.isBrowseOnlyDestination(destination), false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, noLocal, destination instanceof Topic, messageSelector, null, this.isBrowseOnlyDestination(destination), false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, int prefetch, boolean noLocal, boolean exclusive, String selector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetch, prefetch / 2, noLocal, exclusive, selector, null, this.isBrowseOnlyDestination(destination), false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, int prefetchHigh, int prefetchLow, boolean noLocal, boolean exclusive, String selector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetchHigh, prefetchLow, noLocal, exclusive, selector, null, this.isBrowseOnlyDestination(destination), false);
    }

    public MessageConsumer createConsumer(Destination destination, int prefetchHigh, int prefetchLow, boolean noLocal, boolean exclusive, String selector, Map<String, Object> rawSelector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetchHigh, prefetchLow, noLocal, exclusive, selector, rawSelector, this.isBrowseOnlyDestination(destination), false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        this.checkNotClosed();
        Topic origTopic = this.checkValidTopic(topic, true);
        AMQTopic dest = AMQTopic.createDurableTopic(origTopic, name, this._connection);
        if (dest.getDestSyntax() == AMQDestination.DestSyntax.ADDR && !this.isResolved(dest)) {
            try {
                this.resolveAddress(dest, false, noLocal);
                if (dest.getAddressType() != 2) {
                    throw new JMSException("Durable subscribers can only be created for Topics");
                }
            }
            catch (QpidException e) {
                throw this.toJMSException("Error when verifying destination", e);
            }
            catch (TransportException e) {
                throw this.toJMSException("Error when verifying destination", e);
            }
        }
        String messageSelector = selector == null || selector.trim().length() == 0 ? null : selector;
        this._subscriberDetails.lock();
        try {
            TopicSubscriberAdaptor<BasicMessageConsumer> subscriber = (TopicSubscriberAdaptor<BasicMessageConsumer>)this._subscriptions.get(name);
            if (subscriber == null) {
                String topicName = dest.getRoutingKey();
                if (this._strictAMQP) {
                    if (this._strictAMQPFATAL) {
                        throw new UnsupportedOperationException("JMS Durable not currently supported by AMQP.");
                    }
                    _logger.warn("Unable to determine if subscription already exists for '" + topicName + "' for creation durableSubscriber. Requesting queue deletion regardless.");
                    this.deleteQueue(dest.getAMQQueueName());
                } else {
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put(AMQPFilterTypes.JMS_SELECTOR.getValue(), messageSelector == null ? "" : messageSelector);
                    if (noLocal) {
                        args.put(AMQPFilterTypes.NO_LOCAL.getValue(), true);
                    }
                    boolean isQueueBound = this.isQueueBound(dest.getExchangeName(), dest.getAMQQueueName());
                    boolean isQueueBoundForTopicAndSelector = this.isQueueBound(dest.getExchangeName(), dest.getAMQQueueName(), topicName, args);
                    if (isQueueBound && !isQueueBoundForTopicAndSelector) {
                        this.deleteQueue(dest.getAMQQueueName());
                    } else if (isQueueBound) {
                        try {
                            this.bindQueue(dest.getAMQQueueName(), dest.getRoutingKey(), args, dest.getExchangeName(), dest, true);
                        }
                        catch (QpidException e) {
                            throw this.toJMSException("Error when checking binding", e);
                        }
                    }
                }
            } else {
                if (subscriber.getTopic().equals(topic) && (messageSelector == null && subscriber.getMessageSelector() == null || messageSelector != null && messageSelector.equals(subscriber.getMessageSelector()))) {
                    throw new javax.jms.IllegalStateException("Already subscribed to topic " + topic + " with subscription name " + name + (messageSelector != null ? " and selector " + messageSelector : ""));
                }
                this.unsubscribe(name, true);
            }
            this._subscriberAccess.lock();
            try {
                BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer(dest, messageSelector, noLocal);
                consumer.markAsDurableSubscriber();
                subscriber = new TopicSubscriberAdaptor<BasicMessageConsumer>(dest, consumer);
                this._subscriptions.put(name, subscriber);
                this._reverseSubscriptionMap.put(subscriber.getMessageConsumer(), name);
            }
            finally {
                this._subscriberAccess.unlock();
            }
            TopicSubscriberAdaptor<BasicMessageConsumer> topicSubscriberAdaptor = subscriber;
            return topicSubscriberAdaptor;
        }
        catch (TransportException e) {
            throw this.toJMSException("Exception while creating durable subscriber:" + e.getMessage(), e);
        }
        finally {
            this._subscriberDetails.unlock();
        }
    }

    @Override
    public ListMessage createListMessage() throws JMSException {
        this.checkNotClosed();
        AMQPEncodedListMessage msg = new AMQPEncodedListMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkNotClosed();
        if (this._useAMQPEncodedMapMessage) {
            AMQPEncodedMapMessage msg = new AMQPEncodedMapMessage(this.getMessageDelegateFactory());
            msg.setAMQSession(this);
            return msg;
        }
        JMSMapMessage msg = new JMSMapMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public Message createMessage() throws JMSException {
        return this.createBytesMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkNotClosed();
        JMSObjectMessage msg = new JMSObjectMessage(this.getAMQConnection(), this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        ObjectMessage msg = this.createObjectMessage();
        msg.setObject(object);
        return msg;
    }

    public P createProducer(Destination destination) throws JMSException {
        return this.createProducerImpl(destination, null, null);
    }

    public P createProducer(Destination destination, boolean immediate) throws JMSException {
        return this.createProducerImpl(destination, null, immediate);
    }

    public P createProducer(Destination destination, boolean mandatory, boolean immediate) throws JMSException {
        return this.createProducerImpl(destination, mandatory, immediate);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkNotClosed();
        return new TopicPublisherAdapter((BasicMessageProducer)this.createProducer((Destination)topic, false, false), topic);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkNotClosed();
        try {
            if (queueName.indexOf(47) == -1 && queueName.indexOf(59) == -1) {
                AMQDestination.DestSyntax syntax = AMQDestination.getDestType(queueName);
                if (syntax == AMQDestination.DestSyntax.BURL) {
                    return new AMQQueue(this.getDefaultQueueExchangeName(), AMQDestination.stripSyntaxPrefix(queueName));
                }
                AMQQueue queue = new AMQQueue(queueName);
                return queue;
            }
            return new AMQQueue(queueName);
        }
        catch (URISyntaxException urlse) {
            _logger.error("", (Throwable)urlse);
            throw JMSExceptionHelper.chainJMSException(new JMSException(urlse.getReason()), urlse);
        }
    }

    public void createQueue(String name, boolean autoDelete, boolean durable, boolean exclusive) throws QpidException {
        this.createQueue(name, autoDelete, durable, exclusive, null);
    }

    public void createQueue(final String name, final boolean autoDelete, final boolean durable, final boolean exclusive, final Map<String, Object> arguments) throws QpidException {
        new FailoverRetrySupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

            @Override
            public Object execute() throws QpidException, FailoverException {
                AMQSession.this.sendCreateQueue(name, autoDelete, durable, exclusive, arguments);
                return null;
            }
        }, this._connection).execute();
    }

    public abstract void sendCreateQueue(String var1, boolean var2, boolean var3, boolean var4, Map<String, Object> var5) throws QpidException, FailoverException;

    public QueueReceiver createQueueReceiver(Destination destination) throws JMSException {
        this.checkValidDestination(destination);
        Queue dest = this.validateQueue(destination);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest);
        consumer.setAddressType(1);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    public QueueReceiver createQueueReceiver(Destination destination, String messageSelector) throws JMSException {
        this.checkValidDestination(destination);
        Queue dest = this.validateQueue(destination);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest, messageSelector);
        consumer.setAddressType(1);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkNotClosed();
        Queue dest = this.validateQueue((Destination)queue);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest);
        consumer.setAddressType(1);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkNotClosed();
        Queue dest = this.validateQueue((Destination)queue);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest, messageSelector);
        consumer.setAddressType(1);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    private Queue validateQueue(Destination dest) throws InvalidDestinationException {
        if (dest instanceof AMQDestination && dest instanceof Queue) {
            return (Queue)dest;
        }
        throw new InvalidDestinationException("The destination object used is not from this provider or of type javax.jms.Queue");
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkNotClosed();
        return new QueueSenderAdapter((BasicMessageProducer)this.createProducer((Destination)queue), queue);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkNotClosed();
        if (this._useAMQPEncodedStreamMessage) {
            AMQPEncodedListMessage msg = new AMQPEncodedListMessage(this.getMessageDelegateFactory());
            msg.setAMQSession(this);
            return msg;
        }
        JMSStreamMessage msg = new JMSStreamMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkNotClosed();
        this.checkValidTopic(topic);
        return new TopicSubscriberAdaptor<C>(topic, this.createConsumerImpl((Destination)topic, this._prefetchHighMark, this._prefetchLowMark, false, true, null, null, false, false));
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkNotClosed();
        this.checkValidTopic(topic);
        return new TopicSubscriberAdaptor<C>(topic, this.createConsumerImpl((Destination)topic, this._prefetchHighMark, this._prefetchLowMark, noLocal, true, messageSelector, null, false, false));
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkNotClosed();
        try {
            HashMap<String, Object> args;
            AMQTemporaryQueue result = new AMQTemporaryQueue(this);
            result.setQueueName(result.getRoutingKey());
            if (this._connection.getDelegate().isQueueLifetimePolicySupported()) {
                args = new HashMap<String, Object>();
                args.put("qpid.lifetime_policy", "DELETE_ON_CONNECTION_CLOSE");
                args.put("qpid.exclusivity_policy", "CONNECTION");
            } else {
                args = null;
            }
            this.createQueue(result.getAMQQueueName(), result.isAutoDelete(), result.isDurable(), result.isExclusive(), args);
            this.bindQueue(result.getAMQQueueName(), result.getRoutingKey(), new HashMap<String, Object>(), result.getExchangeName(), result);
            return result;
        }
        catch (QpidException e) {
            throw this.toJMSException("Cannot create temporary queue", e);
        }
        catch (TransportException e) {
            throw this.toJMSException("Cannot create temporary queue: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Cannot create temporary queue: " + e.getMessage()), e);
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkNotClosed();
        return new AMQTemporaryTopic(this);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkNotClosed();
        JMSTextMessage msg = new JMSTextMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    protected Object getFailoverMutex() {
        return this._connection.getFailoverMutex();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        TextMessage msg = this.createTextMessage();
        msg.setText(text);
        return msg;
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkNotClosed();
        try {
            if (topicName.indexOf(47) == -1 && topicName.indexOf(59) == -1) {
                AMQDestination.DestSyntax syntax = AMQDestination.getDestType(topicName);
                topicName = AMQDestination.stripSyntaxPrefix(topicName);
                if (syntax == AMQDestination.DestSyntax.BURL) {
                    return new AMQTopic(this.getDefaultTopicExchangeName(), topicName);
                }
                return new AMQTopic("ADDR:" + this.getDefaultTopicExchangeName() + "/" + topicName);
            }
            return new AMQTopic(topicName);
        }
        catch (URISyntaxException urlse) {
            _logger.error("", (Throwable)urlse);
            throw JMSExceptionHelper.chainJMSException(new JMSException(urlse.getReason()), urlse);
        }
    }

    public void declareExchange(String name, String type, boolean nowait) throws QpidException {
        this.declareExchange(name, type, nowait, false, false, false);
    }

    @Override
    public void deleteExchange(final String exchangeName) throws JMSException {
        try {
            new FailoverRetrySupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

                @Override
                public Object execute() throws QpidException, FailoverException {
                    AMQSession.this.sendExchangeDelete(exchangeName, false);
                    return null;
                }
            }, this._connection).execute();
        }
        catch (QpidException e) {
            throw this.toJMSException("The exchange deletion failed: " + e.getMessage(), e);
        }
    }

    abstract void sendExchangeDelete(String var1, boolean var2) throws QpidException, FailoverException;

    public abstract void sync() throws QpidException;

    public int getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public AMQConnection getAMQConnection() {
        return this._connection;
    }

    public int getChannelId() {
        return this._channelId;
    }

    @Override
    public int getDefaultPrefetch() {
        return this._prefetchHighMark;
    }

    @Override
    public int getDefaultPrefetchHigh() {
        return this._prefetchHighMark;
    }

    @Override
    public int getDefaultPrefetchLow() {
        return this._prefetchLowMark;
    }

    public int getPrefetch() {
        return this._prefetchHighMark;
    }

    @Override
    public String getDefaultQueueExchangeName() {
        return this._connection.getDefaultQueueExchangeName();
    }

    @Override
    public String getDefaultTopicExchangeName() {
        return this._connection.getDefaultTopicExchangeName();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this._messageListener;
    }

    @Override
    public String getTemporaryQueueExchangeName() {
        return this._connection.getTemporaryQueueExchangeName();
    }

    @Override
    public String getTemporaryTopicExchangeName() {
        return this._connection.getTemporaryTopicExchangeName();
    }

    public int getTicket() {
        return this._ticket;
    }

    public boolean getTransacted() throws JMSException {
        this.checkNotClosed();
        return this._transacted;
    }

    public boolean isTransacted() {
        return this._transacted;
    }

    public boolean hasConsumer(Destination destination) {
        AtomicInteger counter = (AtomicInteger)this._destinationConsumerCount.get(destination);
        return counter != null && counter.get() != 0;
    }

    public boolean isStrictAMQP() {
        return this._strictAMQP;
    }

    public boolean isSuspended() {
        return this._suspended;
    }

    protected void addUnacknowledgedMessage(long id) {
        this._unacknowledgedMessageTags.add(id);
    }

    protected void addDeliveredMessage(long id) {
        this._deliveredMessageTags.add(id);
    }

    public void messageReceived(UnprocessedMessage message) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Message[" + message.toString() + "] received in session");
        }
        this._highestDeliveryTag.set(message.getDeliveryTag());
        this._queue.add(message);
    }

    public void declareAndBind(AMQDestination amqd) throws QpidException {
        this.declareAndBind(amqd, new HashMap<String, Object>());
    }

    public void declareAndBind(AMQDestination amqd, Map<String, Object> arguments) throws QpidException {
        this.declareExchange(amqd, false);
        String queueName = this.declareQueue(amqd, false);
        this.bindQueue(queueName, amqd.getRoutingKey(), arguments, amqd.getExchangeName(), amqd);
    }

    public void recover() throws JMSException {
        this.checkNotClosed();
        this.checkNotTransacted();
        try {
            this.flushAcknowledgments();
            this._sessionInRecovery = true;
            boolean isSuspended = this.isSuspended();
            if (!isSuspended) {
                this.suspendChannel(true);
            }
            this._usingDispatcherForCleanup = true;
            this.syncDispatchQueue(false);
            this._usingDispatcherForCleanup = false;
            if (this._dispatcher != null) {
                this._dispatcher.recover();
            }
            this.sendRecover();
            this.markClean();
            if (!isSuspended) {
                this.suspendChannel(false);
            }
        }
        catch (QpidException e) {
            throw this.toJMSException("Recover failed: " + e.getMessage(), e);
        }
        catch (FailoverException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Recovery was interrupted by fail-over. Recovery status is not known."), e);
        }
        catch (TransportException e) {
            throw this.toJMSException("Recover failed: " + e.getMessage(), e);
        }
    }

    protected abstract void sendRecover() throws QpidException, FailoverException;

    protected abstract void flushAcknowledgments();

    public void rejectMessage(UnprocessedMessage message, boolean requeue) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Rejecting Unacked message:" + message.getDeliveryTag());
        }
        this.rejectMessage(message.getDeliveryTag(), requeue);
    }

    public void rejectMessage(AbstractJMSMessage message, boolean requeue) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Rejecting Abstract message:" + message.getDeliveryTag());
        }
        this.rejectMessage(message.getDeliveryTag(), requeue);
    }

    public abstract void rejectMessage(long var1, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        Object object = this._suspensionLock;
        synchronized (object) {
            this.checkTransacted();
            try {
                boolean isSuspended = this.isSuspended();
                if (!isSuspended) {
                    this.suspendChannel(true);
                }
                this.setRollbackMark();
                this.syncDispatchQueue(false);
                this._dispatcher.rollback();
                this.releaseForRollback();
                this.sendRollback();
                this.markClean();
                if (!isSuspended) {
                    this.suspendChannel(false);
                }
            }
            catch (QpidException e) {
                throw this.toJMSException("Failed to rollback: " + e, e);
            }
            catch (FailoverException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Fail-over interrupted rollback. Status of the rollback is uncertain."), e);
            }
            catch (TransportException e) {
                throw this.toJMSException("Failure to rollback:" + e.getMessage(), e);
            }
        }
    }

    public abstract void releaseForRollback();

    public abstract void sendRollback() throws QpidException, FailoverException;

    public void run() {
        throw new UnsupportedOperationException();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
    }

    public void unsubscribe(String name) throws JMSException {
        try {
            this.unsubscribe(name, false);
        }
        catch (TransportException e) {
            throw this.toJMSException("Exception while unsubscribing:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe(String name, boolean safe) throws JMSException {
        TopicSubscriberAdaptor subscriber;
        this._subscriberDetails.lock();
        try {
            this.checkNotClosed();
            subscriber = (TopicSubscriberAdaptor)this._subscriptions.get(name);
            if (subscriber != null) {
                this._subscriptions.remove(name);
                this._reverseSubscriptionMap.remove(subscriber.getMessageConsumer());
            }
        }
        finally {
            this._subscriberDetails.unlock();
        }
        if (subscriber != null) {
            subscriber.close();
            this.deleteQueue(AMQTopic.getDurableTopicQueueName(name, this._connection));
        } else if (this._strictAMQP) {
            if (this._strictAMQPFATAL) {
                throw new UnsupportedOperationException("JMS Durable not currently supported by AMQP.");
            }
            _logger.warn("Unable to determine if subscription already exists for '" + name + "' for unsubscribe. Requesting queue deletion regardless.");
            this.deleteQueue(AMQTopic.getDurableTopicQueueName(name, this._connection));
        } else if (this.isQueueBound(this.getDefaultTopicExchangeName(), AMQTopic.getDurableTopicQueueName(name, this._connection))) {
            this.deleteQueue(AMQTopic.getDurableTopicQueueName(name, this._connection));
        } else if (!safe) {
            throw new InvalidDestinationException("Unknown subscription name: " + name);
        }
    }

    protected C createConsumerImpl(final Destination destination, final int prefetchHigh, final int prefetchLow, final boolean noLocal, final boolean exclusive, String selector, final Map<String, Object> rawSelector, final boolean noConsume, final boolean autoClose) throws JMSException {
        String messageSelector;
        this.checkTemporaryDestination(destination);
        if (!noConsume && this.isBrowseOnlyDestination(destination)) {
            throw new InvalidDestinationException("The consumer being created is not 'noConsume',but a 'browseOnly' Destination has been supplied.");
        }
        if (this._strictAMQP && selector != null && !selector.equals("")) {
            if (this._strictAMQPFATAL) {
                throw new UnsupportedOperationException("Selectors not currently supported by AMQP.");
            }
            messageSelector = null;
        } else {
            messageSelector = selector;
        }
        return (C)((BasicMessageConsumer)new FailoverRetrySupport(new FailoverProtectedOperation<C, JMSException>(){

            @Override
            public C execute() throws JMSException, FailoverException {
                Object consumer;
                AMQSession.this.checkNotClosed();
                AMQDestination amqd = (AMQDestination)destination;
                try {
                    consumer = AMQSession.this.createMessageConsumer(amqd, prefetchHigh, prefetchLow, noLocal, exclusive, messageSelector, rawSelector, noConsume, autoClose);
                }
                catch (TransportException e) {
                    throw AMQSession.this.toJMSException("Exception while creating consumer: " + e.getMessage(), e);
                }
                if (AMQSession.this._messageListener != null) {
                    ((BasicMessageConsumer)consumer).setMessageListener(AMQSession.this._messageListener);
                }
                try {
                    AMQSession.this.registerConsumer(consumer, false);
                }
                catch (AMQInvalidArgumentException ise) {
                    throw JMSExceptionHelper.chainJMSException((JMSException)new InvalidSelectorException(ise.getMessage()), ise);
                }
                catch (AMQInvalidRoutingKeyException e) {
                    throw JMSExceptionHelper.chainJMSException((JMSException)new InvalidDestinationException("Invalid routing key:" + amqd.getRoutingKey()), e);
                }
                catch (QpidException e) {
                    if (e instanceof AMQChannelClosedException) {
                        AMQSession.this.close(-1L, false);
                    }
                    throw AMQSession.this.toJMSException("Error registering consumer: " + e, e);
                }
                catch (TransportException e) {
                    throw AMQSession.this.toJMSException("Exception while registering consumer:" + e.getMessage(), e);
                }
                return consumer;
            }
        }, this._connection).execute());
    }

    public abstract C createMessageConsumer(AMQDestination var1, int var2, int var3, boolean var4, boolean var5, String var6, Map<String, Object> var7, boolean var8, boolean var9) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterConsumer(C consumer) {
        if (this._consumers.remove(((BasicMessageConsumer)consumer).getConsumerTag()) != null) {
            AMQDestination dest;
            this._subscriberAccess.lock();
            try {
                String subscriptionName = (String)this._reverseSubscriptionMap.remove(consumer);
                if (subscriptionName != null) {
                    this._subscriptions.remove(subscriptionName);
                }
            }
            finally {
                this._subscriberAccess.unlock();
            }
            AMQDestination aMQDestination = dest = ((BasicMessageConsumer)consumer).getDestination();
            synchronized (aMQDestination) {
                if (this._destinationConsumerCount.get(dest) != null && ((AtomicInteger)this._destinationConsumerCount.get(dest)).decrementAndGet() == 0) {
                    this._destinationConsumerCount.remove(dest);
                }
            }
        }
    }

    void deregisterProducer(long producerId) {
        this._producers.remove(producerId);
    }

    boolean isInRecovery() {
        return this._sessionInRecovery;
    }

    boolean isQueueBound(String exchangeName, String queueName) throws JMSException {
        return this.isQueueBound(exchangeName, queueName, null);
    }

    public abstract boolean isQueueBound(String var1, String var2, String var3) throws JMSException;

    public abstract boolean isQueueBound(AMQDestination var1) throws JMSException;

    public abstract boolean isQueueBound(String var1, String var2, String var3, Map<String, Object> var4) throws JMSException;

    void markClosed() {
        this.setClosed();
        this._connection.deregisterSession(this._channelId);
        this.markClosedProducersAndConsumers();
    }

    void syncDispatchQueue(boolean holdDispatchLock) {
        if (Thread.currentThread() == this._dispatcherThread || holdDispatchLock) {
            while (!super.isClosed() && !this._queue.isEmpty()) {
                Dispatchable disp;
                try {
                    disp = this._queue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (disp == null) {
                    _logger.debug("_queue became empty during sync.");
                    break;
                }
                disp.dispatch(this);
            }
        } else {
            this.startDispatcherIfNecessary();
            final CountDownLatch signal = new CountDownLatch(1);
            this._queue.add(new DispatchableControl(){

                @Override
                public void dispatch(AMQSession ssn) {
                    signal.countDown();
                }
            });
            try {
                signal.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void drainDispatchQueue() {
        if (Thread.currentThread() == this._dispatcherThread) {
            while (!super.isClosed() && !this._queue.isEmpty()) {
                Dispatchable disp;
                try {
                    disp = this._queue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (disp == null) {
                    _logger.debug("_queue became empty during sync.");
                    break;
                }
                disp.dispatch(this);
            }
        } else {
            this.startDispatcherIfNecessary(false);
            final CountDownLatch signal = new CountDownLatch(1);
            this._queue.add(new DispatchableControl(){

                @Override
                public void dispatch(AMQSession ssn) {
                    signal.countDown();
                }
            });
            try {
                signal.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void resubscribe() throws QpidException {
        if (this._dirty) {
            this._failedOverDirty = true;
        }
        this.resetRollbackMarkers();
        this._unacknowledgedMessageTags.clear();
        this._prefetchedMessageTags.clear();
        this.clearResolvedDestinations();
        this.resubscribeProducers();
        this.resubscribeConsumers();
    }

    void resetRollbackMarkers() {
        this._highestDeliveryTag.set(-1L);
        this._rollbackMark.set(-1L);
    }

    void setHasMessageListeners() {
        this._hasMessageListeners = true;
    }

    void setInRecovery(boolean inRecovery) {
        this._sessionInRecovery = inRecovery;
    }

    boolean isStarted() {
        return this._startedAtLeastOnce.get();
    }

    void start() throws QpidException {
        if (this._startedAtLeastOnce.getAndSet(true)) {
            this.suspendChannel(false);
        }
        if (this.hasMessageListeners()) {
            this.startDispatcherIfNecessary();
        }
    }

    void startDispatcherIfNecessary() {
        if (Thread.currentThread() == this._dispatcherThread) {
            return;
        }
        if (!this._immediatePrefetch && this.isSuspended() && this._startedAtLeastOnce.get() && this._firstDispatcher.getAndSet(false)) {
            try {
                this.suspendChannel(false);
            }
            catch (QpidException e) {
                _logger.info("Unsuspending channel threw an exception:", (Throwable)e);
            }
        }
        this.startDispatcherIfNecessary(false);
    }

    synchronized void startDispatcherIfNecessary(boolean initiallyStopped) {
        if (this._dispatcher == null) {
            this._dispatcher = new Dispatcher();
            try {
                this._dispatcherThread = Threading.getThreadFactory().createThread(this._dispatcher);
            }
            catch (Exception e) {
                throw new Error("Error creating Dispatcher thread", e);
            }
            String dispatcherThreadName = "Dispatcher-" + this._channelId + "-Conn-" + this._connection.getConnectionNumber();
            this._dispatcherThread.setName(dispatcherThreadName);
            this._dispatcherThread.setDaemon(this.DAEMON_DISPATCHER_THREAD);
            this._dispatcher.setConnectionStopped(initiallyStopped);
            this._dispatcherThread.start();
            if (_dispatcherLogger.isDebugEnabled()) {
                _dispatcherLogger.debug(this._dispatcherThread.getName() + " created");
            }
        } else {
            this._dispatcher.setConnectionStopped(initiallyStopped);
        }
    }

    void stop() throws QpidException {
        this.suspendChannelIfNotClosing();
        this.stopExistingDispatcher();
    }

    private void checkNotTransacted() throws JMSException {
        if (this.getTransacted()) {
            throw new javax.jms.IllegalStateException("Session is transacted");
        }
    }

    private void checkTemporaryDestination(Destination destination) throws JMSException {
        if (destination instanceof TemporaryDestination) {
            _logger.debug("destination is temporary");
            TemporaryDestination tempDest = (TemporaryDestination)destination;
            if (tempDest.getSession().getAMQConnection() != this.getAMQConnection()) {
                _logger.debug("destination is on different conection");
                throw new JMSException("Cannot consume from a temporary destination created on another connection");
            }
            if (tempDest.isDeleted()) {
                _logger.debug("destination is deleted");
                throw new JMSException("Cannot consume from a deleted destination");
            }
        }
    }

    protected void checkTransacted() throws JMSException {
        if (!this.getTransacted()) {
            throw new javax.jms.IllegalStateException("Session is not transacted");
        }
    }

    private void checkValidDestination(Destination destination) throws InvalidDestinationException {
        if (destination == null) {
            throw new InvalidDestinationException("Invalid Queue");
        }
    }

    private void checkValidQueue(Queue queue) throws InvalidDestinationException {
        if (queue == null) {
            throw new InvalidDestinationException("Invalid Queue");
        }
    }

    protected Topic checkValidTopic(Topic topic, boolean durable) throws JMSException {
        if (topic == null) {
            throw new InvalidDestinationException("Invalid Topic");
        }
        if (topic instanceof TemporaryDestination && ((TemporaryDestination)topic).getSession() != this) {
            throw new InvalidDestinationException("Cannot create a subscription on a temporary topic created in another session");
        }
        if (topic instanceof TemporaryDestination && durable) {
            throw new InvalidDestinationException("Cannot create a durable subscription with a temporary topic: " + topic);
        }
        if (!(topic instanceof AMQDestination)) {
            throw new InvalidDestinationException("Cannot create a subscription on topic created for another JMS Provider, class of topic provided is: " + topic.getClass().getName());
        }
        return topic;
    }

    protected Topic checkValidTopic(Topic topic) throws JMSException {
        return this.checkValidTopic(topic, false);
    }

    private void closeConsumers(Throwable error) throws JMSException {
        ArrayList<C> clonedConsumers = new ArrayList<C>(this._consumers.values());
        for (BasicMessageConsumer con : clonedConsumers) {
            if (error != null) {
                con.notifyError(error);
                continue;
            }
            con.close(false);
        }
        if (this._dispatcher != null) {
            this._dispatcher.close();
            this._dispatcher = null;
        }
    }

    private void closeProducers() throws JMSException {
        ArrayList<MessageProducer> clonedProducers = new ArrayList<MessageProducer>(this._producers.values());
        for (BasicMessageProducer basicMessageProducer : clonedProducers) {
            basicMessageProducer.close();
        }
    }

    private void closeProducersAndConsumers(QpidException amqe) throws JMSException {
        JMSException jmse;
        block5: {
            jmse = null;
            try {
                this.closeProducers();
            }
            catch (JMSException e) {
                _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
                jmse = e;
            }
            try {
                this.closeConsumers(amqe);
            }
            catch (JMSException e) {
                _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
                if (jmse != null) break block5;
                jmse = e;
            }
        }
        if (jmse != null) {
            throw jmse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeFromQueue(C consumer, String queueName, boolean nowait) throws QpidException, FailoverException {
        Link link = ((BasicMessageConsumer)consumer).getDestination().getLink();
        String linkName = link != null && link.getName() != null && ((BasicMessageConsumer)consumer).getDestination().getAddressType() == 1 ? link.getName() : String.valueOf(this._nextTag++);
        ((BasicMessageConsumer)consumer).setConsumerTag(linkName);
        this._consumers.put(linkName, consumer);
        AMQDestination aMQDestination = ((BasicMessageConsumer)consumer).getDestination();
        synchronized (aMQDestination) {
            this._destinationConsumerCount.putIfAbsent(((BasicMessageConsumer)consumer).getDestination(), new AtomicInteger());
            ((AtomicInteger)this._destinationConsumerCount.get(((BasicMessageConsumer)consumer).getDestination())).incrementAndGet();
        }
        try {
            this.sendConsume(consumer, queueName, nowait);
        }
        catch (QpidException e) {
            this._consumers.remove(linkName);
            throw e;
        }
    }

    void handleLinkCreation(AMQDestination dest) throws QpidException {
        this.createBindings(dest, dest.getLink().getBindings());
    }

    void createBindings(AMQDestination dest, List<AMQDestination.Binding> bindings) throws QpidException {
        String defaultExchangeForBinding = dest.getAddressType() == 2 ? dest.getAddressName() : "amq.topic";
        String defaultQueueName = null;
        defaultQueueName = 1 == dest.getAddressType() ? dest.getQueueName() : (dest.getLink().getName() != null ? dest.getLink().getName() : dest.getQueueName());
        for (AMQDestination.Binding binding : bindings) {
            String exchange;
            String queue = binding.getQueue() == null ? defaultQueueName : binding.getQueue();
            String string = exchange = binding.getExchange() == null ? defaultExchangeForBinding : binding.getExchange();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Binding queue : " + queue + " exchange: " + exchange + " using binding key " + binding.getBindingKey() + " with args " + Strings.printMap(binding.getArgs()));
            }
            this.doBind(dest, binding, queue, exchange);
        }
    }

    protected abstract void handleQueueNodeCreation(AMQDestination var1, boolean var2) throws QpidException;

    abstract void handleExchangeNodeCreation(AMQDestination var1) throws QpidException;

    protected abstract void doBind(AMQDestination var1, AMQDestination.Binding var2, String var3, String var4) throws QpidException;

    public abstract void sendConsume(C var1, String var2, boolean var3) throws QpidException, FailoverException;

    private P createProducerImpl(final Destination destination, final Boolean mandatory, final Boolean immediate) throws JMSException {
        return (P)((BasicMessageProducer)new FailoverRetrySupport(new FailoverProtectedOperation<P, JMSException>(){

            @Override
            public P execute() throws JMSException, FailoverException {
                Object producer;
                AMQSession.this.checkNotClosed();
                long producerId = AMQSession.this.getNextProducerId();
                try {
                    producer = AMQSession.this.createMessageProducer(destination, mandatory, immediate, producerId);
                }
                catch (TransportException e) {
                    throw AMQSession.this.toJMSException("Exception while creating producer:" + e.getMessage(), e);
                }
                AMQSession.this.registerProducer(producerId, producer);
                return producer;
            }
        }, this._connection).execute());
    }

    public abstract P createMessageProducer(Destination var1, Boolean var2, Boolean var3, long var4) throws JMSException;

    private void declareExchange(AMQDestination amqd, boolean nowait) throws QpidException {
        this.declareExchange(amqd.getExchangeName(), amqd.getExchangeClass(), nowait, amqd.isExchangeDurable(), amqd.isExchangeAutoDelete(), amqd.isExchangeInternal());
    }

    public long getQueueDepth(AMQDestination amqd) throws QpidException {
        return this.getQueueDepth(amqd, false);
    }

    public long getQueueDepth(final AMQDestination amqd, final boolean sync) throws QpidException {
        return new FailoverNoopSupport<Long, QpidException>(new FailoverProtectedOperation<Long, QpidException>(){

            @Override
            public Long execute() throws QpidException, FailoverException {
                try {
                    return AMQSession.this.requestQueueDepth(amqd, sync);
                }
                catch (TransportException e) {
                    throw new AMQException(AMQSession.this.getErrorCode(e), e.getMessage(), e);
                }
            }
        }, this._connection).execute();
    }

    protected abstract Long requestQueueDepth(AMQDestination var1, boolean var2) throws QpidException, FailoverException;

    void declareExchange(final String name, final String type, final boolean nowait, final boolean durable, final boolean autoDelete, final boolean internal) throws QpidException {
        new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

            @Override
            public Object execute() throws QpidException, FailoverException {
                AMQSession.this.sendExchangeDeclare(name, type, nowait, durable, autoDelete, internal);
                return null;
            }
        }, this._connection).execute();
    }

    void declareExchange(final String name, final String type, final boolean nowait, final boolean durable, final boolean autoDelete, final Map<String, Object> arguments, final boolean passive) throws QpidException {
        new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

            @Override
            public Object execute() throws QpidException, FailoverException {
                AMQSession.this.sendExchangeDeclare(name, type, nowait, durable, autoDelete, arguments, passive);
                return null;
            }
        }, this._connection).execute();
    }

    protected String preprocessAddressTopic(C consumer, String queueName) throws QpidException {
        if (AMQDestination.DestSyntax.ADDR == ((BasicMessageConsumer)consumer).getDestination().getDestSyntax()) {
            if (2 == ((BasicMessageConsumer)consumer).getDestination().getAddressType()) {
                String selector = ((BasicMessageConsumer)consumer).getMessageSelectorFilter() == null ? null : ((BasicMessageConsumer)consumer).getMessageSelectorFilter().getSelector();
                this.createSubscriptionQueue(((BasicMessageConsumer)consumer).getDestination(), ((BasicMessageConsumer)consumer).isNoLocal(), selector);
                queueName = ((BasicMessageConsumer)consumer).getDestination().getAMQQueueName();
                ((BasicMessageConsumer)consumer).setQueuename(queueName);
            }
            this.handleLinkCreation(((BasicMessageConsumer)consumer).getDestination());
        }
        return queueName;
    }

    abstract void createSubscriptionQueue(AMQDestination var1, boolean var2, String var3) throws QpidException;

    public abstract void sendExchangeDeclare(String var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6) throws QpidException, FailoverException;

    public abstract void sendExchangeDeclare(String var1, String var2, boolean var3, boolean var4, boolean var5, Map<String, Object> var6, boolean var7) throws QpidException, FailoverException;

    protected String declareQueue(AMQDestination amqd, boolean noLocal) throws QpidException {
        return this.declareQueue(amqd, noLocal, false);
    }

    protected String declareQueue(AMQDestination amqd, boolean noLocal, boolean nowait) throws QpidException {
        return this.declareQueue(amqd, noLocal, nowait, false);
    }

    protected abstract String declareQueue(AMQDestination var1, boolean var2, boolean var3, boolean var4) throws QpidException;

    @Override
    public void deleteQueue(final String queueName) throws JMSException {
        try {
            new FailoverRetrySupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

                @Override
                public Object execute() throws QpidException, FailoverException {
                    AMQSession.this.sendQueueDelete(queueName);
                    return null;
                }
            }, this._connection).execute();
        }
        catch (QpidException e) {
            throw this.toJMSException("The queue deletion failed: " + e.getMessage(), e);
        }
    }

    protected void deleteTemporaryDestination(TemporaryDestination amqQueue) throws JMSException {
        this.deleteQueue(amqQueue.getAMQQueueName());
    }

    public abstract void sendQueueDelete(String var1) throws QpidException, FailoverException;

    private long getNextProducerId() {
        return ++this._nextProducerId;
    }

    protected boolean hasMessageListeners() {
        return this._hasMessageListeners;
    }

    private void markClosedConsumers() throws JMSException {
        if (this._dispatcher != null) {
            this._dispatcher.close();
            this._dispatcher = null;
        }
        ArrayList<C> clonedConsumers = new ArrayList<C>(this._consumers.values());
        for (BasicMessageConsumer con : clonedConsumers) {
            con.markClosed();
        }
    }

    private void markClosedProducersAndConsumers() {
        try {
            this.closeProducers();
        }
        catch (JMSException e) {
            _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
        }
        try {
            this.markClosedConsumers();
        }
        catch (JMSException e) {
            _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private void registerConsumer(C consumer, boolean nowait) throws QpidException {
        AMQDestination amqd = ((BasicMessageConsumer)consumer).getDestination();
        if (amqd.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            this.resolveAddress(amqd, true, ((BasicMessageConsumer)consumer).isNoLocal());
        } else {
            if (this._declareExchanges && !amqd.neverDeclare()) {
                this.declareExchange(amqd, nowait);
            }
            if ((this._declareQueues || amqd.isNameRequired()) && !amqd.neverDeclare()) {
                this.declareQueue(amqd, ((BasicMessageConsumer)consumer).isNoLocal(), nowait);
            }
            if (this._bindQueues && !amqd.neverDeclare() && !amqd.isDefaultExchange() && !this.isBound(amqd.getExchangeName(), amqd.getAMQQueueName(), amqd.getRoutingKey())) {
                this.bindQueue(amqd.getAMQQueueName(), amqd.getRoutingKey(), amqd instanceof AMQTopic ? ((BasicMessageConsumer)consumer).getArguments() : null, amqd.getExchangeName(), amqd, nowait);
            }
        }
        String queueName = amqd.getAMQQueueName();
        ((BasicMessageConsumer)consumer).setQueuename(queueName);
        if (!this._immediatePrefetch) {
            if (this._dispatcher == null && !this.isSuspended()) {
                try {
                    this.suspendChannel(true);
                    _logger.debug("Prefetching delayed existing messages will not flow until requested via receive*() or setML().");
                }
                catch (QpidException e) {
                    _logger.info("Suspending channel threw an exception:", (Throwable)e);
                }
            }
        } else {
            _logger.debug("Immediately prefetching existing messages to new consumer.");
        }
        try {
            this.consumeFromQueue(consumer, queueName, nowait);
        }
        catch (FailoverException e) {
            throw new QpidException("Fail-over exception interrupted basic consume.", e);
        }
    }

    protected abstract boolean isBound(String var1, String var2, String var3) throws QpidException;

    private void registerProducer(long producerId, MessageProducer producer) {
        this._producers.put(producerId, producer);
    }

    private void rejectMessagesForConsumerTag(String consumerTag) {
        Iterator<Dispatchable> messages = this._queue.iterator();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Rejecting messages from _queue for Consumer tag(" + consumerTag + ")");
            if (messages.hasNext()) {
                _logger.debug("Checking all messages in _queue for Consumer tag(" + consumerTag + ")");
            } else {
                _logger.debug("No messages in _queue to reject");
            }
        }
        while (messages.hasNext()) {
            UnprocessedMessage message = (UnprocessedMessage)messages.next();
            if (!message.getConsumerTag().equals(consumerTag) || !this._queue.remove(message)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Removing message(" + System.identityHashCode(message) + ") from _queue DT:" + message.getDeliveryTag());
            }
            this.rejectMessage(message, true);
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("Rejected the message(" + message.toString() + ") for consumer :" + consumerTag);
        }
    }

    private void resubscribeConsumers() throws QpidException {
        ArrayList<C> consumers = new ArrayList<C>(this._consumers.values());
        this._consumers.clear();
        for (BasicMessageConsumer consumer : consumers) {
            consumer.failedOverPre();
            this.registerConsumer(consumer, true);
            consumer.failedOverPost();
        }
    }

    private void resubscribeProducers() throws QpidException {
        ArrayList<MessageProducer> producers = new ArrayList<MessageProducer>(this._producers.values());
        _logger.debug(MessageFormat.format("Resubscribing producers = {0} producers.size={1}", producers, producers.size()));
        for (BasicMessageProducer basicMessageProducer : producers) {
            basicMessageProducer.resubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendChannel(boolean suspend) throws QpidException {
        Object object = this._suspensionLock;
        synchronized (object) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Setting channel flow : " + (suspend ? "suspended" : "unsuspended"));
                }
                this._suspended = suspend;
                this.sendSuspendChannel(suspend);
            }
            catch (FailoverException e) {
                throw new QpidException("Fail-over interrupted suspend/unsuspend channel.", e);
            }
            catch (TransportException e) {
                throw new AMQException(this.getErrorCode(e), e.getMessage(), e);
            }
        }
    }

    public abstract void sendSuspendChannel(boolean var1) throws QpidException, FailoverException;

    boolean tryLockMessageDelivery() {
        try {
            return this._messageDeliveryLock.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void lockMessageDelivery() {
        this._messageDeliveryLock.lock();
    }

    void unlockMessageDelivery() {
        this._messageDeliveryLock.unlock();
    }

    public boolean prefetch() {
        return this._prefetchHighMark > 0;
    }

    public void markDirty() {
        this._dirty = true;
    }

    public void markClean() {
        this._dirty = false;
        this._failedOverDirty = false;
    }

    public boolean hasFailedOverDirty() {
        return this._failedOverDirty;
    }

    public void setTicket(int ticket) {
        this._ticket = ticket;
    }

    public abstract boolean isFlowBlocked();

    public abstract void setFlowControl(boolean var1);

    Object getDispatcherLock() {
        Dispatcher dispatcher = this._dispatcher;
        return dispatcher == null ? null : dispatcher._lock;
    }

    public String createTemporaryQueueName() {
        String prefix = this._connection.getTemporaryQueuePrefix();
        assert (prefix.isEmpty() || prefix.endsWith("/"));
        return prefix + "TempQueue" + UUID.randomUUID();
    }

    public void dispatch(UnprocessedMessage message) {
        if (this._dispatcher == null) {
            throw new IllegalStateException("dispatcher is not started");
        }
        this._dispatcher.dispatchMessage(message);
    }

    protected abstract boolean tagLE(long var1, long var3);

    protected abstract boolean updateRollbackMark(long var1, long var3);

    public abstract AMQMessageDelegateFactory getMessageDelegateFactory();

    @Override
    public boolean isClosed() {
        return super.isClosed() || this._connection.isClosed();
    }

    public boolean isSessionClosed() {
        return super.isClosed();
    }

    @Override
    public boolean isClosing() {
        return super.isClosing() || this._connection.isClosing();
    }

    public boolean isDeclareExchanges() {
        return this._declareExchanges;
    }

    JMSException toJMSException(String message, TransportException e) {
        int code = this.getErrorCode(e);
        return JMSExceptionHelper.chainJMSException(new JMSException(message, Integer.toString(code)), e);
    }

    private int getErrorCode(TransportException e) {
        SessionException se;
        int code = 541;
        if (e instanceof SessionException && (se = (SessionException)e).getException() != null && se.getException().getErrorCode() != null) {
            code = se.getException().getErrorCode().getValue();
        }
        return code;
    }

    JMSException toJMSException(String message, QpidException e) {
        int errorCode = 0;
        if (e instanceof AMQException) {
            errorCode = ((AMQException)e).getErrorCode();
        }
        JMSException ex = errorCode == 403 ? JMSExceptionHelper.chainJMSException((JMSException)new JMSSecurityException(message, Integer.toString(errorCode)), e) : JMSExceptionHelper.chainJMSException(new JMSException(message, errorCode == 0 ? null : Integer.toString(errorCode)), e);
        return ex;
    }

    private boolean isBrowseOnlyDestination(Destination destination) {
        return destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly();
    }

    private void setRollbackMark() {
        this._rollbackMark.set(this._highestDeliveryTag.get());
        if (_logger.isDebugEnabled()) {
            _logger.debug("Rollback mark is set to " + this._rollbackMark.get());
        }
    }

    public MessageEncryptionHelper getMessageEncryptionHelper() {
        return this._messageEncryptionHelper;
    }

    protected void drainDispatchQueueWithDispatcher() {
        if (!this._queue.isEmpty()) {
            try {
                this.setUsingDispatcherForCleanup(true);
                this.drainDispatchQueue();
            }
            finally {
                this.setUsingDispatcherForCleanup(false);
            }
        }
    }

    protected void stopExistingDispatcher() {
        Dispatcher dispatcher = this._dispatcher;
        if (dispatcher != null) {
            dispatcher.setConnectionStopped(true);
        }
    }

    protected void suspendChannelIfNotClosing() throws QpidException {
        if (!this.isClosed() && !this.isClosing()) {
            this.suspendChannel(true);
        }
    }

    private void shutdownFlowControlNoAckTaskPool() {
        if (this._flowControlNoAckTaskPool != null) {
            this._flowControlNoAckTaskPool.shutdown();
        }
    }

    private class SuspenderRunner
    implements Runnable {
        private AtomicBoolean _suspend;

        public SuspenderRunner(AtomicBoolean suspend) {
            this._suspend = suspend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    Object object = AMQSession.this._suspensionLock;
                    synchronized (object) {
                        if (!AMQSession.this.isClosed() && !AMQSession.this.isClosing()) {
                            AMQSession.this.suspendChannel(this._suspend.get());
                        }
                    }
                }
                catch (QpidException e) {
                    _logger.warn("Unable to " + (this._suspend.get() ? "suspend" : "unsuspend") + " session " + AMQSession.this + " due to: ", (Throwable)e);
                    if (!_logger.isDebugEnabled()) break block6;
                    _logger.debug("Is the _queue empty?" + AMQSession.this._queue.isEmpty());
                    _logger.debug("Is the dispatcher closed?" + (AMQSession.this._dispatcher == null ? "it's Null" : AMQSession.this._dispatcher.getClosed()));
                }
            }
        }
    }

    class Dispatcher
    implements Runnable {
        private final AtomicBoolean _closed = new AtomicBoolean(false);
        private final CountDownLatch _closeCompleted = new CountDownLatch(1);
        private final Object _lock = new Object();
        private final String dispatcherID = "" + System.identityHashCode(this);

        public void close() {
            this._closed.set(true);
            AMQSession.this._queue.close();
            AMQSession.this._dispatcherThread.interrupt();
            if (Thread.currentThread() != AMQSession.this._dispatcherThread) {
                try {
                    if (!this._closeCompleted.await(AMQSession.this._dispatcherShutdownTimeoutMs, TimeUnit.MILLISECONDS)) {
                        throw new RuntimeException("Dispatcher did not close down within the timeout of " + AMQSession.this._dispatcherShutdownTimeoutMs + " ms.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private AtomicBoolean getClosed() {
            return this._closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            Object object = this._lock;
            synchronized (object) {
                boolean isStopped = this.connectionStopped();
                if (!isStopped) {
                    this.setConnectionStopped(true);
                }
                AMQSession.this.setRollbackMark();
                _dispatcherLogger.debug("Session Pre Dispatch Queue cleared");
                for (BasicMessageConsumer consumer : AMQSession.this._consumers.values()) {
                    if (!consumer.isBrowseOnly()) {
                        consumer.releasePendingMessages();
                        continue;
                    }
                    consumer.clearReceiveQueue();
                }
                this.setConnectionStopped(isStopped);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover() {
            Object object = this._lock;
            synchronized (object) {
                boolean isStopped = this.connectionStopped();
                if (!isStopped) {
                    this.setConnectionStopped(true);
                }
                _dispatcherLogger.debug("Session clearing the consumer queues");
                for (BasicMessageConsumer consumer : AMQSession.this._consumers.values()) {
                    List<Long> tags = consumer.drainReceiverQueueAndRetrieveDeliveryTags();
                    AMQSession.this._prefetchedMessageTags.addAll(tags);
                }
                this.setConnectionStopped(isStopped);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                if (_dispatcherLogger.isDebugEnabled()) {
                    _dispatcherLogger.debug(AMQSession.this._dispatcherThread.getName() + " started");
                }
                Object object = this._lock;
                synchronized (object) {
                    while (!this._closed.get() && this.connectionStopped()) {
                        try {
                            this._lock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                try {
                    while (AMQSession.this._queue.blockingPeek() != null) {
                        if (this._closed.get()) return;
                        object = this._lock;
                        synchronized (object) {
                            Dispatchable disp = (Dispatchable)AMQSession.this._queue.nonBlockingTake();
                            if ((disp instanceof DispatchableControl || !AMQSession.this.isClosed() && !AMQSession.this.isClosing() && !this._closed.get()) && disp != null) {
                                disp.dispatch(AMQSession.this);
                            }
                        }
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    return;
                }
            }
            finally {
                this._closeCompleted.countDown();
                if (_dispatcherLogger.isDebugEnabled()) {
                    _dispatcherLogger.debug(AMQSession.this._dispatcherThread.getName() + " thread terminating for channel " + AMQSession.this._channelId + ":" + AMQSession.this);
                }
            }
        }

        final boolean connectionStopped() {
            return AMQSession.this._connectionStopped.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setConnectionStopped(boolean connectionStopped) {
            boolean currently = AMQSession.this._connectionStopped.get();
            if (connectionStopped != currently) {
                Object object = this._lock;
                synchronized (object) {
                    AMQSession.this._connectionStopped.set(connectionStopped);
                    this._lock.notifyAll();
                    if (_dispatcherLogger.isDebugEnabled()) {
                        _dispatcherLogger.debug("Set Dispatcher Connection " + (connectionStopped ? "Stopped" : "Started") + ": Currently " + (currently ? "Stopped" : "Started"));
                    }
                }
            }
            return currently;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMessage(UnprocessedMessage message) {
            long deliveryTag = message.getDeliveryTag();
            Object object = this._lock;
            synchronized (object) {
                try {
                    while (!AMQSession.this.getAMQConnection().isFailingOver() && this.connectionStopped()) {
                        this._lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!(message instanceof CloseConsumerMessage) && AMQSession.this.tagLE(deliveryTag, AMQSession.this._rollbackMark.get())) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Rejecting message because delivery tag " + deliveryTag + " <= rollback mark " + AMQSession.this._rollbackMark.get());
                    }
                    AMQSession.this.rejectMessage(message, true);
                } else if (AMQSession.this._usingDispatcherForCleanup) {
                    AMQSession.this._prefetchedMessageTags.add(deliveryTag);
                } else {
                    while (!AMQSession.this.isClosed() && !AMQSession.this.isClosing()) {
                        if (!AMQSession.this.tryLockMessageDelivery()) continue;
                        try {
                            this.notifyConsumer(message);
                            break;
                        }
                        finally {
                            AMQSession.this.unlockMessageDelivery();
                        }
                    }
                }
            }
            long current = AMQSession.this._rollbackMark.get();
            if (AMQSession.this.updateRollbackMark(current, deliveryTag)) {
                AMQSession.this._rollbackMark.compareAndSet(current, deliveryTag);
            }
        }

        private void notifyConsumer(UnprocessedMessage message) {
            BasicMessageConsumer consumer = (BasicMessageConsumer)AMQSession.this._consumers.get(message.getConsumerTag());
            if (consumer == null || consumer.isClosed() || consumer.isClosing()) {
                if (_dispatcherLogger.isInfoEnabled()) {
                    if (consumer == null) {
                        _dispatcherLogger.info("Dispatcher(" + this.dispatcherID + ")Received a message(" + System.identityHashCode(message) + ")[" + message.getDeliveryTag() + "] from queue " + message.getConsumerTag() + " )without a handler - rejecting(requeue)...");
                    } else {
                        if (consumer.isBrowseOnly()) {
                            _dispatcherLogger.info("Received a message(" + System.identityHashCode(message) + ")[" + message.getDeliveryTag() + "] from queue  consumer(" + message.getConsumerTag() + ") is closed and a browser so dropping...");
                            return;
                        }
                        _dispatcherLogger.info("Received a message(" + System.identityHashCode(message) + ")[" + message.getDeliveryTag() + "] from queue  consumer(" + message.getConsumerTag() + ") is closed rejecting(requeue)...");
                    }
                }
                if (!this._closed.get()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Rejecting message with delivery tag " + message.getDeliveryTag() + " for closing consumer " + String.valueOf(consumer == null ? null : consumer.getConsumerTag()));
                    }
                    AMQSession.this.rejectMessage(message, true);
                }
            } else {
                consumer.notifyMessage(message);
            }
        }
    }

    public static interface DispatchableControl
    extends Dispatchable {
    }

    public static interface Dispatchable {
        public void dispatch(AMQSession var1);
    }
}

