/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.filter;

import java.math.BigDecimal;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.Expression;

public class ConstantExpression<T>
implements Expression<T> {
    public static final BooleanConstantExpression NULL = new BooleanConstantExpression(null);
    public static final BooleanConstantExpression TRUE = new BooleanConstantExpression(Boolean.TRUE);
    public static final BooleanConstantExpression FALSE = new BooleanConstantExpression(Boolean.FALSE);
    private Object _value;

    public static <E> ConstantExpression<E> NULL() {
        return NULL;
    }

    public static <E> ConstantExpression<E> TRUE() {
        return TRUE;
    }

    public static <E> ConstantExpression<E> FALSE() {
        return FALSE;
    }

    public static <E> ConstantExpression<E> createFromDecimal(String text) {
        Number value;
        if (text.endsWith("l") || text.endsWith("L")) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            value = Long.valueOf(text);
        }
        catch (NumberFormatException e) {
            value = new BigDecimal(text);
        }
        long l = value.longValue();
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            value = value.intValue();
        }
        return new ConstantExpression(value);
    }

    public static <E> ConstantExpression<E> createFromHex(String text) {
        Number value = Long.parseLong(text.substring(2), 16);
        long l = value;
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            value = ((Number)value).intValue();
        }
        return new ConstantExpression(value);
    }

    public static <E> ConstantExpression<E> createFromOctal(String text) {
        Number value = Long.parseLong(text, 8);
        long l = value;
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            value = ((Number)value).intValue();
        }
        return new ConstantExpression(value);
    }

    public static <E> ConstantExpression<E> createFloat(String text) {
        Double value = new Double(text);
        return new ConstantExpression(value);
    }

    public ConstantExpression(Object value) {
        this._value = value;
    }

    @Override
    public Object evaluate(T message) {
        return this._value;
    }

    public Object getValue() {
        return this._value;
    }

    public String toString() {
        if (this._value == null) {
            return "NULL";
        }
        if (this._value instanceof Boolean) {
            return (Boolean)this._value != false ? "TRUE" : "FALSE";
        }
        if (this._value instanceof String) {
            return ConstantExpression.encodeString((String)this._value);
        }
        return this._value.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public static String encodeString(String s) {
        StringBuilder b = new StringBuilder();
        b.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                b.append(c);
            }
            b.append(c);
        }
        b.append('\'');
        return b.toString();
    }

    static class BooleanConstantExpression<E>
    extends ConstantExpression<E>
    implements BooleanExpression<E> {
        public BooleanConstantExpression(Object value) {
            super(value);
        }

        @Override
        public boolean matches(E message) {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

