/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;

public class ConnectionSecureMethodHandler
implements StateAwareMethodListener<ConnectionSecureBody> {
    private static final ConnectionSecureMethodHandler _instance = new ConnectionSecureMethodHandler();

    public static ConnectionSecureMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionSecureBody body, int channelId) throws QpidException {
        SaslClient client = session.getSaslClient();
        if (client == null) {
            throw new QpidException("No SASL client set up - cannot proceed with authentication", null);
        }
        try {
            byte[] response = client.evaluateChallenge(body.getChallenge());
            ConnectionSecureOkBody secureOkBody = session.getMethodRegistry().createConnectionSecureOkBody(response);
            session.writeFrame(secureOkBody.generateFrame(channelId));
        }
        catch (SaslException e) {
            throw new QpidException("Error processing SASL challenge: " + e, e);
        }
    }
}

