/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodRegistry;

public class AMQConnectionException
extends AMQException {
    private final int _classId;
    private final int _methodId;
    private final MethodRegistry _methodRegistry;

    public AMQConnectionException(int errorCode, String msg, int classId, int methodId, MethodRegistry methodRegistry, Throwable cause) {
        super(errorCode, msg, cause);
        this._classId = classId;
        this._methodId = methodId;
        this._methodRegistry = methodRegistry;
    }

    public AMQFrame getCloseFrame() {
        return new AMQFrame(0, this._methodRegistry.createConnectionCloseBody(this.getErrorCode(), AMQShortString.validValueOf(this.getMessage()), this._classId, this._methodId));
    }

    @Override
    public AMQException cloneForCurrentThread() {
        return new AMQConnectionException(this.getErrorCode(), this.getMessage(), this._classId, this._methodId, this._methodRegistry, this.getCause());
    }
}

