/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.qpid.server.protocol.v1_0.LinkDefinition;
import org.apache.qpid.server.protocol.v1_0.store.LinkStore;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreUpdater;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.store.StoreException;

public abstract class AbstractLinkStore
implements LinkStore {
    private final ReentrantReadWriteLock _useOrCloseRWLock = new ReentrantReadWriteLock(true);
    private volatile StoreState _storeState = StoreState.CLOSED;

    protected abstract Collection<LinkDefinition<Source, Target>> doOpenAndLoad(LinkStoreUpdater var1);

    protected abstract void doClose();

    protected abstract void doDelete();

    protected abstract void doSaveLink(LinkDefinition<Source, Target> var1);

    protected abstract void doDeleteLink(LinkDefinition<Source, Target> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<LinkDefinition<Source, Target>> openAndLoad(LinkStoreUpdater updater) throws StoreException {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (this._storeState != StoreState.CLOSED) {
                throw new StoreException("Store is already opened");
            }
            Collection<LinkDefinition<Source, Target>> linkDefinitions = this.doOpenAndLoad(updater);
            this._storeState = StoreState.OPENED;
            Collection<LinkDefinition<Source, Target>> collection = linkDefinitions;
            return collection;
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    @Override
    public final void close() throws StoreException {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            this.doClose();
            this._storeState = StoreState.CLOSED;
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    @Override
    public final void saveLink(LinkDefinition<Source, Target> link) throws StoreException {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (this._storeState != StoreState.OPENED) {
                throw new StoreException("Store is not opened");
            }
            this.doSaveLink(link);
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    @Override
    public final void deleteLink(LinkDefinition<Source, Target> link) throws StoreException {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (this._storeState != StoreState.OPENED) {
                throw new StoreException("Store is not opened");
            }
            this.doDeleteLink(link);
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    @Override
    public final void delete() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            this.close();
            this.doDelete();
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    static enum StoreState {
        CLOSED,
        OPENED;

    }
}

