/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MascNamedEntityParser
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(MascNamedEntityParser.class);
    private final Map<Integer, String> entityIDtoEntityType = new HashMap<Integer, String>();
    private final Map<Integer, List<Integer>> entityIDsToTokens = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, String> tokenToEntity = new HashMap<Integer, String>();

    public Map<Integer, String> getEntityIDtoEntityType() {
        return this.entityIDtoEntityType;
    }

    public Map<Integer, List<Integer>> getEntityIDsToTokens() {
        return this.entityIDsToTokens;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            int entityID;
            if (qName.equals("a")) {
                entityID = Integer.parseInt(attributes.getValue("ref").replaceFirst("ne-n", ""));
                String label = attributes.getValue("label");
                if (this.entityIDtoEntityType.containsKey(entityID)) {
                    throw new SAXException("Multiple labels for one named entity");
                }
                this.entityIDtoEntityType.put(entityID, label);
            }
            if (qName.equals("edge")) {
                entityID = Integer.parseInt(attributes.getValue("from").replaceFirst("ne-n", ""));
                int tokenID = Integer.parseInt(attributes.getValue("to").replaceFirst("penn-n", ""));
                if (!this.entityIDsToTokens.containsKey(entityID)) {
                    ArrayList<Integer> tokens = new ArrayList<Integer>();
                    tokens.add(tokenID);
                    this.entityIDsToTokens.put(entityID, tokens);
                } else {
                    this.entityIDsToTokens.get(entityID).add(tokenID);
                }
                String type = this.entityIDtoEntityType.get(entityID);
                if (this.tokenToEntity.containsKey(tokenID) && !type.equals(this.tokenToEntity.get(tokenID))) {
                    logger.warn("One token assigned to different named entity types.\n\tPenn-TokenID: {}\n\tToken types: \"{}\", \"{}\"\n\tKeeping only \"type\"", tokenID, type, this.tokenToEntity.get(tokenID));
                }
                this.tokenToEntity.put(tokenID, type);
            }
        }
        catch (Exception e) {
            throw new SAXException("Could not parse the named entity annotation file.\n" + e.getMessage(), e);
        }
    }
}

