/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLSelectSingleContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectSingleContext;

public class JPQLSelectSingleStatementBuilder
extends JPQLStatement.JPQLStatementBuilder {
    JPQLStatement jpqlStatement;
    private JPQLSelectSingleContextView context;

    public JPQLSelectSingleStatementBuilder(JPQLContextView context) {
        this.context = (JPQLSelectSingleContextView)context;
    }

    public JPQLStatement build() throws ODataJPARuntimeException {
        this.jpqlStatement = this.createStatement(this.createJPQLQuery());
        this.context.setJPQLStatement(this.jpqlStatement.toString());
        return this.jpqlStatement;
    }

    private String createJPQLQuery() throws ODataJPARuntimeException {
        StringBuilder jpqlQuery = new StringBuilder();
        String tableAlias = this.context.getJPAEntityAlias();
        String fromClause = this.context.getJPAEntityName() + " " + tableAlias;
        jpqlQuery.append("SELECT").append(' ');
        jpqlQuery.append(this.context.getSelectExpression()).append(' ');
        jpqlQuery.append("FROM").append(' ');
        jpqlQuery.append(fromClause);
        if (this.context.getKeyPredicates() != null && !this.context.getKeyPredicates().isEmpty()) {
            jpqlQuery.append(' ');
            jpqlQuery.append("WHERE").append(' ');
            String keyString = ODataExpressionParser.parseKeyPredicates(this.context.getKeyPredicates(), this.context.getJPAEntityAlias());
            HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
            if (keyString != null) {
                parameterizedExpressionMap.put(keyString, ODataExpressionParser.getPositionalParametersThreadLocal());
                ((JPQLSelectSingleContext)this.context).setParameterizedQueryMap(parameterizedExpressionMap);
            }
            jpqlQuery.append(keyString);
        }
        return jpqlQuery.toString();
    }
}

