/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api;

import javax.persistence.EntityManager;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAResponseBuilder;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;

public abstract class ODataJPAProcessor
extends ODataSingleProcessor {
    protected ODataJPAContext oDataJPAContext;
    protected JPAProcessor jpaProcessor;
    protected ODataJPAResponseBuilder responseBuilder;

    public ODataJPAContext getOdataJPAContext() {
        return this.oDataJPAContext;
    }

    public void setOdataJPAContext(ODataJPAContext odataJPAContext) {
        this.oDataJPAContext = odataJPAContext;
    }

    public ODataJPAProcessor(ODataJPAContext oDataJPAContext) {
        if (oDataJPAContext == null) {
            throw new IllegalArgumentException("OData JPA Context cannot be null");
        }
        this.oDataJPAContext = oDataJPAContext;
        this.jpaProcessor = ODataJPAFactory.createFactory().getJPAAccessFactory().getJPAProcessor(this.oDataJPAContext);
        this.responseBuilder = ODataJPAFactory.createFactory().getODataJPAAccessFactory().getODataJPAResponseBuilder(this.oDataJPAContext);
    }

    public void close(boolean forceClose) {
        ODataJPATombstoneContext.cleanup();
        if (!this.oDataJPAContext.isContainerManaged()) {
            EntityManager em = this.oDataJPAContext.getEntityManager();
            if ((!this.oDataJPAContext.getODataContext().isInBatchMode() || forceClose) && em.isOpen()) {
                em.close();
            }
        }
    }

    public void close() {
        this.close(false);
    }
}

