/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAFunction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;

public class JPAFunctionContext
extends JPAMethodContext {

    public class JPAFunctionContextBuilder
    extends JPAMethodContext.JPAMethodContextBuilder {
        protected GetFunctionImportUriInfo functionView;
        private EdmFunctionImport functionImport;
        private EdmMapping mapping;

        public JPAMethodContext build() throws ODataJPAModelException, ODataJPARuntimeException {
            if (this.functionView != null) {
                this.functionImport = this.functionView.getFunctionImport();
                try {
                    this.mapping = this.functionImport.getMapping();
                    ArrayList<JPAFunction> jpaFunctionList = new ArrayList<JPAFunction>();
                    jpaFunctionList.add(this.generateJPAFunction());
                    JPAFunctionContext.this.setJpaFunction(jpaFunctionList);
                    JPAFunctionContext.this.setEnclosingObject(this.generateEnclosingObject());
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (SecurityException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            return JPAFunctionContext.this;
        }

        protected void setResultsView(Object resultsView) {
            if (resultsView instanceof GetFunctionImportUriInfo) {
                this.functionView = (GetFunctionImportUriInfo)resultsView;
            }
        }

        private JPAFunction generateJPAFunction() throws EdmException, NoSuchMethodException, SecurityException, ODataJPAModelException, ODataJPARuntimeException {
            Class[] parameterTypes = this.getParameterTypes();
            Method method = this.getMethod(parameterTypes);
            Type returnType = this.getReturnType();
            Object[] args = this.getArguments();
            return new JPAFunction(method, parameterTypes, returnType, args);
        }

        private Object[] getArguments() throws EdmException {
            Map edmArguments = this.functionView.getFunctionImportParameters();
            if (edmArguments == null) {
                return null;
            }
            Collection paramNames = this.functionImport.getParameterNames();
            Object[] args = new Object[paramNames.size()];
            int i = 0;
            for (String paramName : this.functionImport.getParameterNames()) {
                EdmLiteral literal = (EdmLiteral)edmArguments.get(paramName);
                EdmParameter parameter = this.functionImport.getParameter(paramName);
                JPAEdmMapping mappingValue = (JPAEdmMapping)parameter.getMapping();
                args[i++] = this.convertArgument(literal, parameter.getFacets(), mappingValue.getJPAType());
            }
            return args;
        }

        private Object convertArgument(EdmLiteral edmLiteral, EdmFacets facets, Class<?> targetType) throws EdmSimpleTypeException {
            Object value = null;
            if (edmLiteral != null) {
                EdmSimpleType edmType = edmLiteral.getType();
                value = edmType.valueOfString(edmLiteral.getLiteral(), EdmLiteralKind.DEFAULT, facets, targetType);
            }
            return value;
        }

        private Class<?>[] getParameterTypes() throws EdmException {
            Class[] parameterTypes = new Class[this.functionImport.getParameterNames().size()];
            int i = 0;
            for (String parameterName : this.functionImport.getParameterNames()) {
                EdmParameter parameter = this.functionImport.getParameter(parameterName);
                parameterTypes[i++] = ((JPAEdmMapping)parameter.getMapping()).getJPAType();
            }
            return parameterTypes;
        }

        private Method getMethod(Class<?>[] parameterTypes) throws NoSuchMethodException, SecurityException {
            Class type = ((JPAEdmMapping)this.mapping).getJPAType();
            Method method = type.getMethod(this.mapping.getInternalName(), parameterTypes);
            return method;
        }

        private Type getReturnType() throws ODataJPAModelException, ODataJPARuntimeException, EdmException {
            return null;
        }

        private Object generateEnclosingObject() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            Class type = ((JPAEdmMapping)this.mapping).getJPAType();
            Object[] params = null;
            return type.getConstructor((Class[])params).newInstance(params);
        }
    }
}

