/****************************************************************************
 * arch/arm/src/stm32h5/hardware/stm32h56xxx_pinmap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_STM32H5_HARDWARE_STM32H56XXX_PINMAP_H
#define __ARCH_ARM_SRC_STM32H5_HARDWARE_STM32H56XXX_PINMAP_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#if defined(CONFIG_STM32H5_STM32H563XX) || \
    defined(CONFIG_STM32H5_STM32H562XX)
/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Alternate Pin Functions.  All members of the STM32H562xx and STM32H563xx
 * families share the same pin multiplexing (although they may differ in the
 * pins physically available).  See DS14258, Table 15 "Alternate Function AF0
 * to AF7" and Table 16 "Alternate Function AF8 to AF15".
 *
 * Alternative pin selections are provided with a numeric suffix like _1, _2,
 * etc.  Drivers, however, will use the pin selection without the numeric
 * suffix.  Additional definitions are required in the board.h file.  For
 * example, if FDCAN1_RX connects via PA11 on some board, then the following
 * definitions should appear in the board.h header file for that board:
 *
 * #define GPIO_FDCAN1_RX GPIO_FDCAN1_RX_1
 *
 * The driver will then automatically configure PA11 as the FDCAN1 RX pin.
 */

/* Ethernet MAC */

#define GPIO_ETH_MDC_0          (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ETH_MDIO_0         (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ETH_MII_COL_1      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ETH_MII_COL_2      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN3)
#define GPIO_ETH_MII_CRS_1      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ETH_MII_CRS_2      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN2)
#define GPIO_ETH_MII_RX_CLK_0   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ETH_MII_RX_DV_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ETH_MII_RX_ER_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_ETH_MII_RX_ER_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN10)
#define GPIO_ETH_MII_RXD0_0     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ETH_MII_RXD1_0     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#define GPIO_ETH_MII_RXD2_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#define GPIO_ETH_MII_RXD2_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)
#define GPIO_ETH_MII_RXD3_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)
#define GPIO_ETH_MII_RXD3_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN7)
#define GPIO_ETH_MII_TX_CLK_0   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ETH_MII_TX_EN_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_ETH_MII_TX_EN_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_ETH_MII_TX_EN_3    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)
#define GPIO_ETH_MII_TX_ER_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_ETH_MII_TXD0_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_ETH_MII_TXD0_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_ETH_MII_TXD0_3     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN13)
#define GPIO_ETH_MII_TXD1_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN15)
#define GPIO_ETH_MII_TXD1_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN12)
#define GPIO_ETH_MII_TXD1_3     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)
#define GPIO_ETH_MII_TXD2_0     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ETH_MII_TXD3_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_ETH_MII_TXD3_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN2)
#define GPIO_ETH_PPS_OUT_0      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_ETH_RMII_CRS_DV_0  (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ETH_RMII_REF_CLK_0 (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ETH_RMII_RXD0_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ETH_RMII_RXD1_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#define GPIO_ETH_RMII_TX_EN_1   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_ETH_RMII_TX_EN_2   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_ETH_RMII_TX_EN_3   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)
#define GPIO_ETH_RMII_TXD0_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_ETH_RMII_TXD0_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_ETH_RMII_TXD0_3    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN13)
#define GPIO_ETH_RMII_TXD1_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN15)
#define GPIO_ETH_RMII_TXD1_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN12)
#define GPIO_ETH_RMII_TXD1_3    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)

/* FDCAN */

#define GPIO_FDCAN1_RX_1               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTA | GPIO_PIN11)
#define GPIO_FDCAN1_RX_2               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN8)
#define GPIO_FDCAN1_RX_3               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTD | GPIO_PIN0)
#define GPIO_FDCAN1_RX_4               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTE | GPIO_PIN0)
#define GPIO_FDCAN1_RX_5               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTH | GPIO_PIN14)
#define GPIO_FDCAN1_RX_6               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTI | GPIO_PIN9)
#define GPIO_FDCAN1_RX_7               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTI | GPIO_PIN10)

#define GPIO_FDCAN1_TX_1               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTA | GPIO_PIN12)
#define GPIO_FDCAN1_TX_2               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN9)
#define GPIO_FDCAN1_TX_3               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN7)
#define GPIO_FDCAN1_TX_4               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTD | GPIO_PIN1)
#define GPIO_FDCAN1_TX_5               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTD | GPIO_PIN5)
#define GPIO_FDCAN1_TX_6               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTE | GPIO_PIN1)
#define GPIO_FDCAN1_TX_7               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTH | GPIO_PIN13)

#define GPIO_FDCAN2_RX_1               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN5)
#define GPIO_FDCAN2_RX_2               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN12)
#define GPIO_FDCAN2_RX_3               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTD | GPIO_PIN9)

#define GPIO_FDCAN2_TX_1               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN6)
#define GPIO_FDCAN2_TX_2               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTB | GPIO_PIN13)
#define GPIO_FDCAN2_TX_3               (GPIO_ALT | GPIO_AF9 | GPIO_PUSHPULL | GPIO_PORTA | GPIO_PIN10)

/* Clocks outputs */

#define GPIO_MCO_0             (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN8)

/* I2C */

#define GPIO_I2C1_SDA_1        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN7)
#define GPIO_I2C1_SDA_2        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN9)
#define GPIO_I2C1_SCL_1        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN6)
#define GPIO_I2C1_SCL_2        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN8)
#define GPIO_I2C1_SMBA_1       (GPIO_ALT|GPIO_AF4|GPIO_PORTB|GPIO_PIN5)

#define GPIO_I2C2_SDA_1        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN11)
#define GPIO_I2C2_SDA_2        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN12)
#define GPIO_I2C2_SDA_3        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN3)
#define GPIO_I2C2_SDA_4        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN5)
#define GPIO_I2C2_SCL_1        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN10)
#define GPIO_I2C2_SCL_2        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN1)
#define GPIO_I2C2_SCL_3        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN4)
#define GPIO_I2C2_SMBA_1       (GPIO_ALT|GPIO_AF4|GPIO_PORTH|GPIO_PIN6)

#define GPIO_I2C3_SDA_1        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN9)
#define GPIO_I2C3_SDA_2        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN8)
#define GPIO_I2C3_SCL_1        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN8)
#define GPIO_I2C3_SCL_2        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN7)
#define GPIO_I2C3_SMBA_1       (GPIO_ALT|GPIO_AF4|GPIO_PORTA|GPIO_PIN9)
#define GPIO_I2C3_SMBA_2       (GPIO_ALT|GPIO_AF4|GPIO_PORTH|GPIO_PIN9)

#define GPIO_I2C4_SDA_1        (GPIO_ALT|GPIO_AF6|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN7)
#define GPIO_I2C4_SDA_2        (GPIO_ALT|GPIO_AF6|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN9)
#define GPIO_I2C4_SDA_3        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTD|GPIO_PIN13)
#define GPIO_I2C4_SDA_4        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN15)
#define GPIO_I2C4_SCL_1        (GPIO_ALT|GPIO_AF6|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN6)
#define GPIO_I2C4_SCL_2        (GPIO_ALT|GPIO_AF6|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN8)
#define GPIO_I2C4_SCL_3        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTD|GPIO_PIN12)
#define GPIO_I2C4_SCL_4        (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN5)
#define GPIO_I2C4_SMBA_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN5)
#define GPIO_I2C4_SMBA_2       (GPIO_ALT|GPIO_AF4|GPIO_PORTD|GPIO_PIN11)
#define GPIO_I2C4_SMBA_3       (GPIO_ALT|GPIO_AF4|GPIO_PORTF|GPIO_PIN13)

/* JTAG */

#define GPIO_JTCK_SWCLK_0      (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN14)
#define GPIO_JTDI_0            (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN15)
#define GPIO_JTDO_0            (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN3)
#define GPIO_JTMS_SWDAT_0      (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN13)
#define GPIO_JTRST_0           (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN4)

/* OCTOSPI / QSPI */

#define GPIO_OCTOSPI1_CLK_1       (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN3)
#define GPIO_OCTOSPI1_CLK_2       (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN4)
#define GPIO_OCTOSPI1_CLK_3       (GPIO_ALT|GPIO_AF9|GPIO_PORTB|GPIO_PIN2)
#define GPIO_OCTOSPI1_CLK_4       (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN15)
#define GPIO_OCTOSPI1_CLK_5       (GPIO_ALT|GPIO_AF9|GPIO_PORTF|GPIO_PIN10)

#define GPIO_OCTOSPI1_NCLK_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN5)
#define GPIO_OCTOSPI1_NCLK_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN12)
#define GPIO_OCTOSPI1_NCLK_3      (GPIO_ALT|GPIO_AF9|GPIO_PORTF|GPIO_PIN11)

#define GPIO_OCTOSPI1_NCS_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN11)
#define GPIO_OCTOSPI1_NCS_2       (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN6)
#define GPIO_OCTOSPI1_NCS_3       (GPIO_ALT|GPIO_AF9|GPIO_PORTB|GPIO_PIN10)
#define GPIO_OCTOSPI1_NCS_4       (GPIO_ALT|GPIO_AF9|GPIO_PORTC|GPIO_PIN11)
#define GPIO_OCTOSPI1_NCS_5       (GPIO_ALT|GPIO_AF10|GPIO_PORTG|GPIO_PIN6)

#define GPIO_OCTOSPI1_DQS_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN1)
#define GPIO_OCTOSPI1_DQS_2       (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN2)
#define GPIO_OCTOSPI1_DQS_3       (GPIO_ALT|GPIO_AF10|GPIO_PORTC|GPIO_PIN5)

#define GPIO_OCTOSPI1_IO0_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN1)
#define GPIO_OCTOSPI1_IO0_2       (GPIO_ALT|GPIO_AF9|GPIO_PORTC|GPIO_PIN3)
#define GPIO_OCTOSPI1_IO0_3       (GPIO_ALT|GPIO_AF9|GPIO_PORTC|GPIO_PIN9)
#define GPIO_OCTOSPI1_IO0_4       (GPIO_ALT|GPIO_AF9|GPIO_PORTD|GPIO_PIN11)
#define GPIO_OCTOSPI1_IO0_5       (GPIO_ALT|GPIO_AF10|GPIO_PORTF|GPIO_PIN8)

#define GPIO_OCTOSPI1_IO1_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN0)
#define GPIO_OCTOSPI1_IO1_2       (GPIO_ALT|GPIO_AF9|GPIO_PORTC|GPIO_PIN10)
#define GPIO_OCTOSPI1_IO1_3       (GPIO_ALT|GPIO_AF9|GPIO_PORTD|GPIO_PIN12)
#define GPIO_OCTOSPI1_IO1_4       (GPIO_ALT|GPIO_AF10|GPIO_PORTF|GPIO_PIN9)

#define GPIO_OCTOSPI1_IO2_1       (GPIO_ALT|GPIO_AF10|GPIO_PORTA|GPIO_PIN7)
#define GPIO_OCTOSPI1_IO2_2       (GPIO_ALT|GPIO_AF9|GPIO_PORTC|GPIO_PIN2)
#define GPIO_OCTOSPI1_IO2_3       (GPIO_ALT|GPIO_AF9|GPIO_PORTE|GPIO_PIN2)
#define GPIO_OCTOSPI1_IO2_4       (GPIO_ALT|GPIO_AF10|GPIO_PORTF|GPIO_PIN7)

#define GPIO_OCTOSPI1_IO3_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN6)
#define GPIO_OCTOSPI1_IO3_2       (GPIO_ALT|GPIO_AF9|GPIO_PORTA|GPIO_PIN1)
#define GPIO_OCTOSPI1_IO3_3       (GPIO_ALT|GPIO_AF9|GPIO_PORTD|GPIO_PIN13)
#define GPIO_OCTOSPI1_IO3_4       (GPIO_ALT|GPIO_AF10|GPIO_PORTF|GPIO_PIN6)

#define GPIO_OCTOSPI1_IO4_1       (GPIO_ALT|GPIO_AF10|GPIO_PORTC|GPIO_PIN1)
#define GPIO_OCTOSPI1_IO4_2       (GPIO_ALT|GPIO_AF10|GPIO_PORTD|GPIO_PIN4)
#define GPIO_OCTOSPI1_IO4_3       (GPIO_ALT|GPIO_AF10|GPIO_PORTE|GPIO_PIN7)
#define GPIO_OCTOSPI1_IO4_4       (GPIO_ALT|GPIO_AF9|GPIO_PORTH|GPIO_PIN2)

#define GPIO_OCTOSPI1_IO5_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN2)
#define GPIO_OCTOSPI1_IO5_2       (GPIO_ALT|GPIO_AF11|GPIO_PORTC|GPIO_PIN6)
#define GPIO_OCTOSPI1_IO5_3       (GPIO_ALT|GPIO_AF10|GPIO_PORTD|GPIO_PIN5)
#define GPIO_OCTOSPI1_IO5_4       (GPIO_ALT|GPIO_AF10|GPIO_PORTE|GPIO_PIN8)
#define GPIO_OCTOSPI1_IO5_5       (GPIO_ALT|GPIO_AF9|GPIO_PORTH|GPIO_PIN3)

#define GPIO_OCTOSPI1_IO6_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN3)
#define GPIO_OCTOSPI1_IO6_2       (GPIO_ALT|GPIO_AF11|GPIO_PORTC|GPIO_PIN7)
#define GPIO_OCTOSPI1_IO6_3       (GPIO_ALT|GPIO_AF10|GPIO_PORTD|GPIO_PIN6)
#define GPIO_OCTOSPI1_IO6_4       (GPIO_ALT|GPIO_AF10|GPIO_PORTE|GPIO_PIN9)
#define GPIO_OCTOSPI1_IO6_5       (GPIO_ALT|GPIO_AF9|GPIO_PORTG|GPIO_PIN9)

#define GPIO_OCTOSPI1_IO7_1       (GPIO_ALT|GPIO_AF10|GPIO_PORTC|GPIO_PIN0)
#define GPIO_OCTOSPI1_IO7_2       (GPIO_ALT|GPIO_AF10|GPIO_PORTD|GPIO_PIN7)
#define GPIO_OCTOSPI1_IO7_3       (GPIO_ALT|GPIO_AF10|GPIO_PORTE|GPIO_PIN10)
#define GPIO_OCTOSPI1_IO7_4       (GPIO_ALT|GPIO_AF9|GPIO_PORTG|GPIO_PIN14)

/* SPI */

#define GPIO_SPI1_MISO_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SPI1_MISO_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI1_MISO_3          (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN9)
#define GPIO_SPI1_MOSI_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN7)
#define GPIO_SPI1_MOSI_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI1_MOSI_3          (GPIO_ALT|GPIO_AF5|GPIO_PORTD|GPIO_PIN7)
#define GPIO_SPI1_NSS_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI1_NSS_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI1_NSS_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN10)
#define GPIO_SPI1_SCK_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN5)
#define GPIO_SPI1_SCK_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN3)
#define GPIO_SPI1_SCK_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN11)
#define GPIO_SPI1_RDY_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN8)
#define GPIO_SPI1_RDY_2           (GPIO_ALT|GPIO_AF4|GPIO_PORTB|GPIO_PIN2)
#define GPIO_SPI1_RDY_3           (GPIO_ALT|GPIO_AF4|GPIO_PORTE|GPIO_PIN11)
#define GPIO_SPI1_RDY_4           (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN6)

#define GPIO_SPI2_MISO_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN14)
#define GPIO_SPI2_MISO_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN2)
#define GPIO_SPI2_MISO_3          (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN2)
#define GPIO_SPI2_MOSI_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN15)
#define GPIO_SPI2_MOSI_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN1)
#define GPIO_SPI2_MOSI_3          (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN3)
#define GPIO_SPI2_MOSI_4          (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN1)
#define GPIO_SPI2_MOSI_5          (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN3)
#define GPIO_SPI2_NSS_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN11)
#define GPIO_SPI2_NSS_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN12)
#define GPIO_SPI2_NSS_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN9)
#define GPIO_SPI2_NSS_4           (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN0)
#define GPIO_SPI2_NSS_5           (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI2_SCK_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN12)
#define GPIO_SPI2_SCK_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN9)
#define GPIO_SPI2_SCK_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN10)
#define GPIO_SPI2_SCK_4           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN13)
#define GPIO_SPI2_SCK_5           (GPIO_ALT|GPIO_AF5|GPIO_PORTD|GPIO_PIN3)
#define GPIO_SPI2_SCK_6           (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN1)
#define GPIO_SPI2_RDY_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN11)
#define GPIO_SPI2_RDY_2           (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN0)
#define GPIO_SPI2_RDY_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTD|GPIO_PIN5)
#define GPIO_SPI2_RDY_4           (GPIO_ALT|GPIO_AF7|GPIO_PORTI|GPIO_PIN4)

#define GPIO_SPI3_MISO_1          (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI3_MISO_2          (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN11)
#define GPIO_SPI3_MOSI_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTD|GPIO_PIN6)
#define GPIO_SPI3_MOSI_2          (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN12)
#define GPIO_SPI3_MOSI_3          (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN2)
#define GPIO_SPI3_MOSI_4          (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI3_NSS_1           (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI3_NSS_2           (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI3_SCK_1           (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN3)
#define GPIO_SPI3_SCK_2           (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN10)
#define GPIO_SPI3_RDY_1           (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN0)
#define GPIO_SPI3_RDY_2           (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN0)

#define GPIO_SPI4_MISO_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN13)
#define GPIO_SPI4_MISO_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN5)
#define GPIO_SPI4_MOSI_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN14)
#define GPIO_SPI4_MOSI_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN6)
#define GPIO_SPI4_NSS_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN11)
#define GPIO_SPI4_NSS_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN4)
#define GPIO_SPI4_SCK_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN12)
#define GPIO_SPI4_SCK_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTE|GPIO_PIN2)
#define GPIO_SPI4_RDY_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN8)
#define GPIO_SPI4_RDY_2           (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN11)
#define GPIO_SPI4_RDY_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN15)

#define GPIO_SPI5_MISO_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTF|GPIO_PIN8)
#define GPIO_SPI5_MISO_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN7)
#define GPIO_SPI5_MOSI_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTF|GPIO_PIN11)
#define GPIO_SPI5_MOSI_2          (GPIO_ALT|GPIO_AF5|GPIO_PORTF|GPIO_PIN9)
#define GPIO_SPI5_MOSI_3          (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN8)
#define GPIO_SPI5_NSS_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTF|GPIO_PIN6)
#define GPIO_SPI5_NSS_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN5)
#define GPIO_SPI5_NSS_3           (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN9)
#define GPIO_SPI5_SCK_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTF|GPIO_PIN7)
#define GPIO_SPI5_SCK_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN6)
#define GPIO_SPI5_RDY_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN4)
#define GPIO_SPI5_RDY_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTH|GPIO_PIN4)

#define GPIO_SPI6_MISO_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN12)
#define GPIO_SPI6_MISO_2          (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SPI6_MISO_3          (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI6_MOSI_1          (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN14)
#define GPIO_SPI6_MOSI_2          (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN7)
#define GPIO_SPI6_MOSI_3          (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI6_NSS_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN8)
#define GPIO_SPI6_NSS_2           (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI6_NSS_3           (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI6_SCK_1           (GPIO_ALT|GPIO_AF5|GPIO_PORTG|GPIO_PIN13)
#define GPIO_SPI6_SCK_2           (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN12)
#define GPIO_SPI6_SCK_3           (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN5)
#define GPIO_SPI6_SCK_4           (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN3)
#define GPIO_SPI6_RDY_1           (GPIO_ALT|GPIO_AF7|GPIO_PORTH|GPIO_PIN4)
#define GPIO_SPI6_RDY_2           (GPIO_ALT|GPIO_AF7|GPIO_PORTH|GPIO_PIN5)

/* Trace */

#define GPIO_TRACECK_0         (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN2)

#define GPIO_TRACED0_0         (GPIO_ALT|GPIO_AF0|GPIO_PORTC|GPIO_PIN1)
#define GPIO_TRACED0_1         (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TRACED0_2         (GPIO_ALT|GPIO_AF0|GPIO_PORTG|GPIO_PIN13)

#define GPIO_TRACED1_0         (GPIO_ALT|GPIO_AF0|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TRACED1_1         (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN4)
#define GPIO_TRACED1_2         (GPIO_ALT|GPIO_AF0|GPIO_PORTC|GPIO_PIN14)

#define GPIO_TRACED2_0         (GPIO_ALT|GPIO_AF0|GPIO_PORTD|GPIO_PIN2)
#define GPIO_TRACED2_1         (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN5)

#define GPIO_TRACED3_0         (GPIO_ALT|GPIO_AF0|GPIO_PORTC|GPIO_PIN12)
#define GPIO_TRACED3_1         (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN6)

/* Timers */

/*  TIM1 (AF1)  */

#define GPIO_TIM1_CH1OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)   /* PA8  */
#define GPIO_TIM1_CH1OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN9)   /* PE9  */
#define GPIO_TIM1_CH1OUT_3        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN11)  /* PH11 */

#define GPIO_TIM1_CH1NOUT_1       (GPIO_ALT|GPIO_AF1|GPIO_PORTA|GPIO_PIN7)   /* PA7  */
#define GPIO_TIM1_CH1NOUT_2       (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN13)  /* PB13 */
#define GPIO_TIM1_CH1NOUT_3       (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN8)   /* PE8  */
#define GPIO_TIM1_CH1NOUT_4       (GPIO_ALT|GPIO_AF1|GPIO_PORTH|GPIO_PIN10)  /* PH10 */

#define GPIO_TIM1_CH2OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)   /* PA9  */
#define GPIO_TIM1_CH2OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN11)  /* PE11 */
#define GPIO_TIM1_CH2OUT_3        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN9)   /* PH9  */

#define GPIO_TIM1_CH2NOUT_1       (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN0)   /* PB0  */
#define GPIO_TIM1_CH2NOUT_2       (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN14)  /* PB14 */
#define GPIO_TIM1_CH2NOUT_3       (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN10)  /* PE10 */
#define GPIO_TIM1_CH2NOUT_4       (GPIO_ALT|GPIO_AF1|GPIO_PORTH|GPIO_PIN8)   /* PH8  */

#define GPIO_TIM1_CH3OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN10)  /* PA10 */
#define GPIO_TIM1_CH3OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN13)  /* PE13 */
#define GPIO_TIM1_CH3OUT_3        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN7)   /* PH7  */

#define GPIO_TIM1_CH3NOUT_1       (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN1)   /* PB1  */
#define GPIO_TIM1_CH3NOUT_2       (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN15)  /* PB15 */
#define GPIO_TIM1_CH3NOUT_3       (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN12)  /* PE12 */
#define GPIO_TIM1_CH3NOUT_4       (GPIO_ALT|GPIO_AF1|GPIO_PORTH|GPIO_PIN6)   /* PH6  */

#define GPIO_TIM1_CH4OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)  /* PA11 */
#define GPIO_TIM1_CH4OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN14)  /* PE14 */

#define GPIO_TIM1_CH4NOUT_1       (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN15)  /* PE15 */
#define GPIO_TIM1_CH4NOUT_2       (GPIO_ALT|GPIO_AF1|GPIO_PORTC|GPIO_PIN5)   /* PC5  */

/*  TIM2 (AF1)  */

#define GPIO_TIM2_CH1OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)   /* PA0  */
#define GPIO_TIM2_CH1OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)   /* PA5  */
#define GPIO_TIM2_CH1OUT_3        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN15)  /* PA15 */

#define GPIO_TIM2_CH2OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)   /* PA1  */
#define GPIO_TIM2_CH2OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN3)   /* PB3  */

#define GPIO_TIM2_CH3OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)   /* PA2  */
#define GPIO_TIM2_CH3OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)  /* PB10 */

#define GPIO_TIM2_CH4OUT_1        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)   /* PA3  */
#define GPIO_TIM2_CH4OUT_2        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)  /* PB11 */
#define GPIO_TIM2_CH4OUT_3        (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)   /* PC4  */

/*  TIM3 (AF2)  */

#define GPIO_TIM3_CH1OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)   /* PA6  */
#define GPIO_TIM3_CH1OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN4)   /* PB4  */
#define GPIO_TIM3_CH1OUT_3        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)   /* PC6  */

#define GPIO_TIM3_CH2OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)   /* PA7  */
#define GPIO_TIM3_CH2OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)   /* PB5  */
#define GPIO_TIM3_CH2OUT_3        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)   /* PC7  */

#define GPIO_TIM3_CH3OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)   /* PB0  */
#define GPIO_TIM3_CH3OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)   /* PC8  */

#define GPIO_TIM3_CH4OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)   /* PB1  */
#define GPIO_TIM3_CH4OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)   /* PC9  */

/*  TIM4 (AF2)  */

#define GPIO_TIM4_CH1OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)   /* PB6  */
#define GPIO_TIM4_CH2OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN7)   /* PB7  */
#define GPIO_TIM4_CH3OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)   /* PB8  */
#define GPIO_TIM4_CH4OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)   /* PB9  */
#define GPIO_TIM4_CH4OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)   /* PC2  */

/*  TIM5 (AF2)  */

#define GPIO_TIM5_CH1OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)   /* PA0  */
#define GPIO_TIM5_CH1OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN10)  /* PH10 */

#define GPIO_TIM5_CH2OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)   /* PA1  */
#define GPIO_TIM5_CH2OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN11)  /* PH11 */

#define GPIO_TIM5_CH3OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)   /* PA2  */
#define GPIO_TIM5_CH3OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN12)  /* PH12 */

#define GPIO_TIM5_CH4OUT_1        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)   /* PA3  */
#define GPIO_TIM5_CH4OUT_2        (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN0)   /* PI0  */

/*  TIM8 (AF3)  */

#define GPIO_TIM8_CH1OUT_1        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)   /* PC6  */
#define GPIO_TIM8_CH1OUT_2        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN5)   /* PI5  */
#define GPIO_TIM8_CH1OUT_3        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)   /* PH6  */

#define GPIO_TIM8_CH1NOUT_1       (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN5)   /* PA5  */
#define GPIO_TIM8_CH1NOUT_2       (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN7)   /* PA7  */
#define GPIO_TIM8_CH1NOUT_3       (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN7)   /* PH7  */
#define GPIO_TIM8_CH1NOUT_4       (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN13)  /* PH13 */

#define GPIO_TIM8_CH2OUT_1        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)   /* PC7  */
#define GPIO_TIM8_CH2OUT_2        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN6)   /* PI6  */
#define GPIO_TIM8_CH2OUT_3        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN8)   /* PH8  */

#define GPIO_TIM8_CH2NOUT_1       (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN0)   /* PB0  */
#define GPIO_TIM8_CH2NOUT_2       (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN14)  /* PB14 */
#define GPIO_TIM8_CH2NOUT_3       (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN9)   /* PH9  */
#define GPIO_TIM8_CH2NOUT_4       (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN14)  /* PH14 */

#define GPIO_TIM8_CH3OUT_1        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)   /* PC8  */
#define GPIO_TIM8_CH3OUT_2        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN10)  /* PH10 */
#define GPIO_TIM8_CH3OUT_3        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN7)   /* PI7  */

#define GPIO_TIM8_CH3NOUT_1       (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN1)   /* PB1  */
#define GPIO_TIM8_CH3NOUT_2       (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN15)  /* PB15 */
#define GPIO_TIM8_CH3NOUT_3       (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN11)  /* PH11 */
#define GPIO_TIM8_CH3NOUT_4       (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN15)  /* PH15 */

#define GPIO_TIM8_CH4OUT_1        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)   /* PC9  */
#define GPIO_TIM8_CH4OUT_2        (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN2)   /* PI2  */

#define GPIO_TIM8_CH4NOUT_1       (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN2)   /* PB2  */

/*  TIM12 (AF2)  */

#define GPIO_TIM12_CH1OUT_1       (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN14)  /* PB14 */
#define GPIO_TIM12_CH1OUT_2       (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)   /* PH6  */

#define GPIO_TIM12_CH2OUT_1       (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN15)  /* PB15 */
#define GPIO_TIM12_CH2OUT_2       (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN9)   /* PH9  */

/*  TIM15 (AF2/AF4, per pin) */

#define GPIO_TIM15_CH1OUT_1       (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)   /* PA2  */
#define GPIO_TIM15_CH1OUT_2       (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN5)   /* PE5  */
#define GPIO_TIM15_CH1OUT_3       (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN12)  /* PC12 */

#define GPIO_TIM15_CH1NOUT_1      (GPIO_ALT|GPIO_AF4|GPIO_PORTA|GPIO_PIN1)   /* PA1  */
#define GPIO_TIM15_CH1NOUT_2      (GPIO_ALT|GPIO_AF4|GPIO_PORTE|GPIO_PIN4)   /* PE4  */

#define GPIO_TIM15_CH2OUT_1       (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)   /* PA3  */
#define GPIO_TIM15_CH2OUT_2       (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN6)   /* PE6  */

/*  TIM16 (AF1)  */

#define GPIO_TIM16_CH1OUT_1       (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)   /* PB8  */
#define GPIO_TIM16_CH1OUT_2       (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN6)   /* PF6  */
#define GPIO_TIM16_CH1NOUT_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN6)                 /* PB6  */
#define GPIO_TIM16_CH1NOUT_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTF|GPIO_PIN8)                 /* PF8  */

/*  TIM17 (AF1)  */

#define GPIO_TIM17_CH1OUT_1       (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)   /* PB9  */
#define GPIO_TIM17_CH1OUT_2       (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN7)   /* PF7  */
#define GPIO_TIM17_CH1NOUT_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN7)                 /* PB7  */
#define GPIO_TIM17_CH1NOUT_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTF|GPIO_PIN9)                 /* PF9  */

/* UARTs/USARTs */

/* UART4 */

#define GPIO_UART4_TX_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN12)
#define GPIO_UART4_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN0)
#define GPIO_UART4_TX_3       (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN9)
#define GPIO_UART4_TX_4       (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN10)
#define GPIO_UART4_TX_5       (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN1)
#define GPIO_UART4_TX_6       (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN12)
#define GPIO_UART4_TX_7       (GPIO_ALT|GPIO_AF8|GPIO_PORTH|GPIO_PIN13)

#define GPIO_UART4_RX_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN11)
#define GPIO_UART4_RX_2       (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN1)
#define GPIO_UART4_RX_3       (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN8)
#define GPIO_UART4_RX_4       (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN11)
#define GPIO_UART4_RX_5       (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN0)
#define GPIO_UART4_RX_6       (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN11)
#define GPIO_UART4_RX_7       (GPIO_ALT|GPIO_AF8|GPIO_PORTH|GPIO_PIN14)
#define GPIO_UART4_RX_8       (GPIO_ALT|GPIO_AF8|GPIO_PORTI|GPIO_PIN9)

#define GPIO_UART4_CTS_1      (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN0)
#define GPIO_UART4_CTS_2      (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN15)

#define GPIO_UART4_RTS_DE_1   (GPIO_ALT|GPIO_AF8|GPIO_PORTA|GPIO_PIN15)
#define GPIO_UART4_RTS_DE_2   (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN14)

/* UART5 */

#define GPIO_UART5_TX_1       (GPIO_ALT|GPIO_AF14|GPIO_PORTB|GPIO_PIN6)
#define GPIO_UART5_TX_2       (GPIO_ALT|GPIO_AF14|GPIO_PORTB|GPIO_PIN13)
#define GPIO_UART5_TX_3       (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN12)

#define GPIO_UART5_RX_1       (GPIO_ALT|GPIO_AF14|GPIO_PORTB|GPIO_PIN5)
#define GPIO_UART5_RX_2       (GPIO_ALT|GPIO_AF14|GPIO_PORTB|GPIO_PIN12)
#define GPIO_UART5_RX_3       (GPIO_ALT|GPIO_AF14|GPIO_PORTB|GPIO_PIN15)
#define GPIO_UART5_RX_4       (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN2)

#define GPIO_UART5_CTS_1      (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN9)

#define GPIO_UART5_RTS_DE_1   (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN8)

/* UART7 */

#define GPIO_UART7_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN8)
#define GPIO_UART7_TX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN7)
#define GPIO_UART7_TX_3       (GPIO_ALT|GPIO_AF11|GPIO_PORTA|GPIO_PIN15)
#define GPIO_UART7_TX_4       (GPIO_ALT|GPIO_AF11|GPIO_PORTB|GPIO_PIN4)

#define GPIO_UART7_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN7)
#define GPIO_UART7_RX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN6)
#define GPIO_UART7_RX_3       (GPIO_ALT|GPIO_AF11|GPIO_PORTA|GPIO_PIN8)
#define GPIO_UART7_RX_4       (GPIO_ALT|GPIO_AF11|GPIO_PORTB|GPIO_PIN3)

#define GPIO_UART7_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN10)
#define GPIO_UART7_CTS_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN9)

#define GPIO_UART7_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN9)
#define GPIO_UART7_RTS_DE_2   (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN8)

/* UART8 */

#define GPIO_UART8_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTH|GPIO_PIN13)
#define GPIO_UART8_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PORTE|GPIO_PIN1)
#define GPIO_UART8_TX_3       (GPIO_ALT|GPIO_AF8|GPIO_PORTE|GPIO_PIN2)

#define GPIO_UART8_RX_1       (GPIO_ALT|GPIO_AF8|GPIO_PORTE|GPIO_PIN0)

#define GPIO_UART8_CTS_1      (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN14)

#define GPIO_UART8_RTS_DE_1   (GPIO_ALT|GPIO_AF8|GPIO_PORTD|GPIO_PIN15)

/* UART12 */

#define GPIO_UART12_TX_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN10)
#define GPIO_UART12_TX_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTF|GPIO_PIN2)
#define GPIO_UART12_TX_3       (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN3)

#define GPIO_UART12_RX_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN9)
#define GPIO_UART12_RX_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTF|GPIO_PIN5)
#define GPIO_UART12_RX_3       (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN2)

#define GPIO_UART12_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN3)
#define GPIO_UART12_CTS_2      (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN8)

#define GPIO_UART12_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN5)
#define GPIO_UART12_RTS_DE_2   (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN7)

/* USART1 */

#define GPIO_USART1_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN9)
#define GPIO_USART1_TX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN6)
#define GPIO_USART1_TX_3       (GPIO_ALT|GPIO_AF4|GPIO_PORTD|GPIO_PIN14)

#define GPIO_USART1_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN10)
#define GPIO_USART1_RX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN7)
#define GPIO_USART1_RX_3       (GPIO_ALT|GPIO_AF4|GPIO_PORTB|GPIO_PIN15)

#define GPIO_USART1_CK_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN8)

#define GPIO_USART1_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN11)

#define GPIO_USART1_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN12)

/* USART2 */

#define GPIO_USART2_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN2)
#define GPIO_USART2_TX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN5)

#define GPIO_USART2_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN3)
#define GPIO_USART2_RX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN6)

#define GPIO_USART2_CK_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN4)
#define GPIO_USART2_CK_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN4)

#define GPIO_USART2_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN0)
#define GPIO_USART2_CTS_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN3)

#define GPIO_USART2_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN1)
#define GPIO_USART2_RTS_DE_2   (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN4)

/* USART3 */

#define GPIO_USART3_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN10)
#define GPIO_USART3_TX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN4)
#define GPIO_USART3_TX_3       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN10)
#define GPIO_USART3_TX_4       (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN8)

#define GPIO_USART3_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN11)
#define GPIO_USART3_RX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN5)
#define GPIO_USART3_RX_3       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN11)
#define GPIO_USART3_RX_4       (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN9)

#define GPIO_USART3_CK_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN0)
#define GPIO_USART3_CK_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN12)
#define GPIO_USART3_CK_3       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN12)
#define GPIO_USART3_CK_4       (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN10)

#define GPIO_USART3_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN6)
#define GPIO_USART3_CTS_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN13)
#define GPIO_USART3_CTS_3      (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN11)

#define GPIO_USART3_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN15)
#define GPIO_USART3_RTS_DE_2   (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN1)
#define GPIO_USART3_RTS_DE_3   (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN14)
#define GPIO_USART3_RTS_DE_4   (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN2)
#define GPIO_USART3_RTS_DE_5   (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN12)

/* USART6 */

#define GPIO_USART6_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN6)
#define GPIO_USART6_TX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN14)

#define GPIO_USART6_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN7)
#define GPIO_USART6_RX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN9)

#define GPIO_USART6_CK_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN8)
#define GPIO_USART6_CK_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN7)

#define GPIO_USART6_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN13)
#define GPIO_USART6_CTS_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN15)

#define GPIO_USART6_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN8)
#define GPIO_USART6_RTS_DE_2   (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN12)

/* USART10 */

#define GPIO_USART10_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN3)
#define GPIO_USART10_TX_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTG|GPIO_PIN12)

#define GPIO_USART10_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN2)
#define GPIO_USART10_RX_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTG|GPIO_PIN11)

#define GPIO_USART10_CK_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTE|GPIO_PIN15)
#define GPIO_USART10_CK_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTG|GPIO_PIN15)

#define GPIO_USART10_CTS_1      (GPIO_ALT|GPIO_AF6|GPIO_PORTG|GPIO_PIN13)

#define GPIO_USART10_RTS_DE_1   (GPIO_ALT|GPIO_AF6|GPIO_PORTG|GPIO_PIN14)

/* USART11 */

#define GPIO_USART11_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN6)
#define GPIO_USART11_TX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN3)

#define GPIO_USART11_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN7)
#define GPIO_USART11_RX_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN4)

#define GPIO_USART11_CK_1       (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN0)
#define GPIO_USART11_CK_2       (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN2)

#define GPIO_USART11_CTS_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN15)
#define GPIO_USART11_CTS_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTF|GPIO_PIN5)

#define GPIO_USART11_RTS_DE_1   (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN1)
#define GPIO_USART11_RTS_DE_2   (GPIO_ALT|GPIO_AF7|GPIO_PORTG|GPIO_PIN11)

/* LPUART1 */

#define GPIO_LPUART1_TX_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN9)
#define GPIO_LPUART1_TX_2      (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN6)

#define GPIO_LPUART1_RX_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN10)
#define GPIO_LPUART1_RX_2      (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN7)

#define GPIO_LPUART1_CTS_1     (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN11)

#define GPIO_LPUART1_RTS_DE_1  (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN12)

/* USB */

#define GPIO_USB_DM           (GPIO_ALT|GPIO_AF10|GPIO_PUSHPULL|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN11)
#define GPIO_USB_DP           (GPIO_ALT|GPIO_AF10|GPIO_PUSHPULL|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN12)
#define GPIO_USB_SOF          (GPIO_ALT|GPIO_AF10|GPIO_PUSHPULL|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN8)

/* ADC1 */

#define GPIO_ADC1_INP0_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN0)
#define GPIO_ADC1_INP1_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN1)
#define GPIO_ADC1_INN1_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN0)
#define GPIO_ADC1_INP2_0   (GPIO_ANALOG | GPIO_PORTF | GPIO_PIN11)
#define GPIO_ADC1_INN2_0   (GPIO_ANALOG | GPIO_PORTF | GPIO_PIN12)
#define GPIO_ADC1_INP3_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN6)
#define GPIO_ADC1_INN3_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN7)
#define GPIO_ADC1_INP4_0   (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN4)
#define GPIO_ADC1_INN4_0   (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN5)
#define GPIO_ADC1_INP5_0   (GPIO_ANALOG | GPIO_PORTB | GPIO_PIN1)
#define GPIO_ADC1_INN5_0   (GPIO_ANALOG | GPIO_PORTB | GPIO_PIN0)
#define GPIO_ADC1_INP6_0   (GPIO_ANALOG | GPIO_PORTF | GPIO_PIN12)
#define GPIO_ADC1_INP7_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN7)
#define GPIO_ADC1_INP8_0   (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN5)
#define GPIO_ADC1_INP9_0   (GPIO_ANALOG | GPIO_PORTB | GPIO_PIN0)
#define GPIO_ADC1_INP10_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN0)
#define GPIO_ADC1_INN10_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN1)
#define GPIO_ADC1_INP11_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN1)
#define GPIO_ADC1_INN11_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN2)
#define GPIO_ADC1_INP12_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN2)
#define GPIO_ADC1_INN12_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN3)
#define GPIO_ADC1_INP13_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN3)
#define GPIO_ADC1_INP14_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN2)
#define GPIO_ADC1_INP15_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN3)
#define GPIO_ADC1_INP18_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN4)
#define GPIO_ADC1_INN18_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN5)
#define GPIO_ADC1_INP19_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN5)

/* ADC2 */

#define GPIO_ADC2_INP0_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN0)
#define GPIO_ADC2_INP1_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN1)
#define GPIO_ADC2_INN1_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN0)
#define GPIO_ADC2_INP2_0   (GPIO_ANALOG | GPIO_PORTF | GPIO_PIN13)
#define GPIO_ADC2_INN2_0   (GPIO_ANALOG | GPIO_PORTF | GPIO_PIN14)
#define GPIO_ADC2_INP3_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN6)
#define GPIO_ADC2_INN3_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN7)
#define GPIO_ADC2_INP4_0   (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN4)
#define GPIO_ADC2_INN4_0   (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN5)
#define GPIO_ADC2_INP5_0   (GPIO_ANALOG | GPIO_PORTB | GPIO_PIN1)
#define GPIO_ADC2_INN5_0   (GPIO_ANALOG | GPIO_PORTB | GPIO_PIN0)
#define GPIO_ADC2_INP6_0   (GPIO_ANALOG | GPIO_PORTF | GPIO_PIN14)
#define GPIO_ADC2_INP7_0   (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN7)
#define GPIO_ADC2_INP8_0   (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN5)
#define GPIO_ADC2_INP9_0   (GPIO_ANALOG | GPIO_PORTB | GPIO_PIN0)
#define GPIO_ADC2_INP10_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN0)
#define GPIO_ADC2_INN10_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN1)
#define GPIO_ADC2_INP11_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN1)
#define GPIO_ADC2_INN11_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN2)
#define GPIO_ADC2_INP12_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN2)
#define GPIO_ADC2_INN12_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN3)
#define GPIO_ADC2_INP13_0  (GPIO_ANALOG | GPIO_PORTC | GPIO_PIN3)
#define GPIO_ADC2_INP14_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN2)
#define GPIO_ADC2_INP15_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN3)
#define GPIO_ADC2_INP18_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN4)
#define GPIO_ADC2_INN18_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN5)
#define GPIO_ADC2_INP19_0  (GPIO_ANALOG | GPIO_PORTA | GPIO_PIN5)

#endif /* CONFIG_STM32H5_STM32H563XX*/
#endif /* __ARCH_ARM_SRC_STM32H5_HARDWARE_STM32H56XXX_PINMAP_H */
