/****************************************************************************
 * arch/arm/src/rp23xx/hardware/rp23xx_accessctrl.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_RP23XX_HARDWARE_RP23XX_ACCESSCTRL_H
#define __ARCH_ARM_SRC_RP23XX_HARDWARE_RP23XX_ACCESSCTRL_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/rp23xx_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Register offsets *********************************************************/

#define RP23XX_ACCESSCTRL_LOCK_OFFSET               0x00000000
#define RP23XX_ACCESSCTRL_FORCE_CORE_NS_OFFSET      0x00000004
#define RP23XX_ACCESSCTRL_CFGRESET_OFFSET           0x00000008
#define RP23XX_ACCESSCTRL_GPIO_NSMASK0_OFFSET       0x0000000c
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_OFFSET       0x00000010
#define RP23XX_ACCESSCTRL_ROM_OFFSET                0x00000014
#define RP23XX_ACCESSCTRL_XIP_MAIN_OFFSET           0x00000018
#define RP23XX_ACCESSCTRL_SRAM0_OFFSET              0x0000001c
#define RP23XX_ACCESSCTRL_SRAM1_OFFSET              0x00000020
#define RP23XX_ACCESSCTRL_SRAM2_OFFSET              0x00000024
#define RP23XX_ACCESSCTRL_SRAM3_OFFSET              0x00000028
#define RP23XX_ACCESSCTRL_SRAM4_OFFSET              0x0000002c
#define RP23XX_ACCESSCTRL_SRAM5_OFFSET              0x00000030
#define RP23XX_ACCESSCTRL_SRAM6_OFFSET              0x00000034
#define RP23XX_ACCESSCTRL_SRAM7_OFFSET              0x00000038
#define RP23XX_ACCESSCTRL_SRAM8_OFFSET              0x0000003c
#define RP23XX_ACCESSCTRL_SRAM9_OFFSET              0x00000040
#define RP23XX_ACCESSCTRL_DMA_OFFSET                0x00000044
#define RP23XX_ACCESSCTRL_USBCTRL_OFFSET            0x00000048
#define RP23XX_ACCESSCTRL_PIO0_OFFSET               0x0000004c
#define RP23XX_ACCESSCTRL_PIO1_OFFSET               0x00000050
#define RP23XX_ACCESSCTRL_PIO2_OFFSET               0x00000054
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_OFFSET    0x00000058
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_OFFSET   0x0000005c
#define RP23XX_ACCESSCTRL_SYSINFO_OFFSET            0x00000060
#define RP23XX_ACCESSCTRL_RESETS_OFFSET             0x00000064
#define RP23XX_ACCESSCTRL_IO_BANK0_OFFSET           0x00000068
#define RP23XX_ACCESSCTRL_IO_BANK1_OFFSET           0x0000006c
#define RP23XX_ACCESSCTRL_PADS_BANK0_OFFSET         0x00000070
#define RP23XX_ACCESSCTRL_PADS_QSPI_OFFSET          0x00000074
#define RP23XX_ACCESSCTRL_BUSCTRL_OFFSET            0x00000078
#define RP23XX_ACCESSCTRL_ADC0_OFFSET               0x0000007c
#define RP23XX_ACCESSCTRL_HSTX_OFFSET               0x00000080
#define RP23XX_ACCESSCTRL_I2C0_OFFSET               0x00000084
#define RP23XX_ACCESSCTRL_I2C1_OFFSET               0x00000088
#define RP23XX_ACCESSCTRL_PWM_OFFSET                0x0000008c
#define RP23XX_ACCESSCTRL_SPI0_OFFSET               0x00000090
#define RP23XX_ACCESSCTRL_SPI1_OFFSET               0x00000094
#define RP23XX_ACCESSCTRL_TIMER0_OFFSET             0x00000098
#define RP23XX_ACCESSCTRL_TIMER1_OFFSET             0x0000009c
#define RP23XX_ACCESSCTRL_UART0_OFFSET              0x000000a0
#define RP23XX_ACCESSCTRL_UART1_OFFSET              0x000000a4
#define RP23XX_ACCESSCTRL_OTP_OFFSET                0x000000a8
#define RP23XX_ACCESSCTRL_TBMAN_OFFSET              0x000000ac
#define RP23XX_ACCESSCTRL_POWMAN_OFFSET             0x000000b0
#define RP23XX_ACCESSCTRL_TRNG_OFFSET               0x000000b4
#define RP23XX_ACCESSCTRL_SHA256_OFFSET             0x000000b8
#define RP23XX_ACCESSCTRL_SYSCFG_OFFSET             0x000000bc
#define RP23XX_ACCESSCTRL_CLOCKS_OFFSET             0x000000c0
#define RP23XX_ACCESSCTRL_XOSC_OFFSET               0x000000c4
#define RP23XX_ACCESSCTRL_ROSC_OFFSET               0x000000c8
#define RP23XX_ACCESSCTRL_PLL_SYS_OFFSET            0x000000cc
#define RP23XX_ACCESSCTRL_PLL_USB_OFFSET            0x000000d0
#define RP23XX_ACCESSCTRL_TICKS_OFFSET              0x000000d4
#define RP23XX_ACCESSCTRL_WATCHDOG_OFFSET           0x000000d8
#define RP23XX_ACCESSCTRL_RSM_OFFSET                0x000000dc
#define RP23XX_ACCESSCTRL_XIP_CTRL_OFFSET           0x000000e0
#define RP23XX_ACCESSCTRL_XIP_QMI_OFFSET            0x000000e4
#define RP23XX_ACCESSCTRL_XIP_AUX_OFFSET            0x000000e8

/* Register definitions *****************************************************/

#define RP23XX_ACCESSCTRL_LOCK              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_LOCK_OFFSET)
#define RP23XX_ACCESSCTRL_FORCE_CORE_NS     (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_FORCE_CORE_NS_OFFSET)
#define RP23XX_ACCESSCTRL_CFGRESET          (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_CFGRESET_OFFSET)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK0      (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_GPIO_NSMASK0_OFFSET)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1      (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_GPIO_NSMASK1_OFFSET)
#define RP23XX_ACCESSCTRL_ROM               (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_ROM_OFFSET)
#define RP23XX_ACCESSCTRL_XIP_MAIN          (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_XIP_MAIN_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM0             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM0_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM1             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM1_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM2             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM2_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM3             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM3_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM4             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM4_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM5             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM5_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM6             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM6_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM7             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM7_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM8             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM8_OFFSET)
#define RP23XX_ACCESSCTRL_SRAM9             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SRAM9_OFFSET)
#define RP23XX_ACCESSCTRL_DMA               (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_DMA_OFFSET)
#define RP23XX_ACCESSCTRL_USBCTRL           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_USBCTRL_OFFSET)
#define RP23XX_ACCESSCTRL_PIO0              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PIO0_OFFSET)
#define RP23XX_ACCESSCTRL_PIO1              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PIO1_OFFSET)
#define RP23XX_ACCESSCTRL_PIO2              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PIO2_OFFSET)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE   (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_CORESIGHT_TRACE_OFFSET)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH  (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_OFFSET)
#define RP23XX_ACCESSCTRL_SYSINFO           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SYSINFO_OFFSET)
#define RP23XX_ACCESSCTRL_RESETS            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_RESETS_OFFSET)
#define RP23XX_ACCESSCTRL_IO_BANK0          (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_IO_BANK0_OFFSET)
#define RP23XX_ACCESSCTRL_IO_BANK1          (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_IO_BANK1_OFFSET)
#define RP23XX_ACCESSCTRL_PADS_BANK0        (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PADS_BANK0_OFFSET)
#define RP23XX_ACCESSCTRL_PADS_QSPI         (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PADS_QSPI_OFFSET)
#define RP23XX_ACCESSCTRL_BUSCTRL           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_BUSCTRL_OFFSET)
#define RP23XX_ACCESSCTRL_ADC0              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_ADC0_OFFSET)
#define RP23XX_ACCESSCTRL_HSTX              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_HSTX_OFFSET)
#define RP23XX_ACCESSCTRL_I2C0              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_I2C0_OFFSET)
#define RP23XX_ACCESSCTRL_I2C1              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_I2C1_OFFSET)
#define RP23XX_ACCESSCTRL_PWM               (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PWM_OFFSET)
#define RP23XX_ACCESSCTRL_SPI0              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SPI0_OFFSET)
#define RP23XX_ACCESSCTRL_SPI1              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SPI1_OFFSET)
#define RP23XX_ACCESSCTRL_TIMER0            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_TIMER0_OFFSET)
#define RP23XX_ACCESSCTRL_TIMER1            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_TIMER1_OFFSET)
#define RP23XX_ACCESSCTRL_UART0             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_UART0_OFFSET)
#define RP23XX_ACCESSCTRL_UART1             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_UART1_OFFSET)
#define RP23XX_ACCESSCTRL_OTP               (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_OTP_OFFSET)
#define RP23XX_ACCESSCTRL_TBMAN             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_TBMAN_OFFSET)
#define RP23XX_ACCESSCTRL_POWMAN            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_POWMAN_OFFSET)
#define RP23XX_ACCESSCTRL_TRNG              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_TRNG_OFFSET)
#define RP23XX_ACCESSCTRL_SHA256            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SHA256_OFFSET)
#define RP23XX_ACCESSCTRL_SYSCFG            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_SYSCFG_OFFSET)
#define RP23XX_ACCESSCTRL_CLOCKS            (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_CLOCKS_OFFSET)
#define RP23XX_ACCESSCTRL_XOSC              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_XOSC_OFFSET)
#define RP23XX_ACCESSCTRL_ROSC              (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_ROSC_OFFSET)
#define RP23XX_ACCESSCTRL_PLL_SYS           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PLL_SYS_OFFSET)
#define RP23XX_ACCESSCTRL_PLL_USB           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_PLL_USB_OFFSET)
#define RP23XX_ACCESSCTRL_TICKS             (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_TICKS_OFFSET)
#define RP23XX_ACCESSCTRL_WATCHDOG          (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_WATCHDOG_OFFSET)
#define RP23XX_ACCESSCTRL_RSM               (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_RSM_OFFSET)
#define RP23XX_ACCESSCTRL_XIP_CTRL          (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_XIP_CTRL_OFFSET)
#define RP23XX_ACCESSCTRL_XIP_QMI           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_XIP_QMI_OFFSET)
#define RP23XX_ACCESSCTRL_XIP_AUX           (RP23XX_ACCESSCTRL_BASE + RP23XX_ACCESSCTRL_XIP_AUX_OFFSET)

/* Register bit definitions *************************************************/

#define RP23XX_ACCESSCTRL_LOCK_MASK                     (0x0000000f)
#define RP23XX_ACCESSCTRL_LOCK_DEBUG_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_LOCK_DMA_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_LOCK_CORE1_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_LOCK_CORE0_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_FORCE_CORE_NS_MASK            (1 << 1)
#define RP23XX_ACCESSCTRL_FORCE_CORE_NS_CORE1_MASK      (1 << 1)
#define RP23XX_ACCESSCTRL_CFGRESET_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK0_MASK             (0xffffffff)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_MASK             (0xff00ffff)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_QSPI_SD_MASK     (0xf0000000)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_QSPI_CSN_MASK    (1 << 27)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_QSPI_SCK_MASK    (1 << 26)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_USB_DM_MASK      (1 << 25)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_USB_DP_MASK      (1 << 24)
#define RP23XX_ACCESSCTRL_GPIO_NSMASK1_GPIO_MASK        (0x0000ffff)
#define RP23XX_ACCESSCTRL_ROM_MASK                      (0x000000ff)
#define RP23XX_ACCESSCTRL_ROM_DBG_MASK                  (1 << 7)
#define RP23XX_ACCESSCTRL_ROM_DMA_MASK                  (1 << 6)
#define RP23XX_ACCESSCTRL_ROM_CORE1_MASK                (1 << 5)
#define RP23XX_ACCESSCTRL_ROM_CORE0_MASK                (1 << 4)
#define RP23XX_ACCESSCTRL_ROM_SP_MASK                   (1 << 3)
#define RP23XX_ACCESSCTRL_ROM_SU_MASK                   (1 << 2)
#define RP23XX_ACCESSCTRL_ROM_NSP_MASK                  (1 << 1)
#define RP23XX_ACCESSCTRL_ROM_NSU_MASK                  (1 << 0)
#define RP23XX_ACCESSCTRL_XIP_MAIN_MASK                 (0x000000ff)
#define RP23XX_ACCESSCTRL_XIP_MAIN_DBG_MASK             (1 << 7)
#define RP23XX_ACCESSCTRL_XIP_MAIN_DMA_MASK             (1 << 6)
#define RP23XX_ACCESSCTRL_XIP_MAIN_CORE1_MASK           (1 << 5)
#define RP23XX_ACCESSCTRL_XIP_MAIN_CORE0_MASK           (1 << 4)
#define RP23XX_ACCESSCTRL_XIP_MAIN_SP_MASK              (1 << 3)
#define RP23XX_ACCESSCTRL_XIP_MAIN_SU_MASK              (1 << 2)
#define RP23XX_ACCESSCTRL_XIP_MAIN_NSP_MASK             (1 << 1)
#define RP23XX_ACCESSCTRL_XIP_MAIN_NSU_MASK             (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM0_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM0_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM0_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM0_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM0_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM0_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM0_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM0_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM0_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM1_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM1_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM1_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM1_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM1_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM1_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM1_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM1_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM1_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM2_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM2_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM2_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM2_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM2_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM2_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM2_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM2_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM2_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM3_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM3_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM3_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM3_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM3_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM3_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM3_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM3_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM3_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM4_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM4_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM4_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM4_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM4_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM4_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM4_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM4_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM4_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM5_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM5_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM5_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM5_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM5_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM5_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM5_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM5_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM5_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM6_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM6_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM6_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM6_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM6_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM6_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM6_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM6_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM6_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM7_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM7_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM7_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM7_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM7_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM7_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM7_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM7_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM7_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM8_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM8_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM8_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM8_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM8_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM8_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM8_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM8_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM8_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_SRAM9_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_SRAM9_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_SRAM9_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_SRAM9_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_SRAM9_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_SRAM9_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_SRAM9_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_SRAM9_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_SRAM9_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_DMA_MASK                      (0x000000ff)
#define RP23XX_ACCESSCTRL_DMA_DBG_MASK                  (1 << 7)
#define RP23XX_ACCESSCTRL_DMA_DMA_MASK                  (1 << 6)
#define RP23XX_ACCESSCTRL_DMA_CORE1_MASK                (1 << 5)
#define RP23XX_ACCESSCTRL_DMA_CORE0_MASK                (1 << 4)
#define RP23XX_ACCESSCTRL_DMA_SP_MASK                   (1 << 3)
#define RP23XX_ACCESSCTRL_DMA_SU_MASK                   (1 << 2)
#define RP23XX_ACCESSCTRL_DMA_NSP_MASK                  (1 << 1)
#define RP23XX_ACCESSCTRL_DMA_NSU_MASK                  (1 << 0)
#define RP23XX_ACCESSCTRL_USBCTRL_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_USBCTRL_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_USBCTRL_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_USBCTRL_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_USBCTRL_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_USBCTRL_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_USBCTRL_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_USBCTRL_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_USBCTRL_NSU_MASK              (1 << 0)
#define RP23XX_ACCESSCTRL_PIO0_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_PIO0_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_PIO0_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_PIO0_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_PIO0_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_PIO0_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_PIO0_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_PIO0_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_PIO0_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_PIO1_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_PIO1_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_PIO1_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_PIO1_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_PIO1_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_PIO1_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_PIO1_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_PIO1_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_PIO1_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_PIO2_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_PIO2_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_PIO2_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_PIO2_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_PIO2_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_PIO2_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_PIO2_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_PIO2_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_PIO2_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_MASK          (0x000000ff)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_DBG_MASK      (1 << 7)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_DMA_MASK      (1 << 6)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_CORE1_MASK    (1 << 5)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_CORE0_MASK    (1 << 4)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_SP_MASK       (1 << 3)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_SU_MASK       (1 << 2)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_NSP_MASK      (1 << 1)
#define RP23XX_ACCESSCTRL_CORESIGHT_TRACE_NSU_MASK      (1 << 0)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_MASK         (0x000000ff)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_DBG_MASK     (1 << 7)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_DMA_MASK     (1 << 6)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_CORE1_MASK   (1 << 5)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_CORE0_MASK   (1 << 4)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_SP_MASK      (1 << 3)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_SU_MASK      (1 << 2)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_NSP_MASK     (1 << 1)
#define RP23XX_ACCESSCTRL_CORESIGHT_PERIPH_NSU_MASK     (1 << 0)
#define RP23XX_ACCESSCTRL_SYSINFO_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_SYSINFO_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_SYSINFO_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_SYSINFO_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_SYSINFO_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_SYSINFO_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_SYSINFO_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_SYSINFO_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_SYSINFO_NSU_MASK              (1 << 0)
#define RP23XX_ACCESSCTRL_RESETS_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_RESETS_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_RESETS_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_RESETS_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_RESETS_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_RESETS_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_RESETS_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_RESETS_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_RESETS_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_IO_BANK0_MASK                 (0x000000ff)
#define RP23XX_ACCESSCTRL_IO_BANK0_DBG_MASK             (1 << 7)
#define RP23XX_ACCESSCTRL_IO_BANK0_DMA_MASK             (1 << 6)
#define RP23XX_ACCESSCTRL_IO_BANK0_CORE1_MASK           (1 << 5)
#define RP23XX_ACCESSCTRL_IO_BANK0_CORE0_MASK           (1 << 4)
#define RP23XX_ACCESSCTRL_IO_BANK0_SP_MASK              (1 << 3)
#define RP23XX_ACCESSCTRL_IO_BANK0_SU_MASK              (1 << 2)
#define RP23XX_ACCESSCTRL_IO_BANK0_NSP_MASK             (1 << 1)
#define RP23XX_ACCESSCTRL_IO_BANK0_NSU_MASK             (1 << 0)
#define RP23XX_ACCESSCTRL_IO_BANK1_MASK                 (0x000000ff)
#define RP23XX_ACCESSCTRL_IO_BANK1_DBG_MASK             (1 << 7)
#define RP23XX_ACCESSCTRL_IO_BANK1_DMA_MASK             (1 << 6)
#define RP23XX_ACCESSCTRL_IO_BANK1_CORE1_MASK           (1 << 5)
#define RP23XX_ACCESSCTRL_IO_BANK1_CORE0_MASK           (1 << 4)
#define RP23XX_ACCESSCTRL_IO_BANK1_SP_MASK              (1 << 3)
#define RP23XX_ACCESSCTRL_IO_BANK1_SU_MASK              (1 << 2)
#define RP23XX_ACCESSCTRL_IO_BANK1_NSP_MASK             (1 << 1)
#define RP23XX_ACCESSCTRL_IO_BANK1_NSU_MASK             (1 << 0)
#define RP23XX_ACCESSCTRL_PADS_BANK0_MASK               (0x000000ff)
#define RP23XX_ACCESSCTRL_PADS_BANK0_DBG_MASK           (1 << 7)
#define RP23XX_ACCESSCTRL_PADS_BANK0_DMA_MASK           (1 << 6)
#define RP23XX_ACCESSCTRL_PADS_BANK0_CORE1_MASK         (1 << 5)
#define RP23XX_ACCESSCTRL_PADS_BANK0_CORE0_MASK         (1 << 4)
#define RP23XX_ACCESSCTRL_PADS_BANK0_SP_MASK            (1 << 3)
#define RP23XX_ACCESSCTRL_PADS_BANK0_SU_MASK            (1 << 2)
#define RP23XX_ACCESSCTRL_PADS_BANK0_NSP_MASK           (1 << 1)
#define RP23XX_ACCESSCTRL_PADS_BANK0_NSU_MASK           (1 << 0)
#define RP23XX_ACCESSCTRL_PADS_QSPI_MASK                (0x000000ff)
#define RP23XX_ACCESSCTRL_PADS_QSPI_DBG_MASK            (1 << 7)
#define RP23XX_ACCESSCTRL_PADS_QSPI_DMA_MASK            (1 << 6)
#define RP23XX_ACCESSCTRL_PADS_QSPI_CORE1_MASK          (1 << 5)
#define RP23XX_ACCESSCTRL_PADS_QSPI_CORE0_MASK          (1 << 4)
#define RP23XX_ACCESSCTRL_PADS_QSPI_SP_MASK             (1 << 3)
#define RP23XX_ACCESSCTRL_PADS_QSPI_SU_MASK             (1 << 2)
#define RP23XX_ACCESSCTRL_PADS_QSPI_NSP_MASK            (1 << 1)
#define RP23XX_ACCESSCTRL_PADS_QSPI_NSU_MASK            (1 << 0)
#define RP23XX_ACCESSCTRL_BUSCTRL_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_BUSCTRL_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_BUSCTRL_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_BUSCTRL_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_BUSCTRL_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_BUSCTRL_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_BUSCTRL_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_BUSCTRL_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_BUSCTRL_NSU_MASK              (1 << 0)
#define RP23XX_ACCESSCTRL_ADC0_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_ADC0_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_ADC0_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_ADC0_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_ADC0_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_ADC0_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_ADC0_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_ADC0_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_ADC0_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_HSTX_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_HSTX_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_HSTX_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_HSTX_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_HSTX_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_HSTX_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_HSTX_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_HSTX_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_HSTX_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_I2C0_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_I2C0_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_I2C0_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_I2C0_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_I2C0_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_I2C0_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_I2C0_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_I2C0_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_I2C0_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_I2C1_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_I2C1_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_I2C1_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_I2C1_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_I2C1_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_I2C1_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_I2C1_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_I2C1_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_I2C1_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_PWM_MASK                      (0x000000ff)
#define RP23XX_ACCESSCTRL_PWM_DBG_MASK                  (1 << 7)
#define RP23XX_ACCESSCTRL_PWM_DMA_MASK                  (1 << 6)
#define RP23XX_ACCESSCTRL_PWM_CORE1_MASK                (1 << 5)
#define RP23XX_ACCESSCTRL_PWM_CORE0_MASK                (1 << 4)
#define RP23XX_ACCESSCTRL_PWM_SP_MASK                   (1 << 3)
#define RP23XX_ACCESSCTRL_PWM_SU_MASK                   (1 << 2)
#define RP23XX_ACCESSCTRL_PWM_NSP_MASK                  (1 << 1)
#define RP23XX_ACCESSCTRL_PWM_NSU_MASK                  (1 << 0)
#define RP23XX_ACCESSCTRL_SPI0_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_SPI0_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_SPI0_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_SPI0_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_SPI0_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_SPI0_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_SPI0_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_SPI0_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_SPI0_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_SPI1_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_SPI1_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_SPI1_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_SPI1_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_SPI1_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_SPI1_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_SPI1_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_SPI1_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_SPI1_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_TIMER0_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_TIMER0_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_TIMER0_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_TIMER0_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_TIMER0_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_TIMER0_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_TIMER0_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_TIMER0_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_TIMER0_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_TIMER1_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_TIMER1_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_TIMER1_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_TIMER1_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_TIMER1_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_TIMER1_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_TIMER1_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_TIMER1_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_TIMER1_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_UART0_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_UART0_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_UART0_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_UART0_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_UART0_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_UART0_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_UART0_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_UART0_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_UART0_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_UART1_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_UART1_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_UART1_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_UART1_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_UART1_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_UART1_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_UART1_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_UART1_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_UART1_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_OTP_MASK                      (0x000000ff)
#define RP23XX_ACCESSCTRL_OTP_DBG_MASK                  (1 << 7)
#define RP23XX_ACCESSCTRL_OTP_DMA_MASK                  (1 << 6)
#define RP23XX_ACCESSCTRL_OTP_CORE1_MASK                (1 << 5)
#define RP23XX_ACCESSCTRL_OTP_CORE0_MASK                (1 << 4)
#define RP23XX_ACCESSCTRL_OTP_SP_MASK                   (1 << 3)
#define RP23XX_ACCESSCTRL_OTP_SU_MASK                   (1 << 2)
#define RP23XX_ACCESSCTRL_OTP_NSP_MASK                  (1 << 1)
#define RP23XX_ACCESSCTRL_OTP_NSU_MASK                  (1 << 0)
#define RP23XX_ACCESSCTRL_TBMAN_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_TBMAN_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_TBMAN_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_TBMAN_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_TBMAN_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_TBMAN_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_TBMAN_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_TBMAN_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_TBMAN_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_POWMAN_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_POWMAN_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_POWMAN_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_POWMAN_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_POWMAN_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_POWMAN_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_POWMAN_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_POWMAN_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_POWMAN_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_TRNG_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_TRNG_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_TRNG_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_TRNG_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_TRNG_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_TRNG_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_TRNG_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_TRNG_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_TRNG_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_SHA256_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_SHA256_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_SHA256_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_SHA256_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_SHA256_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_SHA256_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_SHA256_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_SHA256_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_SHA256_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_SYSCFG_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_SYSCFG_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_SYSCFG_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_SYSCFG_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_SYSCFG_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_SYSCFG_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_SYSCFG_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_SYSCFG_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_SYSCFG_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_CLOCKS_MASK                   (0x000000ff)
#define RP23XX_ACCESSCTRL_CLOCKS_DBG_MASK               (1 << 7)
#define RP23XX_ACCESSCTRL_CLOCKS_DMA_MASK               (1 << 6)
#define RP23XX_ACCESSCTRL_CLOCKS_CORE1_MASK             (1 << 5)
#define RP23XX_ACCESSCTRL_CLOCKS_CORE0_MASK             (1 << 4)
#define RP23XX_ACCESSCTRL_CLOCKS_SP_MASK                (1 << 3)
#define RP23XX_ACCESSCTRL_CLOCKS_SU_MASK                (1 << 2)
#define RP23XX_ACCESSCTRL_CLOCKS_NSP_MASK               (1 << 1)
#define RP23XX_ACCESSCTRL_CLOCKS_NSU_MASK               (1 << 0)
#define RP23XX_ACCESSCTRL_XOSC_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_XOSC_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_XOSC_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_XOSC_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_XOSC_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_XOSC_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_XOSC_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_XOSC_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_XOSC_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_ROSC_MASK                     (0x000000ff)
#define RP23XX_ACCESSCTRL_ROSC_DBG_MASK                 (1 << 7)
#define RP23XX_ACCESSCTRL_ROSC_DMA_MASK                 (1 << 6)
#define RP23XX_ACCESSCTRL_ROSC_CORE1_MASK               (1 << 5)
#define RP23XX_ACCESSCTRL_ROSC_CORE0_MASK               (1 << 4)
#define RP23XX_ACCESSCTRL_ROSC_SP_MASK                  (1 << 3)
#define RP23XX_ACCESSCTRL_ROSC_SU_MASK                  (1 << 2)
#define RP23XX_ACCESSCTRL_ROSC_NSP_MASK                 (1 << 1)
#define RP23XX_ACCESSCTRL_ROSC_NSU_MASK                 (1 << 0)
#define RP23XX_ACCESSCTRL_PLL_SYS_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_PLL_SYS_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_PLL_SYS_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_PLL_SYS_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_PLL_SYS_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_PLL_SYS_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_PLL_SYS_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_PLL_SYS_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_PLL_SYS_NSU_MASK              (1 << 0)
#define RP23XX_ACCESSCTRL_PLL_USB_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_PLL_USB_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_PLL_USB_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_PLL_USB_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_PLL_USB_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_PLL_USB_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_PLL_USB_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_PLL_USB_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_PLL_USB_NSU_MASK              (1 << 0)
#define RP23XX_ACCESSCTRL_TICKS_MASK                    (0x000000ff)
#define RP23XX_ACCESSCTRL_TICKS_DBG_MASK                (1 << 7)
#define RP23XX_ACCESSCTRL_TICKS_DMA_MASK                (1 << 6)
#define RP23XX_ACCESSCTRL_TICKS_CORE1_MASK              (1 << 5)
#define RP23XX_ACCESSCTRL_TICKS_CORE0_MASK              (1 << 4)
#define RP23XX_ACCESSCTRL_TICKS_SP_MASK                 (1 << 3)
#define RP23XX_ACCESSCTRL_TICKS_SU_MASK                 (1 << 2)
#define RP23XX_ACCESSCTRL_TICKS_NSP_MASK                (1 << 1)
#define RP23XX_ACCESSCTRL_TICKS_NSU_MASK                (1 << 0)
#define RP23XX_ACCESSCTRL_WATCHDOG_MASK                 (0x000000ff)
#define RP23XX_ACCESSCTRL_WATCHDOG_DBG_MASK             (1 << 7)
#define RP23XX_ACCESSCTRL_WATCHDOG_DMA_MASK             (1 << 6)
#define RP23XX_ACCESSCTRL_WATCHDOG_CORE1_MASK           (1 << 5)
#define RP23XX_ACCESSCTRL_WATCHDOG_CORE0_MASK           (1 << 4)
#define RP23XX_ACCESSCTRL_WATCHDOG_SP_MASK              (1 << 3)
#define RP23XX_ACCESSCTRL_WATCHDOG_SU_MASK              (1 << 2)
#define RP23XX_ACCESSCTRL_WATCHDOG_NSP_MASK             (1 << 1)
#define RP23XX_ACCESSCTRL_WATCHDOG_NSU_MASK             (1 << 0)
#define RP23XX_ACCESSCTRL_RSM_MASK                      (0x000000ff)
#define RP23XX_ACCESSCTRL_RSM_DBG_MASK                  (1 << 7)
#define RP23XX_ACCESSCTRL_RSM_DMA_MASK                  (1 << 6)
#define RP23XX_ACCESSCTRL_RSM_CORE1_MASK                (1 << 5)
#define RP23XX_ACCESSCTRL_RSM_CORE0_MASK                (1 << 4)
#define RP23XX_ACCESSCTRL_RSM_SP_MASK                   (1 << 3)
#define RP23XX_ACCESSCTRL_RSM_SU_MASK                   (1 << 2)
#define RP23XX_ACCESSCTRL_RSM_NSP_MASK                  (1 << 1)
#define RP23XX_ACCESSCTRL_RSM_NSU_MASK                  (1 << 0)
#define RP23XX_ACCESSCTRL_XIP_CTRL_MASK                 (0x000000ff)
#define RP23XX_ACCESSCTRL_XIP_CTRL_DBG_MASK             (1 << 7)
#define RP23XX_ACCESSCTRL_XIP_CTRL_DMA_MASK             (1 << 6)
#define RP23XX_ACCESSCTRL_XIP_CTRL_CORE1_MASK           (1 << 5)
#define RP23XX_ACCESSCTRL_XIP_CTRL_CORE0_MASK           (1 << 4)
#define RP23XX_ACCESSCTRL_XIP_CTRL_SP_MASK              (1 << 3)
#define RP23XX_ACCESSCTRL_XIP_CTRL_SU_MASK              (1 << 2)
#define RP23XX_ACCESSCTRL_XIP_CTRL_NSP_MASK             (1 << 1)
#define RP23XX_ACCESSCTRL_XIP_CTRL_NSU_MASK             (1 << 0)
#define RP23XX_ACCESSCTRL_XIP_QMI_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_XIP_QMI_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_XIP_QMI_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_XIP_QMI_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_XIP_QMI_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_XIP_QMI_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_XIP_QMI_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_XIP_QMI_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_XIP_QMI_NSU_MASK              (1 << 0)
#define RP23XX_ACCESSCTRL_XIP_AUX_MASK                  (0x000000ff)
#define RP23XX_ACCESSCTRL_XIP_AUX_DBG_MASK              (1 << 7)
#define RP23XX_ACCESSCTRL_XIP_AUX_DMA_MASK              (1 << 6)
#define RP23XX_ACCESSCTRL_XIP_AUX_CORE1_MASK            (1 << 5)
#define RP23XX_ACCESSCTRL_XIP_AUX_CORE0_MASK            (1 << 4)
#define RP23XX_ACCESSCTRL_XIP_AUX_SP_MASK               (1 << 3)
#define RP23XX_ACCESSCTRL_XIP_AUX_SU_MASK               (1 << 2)
#define RP23XX_ACCESSCTRL_XIP_AUX_NSP_MASK              (1 << 1)
#define RP23XX_ACCESSCTRL_XIP_AUX_NSU_MASK              (1 << 0)

#endif /* __ARCH_ARM_SRC_RP23XX_HARDWARE_RP23XX_ACCESSCTRL_H */
