/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class ReplaceFirstEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;
    private final Evaluator<String> replacement;

    public ReplaceFirstEvaluator(Evaluator<String> subject, Evaluator<String> search, Evaluator<String> replacement) {
        this.subject = subject;
        this.search = search;
        this.replacement = replacement;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String searchValue = this.search.evaluate(evaluationContext).getValue();
        String replacementValue = this.replacement.evaluate(evaluationContext).getValue();
        return new StringQueryResult(subjectValue.replaceFirst(searchValue, replacementValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

