/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessGroupClient;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupRecursivity;

public class PGRename
extends AbstractNiFiCommand<StringResult> {
    public PGRename() {
        super("pg-rename", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Renames the given process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.PG_NAME.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String pgName = this.getRequiredArg(properties, CommandOption.PG_NAME);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity pgEntity = pgClient.getProcessGroup(pgId);
        if (pgEntity == null) {
            throw new NiFiClientException("Process group with id " + pgId + " not found.");
        }
        this.rename(pgName, pgClient, pgEntity);
        return new StringResult(pgId, this.isInteractive());
    }

    protected void rename(String pgName, ProcessGroupClient pgClient, ProcessGroupEntity pgEntity) throws NiFiClientException, IOException {
        pgEntity.setProcessGroupUpdateStrategy(ProcessGroupRecursivity.DIRECT_CHILDREN.name());
        pgEntity.getComponent().setContents(null);
        pgEntity.getComponent().setVersionControlInformation(null);
        pgEntity.getComponent().setName(pgName);
        pgClient.updateProcessGroup(pgEntity);
    }
}

