/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef H_MYNEWT_SYSCFG_
#define H_MYNEWT_SYSCFG_

#define MYNEWT_VAL(_name)                       MYNEWT_VAL_ ## _name
#define MYNEWT_VAL_CHOICE(_name, _val)          MYNEWT_VAL_ ## _name ## __ ## _val

#ifndef MYNEWT_VAL_INCLUDE_IMAGE_HEADER
#define MYNEWT_VAL_INCLUDE_IMAGE_HEADER (1)
#endif

#undef MYNEWT_VAL_LINK_TEMPLATE

#ifndef MYNEWT_VAL_MAIN_STACK_FILL
#define MYNEWT_VAL_MAIN_STACK_FILL (0)
#endif

#ifndef MYNEWT_VAL_MAIN_STACK_SIZE
#define MYNEWT_VAL_MAIN_STACK_SIZE (768)
#endif

#ifndef MYNEWT_VAL_MCU_RAM_SIZE
#define MYNEWT_VAL_MCU_RAM_SIZE (0x40000)
#endif

#ifndef MYNEWT_VAL_MCU_RAM_START
#define MYNEWT_VAL_MCU_RAM_START (0x20000000)
#endif

#ifndef MYNEWT_VAL_HARDFLOAT
#define MYNEWT_VAL_HARDFLOAT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_AES_ALT
#define MYNEWT_VAL_MBEDTLS_AES_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_AES_C
#define MYNEWT_VAL_MBEDTLS_AES_C (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_AES_FEWER_TABLES
#define MYNEWT_VAL_MBEDTLS_AES_FEWER_TABLES (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_AES_ROM_TABLES
#define MYNEWT_VAL_MBEDTLS_AES_ROM_TABLES (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ARC4_C
#define MYNEWT_VAL_MBEDTLS_ARC4_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ARIA_C
#define MYNEWT_VAL_MBEDTLS_ARIA_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_BASE64_C
#define MYNEWT_VAL_MBEDTLS_BASE64_C (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_BIGNUM_ALT
#define MYNEWT_VAL_MBEDTLS_BIGNUM_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_BLOWFISH_C
#define MYNEWT_VAL_MBEDTLS_BLOWFISH_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CAMELLIA_C
#define MYNEWT_VAL_MBEDTLS_CAMELLIA_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CCM_C
#define MYNEWT_VAL_MBEDTLS_CCM_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CHACHA20_C
#define MYNEWT_VAL_MBEDTLS_CHACHA20_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CHACHAPOLY_C
#define MYNEWT_VAL_MBEDTLS_CHACHAPOLY_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CIPHER_MODE_CBC
#define MYNEWT_VAL_MBEDTLS_CIPHER_MODE_CBC (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CIPHER_MODE_CFB
#define MYNEWT_VAL_MBEDTLS_CIPHER_MODE_CFB (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CIPHER_MODE_CTR
#define MYNEWT_VAL_MBEDTLS_CIPHER_MODE_CTR (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CIPHER_MODE_OFB
#define MYNEWT_VAL_MBEDTLS_CIPHER_MODE_OFB (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CIPHER_MODE_XTS
#define MYNEWT_VAL_MBEDTLS_CIPHER_MODE_XTS (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CMAC_C
#define MYNEWT_VAL_MBEDTLS_CMAC_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_CTR_DRBG_C
#define MYNEWT_VAL_MBEDTLS_CTR_DRBG_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_DES_C
#define MYNEWT_VAL_MBEDTLS_DES_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECDH_COMPUTE_SHARED_ALT
#define MYNEWT_VAL_MBEDTLS_ECDH_COMPUTE_SHARED_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECDH_GEN_PUBLIC_ALT
#define MYNEWT_VAL_MBEDTLS_ECDH_GEN_PUBLIC_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECDSA_GENKEY_ALT
#define MYNEWT_VAL_MBEDTLS_ECDSA_GENKEY_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECDSA_SIGN_ALT
#define MYNEWT_VAL_MBEDTLS_ECDSA_SIGN_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECDSA_VERIFY_ALT
#define MYNEWT_VAL_MBEDTLS_ECDSA_VERIFY_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECJPAKE_C
#define MYNEWT_VAL_MBEDTLS_ECJPAKE_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_ALT
#define MYNEWT_VAL_MBEDTLS_ECP_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_BP256R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_BP256R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_BP384R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_BP384R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_BP512R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_BP512R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_CURVE25519
#define MYNEWT_VAL_MBEDTLS_ECP_DP_CURVE25519 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_CURVE448
#define MYNEWT_VAL_MBEDTLS_ECP_DP_CURVE448 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP192K1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP192K1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP192R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP192R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP224K1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP224K1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP224R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP224R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP256K1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP256K1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP256R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP256R1 (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP384R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP384R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_DP_SECP521R1
#define MYNEWT_VAL_MBEDTLS_ECP_DP_SECP521R1 (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ECP_RESTARTABLE
#define MYNEWT_VAL_MBEDTLS_ECP_RESTARTABLE (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ENTROPY_C
#define MYNEWT_VAL_MBEDTLS_ENTROPY_C (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_ENTROPY_HARDWARE_ALT
#define MYNEWT_VAL_MBEDTLS_ENTROPY_HARDWARE_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_GENPRIME
#define MYNEWT_VAL_MBEDTLS_GENPRIME (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_HKDF_C
#define MYNEWT_VAL_MBEDTLS_HKDF_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_DHE_RSA_ENABLED
#define MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_DHE_RSA_ENABLED (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_ECDHE_RSA_ENABLED
#define MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_ECDHE_RSA_ENABLED (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_RSA_ENABLED
#define MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_RSA_ENABLED (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_RSA_PSK_ENABLED
#define MYNEWT_VAL_MBEDTLS_KEY_EXCHANGE_RSA_PSK_ENABLED (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_MD2_C
#define MYNEWT_VAL_MBEDTLS_MD2_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_MD4_C
#define MYNEWT_VAL_MBEDTLS_MD4_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_MD5_C
#define MYNEWT_VAL_MBEDTLS_MD5_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_MPI_MAX_SIZE
#define MYNEWT_VAL_MBEDTLS_MPI_MAX_SIZE (1024)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_NIST_KW_C
#define MYNEWT_VAL_MBEDTLS_NIST_KW_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_PKCS1_V15
#define MYNEWT_VAL_MBEDTLS_PKCS1_V15 (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_PKCS1_V21
#define MYNEWT_VAL_MBEDTLS_PKCS1_V21 (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_POLY1305_C
#define MYNEWT_VAL_MBEDTLS_POLY1305_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_RIPEMD160_C
#define MYNEWT_VAL_MBEDTLS_RIPEMD160_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_SHA1_C
#define MYNEWT_VAL_MBEDTLS_SHA1_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_SHA256_ALT
#define MYNEWT_VAL_MBEDTLS_SHA256_ALT (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_SHA256_C
#define MYNEWT_VAL_MBEDTLS_SHA256_C (1)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_SHA512_C
#define MYNEWT_VAL_MBEDTLS_SHA512_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_SSL_TLS_C
#define MYNEWT_VAL_MBEDTLS_SSL_TLS_C (0)
#endif

#ifndef MYNEWT_VAL_MBEDTLS_TIMING_C
#define MYNEWT_VAL_MBEDTLS_TIMING_C (0)
#endif

#ifndef MYNEWT_VAL_TINYCRYPT_SYSINIT_STAGE
#define MYNEWT_VAL_TINYCRYPT_SYSINIT_STAGE (200)
#endif

#ifndef MYNEWT_VAL_TINYCRYPT_UECC_RNG_TRNG_DEV_NAME
#define MYNEWT_VAL_TINYCRYPT_UECC_RNG_TRNG_DEV_NAME "trng"
#endif

#ifndef MYNEWT_VAL_TINYCRYPT_UECC_RNG_USE_TRNG
#define MYNEWT_VAL_TINYCRYPT_UECC_RNG_USE_TRNG (0)
#endif

#ifndef MYNEWT_VAL_BSP_NRF52840
#define MYNEWT_VAL_BSP_NRF52840 (1)
#endif

#ifndef MYNEWT_VAL_SOFT_PWM
#define MYNEWT_VAL_SOFT_PWM (0)
#endif

#ifndef MYNEWT_VAL_HAL_ENABLE_SOFTWARE_BREAKPOINTS
#define MYNEWT_VAL_HAL_ENABLE_SOFTWARE_BREAKPOINTS (1)
#endif

#ifndef MYNEWT_VAL_HAL_FLASH_MAX_DEVICE_COUNT
#define MYNEWT_VAL_HAL_FLASH_MAX_DEVICE_COUNT (0)
#endif

#ifndef MYNEWT_VAL_HAL_FLASH_VERIFY_BUF_SZ
#define MYNEWT_VAL_HAL_FLASH_VERIFY_BUF_SZ (16)
#endif

#ifndef MYNEWT_VAL_HAL_FLASH_VERIFY_ERASES
#define MYNEWT_VAL_HAL_FLASH_VERIFY_ERASES (0)
#endif

#ifndef MYNEWT_VAL_HAL_FLASH_VERIFY_WRITES
#define MYNEWT_VAL_HAL_FLASH_VERIFY_WRITES (0)
#endif

#ifndef MYNEWT_VAL_HAL_SBRK
#define MYNEWT_VAL_HAL_SBRK (1)
#endif

#ifndef MYNEWT_VAL_HAL_SYSTEM_RESET_CB
#define MYNEWT_VAL_HAL_SYSTEM_RESET_CB (0)
#endif

#ifndef MYNEWT_VAL_ADC_0
#define MYNEWT_VAL_ADC_0 (0)
#endif

#ifndef MYNEWT_VAL_ADC_0_REFMV_0
#define MYNEWT_VAL_ADC_0_REFMV_0 (0)
#endif

#ifndef MYNEWT_VAL_CRYPTO
#define MYNEWT_VAL_CRYPTO (0)
#endif

#ifndef MYNEWT_VAL_GPIO_AS_PIN_RESET
#define MYNEWT_VAL_GPIO_AS_PIN_RESET (1)
#endif

#ifndef MYNEWT_VAL_I2C_0
#define MYNEWT_VAL_I2C_0 (0)
#endif

#ifndef MYNEWT_VAL_I2C_0_FREQ_KHZ
#define MYNEWT_VAL_I2C_0_FREQ_KHZ (100)
#endif

#ifndef MYNEWT_VAL_I2C_0_PIN_SCL
#define MYNEWT_VAL_I2C_0_PIN_SCL (27)
#endif

#ifndef MYNEWT_VAL_I2C_0_PIN_SDA
#define MYNEWT_VAL_I2C_0_PIN_SDA (26)
#endif

#ifndef MYNEWT_VAL_I2C_1
#define MYNEWT_VAL_I2C_1 (0)
#endif

#ifndef MYNEWT_VAL_I2C_1_FREQ_KHZ
#define MYNEWT_VAL_I2C_1_FREQ_KHZ (100)
#endif

#undef MYNEWT_VAL_I2C_1_PIN_SCL

#undef MYNEWT_VAL_I2C_1_PIN_SDA

#ifndef MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION__default
#define MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION__default (0)
#endif
#ifndef MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION__disable
#define MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION__disable (1)
#endif
#ifndef MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION__enable
#define MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION__enable (0)
#endif
#ifndef MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION
#define MYNEWT_VAL_MCU_ACCESS_PORT_PROTECTION (1)
#endif

#ifndef MYNEWT_VAL_MCU_BUS_DRIVER_I2C_USE_TWIM
#define MYNEWT_VAL_MCU_BUS_DRIVER_I2C_USE_TWIM (0)
#endif

#ifndef MYNEWT_VAL_MCU_COMMON_STARTUP
#define MYNEWT_VAL_MCU_COMMON_STARTUP (1)
#endif

#ifndef MYNEWT_VAL_MCU_DCDC_ENABLED
#define MYNEWT_VAL_MCU_DCDC_ENABLED (1)
#endif

#ifndef MYNEWT_VAL_MCU_DEBUG_IGNORE_BKPT
#define MYNEWT_VAL_MCU_DEBUG_IGNORE_BKPT (0)
#endif

#ifndef MYNEWT_VAL_MCU_FLASH_MIN_WRITE_SIZE
#define MYNEWT_VAL_MCU_FLASH_MIN_WRITE_SIZE (1)
#endif

#ifndef MYNEWT_VAL_MCU_GPIO_USE_PORT_EVENT
#define MYNEWT_VAL_MCU_GPIO_USE_PORT_EVENT (0)
#endif

#ifndef MYNEWT_VAL_MCU_HFCLK_SOURCE__HFINT
#define MYNEWT_VAL_MCU_HFCLK_SOURCE__HFINT (0)
#endif
#ifndef MYNEWT_VAL_MCU_HFCLK_SOURCE__HFXO
#define MYNEWT_VAL_MCU_HFCLK_SOURCE__HFXO (1)
#endif
#ifndef MYNEWT_VAL_MCU_HFCLK_SOURCE
#define MYNEWT_VAL_MCU_HFCLK_SOURCE (1)
#endif

#ifndef MYNEWT_VAL_MCU_I2C_RECOVERY_DELAY_USEC
#define MYNEWT_VAL_MCU_I2C_RECOVERY_DELAY_USEC (100)
#endif

#ifndef MYNEWT_VAL_MCU_ICACHE_ENABLED
#define MYNEWT_VAL_MCU_ICACHE_ENABLED (1)
#endif

#ifndef MYNEWT_VAL_MCU_LFCLK_SOURCE__LFRC
#define MYNEWT_VAL_MCU_LFCLK_SOURCE__LFRC (0)
#endif
#ifndef MYNEWT_VAL_MCU_LFCLK_SOURCE__LFSYNTH
#define MYNEWT_VAL_MCU_LFCLK_SOURCE__LFSYNTH (0)
#endif
#ifndef MYNEWT_VAL_MCU_LFCLK_SOURCE__LFXO
#define MYNEWT_VAL_MCU_LFCLK_SOURCE__LFXO (1)
#endif
#ifndef MYNEWT_VAL_MCU_LFCLK_SOURCE
#define MYNEWT_VAL_MCU_LFCLK_SOURCE (1)
#endif

#ifndef MYNEWT_VAL_MCU_NRF52832
#define MYNEWT_VAL_MCU_NRF52832 (0)
#endif

#ifndef MYNEWT_VAL_MCU_NRF52840
#define MYNEWT_VAL_MCU_NRF52840 (0)
#endif

#ifndef MYNEWT_VAL_MCU_TARGET__nRF52810
#define MYNEWT_VAL_MCU_TARGET__nRF52810 (0)
#endif
#ifndef MYNEWT_VAL_MCU_TARGET__nRF52811
#define MYNEWT_VAL_MCU_TARGET__nRF52811 (0)
#endif
#ifndef MYNEWT_VAL_MCU_TARGET__nRF52832
#define MYNEWT_VAL_MCU_TARGET__nRF52832 (0)
#endif
#ifndef MYNEWT_VAL_MCU_TARGET__nRF52840
#define MYNEWT_VAL_MCU_TARGET__nRF52840 (1)
#endif
#ifndef MYNEWT_VAL_MCU_TARGET
#define MYNEWT_VAL_MCU_TARGET (1)
#endif

#ifndef MYNEWT_VAL_NFC_PINS_AS_GPIO
#define MYNEWT_VAL_NFC_PINS_AS_GPIO (1)
#endif

#ifndef MYNEWT_VAL_PWM_0
#define MYNEWT_VAL_PWM_0 (0)
#endif

#ifndef MYNEWT_VAL_PWM_1
#define MYNEWT_VAL_PWM_1 (0)
#endif

#ifndef MYNEWT_VAL_PWM_2
#define MYNEWT_VAL_PWM_2 (0)
#endif

#ifndef MYNEWT_VAL_PWM_3
#define MYNEWT_VAL_PWM_3 (0)
#endif

#ifndef MYNEWT_VAL_QSPI_ADDRMODE
#define MYNEWT_VAL_QSPI_ADDRMODE (0)
#endif

#ifndef MYNEWT_VAL_QSPI_DPMCONFIG
#define MYNEWT_VAL_QSPI_DPMCONFIG (0)
#endif

#ifndef MYNEWT_VAL_QSPI_ENABLE
#define MYNEWT_VAL_QSPI_ENABLE (0)
#endif

#ifndef MYNEWT_VAL_QSPI_FLASH_PAGE_SIZE
#define MYNEWT_VAL_QSPI_FLASH_PAGE_SIZE (256)
#endif

#ifndef MYNEWT_VAL_QSPI_FLASH_SECTOR_COUNT
#define MYNEWT_VAL_QSPI_FLASH_SECTOR_COUNT (4096)
#endif

#ifndef MYNEWT_VAL_QSPI_FLASH_SECTOR_SIZE
#define MYNEWT_VAL_QSPI_FLASH_SECTOR_SIZE (4096)
#endif

#ifndef MYNEWT_VAL_QSPI_PIN_CS
#define MYNEWT_VAL_QSPI_PIN_CS (17)
#endif

#ifndef MYNEWT_VAL_QSPI_PIN_DIO0
#define MYNEWT_VAL_QSPI_PIN_DIO0 (20)
#endif

#ifndef MYNEWT_VAL_QSPI_PIN_DIO1
#define MYNEWT_VAL_QSPI_PIN_DIO1 (21)
#endif

#ifndef MYNEWT_VAL_QSPI_PIN_DIO2
#define MYNEWT_VAL_QSPI_PIN_DIO2 (22)
#endif

#ifndef MYNEWT_VAL_QSPI_PIN_DIO3
#define MYNEWT_VAL_QSPI_PIN_DIO3 (23)
#endif

#ifndef MYNEWT_VAL_QSPI_PIN_SCK
#define MYNEWT_VAL_QSPI_PIN_SCK (19)
#endif

#ifndef MYNEWT_VAL_QSPI_READOC
#define MYNEWT_VAL_QSPI_READOC (0)
#endif

#ifndef MYNEWT_VAL_QSPI_SCK_DELAY
#define MYNEWT_VAL_QSPI_SCK_DELAY (0)
#endif

#ifndef MYNEWT_VAL_QSPI_SCK_FREQ
#define MYNEWT_VAL_QSPI_SCK_FREQ (0)
#endif

#ifndef MYNEWT_VAL_QSPI_SPI_MODE
#define MYNEWT_VAL_QSPI_SPI_MODE (0)
#endif

#ifndef MYNEWT_VAL_QSPI_WRITEOC
#define MYNEWT_VAL_QSPI_WRITEOC (0)
#endif

#ifndef MYNEWT_VAL_QSPI_XIP_OFFSET
#define MYNEWT_VAL_QSPI_XIP_OFFSET (0x10000000)
#endif

#ifndef MYNEWT_VAL_SPI_0_MASTER
#define MYNEWT_VAL_SPI_0_MASTER (0)
#endif

#ifndef MYNEWT_VAL_SPI_0_MASTER_PIN_MISO
#define MYNEWT_VAL_SPI_0_MASTER_PIN_MISO (46)
#endif

#ifndef MYNEWT_VAL_SPI_0_MASTER_PIN_MOSI
#define MYNEWT_VAL_SPI_0_MASTER_PIN_MOSI (45)
#endif

#ifndef MYNEWT_VAL_SPI_0_MASTER_PIN_SCK
#define MYNEWT_VAL_SPI_0_MASTER_PIN_SCK (47)
#endif

#ifndef MYNEWT_VAL_SPI_0_SLAVE
#define MYNEWT_VAL_SPI_0_SLAVE (0)
#endif

#ifndef MYNEWT_VAL_SPI_0_SLAVE_PIN_MISO
#define MYNEWT_VAL_SPI_0_SLAVE_PIN_MISO (46)
#endif

#ifndef MYNEWT_VAL_SPI_0_SLAVE_PIN_MOSI
#define MYNEWT_VAL_SPI_0_SLAVE_PIN_MOSI (45)
#endif

#ifndef MYNEWT_VAL_SPI_0_SLAVE_PIN_SCK
#define MYNEWT_VAL_SPI_0_SLAVE_PIN_SCK (47)
#endif

#ifndef MYNEWT_VAL_SPI_0_SLAVE_PIN_SS
#define MYNEWT_VAL_SPI_0_SLAVE_PIN_SS (44)
#endif

#ifndef MYNEWT_VAL_SPI_1_MASTER
#define MYNEWT_VAL_SPI_1_MASTER (0)
#endif

#undef MYNEWT_VAL_SPI_1_MASTER_PIN_MISO

#undef MYNEWT_VAL_SPI_1_MASTER_PIN_MOSI

#undef MYNEWT_VAL_SPI_1_MASTER_PIN_SCK

#ifndef MYNEWT_VAL_SPI_1_SLAVE
#define MYNEWT_VAL_SPI_1_SLAVE (0)
#endif

#undef MYNEWT_VAL_SPI_1_SLAVE_PIN_MISO

#undef MYNEWT_VAL_SPI_1_SLAVE_PIN_MOSI

#undef MYNEWT_VAL_SPI_1_SLAVE_PIN_SCK

#undef MYNEWT_VAL_SPI_1_SLAVE_PIN_SS

#ifndef MYNEWT_VAL_SPI_2_MASTER
#define MYNEWT_VAL_SPI_2_MASTER (0)
#endif

#undef MYNEWT_VAL_SPI_2_MASTER_PIN_MISO

#undef MYNEWT_VAL_SPI_2_MASTER_PIN_MOSI

#undef MYNEWT_VAL_SPI_2_MASTER_PIN_SCK

#ifndef MYNEWT_VAL_SPI_2_SLAVE
#define MYNEWT_VAL_SPI_2_SLAVE (0)
#endif

#undef MYNEWT_VAL_SPI_2_SLAVE_PIN_MISO

#undef MYNEWT_VAL_SPI_2_SLAVE_PIN_MOSI

#undef MYNEWT_VAL_SPI_2_SLAVE_PIN_SCK

#undef MYNEWT_VAL_SPI_2_SLAVE_PIN_SS

#ifndef MYNEWT_VAL_SPI_3_MASTER
#define MYNEWT_VAL_SPI_3_MASTER (0)
#endif

#undef MYNEWT_VAL_SPI_3_MASTER_PIN_MISO

#undef MYNEWT_VAL_SPI_3_MASTER_PIN_MOSI

#undef MYNEWT_VAL_SPI_3_MASTER_PIN_SCK

#ifndef MYNEWT_VAL_TEMP
#define MYNEWT_VAL_TEMP (0)
#endif

#ifndef MYNEWT_VAL_TIMER_0
#define MYNEWT_VAL_TIMER_0 (0)
#endif

#ifndef MYNEWT_VAL_TIMER_1
#define MYNEWT_VAL_TIMER_1 (0)
#endif

#ifndef MYNEWT_VAL_TIMER_2
#define MYNEWT_VAL_TIMER_2 (0)
#endif

#ifndef MYNEWT_VAL_TIMER_3
#define MYNEWT_VAL_TIMER_3 (0)
#endif

#ifndef MYNEWT_VAL_TIMER_4
#define MYNEWT_VAL_TIMER_4 (0)
#endif

#ifndef MYNEWT_VAL_TIMER_5
#define MYNEWT_VAL_TIMER_5 (1)
#endif

#ifndef MYNEWT_VAL_TRNG
#define MYNEWT_VAL_TRNG (0)
#endif

#ifndef MYNEWT_VAL_UART_0
#define MYNEWT_VAL_UART_0 (1)
#endif

#ifndef MYNEWT_VAL_UART_0_PIN_CTS
#define MYNEWT_VAL_UART_0_PIN_CTS (7)
#endif

#ifndef MYNEWT_VAL_UART_0_PIN_RTS
#define MYNEWT_VAL_UART_0_PIN_RTS (5)
#endif

#ifndef MYNEWT_VAL_UART_0_PIN_RX
#define MYNEWT_VAL_UART_0_PIN_RX (8)
#endif

#ifndef MYNEWT_VAL_UART_0_PIN_TX
#define MYNEWT_VAL_UART_0_PIN_TX (6)
#endif

#ifndef MYNEWT_VAL_UART_1
#define MYNEWT_VAL_UART_1 (0)
#endif

#ifndef MYNEWT_VAL_UART_1_PIN_CTS
#define MYNEWT_VAL_UART_1_PIN_CTS (-1)
#endif

#ifndef MYNEWT_VAL_UART_1_PIN_RTS
#define MYNEWT_VAL_UART_1_PIN_RTS (-1)
#endif

#undef MYNEWT_VAL_UART_1_PIN_RX

#undef MYNEWT_VAL_UART_1_PIN_TX

#ifndef MYNEWT_VAL_XTAL_32768
#define MYNEWT_VAL_XTAL_32768 (0)
#endif

#ifndef MYNEWT_VAL_XTAL_32768_SYNTH
#define MYNEWT_VAL_XTAL_32768_SYNTH (0)
#endif

#ifndef MYNEWT_VAL_XTAL_RC
#define MYNEWT_VAL_XTAL_RC (0)
#endif

#ifndef MYNEWT_VAL_JLINK_TARGET
#define MYNEWT_VAL_JLINK_TARGET (NRF52)
#endif

#ifndef MYNEWT_VAL_MYNEWT_DEBUGGER__jlink
#define MYNEWT_VAL_MYNEWT_DEBUGGER__jlink (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DEBUGGER__openocd
#define MYNEWT_VAL_MYNEWT_DEBUGGER__openocd (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DEBUGGER__pyocd
#define MYNEWT_VAL_MYNEWT_DEBUGGER__pyocd (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DEBUGGER__st_link_gdbserver
#define MYNEWT_VAL_MYNEWT_DEBUGGER__st_link_gdbserver (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DEBUGGER__stutil
#define MYNEWT_VAL_MYNEWT_DEBUGGER__stutil (0)
#endif
#undef MYNEWT_VAL_MYNEWT_DEBUGGER

#undef MYNEWT_VAL_MYNEWT_DEBUGGER_SN

#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__bsp_downloader
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__bsp_downloader (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__ezflashcli
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__ezflashcli (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__jlink
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__jlink (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__nrfjprog
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__nrfjprog (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__nrfutil
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__nrfutil (1)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__openocd
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__openocd (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__pyocd
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__pyocd (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__stflash
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__stflash (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER__stm32_programmer_cli
#define MYNEWT_VAL_MYNEWT_DOWNLOADER__stm32_programmer_cli (0)
#endif
#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER
#define MYNEWT_VAL_MYNEWT_DOWNLOADER (1)
#endif

#ifndef MYNEWT_VAL_MYNEWT_DOWNLOADER_MFG_IMAGE_FLASH_OFFSET
#define MYNEWT_VAL_MYNEWT_DOWNLOADER_MFG_IMAGE_FLASH_OFFSET (0x0)
#endif

#undef MYNEWT_VAL_MYNEWT_DOWNLOADER_OPENOCD_BOARD

#undef MYNEWT_VAL_MYNEWT_DOWNLOADER_OPENOCD_CFG

#undef MYNEWT_VAL_MYNEWT_DOWNLOADER_OPENOCD_INTERFACE

#undef MYNEWT_VAL_MYNEWT_DOWNLOADER_SCRIPT

#undef MYNEWT_VAL_NRFJPROG_COPROCESSOR

#undef MYNEWT_VAL_NRFUTIL_DFU_MODE

#undef MYNEWT_VAL_NRFUTIL_DFU_SN

#undef MYNEWT_VAL_NRFUTIL_TRAITS

#ifndef MYNEWT_VAL_PYOCD_TARGET
#define MYNEWT_VAL_PYOCD_TARGET (nrf52840)
#endif

#ifndef MYNEWT_VAL_FLOAT_USER
#define MYNEWT_VAL_FLOAT_USER (0)
#endif

#ifndef MYNEWT_VAL_MSYS_1_BLOCK_COUNT
#define MYNEWT_VAL_MSYS_1_BLOCK_COUNT (5)
#endif

#ifndef MYNEWT_VAL_MSYS_1_BLOCK_SIZE
#define MYNEWT_VAL_MSYS_1_BLOCK_SIZE (88)
#endif

#ifndef MYNEWT_VAL_MSYS_1_SANITY_MIN_COUNT
#define MYNEWT_VAL_MSYS_1_SANITY_MIN_COUNT (0)
#endif

#ifndef MYNEWT_VAL_MSYS_2_BLOCK_COUNT
#define MYNEWT_VAL_MSYS_2_BLOCK_COUNT (0)
#endif

#ifndef MYNEWT_VAL_MSYS_2_BLOCK_SIZE
#define MYNEWT_VAL_MSYS_2_BLOCK_SIZE (0)
#endif

#ifndef MYNEWT_VAL_MSYS_2_SANITY_MIN_COUNT
#define MYNEWT_VAL_MSYS_2_SANITY_MIN_COUNT (0)
#endif

#ifndef MYNEWT_VAL_MSYS_SANITY_TIMEOUT
#define MYNEWT_VAL_MSYS_SANITY_TIMEOUT (60000)
#endif

#ifndef MYNEWT_VAL_OS_ASSERT_CB
#define MYNEWT_VAL_OS_ASSERT_CB (0)
#endif

#ifndef MYNEWT_VAL_OS_CLI
#define MYNEWT_VAL_OS_CLI (0)
#endif

#ifndef MYNEWT_VAL_OS_COREDUMP
#define MYNEWT_VAL_OS_COREDUMP (0)
#endif

#ifndef MYNEWT_VAL_OS_COREDUMP_CB
#define MYNEWT_VAL_OS_COREDUMP_CB (0)
#endif

#ifndef MYNEWT_VAL_OS_CPUTIME_FREQ
#define MYNEWT_VAL_OS_CPUTIME_FREQ (32768)
#endif

#ifndef MYNEWT_VAL_OS_CPUTIME_TIMER_NUM
#define MYNEWT_VAL_OS_CPUTIME_TIMER_NUM (5)
#endif

#ifndef MYNEWT_VAL_OS_CRASH_FILE_LINE
#define MYNEWT_VAL_OS_CRASH_FILE_LINE (0)
#endif

#ifndef MYNEWT_VAL_OS_CRASH_LOG
#define MYNEWT_VAL_OS_CRASH_LOG (0)
#endif

#ifndef MYNEWT_VAL_OS_CRASH_RESTORE_REGS
#define MYNEWT_VAL_OS_CRASH_RESTORE_REGS (0)
#endif

#ifndef MYNEWT_VAL_OS_CRASH_STACKTRACE
#define MYNEWT_VAL_OS_CRASH_STACKTRACE (0)
#endif

#ifndef MYNEWT_VAL_OS_CTX_SW_STACK_CHECK
#define MYNEWT_VAL_OS_CTX_SW_STACK_CHECK (0)
#endif

#ifndef MYNEWT_VAL_OS_CTX_SW_STACK_GUARD
#define MYNEWT_VAL_OS_CTX_SW_STACK_GUARD (4)
#endif

#ifndef MYNEWT_VAL_OS_DEBUG_MODE
#define MYNEWT_VAL_OS_DEBUG_MODE (0)
#endif

#ifndef MYNEWT_VAL_OS_DEFAULT_IRQ_CB
#define MYNEWT_VAL_OS_DEFAULT_IRQ_CB (0)
#endif

#ifndef MYNEWT_VAL_OS_EVENTQ_DEBUG
#define MYNEWT_VAL_OS_EVENTQ_DEBUG (0)
#endif

#ifndef MYNEWT_VAL_OS_EVENTQ_MONITOR
#define MYNEWT_VAL_OS_EVENTQ_MONITOR (0)
#endif

#ifndef MYNEWT_VAL_OS_IDLE_TICKLESS_MS_MAX
#define MYNEWT_VAL_OS_IDLE_TICKLESS_MS_MAX (600000)
#endif

#ifndef MYNEWT_VAL_OS_IDLE_TICKLESS_MS_MIN
#define MYNEWT_VAL_OS_IDLE_TICKLESS_MS_MIN (100)
#endif

#ifndef MYNEWT_VAL_OS_MAIN_STACK_SIZE
#define MYNEWT_VAL_OS_MAIN_STACK_SIZE (1024)
#endif

#ifndef MYNEWT_VAL_OS_MAIN_TASK_PRIO
#define MYNEWT_VAL_OS_MAIN_TASK_PRIO (127)
#endif

#ifndef MYNEWT_VAL_OS_MAIN_TASK_SANITY_ITVL_MS
#define MYNEWT_VAL_OS_MAIN_TASK_SANITY_ITVL_MS (0)
#endif

#ifndef MYNEWT_VAL_OS_MEMPOOL_CHECK
#define MYNEWT_VAL_OS_MEMPOOL_CHECK (0)
#endif

#ifndef MYNEWT_VAL_OS_MEMPOOL_GUARD
#define MYNEWT_VAL_OS_MEMPOOL_GUARD (0)
#endif

#ifndef MYNEWT_VAL_OS_MEMPOOL_POISON
#define MYNEWT_VAL_OS_MEMPOOL_POISON (0)
#endif

#ifndef MYNEWT_VAL_OS_SCHEDULING
#define MYNEWT_VAL_OS_SCHEDULING (1)
#endif

#ifndef MYNEWT_VAL_OS_SYSINIT_STAGE
#define MYNEWT_VAL_OS_SYSINIT_STAGE (0)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW
#define MYNEWT_VAL_OS_SYSVIEW (0)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW_TRACE_CALLOUT
#define MYNEWT_VAL_OS_SYSVIEW_TRACE_CALLOUT (1)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW_TRACE_EVENTQ
#define MYNEWT_VAL_OS_SYSVIEW_TRACE_EVENTQ (1)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW_TRACE_MBUF
#define MYNEWT_VAL_OS_SYSVIEW_TRACE_MBUF (0)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW_TRACE_MEMPOOL
#define MYNEWT_VAL_OS_SYSVIEW_TRACE_MEMPOOL (0)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW_TRACE_MUTEX
#define MYNEWT_VAL_OS_SYSVIEW_TRACE_MUTEX (1)
#endif

#ifndef MYNEWT_VAL_OS_SYSVIEW_TRACE_SEM
#define MYNEWT_VAL_OS_SYSVIEW_TRACE_SEM (1)
#endif

#ifndef MYNEWT_VAL_OS_TASK_RUN_TIME_CPUTIME
#define MYNEWT_VAL_OS_TASK_RUN_TIME_CPUTIME (0)
#endif

#ifndef MYNEWT_VAL_OS_TICKS_PER_SEC
#define MYNEWT_VAL_OS_TICKS_PER_SEC (128)
#endif

#ifndef MYNEWT_VAL_OS_TIME_DEBUG
#define MYNEWT_VAL_OS_TIME_DEBUG (0)
#endif

#ifndef MYNEWT_VAL_OS_WATCHDOG_MONITOR
#define MYNEWT_VAL_OS_WATCHDOG_MONITOR (0)
#endif

#ifndef MYNEWT_VAL_SANITY_INTERVAL
#define MYNEWT_VAL_SANITY_INTERVAL (15000)
#endif

#ifndef MYNEWT_VAL_WATCHDOG_INTERVAL
#define MYNEWT_VAL_WATCHDOG_INTERVAL (30000)
#endif

#ifndef MYNEWT_VAL_LIBC__baselibc
#define MYNEWT_VAL_LIBC__baselibc (1)
#endif
#ifndef MYNEWT_VAL_LIBC__nano
#define MYNEWT_VAL_LIBC__nano (0)
#endif
#ifndef MYNEWT_VAL_LIBC
#define MYNEWT_VAL_LIBC (1)
#endif

#ifndef MYNEWT_VAL_BASELIBC_ASSERT_FILE_LINE
#define MYNEWT_VAL_BASELIBC_ASSERT_FILE_LINE (0)
#endif

#ifndef MYNEWT_VAL_BASELIBC_DEBUG_MALLOC
#define MYNEWT_VAL_BASELIBC_DEBUG_MALLOC (0)
#endif

#ifndef MYNEWT_VAL_BASELIBC_EXECUTE_GLOBAL_CONSTRUCTORS
#define MYNEWT_VAL_BASELIBC_EXECUTE_GLOBAL_CONSTRUCTORS (1)
#endif

#ifndef MYNEWT_VAL_BASELIBC_PRESENT
#define MYNEWT_VAL_BASELIBC_PRESENT (1)
#endif

#ifndef MYNEWT_VAL_BASELIBC_THREAD_SAFE_HEAP_ALLOCATION
#define MYNEWT_VAL_BASELIBC_THREAD_SAFE_HEAP_ALLOCATION (0)
#endif

#ifndef MYNEWT_VAL_CONSOLE_UART_BAUD
#define MYNEWT_VAL_CONSOLE_UART_BAUD (115200)
#endif

#ifndef MYNEWT_VAL_CONSOLE_UART_DEV
#define MYNEWT_VAL_CONSOLE_UART_DEV "uart0"
#endif

#ifndef MYNEWT_VAL_CONSOLE_UART_FLOW_CONTROL
#define MYNEWT_VAL_CONSOLE_UART_FLOW_CONTROL (UART_FLOW_CTL_NONE)
#endif

#ifndef MYNEWT_VAL_FLASH_MAP_MAX_AREAS
#define MYNEWT_VAL_FLASH_MAP_MAX_AREAS (10)
#endif

#ifndef MYNEWT_VAL_FLASH_MAP_SUPPORT_MFG
#define MYNEWT_VAL_FLASH_MAP_SUPPORT_MFG (0)
#endif

#ifndef MYNEWT_VAL_FLASH_MAP_SYSINIT_STAGE
#define MYNEWT_VAL_FLASH_MAP_SYSINIT_STAGE (9)
#endif

#ifndef MYNEWT_VAL_DFLT_LOG_LVL
#define MYNEWT_VAL_DFLT_LOG_LVL (1)
#endif

#ifndef MYNEWT_VAL_DFLT_LOG_MOD
#define MYNEWT_VAL_DFLT_LOG_MOD (0)
#endif

#ifndef MYNEWT_VAL_LOG_GLOBAL_IDX
#define MYNEWT_VAL_LOG_GLOBAL_IDX (1)
#endif

#ifndef MYNEWT_VAL_MODLOG_CONSOLE_DFLT
#define MYNEWT_VAL_MODLOG_CONSOLE_DFLT (1)
#endif

#ifndef MYNEWT_VAL_MODLOG_LOG_MACROS
#define MYNEWT_VAL_MODLOG_LOG_MACROS (0)
#endif

#ifndef MYNEWT_VAL_MODLOG_MAX_MAPPINGS
#define MYNEWT_VAL_MODLOG_MAX_MAPPINGS (16)
#endif

#ifndef MYNEWT_VAL_MODLOG_MAX_PRINTF_LEN
#define MYNEWT_VAL_MODLOG_MAX_PRINTF_LEN (128)
#endif

#ifndef MYNEWT_VAL_MODLOG_SYSINIT_STAGE
#define MYNEWT_VAL_MODLOG_SYSINIT_STAGE (100)
#endif

#ifndef MYNEWT_VAL_MODLOG_USE_PRINTF_ATTRIBUTE
#define MYNEWT_VAL_MODLOG_USE_PRINTF_ATTRIBUTE (0)
#endif

#ifndef MYNEWT_VAL_LOG_CONSOLE
#define MYNEWT_VAL_LOG_CONSOLE (1)
#endif

#ifndef MYNEWT_VAL_LOG_FCB
#define MYNEWT_VAL_LOG_FCB (0)
#endif

#ifndef MYNEWT_VAL_LOG_FCB_SLOT1
#define MYNEWT_VAL_LOG_FCB_SLOT1 (0)
#endif

#ifndef MYNEWT_VAL_LOG_LEVEL
#define MYNEWT_VAL_LOG_LEVEL (255)
#endif

#ifndef MYNEWT_VAL_DEBUG_PANIC_ENABLED
#define MYNEWT_VAL_DEBUG_PANIC_ENABLED (1)
#endif

#ifndef MYNEWT_VAL_SYSDOWN_CONSTRAIN_DOWN
#define MYNEWT_VAL_SYSDOWN_CONSTRAIN_DOWN (1)
#endif

#ifndef MYNEWT_VAL_SYSDOWN_PANIC_FILE_LINE
#define MYNEWT_VAL_SYSDOWN_PANIC_FILE_LINE (0)
#endif

#ifndef MYNEWT_VAL_SYSDOWN_PANIC_MESSAGE
#define MYNEWT_VAL_SYSDOWN_PANIC_MESSAGE (0)
#endif

#ifndef MYNEWT_VAL_SYSDOWN_TIMEOUT_MS
#define MYNEWT_VAL_SYSDOWN_TIMEOUT_MS (10000)
#endif

#ifndef MYNEWT_VAL_SYSINIT_CONSTRAIN_INIT
#define MYNEWT_VAL_SYSINIT_CONSTRAIN_INIT (1)
#endif

#ifndef MYNEWT_VAL_SYSINIT_PANIC_FILE_LINE
#define MYNEWT_VAL_SYSINIT_PANIC_FILE_LINE (0)
#endif

#ifndef MYNEWT_VAL_SYSINIT_PANIC_MESSAGE
#define MYNEWT_VAL_SYSINIT_PANIC_MESSAGE (0)
#endif

#ifndef MYNEWT_VAL_RWLOCK_DEBUG
#define MYNEWT_VAL_RWLOCK_DEBUG (0)
#endif

#ifndef MYNEWT_VAL_BLE_CHANNEL_SOUNDING
#define MYNEWT_VAL_BLE_CHANNEL_SOUNDING (0)
#endif

#ifndef MYNEWT_VAL_BLE_CONN_SUBRATING
#define MYNEWT_VAL_BLE_CONN_SUBRATING (0)
#endif

#ifndef MYNEWT_VAL_BLE_EXT_ADV
#define MYNEWT_VAL_BLE_EXT_ADV (0)
#endif

#ifndef MYNEWT_VAL_BLE_EXT_ADV_MAX_SIZE
#define MYNEWT_VAL_BLE_EXT_ADV_MAX_SIZE (31)
#endif

#ifndef MYNEWT_VAL_BLE_HCI_VS
#define MYNEWT_VAL_BLE_HCI_VS (1)
#endif

#ifndef MYNEWT_VAL_BLE_HCI_VS_OCF_OFFSET
#define MYNEWT_VAL_BLE_HCI_VS_OCF_OFFSET (0)
#endif

#ifndef MYNEWT_VAL_BLE_ISO
#define MYNEWT_VAL_BLE_ISO (0)
#endif

#ifndef MYNEWT_VAL_BLE_ISO_BROADCAST_SINK
#define MYNEWT_VAL_BLE_ISO_BROADCAST_SINK (0)
#endif

#ifndef MYNEWT_VAL_BLE_ISO_BROADCAST_SOURCE
#define MYNEWT_VAL_BLE_ISO_BROADCAST_SOURCE (0)
#endif

#ifndef MYNEWT_VAL_BLE_ISO_TEST
#define MYNEWT_VAL_BLE_ISO_TEST (0)
#endif

#ifndef MYNEWT_VAL_BLE_MAX_CONNECTIONS
#define MYNEWT_VAL_BLE_MAX_CONNECTIONS (1)
#endif

#ifndef MYNEWT_VAL_BLE_MAX_PERIODIC_SYNCS
#define MYNEWT_VAL_BLE_MAX_PERIODIC_SYNCS (0)
#endif

#ifndef MYNEWT_VAL_BLE_MULTI_ADV_INSTANCES
#define MYNEWT_VAL_BLE_MULTI_ADV_INSTANCES (0)
#endif

#ifndef MYNEWT_VAL_BLE_PERIODIC_ADV
#define MYNEWT_VAL_BLE_PERIODIC_ADV (0)
#endif

#ifndef MYNEWT_VAL_BLE_PERIODIC_ADV_SYNC_BIGINFO_REPORTS
#define MYNEWT_VAL_BLE_PERIODIC_ADV_SYNC_BIGINFO_REPORTS (0)
#endif

#ifndef MYNEWT_VAL_BLE_PERIODIC_ADV_SYNC_TRANSFER
#define MYNEWT_VAL_BLE_PERIODIC_ADV_SYNC_TRANSFER (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_2M
#define MYNEWT_VAL_BLE_PHY_2M (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_CODED
#define MYNEWT_VAL_BLE_PHY_CODED (0)
#endif

#ifndef MYNEWT_VAL_BLE_POWER_CONTROL
#define MYNEWT_VAL_BLE_POWER_CONTROL (0)
#endif

#ifndef MYNEWT_VAL_BLE_ROLE_BROADCASTER
#define MYNEWT_VAL_BLE_ROLE_BROADCASTER (1)
#endif

#ifndef MYNEWT_VAL_BLE_ROLE_CENTRAL
#define MYNEWT_VAL_BLE_ROLE_CENTRAL (1)
#endif

#ifndef MYNEWT_VAL_BLE_ROLE_OBSERVER
#define MYNEWT_VAL_BLE_ROLE_OBSERVER (1)
#endif

#ifndef MYNEWT_VAL_BLE_ROLE_PERIPHERAL
#define MYNEWT_VAL_BLE_ROLE_PERIPHERAL (1)
#endif

#ifndef MYNEWT_VAL_BLE_VERSION
#define MYNEWT_VAL_BLE_VERSION (50)
#endif

#ifndef MYNEWT_VAL_BLE_WHITELIST
#define MYNEWT_VAL_BLE_WHITELIST (1)
#endif

#ifndef MYNEWT_VAL_BLE_CONTROLLER
#define MYNEWT_VAL_BLE_CONTROLLER (1)
#endif

#ifndef MYNEWT_VAL_BLE_DEVICE
#define MYNEWT_VAL_BLE_DEVICE (1)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_ANTENNA
#define MYNEWT_VAL_BLE_FEM_ANTENNA (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_LNA
#define MYNEWT_VAL_BLE_FEM_LNA (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_LNA_GAIN
#define MYNEWT_VAL_BLE_FEM_LNA_GAIN (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_LNA_GAIN_TUNABLE
#define MYNEWT_VAL_BLE_FEM_LNA_GAIN_TUNABLE (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_LNA_GPIO
#define MYNEWT_VAL_BLE_FEM_LNA_GPIO (-1)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_LNA_TURN_ON_US
#define MYNEWT_VAL_BLE_FEM_LNA_TURN_ON_US (1)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_PA
#define MYNEWT_VAL_BLE_FEM_PA (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_PA_GAIN
#define MYNEWT_VAL_BLE_FEM_PA_GAIN (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_PA_GAIN_TUNABLE
#define MYNEWT_VAL_BLE_FEM_PA_GAIN_TUNABLE (0)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_PA_GPIO
#define MYNEWT_VAL_BLE_FEM_PA_GPIO (-1)
#endif

#ifndef MYNEWT_VAL_BLE_FEM_PA_TURN_ON_US
#define MYNEWT_VAL_BLE_FEM_PA_TURN_ON_US (1)
#endif

#ifndef MYNEWT_VAL_BLE_HW_WHITELIST_ENABLE
#define MYNEWT_VAL_BLE_HW_WHITELIST_ENABLE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ADD_STRICT_SCHED_PERIODS
#define MYNEWT_VAL_BLE_LL_ADD_STRICT_SCHED_PERIODS (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ADV_CODING_SELECTION
#define MYNEWT_VAL_BLE_LL_ADV_CODING_SELECTION (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_CONN_PARAM_REQ
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_CONN_PARAM_REQ (MYNEWT_VAL_BLE_LL_ROLE_CENTRAL || MYNEWT_VAL_BLE_LL_ROLE_PERIPHERAL)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_CTRL_TO_HOST_FLOW_CONTROL
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_CTRL_TO_HOST_FLOW_CONTROL (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_DATA_LEN_EXT
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_DATA_LEN_EXT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_2M_PHY
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_2M_PHY (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_CODED_PHY
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_CODED_PHY (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_CSA2
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_CSA2 (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_ENCRYPTION
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_ENCRYPTION (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_PING
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_PING (MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_ENCRYPTION)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_ENHANCED_CONN_UPDATE
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_ENHANCED_CONN_UPDATE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_EXT_ADV
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_EXT_ADV (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_ADI_SUPPORT
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_ADI_SUPPORT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_SYNC_CNT
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_SYNC_CNT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_SYNC_LIST_CNT
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_SYNC_LIST_CNT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_SYNC_TRANSFER
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PERIODIC_ADV_SYNC_TRANSFER (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_SCA_UPDATE
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_SCA_UPDATE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_PERIPH_INIT_FEAT_XCHG
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_PERIPH_INIT_FEAT_XCHG (MYNEWT_VAL_BLE_LL_ROLE_CENTRAL || MYNEWT_VAL_BLE_LL_ROLE_PERIPHERAL)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_SLAVE_INIT_FEAT_XCHG
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_SLAVE_INIT_FEAT_XCHG (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CHANNEL_SOUNDING
#define MYNEWT_VAL_BLE_LL_CHANNEL_SOUNDING (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_EVENT_END_MARGIN
#define MYNEWT_VAL_BLE_LL_CONN_EVENT_END_MARGIN (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_INIT_AUTO_DLE
#define MYNEWT_VAL_BLE_LL_CONN_INIT_AUTO_DLE (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_INIT_MAX_TX_BYTES
#define MYNEWT_VAL_BLE_LL_CONN_INIT_MAX_TX_BYTES (MYNEWT_VAL_BLE_LL_MAX_PKT_SIZE)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_INIT_MIN_WIN_OFFSET
#define MYNEWT_VAL_BLE_LL_CONN_INIT_MIN_WIN_OFFSET (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_INIT_SLOTS
#define MYNEWT_VAL_BLE_LL_CONN_INIT_SLOTS (4)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_PHY_DEFAULT_PREF_MASK
#define MYNEWT_VAL_BLE_LL_CONN_PHY_DEFAULT_PREF_MASK (0x07)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_PHY_INIT_UPDATE
#define MYNEWT_VAL_BLE_LL_CONN_PHY_INIT_UPDATE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_PHY_PREFER_2M
#define MYNEWT_VAL_BLE_LL_CONN_PHY_PREFER_2M (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED
#define MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED_FIXED
#define MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED_FIXED (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED_PERIOD_SLOTS
#define MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED_PERIOD_SLOTS (8)
#endif

#ifndef MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED_SLOT_US
#define MYNEWT_VAL_BLE_LL_CONN_STRICT_SCHED_SLOT_US (3750)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DEBUG_GPIO_HCI_CMD
#define MYNEWT_VAL_BLE_LL_DEBUG_GPIO_HCI_CMD (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DEBUG_GPIO_HCI_EV
#define MYNEWT_VAL_BLE_LL_DEBUG_GPIO_HCI_EV (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DEBUG_GPIO_RFMGMT
#define MYNEWT_VAL_BLE_LL_DEBUG_GPIO_RFMGMT (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DEBUG_GPIO_SCHED_ITEM
#define MYNEWT_VAL_BLE_LL_DEBUG_GPIO_SCHED_ITEM (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DEBUG_GPIO_SCHED_RUN
#define MYNEWT_VAL_BLE_LL_DEBUG_GPIO_SCHED_RUN (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DIRECT_TEST_MODE
#define MYNEWT_VAL_BLE_LL_DIRECT_TEST_MODE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DTM
#define MYNEWT_VAL_BLE_LL_DTM (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_DTM_EXTENSIONS
#define MYNEWT_VAL_BLE_LL_DTM_EXTENSIONS (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_EXT
#define MYNEWT_VAL_BLE_LL_EXT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_EXT_ADV_ADVA_IN_AUX
#define MYNEWT_VAL_BLE_LL_EXT_ADV_ADVA_IN_AUX (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_EXT_ADV_AUX_PTR_CNT
#define MYNEWT_VAL_BLE_LL_EXT_ADV_AUX_PTR_CNT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HBD_FAKE_DUAL_MODE
#define MYNEWT_VAL_BLE_LL_HBD_FAKE_DUAL_MODE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HCI_LLCP_TRACE
#define MYNEWT_VAL_BLE_LL_HCI_LLCP_TRACE (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HCI_VS
#define MYNEWT_VAL_BLE_LL_HCI_VS (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HCI_VS_CONN_STRICT_SCHED
#define MYNEWT_VAL_BLE_LL_HCI_VS_CONN_STRICT_SCHED (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HCI_VS_EVENT_ON_ASSERT
#define MYNEWT_VAL_BLE_LL_HCI_VS_EVENT_ON_ASSERT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HCI_VS_LOCAL_IRK
#define MYNEWT_VAL_BLE_LL_HCI_VS_LOCAL_IRK (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_HCI_VS_SET_SCAN_CFG
#define MYNEWT_VAL_BLE_LL_HCI_VS_SET_SCAN_CFG (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ISO
#define MYNEWT_VAL_BLE_LL_ISO (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ISOAL_MUX_PREFILL
#define MYNEWT_VAL_BLE_LL_ISOAL_MUX_PREFILL (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ISO_BROADCASTER
#define MYNEWT_VAL_BLE_LL_ISO_BROADCASTER (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ISO_HCI_DISCARD_THRESHOLD
#define MYNEWT_VAL_BLE_LL_ISO_HCI_DISCARD_THRESHOLD (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ISO_HCI_FEEDBACK_INTERVAL_MS
#define MYNEWT_VAL_BLE_LL_ISO_HCI_FEEDBACK_INTERVAL_MS (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_LNA
#define MYNEWT_VAL_BLE_LL_LNA (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_LNA_GPIO
#define MYNEWT_VAL_BLE_LL_LNA_GPIO (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_LNA_TURN_ON_US
#define MYNEWT_VAL_BLE_LL_LNA_TURN_ON_US (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_MANUFACTURER_ID
#define MYNEWT_VAL_BLE_LL_MANUFACTURER_ID (0x0B65)
#endif

#ifndef MYNEWT_VAL_BLE_LL_MASTER_SCA
#define MYNEWT_VAL_BLE_LL_MASTER_SCA (4)
#endif

#ifndef MYNEWT_VAL_BLE_LL_MAX_PKT_SIZE
#define MYNEWT_VAL_BLE_LL_MAX_PKT_SIZE (251)
#endif

#ifndef MYNEWT_VAL_BLE_LL_MFRG_ID
#define MYNEWT_VAL_BLE_LL_MFRG_ID (0x0B65)
#endif

#ifndef MYNEWT_VAL_BLE_LL_NUM_COMP_PKT_ITVL_MS
#define MYNEWT_VAL_BLE_LL_NUM_COMP_PKT_ITVL_MS (2000)
#endif

#ifndef MYNEWT_VAL_BLE_LL_NUM_SCAN_DUP_ADVS
#define MYNEWT_VAL_BLE_LL_NUM_SCAN_DUP_ADVS (8)
#endif

#ifndef MYNEWT_VAL_BLE_LL_NUM_SCAN_RSP_ADVS
#define MYNEWT_VAL_BLE_LL_NUM_SCAN_RSP_ADVS (8)
#endif

#ifndef MYNEWT_VAL_BLE_LL_OUR_SCA
#define MYNEWT_VAL_BLE_LL_OUR_SCA (60)
#endif

#ifndef MYNEWT_VAL_BLE_LL_PA
#define MYNEWT_VAL_BLE_LL_PA (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_PA_GPIO
#define MYNEWT_VAL_BLE_LL_PA_GPIO (-1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_PA_TURN_ON_US
#define MYNEWT_VAL_BLE_LL_PA_TURN_ON_US (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_PERIODIC_ADV_SYNC_BIGINFO_REPORTS
#define MYNEWT_VAL_BLE_LL_PERIODIC_ADV_SYNC_BIGINFO_REPORTS (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_PRIO
#define MYNEWT_VAL_BLE_LL_PRIO (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_PUBLIC_DEV_ADDR
#define MYNEWT_VAL_BLE_LL_PUBLIC_DEV_ADDR (0x000000000000)
#endif

#ifndef MYNEWT_VAL_BLE_LL_RESOLV_LIST_SIZE
#define MYNEWT_VAL_BLE_LL_RESOLV_LIST_SIZE (4)
#endif

#ifndef MYNEWT_VAL_BLE_LL_RFMGMT_ENABLE_TIME
#define MYNEWT_VAL_BLE_LL_RFMGMT_ENABLE_TIME (1500)
#endif

#ifndef MYNEWT_VAL_BLE_LL_RNG_BUFSIZE
#define MYNEWT_VAL_BLE_LL_RNG_BUFSIZE (32)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ROLE_BROADCASTER
#define MYNEWT_VAL_BLE_LL_ROLE_BROADCASTER (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ROLE_CENTRAL
#define MYNEWT_VAL_BLE_LL_ROLE_CENTRAL (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ROLE_OBSERVER
#define MYNEWT_VAL_BLE_LL_ROLE_OBSERVER (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_ROLE_PERIPHERAL
#define MYNEWT_VAL_BLE_LL_ROLE_PERIPHERAL (1)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCA
#define MYNEWT_VAL_BLE_LL_SCA (60)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCAN_ACTIVE_SCAN_NRPA
#define MYNEWT_VAL_BLE_LL_SCAN_ACTIVE_SCAN_NRPA (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCAN_AUX_SEGMENT_CNT
#define MYNEWT_VAL_BLE_LL_SCAN_AUX_SEGMENT_CNT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCHED_AUX_CHAIN_MAFS_DELAY
#define MYNEWT_VAL_BLE_LL_SCHED_AUX_CHAIN_MAFS_DELAY (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCHED_AUX_MAFS_DELAY
#define MYNEWT_VAL_BLE_LL_SCHED_AUX_MAFS_DELAY (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCHED_SCAN_AUX_PDU_LEN
#define MYNEWT_VAL_BLE_LL_SCHED_SCAN_AUX_PDU_LEN (41)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SCHED_SCAN_SYNC_PDU_LEN
#define MYNEWT_VAL_BLE_LL_SCHED_SCAN_SYNC_PDU_LEN (32)
#endif

#ifndef MYNEWT_VAL_BLE_LL_STACK_SIZE
#define MYNEWT_VAL_BLE_LL_STACK_SIZE (120)
#endif

#ifndef MYNEWT_VAL_BLE_LL_STRICT_CONN_SCHEDULING
#define MYNEWT_VAL_BLE_LL_STRICT_CONN_SCHEDULING (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SUPP_MAX_RX_BYTES
#define MYNEWT_VAL_BLE_LL_SUPP_MAX_RX_BYTES (MYNEWT_VAL_BLE_LL_MAX_PKT_SIZE)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SUPP_MAX_TX_BYTES
#define MYNEWT_VAL_BLE_LL_SUPP_MAX_TX_BYTES (MYNEWT_VAL_BLE_LL_MAX_PKT_SIZE)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SYSINIT_STAGE
#define MYNEWT_VAL_BLE_LL_SYSINIT_STAGE (250)
#endif

#ifndef MYNEWT_VAL_BLE_LL_SYSVIEW
#define MYNEWT_VAL_BLE_LL_SYSVIEW (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_TX_PWR_DBM
#define MYNEWT_VAL_BLE_LL_TX_PWR_DBM (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_TX_PWR_MAX_DBM
#define MYNEWT_VAL_BLE_LL_TX_PWR_MAX_DBM (20)
#endif

#ifndef MYNEWT_VAL_BLE_LL_USECS_PER_PERIOD
#define MYNEWT_VAL_BLE_LL_USECS_PER_PERIOD (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_VND_EVENT_ON_ASSERT
#define MYNEWT_VAL_BLE_LL_VND_EVENT_ON_ASSERT (0)
#endif

#ifndef MYNEWT_VAL_BLE_LL_WHITELIST_SIZE
#define MYNEWT_VAL_BLE_LL_WHITELIST_SIZE (8)
#endif

#ifndef MYNEWT_VAL_BLE_LP_CLOCK
#define MYNEWT_VAL_BLE_LP_CLOCK (1)
#endif

#ifndef MYNEWT_VAL_BLE_NUM_COMP_PKT_RATE
#define MYNEWT_VAL_BLE_NUM_COMP_PKT_RATE ((2 * OS_TICKS_PER_SEC))
#endif

#ifndef MYNEWT_VAL_BLE_PUBLIC_DEV_ADDR
#define MYNEWT_VAL_BLE_PUBLIC_DEV_ADDR ((uint8_t[6]){0x00, 0x00, 0x00, 0x00, 0x00, 0x00})
#endif

#ifndef MYNEWT_VAL_BLE_XTAL_SETTLE_TIME
#define MYNEWT_VAL_BLE_XTAL_SETTLE_TIME (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_DBG_TIME_ADDRESS_END_PIN
#define MYNEWT_VAL_BLE_PHY_DBG_TIME_ADDRESS_END_PIN (-1)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_DBG_TIME_TXRXEN_READY_PIN
#define MYNEWT_VAL_BLE_PHY_DBG_TIME_TXRXEN_READY_PIN (-1)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_DBG_TIME_WFR_PIN
#define MYNEWT_VAL_BLE_PHY_DBG_TIME_WFR_PIN (-1)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_EXTENDED_TIFS
#define MYNEWT_VAL_BLE_PHY_EXTENDED_TIFS (2)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_NRF52_HEADERMASK_WORKAROUND
#define MYNEWT_VAL_BLE_PHY_NRF52_HEADERMASK_WORKAROUND (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_NRF5340_VDDH
#define MYNEWT_VAL_BLE_PHY_NRF5340_VDDH (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_SYSVIEW
#define MYNEWT_VAL_BLE_PHY_SYSVIEW (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_UBLOX_BMD345_PUBLIC_ADDR
#define MYNEWT_VAL_BLE_PHY_UBLOX_BMD345_PUBLIC_ADDR (0)
#endif

#ifndef MYNEWT_VAL_BLE_PHY_VARIABLE_TIFS
#define MYNEWT_VAL_BLE_PHY_VARIABLE_TIFS (0)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_PREFERRED_MTU
#define MYNEWT_VAL_BLE_ATT_PREFERRED_MTU (256)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_FIND_INFO
#define MYNEWT_VAL_BLE_ATT_SVR_FIND_INFO (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_FIND_TYPE
#define MYNEWT_VAL_BLE_ATT_SVR_FIND_TYPE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_INDICATE
#define MYNEWT_VAL_BLE_ATT_SVR_INDICATE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_MAX_PREP_ENTRIES
#define MYNEWT_VAL_BLE_ATT_SVR_MAX_PREP_ENTRIES (64)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_NOTIFY
#define MYNEWT_VAL_BLE_ATT_SVR_NOTIFY (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_NOTIFY_MULTI
#define MYNEWT_VAL_BLE_ATT_SVR_NOTIFY_MULTI (MYNEWT_VAL_BLE_ATT_SVR_NOTIFY && (MYNEWT_VAL_BLE_VERSION >= 52))
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_QUEUED_WRITE
#define MYNEWT_VAL_BLE_ATT_SVR_QUEUED_WRITE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_QUEUED_WRITE_TMO
#define MYNEWT_VAL_BLE_ATT_SVR_QUEUED_WRITE_TMO (30000)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_READ
#define MYNEWT_VAL_BLE_ATT_SVR_READ (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_READ_BLOB
#define MYNEWT_VAL_BLE_ATT_SVR_READ_BLOB (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_READ_GROUP_TYPE
#define MYNEWT_VAL_BLE_ATT_SVR_READ_GROUP_TYPE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_READ_MULT
#define MYNEWT_VAL_BLE_ATT_SVR_READ_MULT (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_READ_TYPE
#define MYNEWT_VAL_BLE_ATT_SVR_READ_TYPE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_SIGNED_WRITE
#define MYNEWT_VAL_BLE_ATT_SVR_SIGNED_WRITE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_WRITE
#define MYNEWT_VAL_BLE_ATT_SVR_WRITE (1)
#endif

#ifndef MYNEWT_VAL_BLE_ATT_SVR_WRITE_NO_RSP
#define MYNEWT_VAL_BLE_ATT_SVR_WRITE_NO_RSP (1)
#endif

#ifndef MYNEWT_VAL_BLE_AUDIO
#define MYNEWT_VAL_BLE_AUDIO (0)
#endif

#ifndef MYNEWT_VAL_BLE_EATT_CHAN_NUM
#define MYNEWT_VAL_BLE_EATT_CHAN_NUM (0)
#endif

#ifndef MYNEWT_VAL_BLE_EATT_LOG_LVL
#define MYNEWT_VAL_BLE_EATT_LOG_LVL (1)
#endif

#ifndef MYNEWT_VAL_BLE_EATT_LOG_MOD
#define MYNEWT_VAL_BLE_EATT_LOG_MOD (27)
#endif

#ifndef MYNEWT_VAL_BLE_EATT_MTU
#define MYNEWT_VAL_BLE_EATT_MTU (128)
#endif

#ifndef MYNEWT_VAL_BLE_GAP_MAX_PENDING_CONN_PARAM_UPDATE
#define MYNEWT_VAL_BLE_GAP_MAX_PENDING_CONN_PARAM_UPDATE (1)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_DISC_ALL_CHRS
#define MYNEWT_VAL_BLE_GATT_DISC_ALL_CHRS (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_DISC_ALL_DSCS
#define MYNEWT_VAL_BLE_GATT_DISC_ALL_DSCS (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_DISC_ALL_SVCS
#define MYNEWT_VAL_BLE_GATT_DISC_ALL_SVCS (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_DISC_CHR_UUID
#define MYNEWT_VAL_BLE_GATT_DISC_CHR_UUID (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_DISC_SVC_UUID
#define MYNEWT_VAL_BLE_GATT_DISC_SVC_UUID (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_FIND_INC_SVCS
#define MYNEWT_VAL_BLE_GATT_FIND_INC_SVCS (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_INDICATE
#define MYNEWT_VAL_BLE_GATT_INDICATE (1)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_MAX_PROCS
#define MYNEWT_VAL_BLE_GATT_MAX_PROCS (4)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_NOTIFY
#define MYNEWT_VAL_BLE_GATT_NOTIFY (1)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_NOTIFY_MULTIPLE
#define MYNEWT_VAL_BLE_GATT_NOTIFY_MULTIPLE ((MYNEWT_VAL_BLE_VERSION >= 52))
#endif

#ifndef MYNEWT_VAL_BLE_GATT_READ
#define MYNEWT_VAL_BLE_GATT_READ (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_READ_LONG
#define MYNEWT_VAL_BLE_GATT_READ_LONG (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_READ_MAX_ATTRS
#define MYNEWT_VAL_BLE_GATT_READ_MAX_ATTRS (8)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_READ_MULT
#define MYNEWT_VAL_BLE_GATT_READ_MULT (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_READ_MULT_VAR
#define MYNEWT_VAL_BLE_GATT_READ_MULT_VAR (MYNEWT_VAL_BLE_ROLE_CENTRAL && (MYNEWT_VAL_BLE_VERSION >= 52))
#endif

#ifndef MYNEWT_VAL_BLE_GATT_READ_UUID
#define MYNEWT_VAL_BLE_GATT_READ_UUID (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_RESUME_RATE
#define MYNEWT_VAL_BLE_GATT_RESUME_RATE (1000)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_SIGNED_WRITE
#define MYNEWT_VAL_BLE_GATT_SIGNED_WRITE (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_WRITE
#define MYNEWT_VAL_BLE_GATT_WRITE (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_WRITE_LONG
#define MYNEWT_VAL_BLE_GATT_WRITE_LONG (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_WRITE_MAX_ATTRS
#define MYNEWT_VAL_BLE_GATT_WRITE_MAX_ATTRS (4)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_WRITE_NO_RSP
#define MYNEWT_VAL_BLE_GATT_WRITE_NO_RSP (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_GATT_WRITE_RELIABLE
#define MYNEWT_VAL_BLE_GATT_WRITE_RELIABLE (MYNEWT_VAL_BLE_ROLE_CENTRAL)
#endif

#ifndef MYNEWT_VAL_BLE_HOST
#define MYNEWT_VAL_BLE_HOST (1)
#endif

#ifndef MYNEWT_VAL_BLE_HS_AUTO_START
#define MYNEWT_VAL_BLE_HS_AUTO_START (1)
#endif

#ifndef MYNEWT_VAL_BLE_HS_DEBUG
#define MYNEWT_VAL_BLE_HS_DEBUG (0)
#endif

#ifndef MYNEWT_VAL_BLE_HS_EXT_ADV_LEGACY_INSTANCE
#define MYNEWT_VAL_BLE_HS_EXT_ADV_LEGACY_INSTANCE (0)
#endif

#ifndef MYNEWT_VAL_BLE_HS_FLOW_CTRL
#define MYNEWT_VAL_BLE_HS_FLOW_CTRL (0)
#endif

#ifndef MYNEWT_VAL_BLE_HS_FLOW_CTRL_ITVL
#define MYNEWT_VAL_BLE_HS_FLOW_CTRL_ITVL (1000)
#endif

#ifndef MYNEWT_VAL_BLE_HS_FLOW_CTRL_THRESH
#define MYNEWT_VAL_BLE_HS_FLOW_CTRL_THRESH (2)
#endif

#ifndef MYNEWT_VAL_BLE_HS_FLOW_CTRL_TX_ON_DISCONNECT
#define MYNEWT_VAL_BLE_HS_FLOW_CTRL_TX_ON_DISCONNECT (0)
#endif

#ifndef MYNEWT_VAL_BLE_HS_GAP_UNHANDLED_HCI_EVENT
#define MYNEWT_VAL_BLE_HS_GAP_UNHANDLED_HCI_EVENT (0)
#endif

#ifndef MYNEWT_VAL_BLE_HS_LOG_LVL
#define MYNEWT_VAL_BLE_HS_LOG_LVL (1)
#endif

#ifndef MYNEWT_VAL_BLE_HS_LOG_MOD
#define MYNEWT_VAL_BLE_HS_LOG_MOD (4)
#endif

#ifndef MYNEWT_VAL_BLE_HS_PHONY_HCI_ACKS
#define MYNEWT_VAL_BLE_HS_PHONY_HCI_ACKS (0)
#endif

#ifndef MYNEWT_VAL_BLE_HS_REQUIRE_OS
#define MYNEWT_VAL_BLE_HS_REQUIRE_OS (1)
#endif

#ifndef MYNEWT_VAL_BLE_HS_STOP_ON_SHUTDOWN
#define MYNEWT_VAL_BLE_HS_STOP_ON_SHUTDOWN (1)
#endif

#ifndef MYNEWT_VAL_BLE_HS_STOP_ON_SHUTDOWN_TIMEOUT
#define MYNEWT_VAL_BLE_HS_STOP_ON_SHUTDOWN_TIMEOUT (2000)
#endif

#ifndef MYNEWT_VAL_BLE_HS_SYSINIT_STAGE
#define MYNEWT_VAL_BLE_HS_SYSINIT_STAGE (200)
#endif

#ifndef MYNEWT_VAL_BLE_ISO_MAX_BIGS
#define MYNEWT_VAL_BLE_ISO_MAX_BIGS (MYNEWT_VAL_BLE_MULTI_ADV_INSTANCES)
#endif

#ifndef MYNEWT_VAL_BLE_ISO_MAX_BISES
#define MYNEWT_VAL_BLE_ISO_MAX_BISES (4)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_COC_MAX_NUM
#define MYNEWT_VAL_BLE_L2CAP_COC_MAX_NUM (0)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_COC_MPS
#define MYNEWT_VAL_BLE_L2CAP_COC_MPS (MYNEWT_VAL_MSYS_1_BLOCK_SIZE-8)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_COC_SDU_BUFF_COUNT
#define MYNEWT_VAL_BLE_L2CAP_COC_SDU_BUFF_COUNT (1)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_ENHANCED_COC
#define MYNEWT_VAL_BLE_L2CAP_ENHANCED_COC (0)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_JOIN_RX_FRAGS
#define MYNEWT_VAL_BLE_L2CAP_JOIN_RX_FRAGS (1)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_MAX_CHANS
#define MYNEWT_VAL_BLE_L2CAP_MAX_CHANS (3*MYNEWT_VAL_BLE_MAX_CONNECTIONS)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_RX_FRAG_TIMEOUT
#define MYNEWT_VAL_BLE_L2CAP_RX_FRAG_TIMEOUT (30000)
#endif

#ifndef MYNEWT_VAL_BLE_L2CAP_SIG_MAX_PROCS
#define MYNEWT_VAL_BLE_L2CAP_SIG_MAX_PROCS (1)
#endif

#ifndef MYNEWT_VAL_BLE_MESH
#define MYNEWT_VAL_BLE_MESH (0)
#endif

#ifndef MYNEWT_VAL_BLE_RPA_TIMEOUT
#define MYNEWT_VAL_BLE_RPA_TIMEOUT (300)
#endif

#ifndef MYNEWT_VAL_BLE_SM_BONDING
#define MYNEWT_VAL_BLE_SM_BONDING (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_CSIS_SIRK
#define MYNEWT_VAL_BLE_SM_CSIS_SIRK (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_IO_CAP
#define MYNEWT_VAL_BLE_SM_IO_CAP (BLE_HS_IO_NO_INPUT_OUTPUT)
#endif

#ifndef MYNEWT_VAL_BLE_SM_KEYPRESS
#define MYNEWT_VAL_BLE_SM_KEYPRESS (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_LEGACY
#define MYNEWT_VAL_BLE_SM_LEGACY (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_LVL
#define MYNEWT_VAL_BLE_SM_LVL (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_MAX_PROCS
#define MYNEWT_VAL_BLE_SM_MAX_PROCS (1)
#endif

#ifndef MYNEWT_VAL_BLE_SM_MITM
#define MYNEWT_VAL_BLE_SM_MITM (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_OOB_DATA_FLAG
#define MYNEWT_VAL_BLE_SM_OOB_DATA_FLAG (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_OUR_KEY_DIST
#define MYNEWT_VAL_BLE_SM_OUR_KEY_DIST (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_SC
#define MYNEWT_VAL_BLE_SM_SC (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_SC_DEBUG_KEYS
#define MYNEWT_VAL_BLE_SM_SC_DEBUG_KEYS (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_SC_ONLY
#define MYNEWT_VAL_BLE_SM_SC_ONLY (0)
#endif

#ifndef MYNEWT_VAL_BLE_SM_THEIR_KEY_DIST
#define MYNEWT_VAL_BLE_SM_THEIR_KEY_DIST (0)
#endif

#ifndef MYNEWT_VAL_BLE_STORE_MAX_BONDS
#define MYNEWT_VAL_BLE_STORE_MAX_BONDS (3)
#endif

#ifndef MYNEWT_VAL_BLE_STORE_MAX_CCCDS
#define MYNEWT_VAL_BLE_STORE_MAX_CCCDS (8)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_APPEARANCE
#define MYNEWT_VAL_BLE_SVC_GAP_APPEARANCE (0)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_APPEARANCE_WRITE_PERM
#define MYNEWT_VAL_BLE_SVC_GAP_APPEARANCE_WRITE_PERM (-1)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_CENTRAL_ADDRESS_RESOLUTION
#define MYNEWT_VAL_BLE_SVC_GAP_CENTRAL_ADDRESS_RESOLUTION (-1)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_DEVICE_NAME
#define MYNEWT_VAL_BLE_SVC_GAP_DEVICE_NAME "nimble"
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_DEVICE_NAME_MAX_LENGTH
#define MYNEWT_VAL_BLE_SVC_GAP_DEVICE_NAME_MAX_LENGTH (31)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_DEVICE_NAME_WRITE_PERM
#define MYNEWT_VAL_BLE_SVC_GAP_DEVICE_NAME_WRITE_PERM (-1)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_PPCP_MAX_CONN_INTERVAL
#define MYNEWT_VAL_BLE_SVC_GAP_PPCP_MAX_CONN_INTERVAL (0)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_PPCP_MIN_CONN_INTERVAL
#define MYNEWT_VAL_BLE_SVC_GAP_PPCP_MIN_CONN_INTERVAL (0)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_PPCP_SLAVE_LATENCY
#define MYNEWT_VAL_BLE_SVC_GAP_PPCP_SLAVE_LATENCY (0)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_PPCP_SUPERVISION_TMO
#define MYNEWT_VAL_BLE_SVC_GAP_PPCP_SUPERVISION_TMO (0)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GAP_SYSINIT_STAGE
#define MYNEWT_VAL_BLE_SVC_GAP_SYSINIT_STAGE (301)
#endif

#ifndef MYNEWT_VAL_BLE_SVC_GATT_SYSINIT_STAGE
#define MYNEWT_VAL_BLE_SVC_GATT_SYSINIT_STAGE (302)
#endif

#undef MYNEWT_VAL_BLE_ACL_BUF_COUNT

#undef MYNEWT_VAL_BLE_ACL_BUF_SIZE

#undef MYNEWT_VAL_BLE_HCI_BRIDGE

#undef MYNEWT_VAL_BLE_HCI_EVT_BUF_SIZE

#undef MYNEWT_VAL_BLE_HCI_EVT_HI_BUF_COUNT

#undef MYNEWT_VAL_BLE_HCI_EVT_LO_BUF_COUNT

#undef MYNEWT_VAL_BLE_HCI_TRANSPORT

#ifndef MYNEWT_VAL_BLE_MONITOR_CONSOLE_BUFFER_SIZE
#define MYNEWT_VAL_BLE_MONITOR_CONSOLE_BUFFER_SIZE (128)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_RTT
#define MYNEWT_VAL_BLE_MONITOR_RTT (0)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_RTT_BUFFERED
#define MYNEWT_VAL_BLE_MONITOR_RTT_BUFFERED (1)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_RTT_BUFFER_NAME
#define MYNEWT_VAL_BLE_MONITOR_RTT_BUFFER_NAME "btmonitor"
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_RTT_BUFFER_SIZE
#define MYNEWT_VAL_BLE_MONITOR_RTT_BUFFER_SIZE (256)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_UART
#define MYNEWT_VAL_BLE_MONITOR_UART (0)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_UART_BAUDRATE
#define MYNEWT_VAL_BLE_MONITOR_UART_BAUDRATE (1000000)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_UART_BUFFER_SIZE
#define MYNEWT_VAL_BLE_MONITOR_UART_BUFFER_SIZE (64)
#endif

#ifndef MYNEWT_VAL_BLE_MONITOR_UART_DEV
#define MYNEWT_VAL_BLE_MONITOR_UART_DEV "uart0"
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT
#define MYNEWT_VAL_BLE_TRANSPORT (1)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ACL_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_ACL_COUNT (24)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ACL_FROM_HS_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_ACL_FROM_HS_COUNT (24)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ACL_FROM_LL_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_ACL_FROM_LL_COUNT (24)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ACL_SIZE
#define MYNEWT_VAL_BLE_TRANSPORT_ACL_SIZE (251)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_EVT_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_EVT_COUNT (2)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_EVT_DISCARDABLE_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_EVT_DISCARDABLE_COUNT (16)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_EVT_SIZE
#define MYNEWT_VAL_BLE_TRANSPORT_EVT_SIZE (70)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__cdc
#define MYNEWT_VAL_BLE_TRANSPORT_HS__cdc (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__custom
#define MYNEWT_VAL_BLE_TRANSPORT_HS__custom (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__dialog_cmac
#define MYNEWT_VAL_BLE_TRANSPORT_HS__dialog_cmac (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__native
#define MYNEWT_VAL_BLE_TRANSPORT_HS__native (1)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__nrf5340
#define MYNEWT_VAL_BLE_TRANSPORT_HS__nrf5340 (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__uart
#define MYNEWT_VAL_BLE_TRANSPORT_HS__uart (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS__usb
#define MYNEWT_VAL_BLE_TRANSPORT_HS__usb (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_HS
#define MYNEWT_VAL_BLE_TRANSPORT_HS (1)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ISO_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_ISO_COUNT (10)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ISO_FROM_HS_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_ISO_FROM_HS_COUNT (10)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ISO_FROM_LL_COUNT
#define MYNEWT_VAL_BLE_TRANSPORT_ISO_FROM_LL_COUNT (10)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_ISO_SIZE
#define MYNEWT_VAL_BLE_TRANSPORT_ISO_SIZE (300)
#endif

#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__apollo3
#define MYNEWT_VAL_BLE_TRANSPORT_LL__apollo3 (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__custom
#define MYNEWT_VAL_BLE_TRANSPORT_LL__custom (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__dialog_cmac
#define MYNEWT_VAL_BLE_TRANSPORT_LL__dialog_cmac (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__emspi
#define MYNEWT_VAL_BLE_TRANSPORT_LL__emspi (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__native
#define MYNEWT_VAL_BLE_TRANSPORT_LL__native (1)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__nrf5340
#define MYNEWT_VAL_BLE_TRANSPORT_LL__nrf5340 (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__socket
#define MYNEWT_VAL_BLE_TRANSPORT_LL__socket (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL__uart_ll
#define MYNEWT_VAL_BLE_TRANSPORT_LL__uart_ll (0)
#endif
#ifndef MYNEWT_VAL_BLE_TRANSPORT_LL
#define MYNEWT_VAL_BLE_TRANSPORT_LL (1)
#endif

#undef MYNEWT_VAL_BLE_TRANSPORT_RX_TASK_STACK_SIZE

#ifndef MYNEWT_VAL_BOOTUTIL_BOOTSTRAP
#define MYNEWT_VAL_BOOTUTIL_BOOTSTRAP (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION__none
#define MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION__none (1)
#endif
#ifndef MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION__security_counter
#define MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION__security_counter (0)
#endif
#ifndef MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION__version
#define MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION__version (0)
#endif
#ifndef MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION
#define MYNEWT_VAL_BOOTUTIL_DOWNGRADE_PREVENTION (1)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_ENCRYPT_EC256
#define MYNEWT_VAL_BOOTUTIL_ENCRYPT_EC256 (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_ENCRYPT_KW
#define MYNEWT_VAL_BOOTUTIL_ENCRYPT_KW (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_ENCRYPT_RSA
#define MYNEWT_VAL_BOOTUTIL_ENCRYPT_RSA (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_ENCRYPT_X25519
#define MYNEWT_VAL_BOOTUTIL_ENCRYPT_X25519 (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_FEED_WATCHDOG
#define MYNEWT_VAL_BOOTUTIL_FEED_WATCHDOG (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_HAVE_LOGGING
#define MYNEWT_VAL_BOOTUTIL_HAVE_LOGGING (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_HW_ROLLBACK_PROT
#define MYNEWT_VAL_BOOTUTIL_HW_ROLLBACK_PROT (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_IMAGE_FORMAT_V2
#define MYNEWT_VAL_BOOTUTIL_IMAGE_FORMAT_V2 (1)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_IMAGE_NUMBER
#define MYNEWT_VAL_BOOTUTIL_IMAGE_NUMBER (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_LOG_LEVEL
#define MYNEWT_VAL_BOOTUTIL_LOG_LEVEL (BOOTUTIL_LOG_LEVEL_INFO)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_MAX_IMG_SECTORS
#define MYNEWT_VAL_BOOTUTIL_MAX_IMG_SECTORS (128)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_NO_LOGGING
#define MYNEWT_VAL_BOOTUTIL_NO_LOGGING (1)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_OVERWRITE_ONLY
#define MYNEWT_VAL_BOOTUTIL_OVERWRITE_ONLY (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_OVERWRITE_ONLY_FAST
#define MYNEWT_VAL_BOOTUTIL_OVERWRITE_ONLY_FAST (1)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SIGN_EC256
#define MYNEWT_VAL_BOOTUTIL_SIGN_EC256 (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SIGN_ED25519
#define MYNEWT_VAL_BOOTUTIL_SIGN_ED25519 (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SIGN_RSA
#define MYNEWT_VAL_BOOTUTIL_SIGN_RSA (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SIGN_RSA_LEN
#define MYNEWT_VAL_BOOTUTIL_SIGN_RSA_LEN (2048)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SINGLE_APPLICATION_SLOT
#define MYNEWT_VAL_BOOTUTIL_SINGLE_APPLICATION_SLOT (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SWAP_SAVE_ENCTLV
#define MYNEWT_VAL_BOOTUTIL_SWAP_SAVE_ENCTLV (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_SWAP_USING_MOVE
#define MYNEWT_VAL_BOOTUTIL_SWAP_USING_MOVE (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_USE_MBED_TLS
#define MYNEWT_VAL_BOOTUTIL_USE_MBED_TLS (1)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_USE_TINYCRYPT
#define MYNEWT_VAL_BOOTUTIL_USE_TINYCRYPT (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_VALIDATE_SLOT0
#define MYNEWT_VAL_BOOTUTIL_VALIDATE_SLOT0 (0)
#endif

#ifndef MYNEWT_VAL_BOOTUTIL_VERSION_CMP_USE_BUILD_NUMBER
#define MYNEWT_VAL_BOOTUTIL_VERSION_CMP_USE_BUILD_NUMBER (0)
#endif

#undef MYNEWT_VAL_MCUBOOT_DATA_SHARING

#undef MYNEWT_VAL_MCUBOOT_MEASURED_BOOT

#undef MYNEWT_VAL_MCUBOOT_MEASURED_BOOT_MAX_RECORD_SZ

#undef MYNEWT_VAL_MCUBOOT_SHARED_DATA_BASE

#undef MYNEWT_VAL_MCUBOOT_SHARED_DATA_SIZE

#ifndef MYNEWT_VAL_APP_NAME
#define MYNEWT_VAL_APP_NAME "dummy_app"
#endif

#ifndef MYNEWT_VAL_APP_dummy_app
#define MYNEWT_VAL_APP_dummy_app (1)
#endif

#ifndef MYNEWT_VAL_ARCH_NAME
#define MYNEWT_VAL_ARCH_NAME "cortex_m4"
#endif

#ifndef MYNEWT_VAL_ARCH_cortex_m4
#define MYNEWT_VAL_ARCH_cortex_m4 (1)
#endif

#ifndef MYNEWT_VAL_BSP_NAME
#define MYNEWT_VAL_BSP_NAME "nordic_pca10056"
#endif

#ifndef MYNEWT_VAL_BSP_nordic_pca10056
#define MYNEWT_VAL_BSP_nordic_pca10056 (1)
#endif

#ifndef MYNEWT_VAL_NEWT_FEATURE_LOGCFG
#define MYNEWT_VAL_NEWT_FEATURE_LOGCFG (1)
#endif

#ifndef MYNEWT_VAL_NEWT_FEATURE_SYSDOWN
#define MYNEWT_VAL_NEWT_FEATURE_SYSDOWN (1)
#endif

#ifndef MYNEWT_VAL_TARGET_NAME
#define MYNEWT_VAL_TARGET_NAME "riot"
#endif

#ifndef MYNEWT_VAL_TARGET_riot
#define MYNEWT_VAL_TARGET_riot (1)
#endif

#define MYNEWT_PKG_apache_mynewt_core__boot_startup 1
#define MYNEWT_PKG_apache_mynewt_core__compiler_arm_none_eabi_m4 1
#define MYNEWT_PKG_apache_mynewt_core__crypto_mbedtls 1
#define MYNEWT_PKG_apache_mynewt_core__crypto_tinycrypt 1
#define MYNEWT_PKG_apache_mynewt_core__hw_bsp_nordic_pca10056 1
#define MYNEWT_PKG_apache_mynewt_core__hw_cmsis_core 1
#define MYNEWT_PKG_apache_mynewt_core__hw_drivers_uart 1
#define MYNEWT_PKG_apache_mynewt_core__hw_drivers_uart_uart_hal 1
#define MYNEWT_PKG_apache_mynewt_core__hw_hal 1
#define MYNEWT_PKG_apache_mynewt_core__hw_mcu_nordic 1
#define MYNEWT_PKG_apache_mynewt_core__hw_mcu_nordic_nrf52xxx 1
#define MYNEWT_PKG_apache_mynewt_core__hw_mcu_nordic_nrf_common 1
#define MYNEWT_PKG_apache_mynewt_core__hw_scripts 1
#define MYNEWT_PKG_apache_mynewt_core__kernel_os 1
#define MYNEWT_PKG_apache_mynewt_core__libc 1
#define MYNEWT_PKG_apache_mynewt_core__libc_baselibc 1
#define MYNEWT_PKG_apache_mynewt_core__mgmt_image_header 1
#define MYNEWT_PKG_apache_mynewt_core__sys_console_stub 1
#define MYNEWT_PKG_apache_mynewt_core__sys_defs 1
#define MYNEWT_PKG_apache_mynewt_core__sys_flash_map 1
#define MYNEWT_PKG_apache_mynewt_core__sys_log_common 1
#define MYNEWT_PKG_apache_mynewt_core__sys_log_modlog 1
#define MYNEWT_PKG_apache_mynewt_core__sys_log_stub 1
#define MYNEWT_PKG_apache_mynewt_core__sys_stats_stub 1
#define MYNEWT_PKG_apache_mynewt_core__sys_sys 1
#define MYNEWT_PKG_apache_mynewt_core__sys_sysdown 1
#define MYNEWT_PKG_apache_mynewt_core__sys_sysinit 1
#define MYNEWT_PKG_apache_mynewt_core__util_mem 1
#define MYNEWT_PKG_apache_mynewt_core__util_rwlock 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble_controller 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble_drivers_nrf5x 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble_host 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble_host_services_gap 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble_host_services_gatt 1
#define MYNEWT_PKG_apache_mynewt_nimble__nimble_transport 1
#define MYNEWT_PKG_apache_mynewt_nimble__porting_npl_mynewt 1
#define MYNEWT_PKG_apache_mynewt_nimble__porting_targets_dummy_app 1
#define MYNEWT_PKG_apache_mynewt_nimble__porting_targets_riot 1
#define MYNEWT_PKG_mcuboot__boot_bootutil 1
#define MYNEWT_PKG_mcuboot__boot_mynewt_flash_map_backend 1
#define MYNEWT_PKG_mcuboot__boot_mynewt_mcuboot_config 1

#define MYNEWT_API_ble_driver 1
#define MYNEWT_API_ble_transport 1
#define MYNEWT_API_bootloader 1
#define MYNEWT_API_console 1
#define MYNEWT_API_log 1
#define MYNEWT_API_stats 1

#endif
