/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFacesPortlet
extends GenericPortlet {
    public static final String BRIDGE_CLASS = "javax.portlet.faces.BridgeClassName";
    public static final String DEFAULT_VIEWID = "javax.portlet.faces.defaultViewId";
    public static final String DEFAULT_CONTENT_TYPE = "javax.portlet.faces.defaultContentType";
    public static final String DEFAULT_CHARACTERSET_ENCODING = "javax.portlet.faces.defaultCharacterSetEncoding";
    public static final String BRIDGE_SERVICE_CLASSPATH = "META-INF/services/javax.portlet.faces.Bridge";
    private Class<? extends Bridge> mFacesBridgeClass = null;
    private Bridge mFacesBridge = null;
    private HashMap<String, String> mDefaultViewIdMap = null;
    private Object mLock = new Object();

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        String bridgeClassName = this.getBridgeClassName();
        if (bridgeClassName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this.mFacesBridgeClass = loader.loadClass(bridgeClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PortletException("Unable to load configured bridge class: " + bridgeClassName);
            }
        } else {
            throw new PortletException("Can't locate configuration parameter defining the bridge class to use for this portlet:" + this.getPortletName());
        }
        List<String> excludedAttrs = this.getExcludedRequestAttributes();
        if (excludedAttrs != null) {
            this.getPortletContext().setAttribute("javax.portlet.faces." + this.getPortletName() + "." + "excludedRequestAttributes", excludedAttrs);
        }
        Boolean preserveActionParams = new Boolean(this.isPreserveActionParameters());
        this.getPortletContext().setAttribute("javax.portlet.faces." + this.getPortletName() + "." + "preserveActionParams", (Object)preserveActionParams);
        Map defaultViewIdMap = this.getDefaultViewIdMap();
        this.getPortletContext().setAttribute("javax.portlet.faces." + this.getPortletName() + "." + "defaultViewIdMap", (Object)defaultViewIdMap);
    }

    public void destroy() {
        if (this.mFacesBridge != null) {
            this.mFacesBridge.destroy();
            this.mFacesBridge = null;
            this.mFacesBridgeClass = null;
        }
        this.mDefaultViewIdMap = null;
        super.destroy();
    }

    public void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletMode mode = request.getPortletMode();
        if (mode.equals((Object)PortletMode.EDIT) || mode.equals((Object)PortletMode.HELP) || mode.equals((Object)PortletMode.VIEW)) {
            super.doDispatch(request, response);
        } else if (!this.doRenderDispatchInternal(request, response)) {
            super.doDispatch(request, response);
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRenderDispatchInternal(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRenderDispatchInternal(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRenderDispatchInternal(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.doActionDispatchInternal(request, response);
    }

    public List<String> getExcludedRequestAttributes() {
        String excludedAttrs = this.getPortletConfig().getInitParameter("javax.portlet.faces.excludedRequestAttributes");
        if (excludedAttrs == null) {
            return null;
        }
        String[] attrArray = excludedAttrs.split(",");
        ArrayList<String> list = new ArrayList<String>(attrArray.length);
        for (int i = 0; i < attrArray.length; ++i) {
            list.add(attrArray[i].trim());
        }
        return list;
    }

    public boolean isPreserveActionParameters() {
        String preserveActionParams = this.getPortletConfig().getInitParameter("javax.portlet.faces.preserveActionParams");
        if (preserveActionParams == null) {
            return false;
        }
        return Boolean.parseBoolean(preserveActionParams);
    }

    public String getBridgeClassName() {
        String bridgeClassName = this.getPortletConfig().getPortletContext().getInitParameter(BRIDGE_CLASS);
        if (bridgeClassName == null) {
            bridgeClassName = this.getFromServicesPath(this.getPortletConfig().getPortletContext(), BRIDGE_SERVICE_CLASSPATH);
        }
        return bridgeClassName;
    }

    public String getResponseContentType(PortletRequest request) {
        String contentType = this.getPortletConfig().getInitParameter(DEFAULT_CONTENT_TYPE);
        if (contentType == null || !this.isInRequestedContentTypes(request, contentType)) {
            contentType = request.getResponseContentType();
        }
        return contentType;
    }

    private boolean isInRequestedContentTypes(PortletRequest request, String contentTypeToCheck) {
        Enumeration e = request.getResponseContentTypes();
        while (e.hasMoreElements()) {
            if (!contentTypeToCheck.equalsIgnoreCase((String)e.nextElement())) continue;
            return true;
        }
        return false;
    }

    public String getResponseCharacterSetEncoding(PortletRequest request) {
        return this.getPortletConfig().getInitParameter(DEFAULT_CHARACTERSET_ENCODING);
    }

    public Map getDefaultViewIdMap() {
        if (this.mDefaultViewIdMap == null) {
            this.mDefaultViewIdMap = new HashMap();
            PortletConfig config = this.getPortletConfig();
            Enumeration e = config.getInitParameterNames();
            int len = DEFAULT_VIEWID.length();
            while (e.hasMoreElements()) {
                String viewId;
                String s = (String)e.nextElement();
                if (!s.startsWith(DEFAULT_VIEWID) || s.length() <= DEFAULT_VIEWID.length() || (viewId = config.getInitParameter(s)) == null || viewId.length() == 0) continue;
                s = s.substring(len + 1);
                this.mDefaultViewIdMap.put(s, viewId);
            }
        }
        return this.mDefaultViewIdMap;
    }

    public Bridge getFacesBridge(PortletRequest request, PortletResponse response) throws PortletException {
        this.initBridgeRequest(request, response);
        return this.mFacesBridge;
    }

    private boolean isNonFacesRequest(PortletRequest request, PortletResponse response) {
        if (request.getParameter("_jsfBridgeNonFacesView") != null) {
            return true;
        }
        String modeDefaultViewId = this.mDefaultViewIdMap.get(request.getPortletMode().toString());
        return modeDefaultViewId == null;
    }

    private void doActionDispatchInternal(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (this.isNonFacesRequest((PortletRequest)request, (PortletResponse)response)) {
            throw new PortletException("GenericFacesPortlet:  Action request is not for a Faces target.  Such nonFaces requests must be handled by a subclass.");
        }
        this.doBridgeDispatch(request, response);
    }

    private boolean doRenderDispatchInternal(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.isNonFacesRequest((PortletRequest)request, (PortletResponse)response)) {
            return this.doNonFacesDispatch(request, response);
        }
        WindowState state = request.getWindowState();
        if (!state.equals((Object)WindowState.MINIMIZED)) {
            this.doBridgeDispatch(request, response);
        }
        return true;
    }

    private boolean doNonFacesDispatch(RenderRequest request, RenderResponse response) throws PortletException {
        String targetPath = request.getParameter("_jsfBridgeNonFacesView");
        if (targetPath == null) {
            return false;
        }
        if (response.getContentType() == null) {
            response.setContentType(request.getResponseContentType());
        }
        try {
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(targetPath);
            dispatcher.include(request, response);
            return true;
        }
        catch (Exception e) {
            throw new PortletException("Unable to dispatch to: " + targetPath, (Throwable)e);
        }
    }

    private void doBridgeDispatch(RenderRequest request, RenderResponse response) throws PortletException {
        this.setResponseContentType(response, this.getResponseContentType((PortletRequest)request), this.getResponseCharacterSetEncoding((PortletRequest)request));
        try {
            this.getFacesBridge((PortletRequest)request, (PortletResponse)response).doFacesRequest(request, response);
        }
        catch (BridgeException e) {
            throw new PortletException("doBridgeDispatch failed:  error from Bridge in executing the request", (Throwable)((Object)e));
        }
    }

    private void doBridgeDispatch(ActionRequest request, ActionResponse response) throws PortletException {
        try {
            this.getFacesBridge((PortletRequest)request, (PortletResponse)response).doFacesRequest(request, response);
        }
        catch (BridgeException e) {
            throw new PortletException("doBridgeDispatch failed:  error from Bridge in executing the request", (Throwable)((Object)e));
        }
    }

    private void initBridgeRequest(PortletRequest request, PortletResponse response) throws PortletException {
        this.initBridge();
        String view = request.getParameter("_jsfBridgeViewId");
        if (view != null) {
            request.setAttribute("javax.portlet.faces.viewId", (Object)view);
        } else {
            view = request.getParameter("_jsfBridgeViewPath");
            if (view != null) {
                request.setAttribute("javax.portlet.faces.viewPath", (Object)view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBridge() throws PortletException {
        if (this.mFacesBridge == null) {
            try {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mFacesBridge == null) {
                        this.mFacesBridge = this.mFacesBridgeClass.newInstance();
                        this.mFacesBridge.init(this.getPortletConfig());
                    }
                }
            }
            catch (Exception e) {
                throw new PortletException("doBridgeDisptach:  error instantiating the bridge class", (Throwable)e);
            }
        }
    }

    private void setResponseContentType(RenderResponse response, String contentType, String charSetEncoding) {
        if (contentType == null) {
            return;
        }
        if (charSetEncoding != null) {
            StringBuffer buf = new StringBuffer(contentType);
            buf.append(";");
            buf.append(charSetEncoding);
            response.setContentType(buf.toString());
        } else {
            response.setContentType(contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromServicesPath(PortletContext context, String resourceName) {
        String result;
        block34: {
            result = null;
            BufferedReader reader = null;
            InputStream stream = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    String string = null;
                    return string;
                }
                stream = cl.getResourceAsStream(resourceName);
                if (stream == null) break block34;
                try {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                }
                result = reader.readLine();
                if (result != null) {
                    result = result.trim();
                }
                reader.close();
                reader = null;
                stream = null;
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                        stream = null;
                    }
                    catch (Throwable t) {}
                    reader = null;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                    stream = null;
                }
            }
        }
        return result;
    }
}

