/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.input.CoreInputFile;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputTextRenderer;

public class SimpleInputFileRenderer
extends SimpleInputTextRenderer {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SimpleInputFileRenderer.class);

    public SimpleInputFileRenderer() {
        this(CoreInputFile.TYPE);
    }

    public SimpleInputFileRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        this.detectAutoSubmit(context, component, clientId);
        Boolean result = null;
        UploadedFile file = null;
        UploadedFiles files = UploadedFiles.getUploadedFiles(context);
        if (files != null) {
            file = files.getUploadedFile(clientId);
        }
        result = file == null || file.getLength() == 0L ? Boolean.FALSE : file;
        return result;
    }

    @Override
    protected String getAutoComplete(UIComponent component, FacesBean bean) {
        return "on";
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        if (submittedValue == Boolean.FALSE) {
            return null;
        }
        UploadedFile file = (UploadedFile)submittedValue;
        if (file.getLength() == -1L) {
            String errorMessage = this._getErrorMessage(context, file);
            FacesMessage fm = MessageFactory.getMessage((FacesContext)context, (FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"org.apache.myfaces.trinidad.UPLOAD_FAILURE", (Object[])new Object[]{errorMessage}, (UIComponent)component);
            throw new ConverterException(fm);
        }
        FacesBean bean = this.getFacesBean(component);
        Converter converter = this.getConverter(component, bean);
        if (converter != null) {
            String fileNameKey = component.getClass().getName() + "." + file.getFilename();
            context.getExternalContext().getRequestMap().put(fileNameKey, file);
            return converter.getAsObject(context, component, fileNameKey);
        }
        return file;
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        super.encodeAllAsElement(context, rc, component, bean);
        RequestContext requestContext = RequestContext.getCurrentInstance();
        Long maxMemory = requestContext.getUploadedFileMaxMemory();
        Long maxDiskSpace = requestContext.getUploadedFileMaxDiskSpace();
        String tempDir = requestContext.getUploadedFileTempDir();
        ExternalContext external = context.getExternalContext();
        Map sessionMap = external.getSessionMap();
        sessionMap.put("org.apache.myfaces.trinidad.UPLOAD_MAX_MEMORY", maxMemory);
        sessionMap.put("org.apache.myfaces.trinidad.UPLOAD_MAX_DISK_SPACE", maxDiskSpace);
        sessionMap.put("org.apache.myfaces.trinidad.UPLOAD_TEMP_DIR", tempDir);
    }

    @Override
    protected String getConvertedString(FacesContext context, UIComponent component, FacesBean bean) {
        return null;
    }

    @Override
    protected String getDefaultInputType() {
        return "file";
    }

    @Override
    public boolean isTextArea(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected boolean isAutoSubmit(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected boolean getSecret(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected Number getMaximumLength(UIComponent component, FacesBean bean) {
        return null;
    }

    @Override
    protected boolean getReadOnly(FacesContext context, UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputFile";
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputFile::content";
    }

    @Override
    protected Integer getDefaultColumns(RenderingContext rc, UIComponent component, FacesBean bean) {
        return null;
    }

    private String _getErrorMessage(FacesContext context, UploadedFile file) {
        String errorMessageKey = file.getOpaqueData().toString();
        Locale locale = context.getViewRoot().getLocale();
        String bundleName = _LOG.getLogger().getResourceBundleName();
        try {
            return ResourceBundle.getBundle(bundleName, locale).getString(errorMessageKey);
        }
        catch (MissingResourceException mre) {
            return errorMessageKey;
        }
    }
}

