/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import java.awt.Color;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.xml.parse.ImageParseUtils;
import org.apache.myfaces.trinidadinternal.share.xml.LeafNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class ColorParser
extends LeafNodeParser {
    private static final String _RGB_ERROR = "Error while parsing rgb attribute value.  Values must be specified in #RRGGBB format.";
    private static final String _COLOR_ERROR = "Error while parsing color attribute value.  Values must be between 0 and 255.";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColorParser.class);

    @Override
    public Object getNodeValue(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        Color color = null;
        String rgb = attrs.getValue("rgb");
        if (rgb != null) {
            try {
                color = CSSUtils.parseColor(rgb);
            }
            catch (PropertyParseException e) {
                _LOG.warning(_RGB_ERROR);
            }
        }
        if (color == null) {
            int red = this._getColorAttr(context, attrs, "red");
            int green = this._getColorAttr(context, attrs, "green");
            int blue = this._getColorAttr(context, attrs, "blue");
            color = new Color(red, green, blue);
        }
        return color;
    }

    private int _getColorAttr(ParseContext context, Attributes attrs, String name) {
        Integer value = ImageParseUtils.getIntegerAttributeValue(context, attrs, name);
        if (value == null) {
            return 0;
        }
        int intValue = value;
        if (intValue < 0 || intValue > 255) {
            _LOG.warning(_COLOR_ERROR);
            intValue = intValue < 0 ? 0 : 255;
        }
        return intValue;
    }
}

