/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXTable;

public final class TableUtils {
    public static int getVisibleRowCount(CollectionComponent table) {
        int rangeStart = table.getFirst();
        int rangeEnd = org.apache.myfaces.trinidad.component.TableUtils.getLast((CollectionComponent)table) + 1;
        return rangeEnd - rangeStart;
    }

    private TableUtils() {
    }

    public static abstract class RowLoop {
        private Object _oldIndex = null;

        private void _saveOldState(CollectionComponent table) {
            this._oldIndex = table.getRowKey();
        }

        private void _restoreOldState(CollectionComponent table) {
            table.setRowKey(this._oldIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run(FacesContext fc, CollectionComponent table) throws IOException {
            this._saveOldState(table);
            try {
                this.loop(fc, table);
            }
            finally {
                this._restoreOldState(table);
            }
        }

        protected void loop(FacesContext fc, CollectionComponent table) throws IOException {
            UIComponent comp = (UIComponent)table;
            boolean showAll = Boolean.TRUE.equals(comp.getAttributes().get(UIXTable.SHOW_ALL_KEY.getName()));
            int rangeStart = table.getFirst();
            int rangeEnd = showAll ? table.getRowCount() - 1 : org.apache.myfaces.trinidad.component.TableUtils.getLast((CollectionComponent)table);
            for (int i = rangeStart; i <= rangeEnd; ++i) {
                table.setRowIndex(i);
                this.processRow(fc, table);
            }
        }

        protected final void processRow(FacesContext fc, CollectionComponent table) throws IOException {
            this.processRowImpl(fc, table);
        }

        protected abstract void processRowImpl(FacesContext var1, CollectionComponent var2) throws IOException;
    }
}

