/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.HierarchyUtils;
import org.apache.myfaces.trinidad.component.StampState;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.event.FocusEvent;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.event.RangeChangeListener;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXTreeTable
extends UIXTree {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXTree.TYPE);
    public static final PropertyKey ROOT_NODE_RENDERED_KEY = TYPE.registerKey("rootNodeRendered", Boolean.class, Boolean.TRUE);
    public static final PropertyKey ROWS_BY_DEPTH_KEY = TYPE.registerKey("rowsByDepth", int[].class, null, 0, PropertyKey.Mutable.SOMETIMES);
    public static final PropertyKey RANGE_CHANGE_LISTENER_KEY = TYPE.registerKey("rangeChangeListener", MethodExpression.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.TreeTable";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.TreeTable";
    private Map<Object, Integer> _firstMap = Collections.emptyMap();
    private transient IdentityHashMap<UIComponent, Boolean> _containerClientIdCache = null;

    public UIXTreeTable() {
        super("org.apache.myfaces.trinidad.BaseTreeTable");
    }

    @Override
    public void decode(FacesContext context) {
        this._resetContainerClientIdCache();
        super.decode(context);
    }

    @Override
    public void processValidators(FacesContext context) {
        this._resetContainerClientIdCache();
        super.processValidators(context);
    }

    @Override
    public void processUpdates(FacesContext context) {
        this._resetContainerClientIdCache();
        super.processUpdates(context);
    }

    @Override
    protected void __encodeBegin(FacesContext context) throws IOException {
        this._resetContainerClientIdCache();
        super.__encodeBegin(context);
    }

    @Override
    public String getContainerClientId(FacesContext context, UIComponent child) {
        String id = this._containerClientIdCache == null || this._isStampedChild(child) ? this.getContainerClientId(context) : this.getClientId(context);
        return id;
    }

    @Deprecated
    public void setRangeChangeListener(MethodBinding binding) {
        this.setRangeChangeListener(UIXTreeTable.adaptMethodBinding(binding));
    }

    @Override
    public final int getRows() {
        int depth = this.getTreeModel().getDepth();
        assert (depth >= 0);
        if (depth == 0) {
            return 1;
        }
        int[] rows = this.getRowsByDepth();
        if (rows == null || rows.length == 0) {
            return 0;
        }
        return --depth >= rows.length ? rows[rows.length - 1] : rows[depth];
    }

    @Override
    public final int getFirst() {
        Object container = this._getContainerPath();
        Integer first = this._firstMap.get(container);
        return first != null ? first : 0;
    }

    public void setFirst(int index) {
        Object container = this._getContainerPath();
        Map comparant = Collections.emptyMap();
        if (this._firstMap == comparant) {
            this._firstMap = new HashMap<Object, Integer>(3);
        }
        if (index <= 0) {
            this._firstMap.remove(container);
        } else {
            this._firstMap.put(container, index);
        }
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        this.addFacesListener(listener);
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public RangeChangeListener[] getRangeChangeListeners() {
        return (RangeChangeListener[])this.getFacesListeners(RangeChangeListener.class);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] array = new Object[2];
        array[0] = super.saveState(context);
        Map<Object, Integer> map = array[1] = this._firstMap.isEmpty() ? null : this._firstMap;
        if (array[0] == null && array[1] == null) {
            return null;
        }
        return array;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] array = (Object[])state;
        super.restoreState(context, array[0]);
        this._firstMap = (Map)array[1];
        if (this._firstMap == null) {
            this._firstMap = Collections.emptyMap();
        }
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FocusEvent) {
            this.setFocusRowKey(this.getRowKey());
            this.addAttributeChange("focusPath", this.getFocusRowKey());
            this.getDisclosedRowKeys().add();
            this.broadcastToMethodExpression(event, this.getFocusListener());
        } else if (event instanceof RangeChangeEvent) {
            RangeChangeEvent rce = (RangeChangeEvent)event;
            this.setFirst(rce.getNewStart());
            this.broadcastToMethodExpression(event, this.getRangeChangeListener());
        }
        super.broadcast(event);
    }

    @Override
    protected final List<UIComponent> getStamps() {
        List<UIComponent> stamps;
        List<UIComponent> children = this.getChildren();
        if (children.isEmpty()) {
            stamps = super.getStamps();
        } else {
            UIComponent nodeStamp = this.getNodeStamp();
            if (nodeStamp == null) {
                stamps = children;
            } else {
                stamps = new ArrayList<UIComponent>(children.size() + 1);
                stamps.addAll(children);
                stamps.add(nodeStamp);
            }
        }
        return stamps;
    }

    @Override
    protected final void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stamp instanceof UIXColumn) {
            StampState.restoreChildStampState(context, stamp, this, stampState);
        } else {
            super.restoreStampState(context, stamp, stampState);
        }
    }

    @Override
    protected final Object saveStampState(FacesContext context, UIComponent stamp) {
        if (stamp instanceof UIXColumn) {
            return StampState.saveChildStampState(context, stamp, this);
        }
        return super.saveStampState(context, stamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        TableUtils.processFacets(context, this, this, phaseId, "nodeStamp");
        UIComponent nodeStamp = this.getNodeStamp();
        TableUtils.processFacets(context, this, nodeStamp, phaseId, null);
        TableUtils.processColumnFacets(context, this, this, phaseId);
        TableUtils.processColumnFacets(context, this, nodeStamp, phaseId);
        Object oldPath = this.getRowKey();
        RowKeySet state = this.getDisclosedRowKeys();
        try {
            Object path = this.getFocusRowKey();
            this.setRowKey(path);
            if (path == null) {
                HierarchyUtils.__iterateOverTree(context, phaseId, this, state, true);
            } else {
                TableUtils.processStampedChildren(context, this, phaseId);
                this.processComponent(context, nodeStamp, phaseId);
                if (state.isContained()) {
                    this.enterContainer();
                    HierarchyUtils.__iterateOverTree(context, phaseId, this, state, true);
                }
            }
        }
        finally {
            this.setRowKey(oldPath);
        }
    }

    @Override
    protected boolean visitChildren(VisitContext visitContext, VisitCallback callback) {
        return this.defaultVisitChildren(visitContext, callback);
    }

    @Override
    protected boolean visitUnstampedFacets(VisitContext visitContext, VisitCallback callback) {
        int facetCount = this.getFacetCount();
        if (facetCount > 0) {
            UIComponent nodeStamp = this.getNodeStamp();
            if (facetCount > 1 || nodeStamp == null) {
                for (UIComponent facet : this.getFacets().values()) {
                    if (facet == nodeStamp || !UIXComponent.visitTree(visitContext, facet, callback)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean visitData(VisitContext visitContext, VisitCallback callback) {
        boolean done;
        Object focusedPath = this.getFocusRowKey();
        Object oldRowKey = null;
        if (focusedPath != null) {
            oldRowKey = this.getRowKey();
            this.setRowKey(focusedPath);
        }
        try {
            done = super.visitData((VisitContext)new UIXCollection.NoColumnFacetsVisitContext(visitContext), callback);
        }
        finally {
            if (focusedPath != null) {
                this.setRowKey(oldRowKey);
            }
        }
        return done;
    }

    private Object _getContainerPath() {
        Object parentKey = this.getTreeModel().getContainerRowKey();
        return parentKey;
    }

    private boolean _isStampedChild(UIComponent target) {
        assert (this._containerClientIdCache != null);
        return !this._containerClientIdCache.containsKey(target);
    }

    private void _resetContainerClientIdCache() {
        if (this._containerClientIdCache == null) {
            this._containerClientIdCache = new IdentityHashMap();
        } else {
            this._containerClientIdCache.clear();
        }
        TableUtils.cacheHeaderFooterFacets(this, this._containerClientIdCache);
        TableUtils.cacheColumnHeaderFooterFacets(this, this._containerClientIdCache);
        UIComponent nodeStamp = this.getNodeStamp();
        if (nodeStamp != null) {
            TableUtils.cacheHeaderFooterFacets(nodeStamp, this._containerClientIdCache);
            TableUtils.cacheColumnHeaderFooterFacets(nodeStamp, this._containerClientIdCache);
        }
    }

    @Override
    Object __getMyStampState() {
        Object[] state = new Object[]{super.__getMyStampState(), this._firstMap.isEmpty() ? null : this._firstMap};
        return state;
    }

    @Override
    void __setMyStampState(Object stampState) {
        Object[] state = (Object[])stampState;
        super.__setMyStampState(state[0]);
        this._firstMap = (Map)state[1];
        if (this._firstMap == null) {
            this._firstMap = Collections.emptyMap();
        }
    }

    @Override
    void __resetMyStampState() {
        super.__resetMyStampState();
        this._firstMap = Collections.emptyMap();
    }

    public final boolean isRootNodeRendered() {
        return ComponentUtils.resolveBoolean(this.getProperty(ROOT_NODE_RENDERED_KEY), true);
    }

    public final void setRootNodeRendered(boolean rootNodeRendered) {
        this.setProperty(ROOT_NODE_RENDERED_KEY, rootNodeRendered ? Boolean.TRUE : Boolean.FALSE);
    }

    public final int[] getRowsByDepth() {
        return (int[])this.getProperty(ROWS_BY_DEPTH_KEY);
    }

    public final void setRowsByDepth(int[] rowsByDepth) {
        this.setProperty(ROWS_BY_DEPTH_KEY, rowsByDepth);
    }

    public final MethodExpression getRangeChangeListener() {
        return (MethodExpression)this.getProperty(RANGE_CHANGE_LISTENER_KEY);
    }

    public final void setRangeChangeListener(MethodExpression rangeChangeListener) {
        this.setProperty(RANGE_CHANGE_LISTENER_KEY, rangeChangeListener);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.TreeTable";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXTreeTable(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.TreeTable", "org.apache.myfaces.trinidad.BaseTreeTable");
    }
}

