/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.Collections;
import java.util.Iterator;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.event.DisclosureEvent;
import org.apache.myfaces.trinidad.event.DisclosureListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXShowDetail
extends UIXComponentBase {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey DISCLOSED_KEY = TYPE.registerKey("disclosed", Boolean.class, Boolean.FALSE);
    public static final PropertyKey DISCLOSED_TRANSIENT_KEY = TYPE.registerKey("disclosedTransient", Boolean.class, Boolean.FALSE);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class, Boolean.FALSE);
    public static final PropertyKey DISCLOSURE_LISTENER_KEY = TYPE.registerKey("disclosureListener", MethodExpression.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.ShowDetail";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.ShowDetail";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXShowDetail.class);

    public UIXShowDetail() {
        super("org.apache.myfaces.trinidad.ShowDetail");
    }

    @Deprecated
    public void setDisclosureListener(MethodBinding binding) {
        this.setDisclosureListener(UIXShowDetail.adaptMethodBinding(binding));
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DisclosureEvent) {
            if (!this.isDisclosedTransient()) {
                boolean isDisclosed = ((DisclosureEvent)event).isExpanded();
                if (isDisclosed == this.isDisclosed()) {
                    _LOG.warning("EVENT_DELIVERED_ALREADY_IN_DISCLOSURE_STATE", event);
                } else {
                    this.setDisclosed(isDisclosed);
                }
                this.addAttributeChange("disclosed", isDisclosed ? Boolean.TRUE : Boolean.FALSE);
            }
            if (this.isImmediate()) {
                this.getFacesContext().renderResponse();
            }
            this.broadcastToMethodExpression(event, this.getDisclosureListener());
        }
    }

    @Override
    public void queueEvent(FacesEvent e) {
        if (e instanceof DisclosureEvent && e.getSource() == this) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.ANY_PHASE);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    @Override
    protected Iterator<UIComponent> getRenderedFacetsAndChildren(FacesContext facesContext) {
        if (this.isDisclosed()) {
            return super.getRenderedFacetsAndChildren(facesContext);
        }
        return Collections.emptyList().iterator();
    }

    public final boolean isDisclosed() {
        return ComponentUtils.resolveBoolean(this.getProperty(DISCLOSED_KEY), false);
    }

    public final void setDisclosed(boolean disclosed) {
        this.setProperty(DISCLOSED_KEY, disclosed ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isDisclosedTransient() {
        return ComponentUtils.resolveBoolean(this.getProperty(DISCLOSED_TRANSIENT_KEY), false);
    }

    public final void setDisclosedTransient(boolean disclosedTransient) {
        this.setProperty(DISCLOSED_TRANSIENT_KEY, disclosedTransient ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY), false);
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final MethodExpression getDisclosureListener() {
        return (MethodExpression)this.getProperty(DISCLOSURE_LISTENER_KEY);
    }

    public final void setDisclosureListener(MethodExpression disclosureListener) {
        this.setProperty(DISCLOSURE_LISTENER_KEY, disclosureListener);
    }

    public final void addDisclosureListener(DisclosureListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeDisclosureListener(DisclosureListener listener) {
        this.removeFacesListener(listener);
    }

    public final DisclosureListener[] getDisclosureListeners() {
        return (DisclosureListener[])this.getFacesListeners(DisclosureListener.class);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.ShowDetail";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXShowDetail(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.ShowDetail", "org.apache.myfaces.trinidad.ShowDetail");
    }
}

