/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXProgress;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.BoundedRangeModel;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.skin.icon.NullIcon;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;

@Deprecated
public class ProcessingRenderer
extends HtmlLafRenderer {
    private static final int _PERCENT_COMPLETE_MAX = 100;
    private static final int _PERCENT_MULTIPLE = 5;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ProcessingRenderer.class);

    @Override
    protected void renderAttributes(UIXRenderingContext context, UINode node) throws IOException {
        this.renderID(context, node);
        ProcessingRenderer.renderLayoutTableAttributes(context, "0", null);
        context.getResponseWriter().writeAttribute("align", (Object)"center", null);
    }

    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)"center", null);
        int percentComplete = ProcessingRenderer._getPercentComplete(context, node);
        if (percentComplete != -1) {
            this.renderDeterminateStatus(context, percentComplete);
        } else {
            this.renderIndeterminateStatus(context, percentComplete);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)"center", null);
        super.renderContent(context, node);
        writer.endElement("td");
        writer.endElement("tr");
    }

    protected void renderDeterminateStatus(UIXRenderingContext context, int percentComplete) throws IOException {
        String iconName = ProcessingRenderer._getProcessingIconName(percentComplete);
        Icon determinateIcon = context.getIcon(iconName);
        String altText = this.getDeterminateAltText(context, String.valueOf(percentComplete));
        if (determinateIcon != null && !determinateIcon.equals(NullIcon.sharedInstance())) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            FacesContext fContext = context.getFacesContext();
            OutputUtils.renderIcon(fContext, arc, determinateIcon, altText, null);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            ProcessingRenderer.renderStyleClassAttribute(context, "p_OraProcessingStatus");
            writer.writeText((Object)this._getDeterminateText(context, String.valueOf(percentComplete)), null);
            writer.endElement("div");
        }
    }

    protected void renderIndeterminateStatus(UIXRenderingContext context, int percentComplete) throws IOException {
        Icon indeterminateIcon = context.getIcon("af|progressIndicator::indeterminate-icon");
        String processingString = ProcessingRenderer.getTranslatedString(context, "af_progressIndicator.PROCESSING");
        if (indeterminateIcon != null && !indeterminateIcon.equals(NullIcon.sharedInstance())) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            FacesContext fContext = context.getFacesContext();
            OutputUtils.renderIcon(fContext, arc, indeterminateIcon, processingString, null);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            ProcessingRenderer.renderStyleClassAttribute(context, "p_OraProcessingStatus");
            writer.writeText((Object)processingString, null);
            writer.endElement("div");
        }
    }

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return "table";
    }

    protected String getDeterminateAltText(UIXRenderingContext context, String percentCompleteString) {
        if (!ProcessingRenderer.isScreenReaderMode(context)) {
            return null;
        }
        return this._getDeterminateText(context, percentCompleteString);
    }

    private static int _getPercentComplete(UIXRenderingContext context, UINode node) {
        int percentComplete = -1;
        UIXProgress progressComponent = (UIXProgress)NodeUtils.getUIComponent(context, node);
        Object modelObject = progressComponent.getValue();
        if (modelObject != null && modelObject instanceof BoundedRangeModel) {
            BoundedRangeModel model = (BoundedRangeModel)modelObject;
            double value = model.getValue();
            double maximum = model.getMaximum();
            percentComplete = value < 0.0 || maximum < 0.0 ? -1 : (int)(value / maximum * 100.0);
        } else {
            _LOG.warning("DEFAULT_COMPONENT_TO_INDETERMINDATE_MODE", (Object)progressComponent.getId());
            percentComplete = -1;
        }
        if (percentComplete < 0) {
            return -1;
        }
        percentComplete = Math.min(percentComplete, 100);
        return percentComplete - percentComplete % 5;
    }

    private String _getDeterminateText(UIXRenderingContext context, String percentCompleteString) {
        String[] parameters = new String[]{percentCompleteString};
        String text = this.formatString(context, ProcessingRenderer.getTranslatedString(context, "af_progressIndicator.DETERMINATE_TIP"), parameters);
        return text;
    }

    private static String _getProcessingIconName(int percentComplete) {
        if (percentComplete < 5) {
            return "af|progressIndicator::zero-percent-icon";
        }
        if (percentComplete < 10) {
            return "af|progressIndicator::five-percent-icon";
        }
        if (percentComplete < 15) {
            return "af|progressIndicator::ten-percent-icon";
        }
        if (percentComplete < 20) {
            return "af|progressIndicator::fifteen-percent-icon";
        }
        if (percentComplete < 25) {
            return "af|progressIndicator::twenty-percent-icon";
        }
        if (percentComplete < 30) {
            return "af|progressIndicator::twenty-five-percent-icon";
        }
        if (percentComplete < 35) {
            return "af|progressIndicator::thirty-percent-icon";
        }
        if (percentComplete < 40) {
            return "af|progressIndicator::thirty-five-percent-icon";
        }
        if (percentComplete < 45) {
            return "af|progressIndicator::forty-percent-icon";
        }
        if (percentComplete < 50) {
            return "af|progressIndicator::forty-five-percent-icon";
        }
        if (percentComplete < 55) {
            return "af|progressIndicator::fifty-percent-icon";
        }
        if (percentComplete < 60) {
            return "af|progressIndicator::fifty-five-percent-icon";
        }
        if (percentComplete < 65) {
            return "af|progressIndicator::sixty-percent-icon";
        }
        if (percentComplete < 70) {
            return "af|progressIndicator::sixty-five-percent-icon";
        }
        if (percentComplete < 75) {
            return "af|progressIndicator::seventy-percent-icon";
        }
        if (percentComplete < 80) {
            return "af|progressIndicator::seventy-five-percent-icon";
        }
        if (percentComplete < 85) {
            return "af|progressIndicator::eighty-percent-icon";
        }
        if (percentComplete < 90) {
            return "af|progressIndicator::eighty-five-percent-icon";
        }
        if (percentComplete < 95) {
            return "af|progressIndicator::ninety-percent-icon";
        }
        if (percentComplete < 100) {
            return "af|progressIndicator::ninety-five-percent-icon";
        }
        return "af|progressIndicator::one-hundred-percent-icon";
    }
}

