/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.io.IOException;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXNavigationLevel;
import org.apache.myfaces.trinidad.style.Style;
import org.apache.myfaces.trinidad.style.Styles;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LinkUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.ModelRendererUtils;

@Deprecated
public class TabBarRenderer
extends HtmlLafRenderer {
    private static final Object _SEPARATOR_KEY = new Object();

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return "table";
    }

    @Override
    protected void renderAttributes(UIXRenderingContext context, UINode node) throws IOException {
        super.renderAttributes(context, node);
        TabBarRenderer.renderLayoutTableAttributes(context, "0", null);
    }

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        this.renderRelatedLinksBlockStart(context, "af_menuTabs.BLOCK_TITLE");
        super.prerender(context, node);
        LinkUtils.startDefaultStyleClassDisabled(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
    }

    protected UIXHierarchy getHierarchyBase(UIXRenderingContext context, UINode node) {
        return (UIXHierarchy)node.getUIComponent();
    }

    protected UINode getStamp(UIXRenderingContext context, UINode node) {
        return node.getNamedChild(context, "nodeStamp");
    }

    protected boolean setNewPath(UIXRenderingContext context, UINode node, UIXHierarchy component) {
        int startDepth = TabBarRenderer.getIntAttributeValue(context, node, LEVEL_ATTR, 0);
        return ModelRendererUtils.setNewPath(component, startDepth, ((UIXNavigationLevel)component).getFocusRowKey());
    }

    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        UIXHierarchy component = this.getHierarchyBase(context, node);
        UINode stamp = this.getStamp(context, node);
        if (stamp != null) {
            Object oldPath = component.getRowKey();
            boolean isNewPath = this.setNewPath(context, node, component);
            if (isNewPath) {
                boolean isRendered;
                int i;
                int size = component.getRowCount();
                int rowIndex = component.getRowIndex();
                boolean needsSeparator = false;
                boolean isSelected = false;
                boolean isFirst = false;
                boolean isLast = false;
                boolean isNextSelected = false;
                int lastIndex = size - 1;
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    component.setRowIndex(i2);
                    boolean isRendered2 = this.isRendered(context, stamp);
                    if (!isRendered2) continue;
                    lastIndex = i2;
                    break;
                }
                int firstIndex = 0;
                for (i = 0; i < size; ++i) {
                    component.setRowIndex(i);
                    isRendered = this.isRendered(context, stamp);
                    if (!isRendered) continue;
                    firstIndex = i;
                    break;
                }
                for (i = 0; i < size; ++i) {
                    component.setRowIndex(i);
                    isRendered = this.isRendered(context, stamp);
                    if (!isRendered) continue;
                    if (needsSeparator) {
                        this.renderBetweenNodes(context, node);
                    } else {
                        needsSeparator = true;
                    }
                    isSelected = i == rowIndex;
                    isFirst = i == firstIndex;
                    isLast = i == lastIndex;
                    isNextSelected = i + 1 == rowIndex;
                    this.renderNode(context, stamp, isSelected, isFirst, isLast, isNextSelected);
                }
                component.setRowKey(oldPath);
            }
            if (this.getVisibleIndexedChildCount(context, node) > 0) {
                this.renderBetweenNodes(context, node);
            }
        }
        super.renderContent(context, node);
    }

    protected boolean isRendered(UIXRenderingContext context, UINode stamp) {
        return TabBarRenderer.getBooleanAttributeValue(context, stamp, RENDERED_ATTR, true);
    }

    @Override
    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("tr");
        LinkUtils.endDefaultStyleClassDisabled(context);
        super.postrender(context, node);
        this.renderRelatedLinksBlockEnd(context);
    }

    protected void renderNode(UIXRenderingContext context, UINode child, boolean selected, boolean isFirst, boolean isLast, boolean isNextSelected) throws IOException {
        this.renderNode(context, child, selected);
    }

    protected void renderNode(UIXRenderingContext context, UINode child, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        boolean disabled = this._isDisabled(context, child);
        this.renderTabStyleAttrs(context, child, selected, disabled);
        this.renderChild(context, child);
        writer.endElement("td");
    }

    @Override
    protected void renderIndexedChild(UIXRenderingContext context, UINode node, int currVisChildIndex, int prevVisChildIndex, int nextVisChildIndex, int ithRenderedChild) throws IOException {
        int selectedIndex = this.getResolvedSelectedIndex(context, node);
        boolean selected = currVisChildIndex == selectedIndex;
        UINode child = node.getIndexedChild(context, currVisChildIndex);
        this.renderNode(context, child, selected, prevVisChildIndex == -1, nextVisChildIndex == -1, selectedIndex == nextVisChildIndex);
    }

    @Override
    protected void renderBetweenIndexedChildren(UIXRenderingContext context, UINode node) throws IOException {
        this.renderBetweenNodes(context, node);
    }

    protected void renderBetweenNodes(UIXRenderingContext context, UINode node) throws IOException {
        if (this._doRenderSeparator(context)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("td", null);
            TabBarRenderer.renderStyleClassAttribute(context, "af|menuTabs::separator");
            writer.endElement("td");
        }
    }

    protected void renderTabStyleAttrs(UIXRenderingContext context, UINode node, boolean selected, boolean disabled) throws IOException {
        String styleClass = null;
        styleClass = disabled ? "af|menuTabs::disabled" : (selected ? "af|menuTabs::selected" : "af|menuTabs::enabled");
        TabBarRenderer.renderStyleClassAttribute(context, styleClass);
    }

    @Override
    protected Object getStyleClass(UIXRenderingContext context, UINode node) {
        return "af|menuTabs";
    }

    protected boolean isSelected(UIXRenderingContext context, UINode node, int index) {
        return this.getResolvedSelectedIndexFromCache(context, node) == index;
    }

    private boolean _isDisabled(UIXRenderingContext context, UINode child) {
        return TabBarRenderer.getBooleanAttributeValue(context, child, DISABLED_ATTR, Boolean.FALSE);
    }

    private boolean _doRenderSeparator(UIXRenderingContext context) {
        String width;
        Style style;
        Object value = context.getLocalProperty(0, _SEPARATOR_KEY, null);
        if (value != null) {
            return (Boolean)value;
        }
        boolean doRenderSep = false;
        Styles styles = context.getStyleContext().getStyles();
        if (styles != null && (style = (Style)styles.getSelectorStyleMap().get("af|menuTabs::separator")) != null && !"0px".equals(width = (String)style.getProperties().get("width"))) {
            doRenderSep = true;
        }
        context.setLocalProperty(_SEPARATOR_KEY, doRenderSep ? Boolean.TRUE : Boolean.FALSE);
        return doRenderSep;
    }
}

