/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class AccessKeyUtils {
    public static void renderAccessKeyText(FacesContext context, Object textValue, int keyIndex) throws IOException {
        AccessKeyUtils.renderAccessKeyText(context, textValue, keyIndex, "AFAccessKeyStyle");
    }

    public static void renderAccessKeyText(FacesContext context, Object textValue, int keyIndex, String accessKeyClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (textValue != null && keyIndex != -1) {
            int charsLeft;
            String textString = textValue.toString();
            char[] textChars = textString.toCharArray();
            writer.writeText(textChars, 0, keyIndex);
            if (accessKeyClass != null && accessKeyClass.length() > 0) {
                writer.startElement("span", null);
                XhtmlRenderer.renderStyleClass((FacesContext)context, (RenderingContext)RenderingContext.getCurrentInstance(), (String)accessKeyClass);
                writer.writeText(textChars, keyIndex, 1);
                writer.endElement("span");
                ++keyIndex;
            }
            if ((charsLeft = textChars.length - keyIndex) > 0) {
                writer.writeText(textChars, keyIndex, charsLeft);
            }
        } else if (textValue != null) {
            writer.writeText(textValue, null);
        }
    }

    public static void renderAccessKeyText(FacesContext context, Object textValue, char accessKey, String highlightElement) throws IOException {
        String textString = textValue != null ? textValue.toString() : null;
        AccessKeyUtils.renderAccessKeyText(context, (Object)textString, AccessKeyUtils.getAccessKeyIndex(textString, accessKey), highlightElement);
    }

    public static int getAccessKeyIndex(Object textValue, char accessChar) {
        String textString;
        int keyIndex = -1;
        if (textValue != null && accessChar != '\uffff' && (keyIndex = (textString = textValue.toString()).indexOf(accessChar)) == -1) {
            char oppositeChar = Character.toLowerCase(accessChar);
            if (oppositeChar == accessChar) {
                oppositeChar = Character.toUpperCase(accessChar);
            }
            if (oppositeChar != accessChar) {
                keyIndex = textString.indexOf(oppositeChar);
            }
        }
        return keyIndex;
    }
}

