/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelListener;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.SortCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableModel
extends CollectionModel {
    private SortCriterion _sortCriterion = null;
    private DataModel _model = null;
    private Object _wrappedData = null;
    private IntList _sortedIndicesList = null;
    private IntList _baseIndicesList = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SortableModel.class);

    public SortableModel(Object model) {
        this.setWrappedData(model);
    }

    public SortableModel() {
    }

    @Override
    public Object getRowData() {
        return this._model.getRowData();
    }

    public Object getWrappedData() {
        return this._wrappedData;
    }

    @Override
    public boolean isRowAvailable() {
        return this._model.isRowAvailable();
    }

    public void setWrappedData(Object data) {
        this._baseIndicesList = null;
        this._model = ModelUtils.toDataModel(data);
        this._sortCriterion = null;
        this._sortedIndicesList = null;
        this._wrappedData = data;
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        int baseIndex = this._toBaseIndex(rowIndex);
        this._model.setRowIndex(baseIndex);
    }

    @Override
    public int getRowIndex() {
        int baseIndex = this._model.getRowIndex();
        return this._toSortedIndex(baseIndex);
    }

    @Override
    public Object getRowKey() {
        return this.isRowAvailable() ? Integer.valueOf(this._model.getRowIndex()) : null;
    }

    @Override
    public void setRowKey(Object key) {
        this._model.setRowIndex(this._toRowIndex(key));
    }

    public void addDataModelListener(DataModelListener listener) {
        this._model.addDataModelListener(listener);
    }

    public DataModelListener[] getDataModelListeners() {
        return this._model.getDataModelListeners();
    }

    public void removeDataModelListener(DataModelListener listener) {
        this._model.removeDataModelListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSortable(String property) {
        int oldIndex = this._model.getRowIndex();
        try {
            this._model.setRowIndex(0);
            if (!this._model.isRowAvailable()) {
                boolean bl = false;
                return bl;
            }
            Object data = this._model.getRowData();
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                ELResolver resolver = SortableModel._getELResolver(context);
                ELContext elContext = SortableModel._getELContext(context, resolver);
                Object propertyValue = this.evaluateProperty(resolver, elContext, data, property);
                boolean bl = propertyValue instanceof Comparable || propertyValue == null;
                return bl;
            }
            catch (RuntimeException e) {
                _LOG.warning(e);
                boolean bl = false;
                this._model.setRowIndex(oldIndex);
                return bl;
            }
        }
        finally {
            this._model.setRowIndex(oldIndex);
        }
    }

    private Object evaluateProperty(ELResolver resolver, ELContext context, Object base, String property) {
        if (!property.contains(".")) {
            return resolver.getValue(context, base, (Object)property);
        }
        int index = property.indexOf(46);
        Object newBase = resolver.getValue(context, base, (Object)property.substring(0, index));
        return this.evaluateProperty(resolver, context, newBase, property.substring(index + 1));
    }

    @Override
    public List<SortCriterion> getSortCriteria() {
        if (this._sortCriterion == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this._sortCriterion);
    }

    @Override
    public void setSortCriteria(List<SortCriterion> criteria) {
        if (criteria == null || criteria.isEmpty()) {
            this._sortCriterion = null;
            this._sortedIndicesList = null;
            this._baseIndicesList = null;
        } else {
            SortCriterion sc = criteria.get(0);
            if (this._sortCriterion == null || !this._sortCriterion.equals(sc)) {
                this._sortCriterion = sc;
                this._sort(this._sortCriterion.getProperty(), this._sortCriterion.isAscending());
            }
        }
    }

    public String toString() {
        return "SortableModel[" + this._model + "]";
    }

    private void _sort(String property, boolean isAscending) {
        int sz = this.getRowCount();
        if (this._baseIndicesList == null || this._baseIndicesList.size() != sz) {
            this._baseIndicesList = new IntList(sz);
        }
        int rowIndex = this._model.getRowIndex();
        this._model.setRowIndex(0);
        if (this._model.isRowAvailable()) {
            FacesContext context = FacesContext.getCurrentInstance();
            RequestContext rc = RequestContext.getCurrentInstance();
            ELResolver resolver = SortableModel._getELResolver(context);
            ELContext elContext = SortableModel._getELContext(context, resolver);
            Locale locale = SortableModel._getLocale(rc, context);
            Comparator<Integer> comp = new Comp(resolver, elContext, locale, property);
            if (!isAscending) {
                comp = new Inverter<Integer>(comp);
            }
            Collections.sort(this._baseIndicesList, comp);
            this._sortedIndicesList = null;
        }
        this._model.setRowIndex(rowIndex);
    }

    private int _toSortedIndex(int baseIndex) {
        if (this._sortedIndicesList == null && this._baseIndicesList != null) {
            this._sortedIndicesList = (IntList)this._baseIndicesList.clone();
            for (int i = 0; i < this._baseIndicesList.size(); ++i) {
                Integer base = (Integer)this._baseIndicesList.get(i);
                this._sortedIndicesList.set(base, i);
            }
        }
        return this._convertIndex(baseIndex, this._sortedIndicesList);
    }

    private int _toBaseIndex(int sortedIndex) {
        return this._convertIndex(sortedIndex, this._baseIndicesList);
    }

    private int _convertIndex(int index, List<Integer> indices) {
        if (index < 0) {
            return index;
        }
        if (indices != null && indices.size() > index) {
            index = indices.get(index);
        }
        return index;
    }

    private int _toRowIndex(Object rowKey) {
        if (rowKey == null) {
            return -1;
        }
        try {
            return (Integer)rowKey;
        }
        catch (ClassCastException e) {
            _LOG.warning("INVALID_ROWKEY", new Object[]{rowKey, rowKey.getClass()});
            _LOG.warning(e);
            return -1;
        }
    }

    static Object __resolveProperty(Object object, String propertyName) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELResolver resolver = SortableModel._getELResolver(context);
        ELContext elContext = SortableModel._getELContext(context, resolver);
        return resolver.getValue(elContext, object, (Object)propertyName);
    }

    private static ELContext _getELContext(FacesContext context, ELResolver resolver) {
        if (context != null) {
            return context.getELContext();
        }
        return new ELContextImpl(resolver);
    }

    private static ELResolver _getELResolver(FacesContext context) {
        if (context != null) {
            return context.getApplication().getELResolver();
        }
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return factory.getApplication().getELResolver();
    }

    private static Locale _getLocale(RequestContext requestContext, FacesContext facesContext) {
        if (requestContext != null) {
            return requestContext.getFormattingLocale();
        }
        if (facesContext != null) {
            return facesContext.getViewRoot().getLocale();
        }
        return null;
    }

    private static final class ELContextImpl
    extends ELContext {
        private final ELResolver _resolver;

        public ELContextImpl(ELResolver resolver) {
            this._resolver = resolver;
        }

        public ELResolver getELResolver() {
            return this._resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return null;
        }

        public VariableMapper getVariableMapper() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Inverter<T>
    implements Comparator<T> {
        private final Comparator<T> _comp;

        public Inverter(Comparator<T> comp) {
            this._comp = comp;
        }

        @Override
        public int compare(T o1, T o2) {
            return this._comp.compare(o2, o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Comp
    implements Comparator<Integer> {
        private final ELResolver _resolver;
        private final ELContext _context;
        private final Collator _collator;
        private final String _prop;

        public Comp(ELResolver resolver, ELContext context, Locale locale, String property) {
            this._resolver = resolver;
            this._context = context;
            this._collator = locale != null ? Collator.getInstance(locale) : null;
            this._prop = property;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            int index1 = o1;
            int index2 = o2;
            SortableModel.this._model.setRowIndex(index1);
            Object instance1 = SortableModel.this._model.getRowData();
            Object value1 = SortableModel.this.evaluateProperty(this._resolver, this._context, instance1, this._prop);
            SortableModel.this._model.setRowIndex(index2);
            Object instance2 = SortableModel.this._model.getRowData();
            Object value2 = SortableModel.this.evaluateProperty(this._resolver, this._context, instance2, this._prop);
            if (value1 == null) {
                return value2 == null ? 0 : -1;
            }
            if (value2 == null) {
                return 1;
            }
            if (value1 instanceof Comparable) {
                if (value1 instanceof String && value2 instanceof String) {
                    return this.compare((String)value1, (String)value2);
                }
                return ((Comparable)value1).compareTo(value2);
            }
            return this.compare(value1.toString(), value2.toString());
        }

        @Override
        private int compare(String s1, String s2) {
            if (this._collator != null) {
                return this._collator.compare(s1, s2);
            }
            return s1.compareTo(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntList
    extends ArrayList<Integer> {
        private static final long serialVersionUID = 1L;

        public IntList(int size) {
            super(size);
            this._expandToSize(size);
        }

        private void _expandToSize(int desiredSize) {
            for (int i = 0; i < desiredSize; ++i) {
                this.add(i);
            }
        }
    }
}

