/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.config.upload.UploadRequestManager;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UploadActionInvocationHandler
implements InvocationHandler {
    private Object _request;
    private Object _response;
    private UploadRequestManager _manager;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UploadActionInvocationHandler.class);

    public UploadActionInvocationHandler(ExternalContext ec, Map<String, String[]> params) {
        this._request = ec.getRequest();
        this._response = ec.getResponse();
        this._manager = new UploadRequestManager(ec, params);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int paramCount = method.getParameterTypes().length;
        switch (paramCount) {
            case 0: {
                if ("getContentType".equals(methodName)) {
                    return this._manager.getContentType();
                }
                if ("getCharacterEncoding".equals(methodName)) {
                    return this._manager.getCharacterEncoding();
                }
                if (!"getParameterMap".equals(methodName)) break;
                return this._manager.getParameterMap();
            }
            case 1: {
                if ("setCharacterEncoding".equals(methodName)) {
                    String encoding = (String)args[0];
                    if (encoding.equals(this._manager.getCharacterEncoding())) {
                        return null;
                    }
                    if (this._manager.isParameterRetrieved()) {
                        _LOG.warning("UNABLE_SET_REQUEST_CHARACTER", (Object)encoding);
                        return null;
                    }
                    this._manager.setCharacterEncoding(encoding);
                    Method m = this._response.getClass().getMethod("setRenderParameters", Map.class);
                    m.invoke(this._response, this._manager.getParameterMap());
                    UploadedFiles.setCharacterEncoding((PortletRequest)((RenderRequest)this._request), encoding);
                    return null;
                }
                if ("getParameterValues".equals(methodName)) {
                    return this._manager.getParameterValues((String)args[0]);
                }
                if (!"getParameter".equals(methodName)) break;
                return this._manager.getParameter((String)args[0]);
            }
        }
        return method.invoke(this._request, args);
    }
}

