/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanImpl;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class ValidatorUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ValidatorUtils.class);

    private ValidatorUtils() {
    }

    static final void assertIsString(Object value, String message) throws IllegalArgumentException {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(message);
        }
    }

    static Object getComponentLabel(UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (null == label) {
            label = component.getValueBinding("label");
        }
        return label;
    }

    static FacesBean getFacesBean(final FacesBean.Type type) {
        FacesBeanImpl bean = new FacesBeanImpl(){

            public FacesBean.Type getType() {
                return type;
            }
        };
        return bean;
    }

    static void setValueExpression(FacesBean bean, String name, ValueExpression expression) {
        PropertyKey key = ValidatorUtils._getPropertyKey(bean, name, true);
        bean.setValueExpression(key, expression);
    }

    static ValueExpression getValueExpression(FacesBean bean, String name) {
        PropertyKey key = ValidatorUtils._getPropertyKey(bean, name, true);
        return bean.getValueExpression(key);
    }

    static void setValueBinding(FacesBean bean, String name, ValueBinding binding) {
        PropertyKey key = ValidatorUtils._getPropertyKey(bean, name, true);
        bean.setValueBinding(key, binding);
    }

    static ValueBinding getValueBinding(FacesBean bean, String name) {
        PropertyKey key = ValidatorUtils._getPropertyKey(bean, name, true);
        return bean.getValueBinding(key);
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static PropertyKey _getPropertyKey(FacesBean bean, String name, boolean isStrict) {
        ValidatorUtils._assertNotNull(name, "attribute cannot be null");
        FacesBean.Type type = bean.getType();
        PropertyKey key = type.findKey(name);
        if (isStrict && key == null) {
            throw new IllegalArgumentException(_LOG.getMessage("INVALID_ATTRIBUTE_NAME", name));
        }
        return key;
    }

    private static void _assertNotNull(Object object, String message) {
        if (object == null) {
            if (message == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(message);
        }
    }
}

