/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreIcon;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconRenderer
extends XhtmlRenderer {
    private PropertyKey _nameKey;
    private static String _ICON_NAME_PREFIX = "AF";
    private static String _ICON_NAME_SUFFIX = "Icon";

    public IconRenderer() {
        super(CoreIcon.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._nameKey = type.findKey("name");
    }

    protected void encodeBegin(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, arc, comp)) {
            return;
        }
        String name = this.getName(bean);
        ResponseWriter rw = context.getResponseWriter();
        if ("logo".equals(name)) {
            rw.startElement("img", comp);
            this.renderId(context, comp);
            this.renderAllAttributes(context, arc, bean, false);
            this.renderStyleAttributes(context, arc, bean, "AFLogo");
            this.renderEncodedResourceURI(context, "src", context.getExternalContext().getRequestContextPath() + "/adf/images/t.gif");
            rw.endElement("img");
        } else {
            Icon icon = arc.getIcon(name);
            if (icon == null) {
                StringBuffer fullName = new StringBuffer(_ICON_NAME_PREFIX.length() + name.length() + _ICON_NAME_SUFFIX.length());
                fullName.append(_ICON_NAME_PREFIX);
                char firstChar = Character.toUpperCase(name.charAt(0));
                fullName.append(firstChar);
                fullName.append(name.substring(1));
                fullName.append(_ICON_NAME_SUFFIX);
                icon = arc.getIcon(fullName.toString());
            }
            if (icon != null && !icon.isNull()) {
                boolean embed;
                rw.startElement("span", comp);
                boolean bl = embed = icon.getImageURI(context, arc) == null;
                if (embed) {
                    this.renderId(context, comp);
                    this.renderAllAttributes(context, arc, bean, false);
                } else if (IconRenderer.supportsScripting(arc)) {
                    this.renderEventHandlers(context, bean);
                }
                this.renderInlineStyle(context, arc, bean);
                icon.renderIcon(context, arc, this._getNodeAttributeMap(context, comp, bean, embed));
                rw.endElement("span");
            }
        }
    }

    @Override
    protected void renderShortDescAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
    }

    protected String getName(FacesBean bean) {
        return IconRenderer.toString((Object)bean.getProperty(this._nameKey));
    }

    private Map<String, Object> _getNodeAttributeMap(FacesContext context, UIComponent comp, FacesBean bean, boolean embed) {
        ArrayMap attrs = null;
        attrs = new ArrayMap(1);
        attrs.put("shortDesc", this.getShortDesc(bean));
        attrs.put("styleClass", this.getStyleClass(bean));
        if (embed) {
            attrs.put("embedded", Boolean.TRUE);
        } else {
            attrs.put("id", this.getClientId(context, comp));
        }
        return attrs;
    }
}

