/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.convert.ClientConverter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidadinternal.convert.GenericConverterFactory;
import org.apache.myfaces.trinidadinternal.convert.TypeConversionException;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;
import org.apache.myfaces.trinidadinternal.util.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeConverter
extends org.apache.myfaces.trinidad.convert.DateTimeConverter
implements ClientConverter {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DateTimeConverter.class);
    private static final String _PATTERN_WRITTEN_KEY = "org.apache.myfaces.trinidadinternal.convert.DateTimeConverter._PATTERN_WRITTEN";
    private static final String _NO_JS_PATTERN = new String();
    private static final String _GMT_PLUS = "GMT+";
    private static final String _GMT_MINUS = "GMT-";
    private static final int _MILLIS_PER_HOUR = 3600000;
    private static final int _MILLIS_PER_MINUTE = 60000;
    private static final Collection<String> _IMPORT_NAMES = Collections.singletonList("TrDateTimeConverter()");

    public DateTimeConverter() {
    }

    public DateTimeConverter(String pattern) {
        super(pattern);
    }

    public DateTimeConverter(String pattern, String secondaryPattern) {
        super(pattern, secondaryPattern);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
        if (!(value instanceof String) && !(value instanceof Date) && fac.isConvertible(value, Date.class)) {
            value = fac.convert(value, Date.class);
        }
        return super.getAsString(context, component, value);
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Object date = super.getAsObject(context, component, value);
        if (date == null) {
            return null;
        }
        date = DateTimeConverter.__typeConvert(context, (Converter)this, component, value, date);
        return date;
    }

    static Object __typeConvert(FacesContext context, Converter converter, UIComponent component, String strValue, Object value) throws ConverterException {
        assert (value != null);
        ValueExpression expression = component.getValueExpression("value");
        if (expression != null) {
            Class expectedType = expression.getExpectedType();
            if (expectedType == null || expectedType == Object.class) {
                expectedType = expression.getType(context.getELContext());
            }
            if (expectedType != null && !expectedType.isAssignableFrom(value.getClass())) {
                if (expectedType == String.class) {
                    ValueHolder holder = (ValueHolder)component;
                    if (strValue.equals(holder.getValue())) {
                        return strValue;
                    }
                    return converter.getAsString(context, component, value);
                }
                GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
                try {
                    value = fac.convert(value, expectedType);
                }
                catch (TypeConversionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, MessageFactory.getString((FacesContext)context, (String)"org.apache.myfaces.trinidad.UIXEditableValue.CONVERSION"), cause.getLocalizedMessage());
                    throw new ConverterException(msg, (Throwable)e);
                }
            }
        }
        return value;
    }

    public String getClientScript(FacesContext context, UIComponent component) {
        if (component == null) {
            _LOG.severe("The component is null, but it is needed for the client id, so no script written");
            return null;
        }
        String clientId = component.getClientId(context);
        if (clientId != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            String jsPattern = this.getJSPattern(context);
            String loc = this._getLocaleString(context);
            StringBuilder buff = new StringBuilder(139 + jsPattern.length() + loc.length());
            if (requestMap.get(_PATTERN_WRITTEN_KEY) == null) {
                requestMap.put(_PATTERN_WRITTEN_KEY, Boolean.TRUE);
                buff.append("if(window['_dfs'] == undefined){window['_dfs']=new Object();}if(window['_dl'] == undefined){window['_dl']=new Object();}");
            }
            buff.append("_dfs[\"");
            buff.append(clientId);
            buff.append("\"]=");
            buff.append(jsPattern);
            buff.append(";");
            buff.append("_dl[\"");
            buff.append(clientId);
            buff.append("\"]=");
            buff.append(loc);
            buff.append(";");
            return buff.toString();
        }
        _LOG.severe("NULL_CLINET_ID_NO_SCRIPT_RENDERED");
        return null;
    }

    public String getClientConversion(FacesContext context, UIComponent component) {
        String jsPattern = this.getJSPattern(context);
        HashMap<String, String> messages = new HashMap<String, String>();
        if (jsPattern != null) {
            String pattern = this.getPattern();
            if (pattern == null) {
                pattern = this.getSecondaryPattern();
            }
            String key = this.getViolationMessageKey(pattern);
            Object[] params = new Object[]{"{0}", "{1}", "{2}"};
            Object msgPattern = this.getMessagePattern(context, key, params, component);
            String hintFormat = this._getHint();
            FacesMessage msg = null;
            String detailMessage = null;
            if (msgPattern != null) {
                msg = MessageFactory.getMessage((FacesContext)context, (String)key, (Object)msgPattern, (Object[])params, (UIComponent)component);
                detailMessage = XhtmlLafUtils.escapeJS(msg.getDetail());
            }
            String exampleString = XhtmlLafUtils.escapeJS(this.getExample(context));
            String escapedType = XhtmlLafUtils.escapeJS(this.getType().toUpperCase());
            StringBuilder outBuffer = new StringBuilder();
            outBuffer.append("new TrDateTimeConverter(");
            outBuffer.append(jsPattern);
            Locale loc = this.getLocale();
            if (loc != null) {
                outBuffer.append(",'");
                outBuffer.append(loc.toString());
                outBuffer.append("','");
            } else {
                outBuffer.append(",null,'");
            }
            outBuffer.append(exampleString);
            outBuffer.append("','");
            outBuffer.append(escapedType);
            outBuffer.append("'");
            if (msgPattern != null || hintFormat != null) {
                messages.put("detail", detailMessage);
                messages.put("hint", hintFormat);
                outBuffer.append(',');
                try {
                    JsonUtils.writeMap(outBuffer, messages, false);
                }
                catch (IOException e) {
                    outBuffer.append("null");
                }
            }
            outBuffer.append(')');
            return outBuffer.toString();
        }
        return null;
    }

    public Collection<String> getClientImportNames() {
        if (this._isDifferentLocale()) {
            ArrayList<String> names = new ArrayList<String>(2);
            names.add("TrDateTimeConverter()");
            String sloc = this.getLocale().toString();
            StringBuffer sb = new StringBuffer(11 + sloc.length());
            sb.append("LocaleInfo_");
            sb.append(sloc);
            names.add(sb.toString());
            return names;
        }
        return _IMPORT_NAMES;
    }

    public String getClientLibrarySource(FacesContext context) {
        return null;
    }

    public int getColumns() {
        int len;
        String pattern = this.getPattern();
        if (pattern != null) {
            len = pattern.length();
        } else {
            String applyPattern = null;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                DateFormat format = this.getDateFormat(context, null, false, null);
                if (format instanceof SimpleDateFormat) {
                    applyPattern = ((SimpleDateFormat)format).toPattern();
                }
            }
            catch (ConverterException e) {
                // empty catch block
            }
            if (applyPattern == null) {
                applyPattern = this.getSecondaryPattern();
            }
            len = applyPattern != null ? applyPattern.length() + 2 : 10;
        }
        return len;
    }

    protected Date getDate(FacesContext context, UIComponent component) {
        if (component instanceof ValueHolder) {
            Object value = ((ValueHolder)component).getValue();
            if (value == null || value instanceof String) {
                return null;
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
            if (fac.isConvertible(value, Date.class)) {
                return (Date)fac.convert(value, Date.class);
            }
        }
        return null;
    }

    protected TimeZone getFormattingTimeZone(TimeZone tZone, Date targetDate) {
        TimeZone zone = (TimeZone)tZone.clone();
        StringBuilder zoneId = new StringBuilder(9);
        int offset = targetDate != null ? zone.getOffset(targetDate.getTime()) : zone.getRawOffset();
        if (offset < 0) {
            zoneId.append(_GMT_MINUS);
            offset = -offset;
        } else {
            zoneId.append(_GMT_PLUS);
        }
        int hours = offset / 3600000;
        if (hours < 10) {
            zoneId.append('0');
        }
        zoneId.append(hours);
        zoneId.append(':');
        int minutes = offset % 3600000 / 60000;
        if (minutes < 10) {
            zoneId.append('0');
        }
        zoneId.append(minutes);
        zone.setID(zoneId.toString());
        return zone;
    }

    protected String getJSPattern(FacesContext context) {
        String jsPattern = null;
        String datePattern = this.getPattern();
        if (datePattern == null) {
            try {
                DateFormat format = this.getDateFormat(context, null, false, null);
                datePattern = format != null && format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : _NO_JS_PATTERN;
            }
            catch (ConverterException ce) {
                datePattern = _NO_JS_PATTERN;
            }
        }
        if ((datePattern == null || datePattern == _NO_JS_PATTERN) && this.getSecondaryPattern() != null) {
            int length = this.getSecondaryPattern().length() * 2 + 2;
            StringBuilder outBuffer = new StringBuilder(length);
            DateTimeConverter._escapePattern(outBuffer, this.getSecondaryPattern());
            return outBuffer.toString();
        }
        if (datePattern != null) {
            String secondaryPattern = this.getSecondaryPattern();
            if (datePattern != _NO_JS_PATTERN) {
                int length = datePattern.length() * 2 + 2;
                if (secondaryPattern != null) {
                    length = length + 3 + secondaryPattern.length() * 2;
                }
                StringBuilder outBuffer = new StringBuilder(length);
                jsPattern = DateTimeConverter._getEscapedPattern(outBuffer, datePattern, secondaryPattern);
            } else {
                jsPattern = datePattern;
            }
        }
        return jsPattern;
    }

    private static void _escapePattern(StringBuilder buffer, String pattern) {
        buffer.append('\'');
        XhtmlUtils.escapeJS(buffer, pattern);
        buffer.append('\'');
    }

    private String _getHint() {
        String type = this.getType();
        if (type.equals("date")) {
            return this.getHintDate();
        }
        if (type.equals("both")) {
            return this.getHintBoth();
        }
        return this.getHintTime();
    }

    private static String _getEscapedPattern(StringBuilder buffer, String pattern, String secondaryPattern) {
        if (secondaryPattern != null) {
            buffer.append('[');
        }
        DateTimeConverter._escapePattern(buffer, pattern);
        if (secondaryPattern != null) {
            buffer.append(",'");
            XhtmlUtils.escapeJS(buffer, secondaryPattern);
            buffer.append("']");
        }
        return buffer.toString();
    }

    private String _getLocaleString(FacesContext context) {
        Locale defaultLocale;
        Locale dateTimeConverterLocale = this.getLocale();
        if (dateTimeConverterLocale != null && !dateTimeConverterLocale.equals(defaultLocale = RenderingContext.getCurrentInstance().getLocaleContext().getFormattingLocale())) {
            String loc = dateTimeConverterLocale.toString();
            StringBuffer sb = new StringBuffer(2 + loc.length());
            sb.append("'");
            sb.append(loc);
            sb.append("'");
            return sb.toString();
        }
        return "null";
    }

    private boolean _isDifferentLocale() {
        Locale dateTimeConverterLocale = this.getLocale();
        if (dateTimeConverterLocale != null) {
            Locale defaultLocale = RenderingContext.getCurrentInstance().getLocaleContext().getFormattingLocale();
            return !dateTimeConverterLocale.equals(defaultLocale);
        }
        return false;
    }
}

