/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageProviderResponse;
import org.apache.myfaces.trinidadinternal.style.ParsedPropertyKey;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.Style;
import org.apache.myfaces.trinidadinternal.style.StyleMap;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
abstract class GeneratedImageRenderer
extends HtmlLafRenderer
implements ImageConstants {
    private static final int _DEFAULT_FONT_SIZE = 12;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GeneratedImageRenderer.class);

    GeneratedImageRenderer() {
    }

    protected void renderImage(UIXRenderingContext context, UINode node, ImageProviderResponse response) throws IOException {
        this.renderImage(context, node, response, null);
    }

    @Override
    protected void renderShortDesc(UIXRenderingContext context, UINode node) {
    }

    protected void renderImage(UIXRenderingContext context, UINode node, ImageProviderResponse response, String mapName) throws IOException {
        assert (response != null);
        boolean disabled = this.isDisabled(context, node);
        boolean hasMap = response.getMapAreas() != null;
        Object shortDesc = this.getShortDesc(context, node);
        boolean hasLink = !disabled && !hasMap;
        Object destination = hasLink ? this.getDestination(context, node) : null;
        this.renderImage(context, node, response, hasMap, mapName, shortDesc, destination);
    }

    protected void renderImage(UIXRenderingContext context, UINode node, ImageProviderResponse response, boolean hasMap, String mapName, Object shortDesc, Object destination) throws IOException {
        Object valign;
        UIComponent component;
        assert (node != null);
        boolean hasLink = destination != null;
        Object longDesc = this.getLongDesc(context, node);
        String imageStyle = this.getImageStyle(context, node);
        String imageStyleClass = this.getImageStyleClass(context, node);
        ResponseWriter writer = context.getResponseWriter();
        UIComponent uIComponent = component = node == null ? null : node.getUIComponent();
        if (hasLink) {
            writer.startElement("a", component);
            this.renderEncodedActionURI(context, "href", destination);
            this.renderAttribute(context, node, "target", TARGET_FRAME_ATTR);
            if (!GeneratedImageRenderer.isNetscape(context)) {
                this.renderButtonAccessKey(context, node);
            }
            this.renderAttributes(context, node);
        }
        writer.startElement("img", component);
        if (!hasLink) {
            this.renderAttributes(context, node);
        }
        GeneratedImageRenderer.writeCacheImageURI(context, "src", response.getImageURI());
        GeneratedImageRenderer.renderAltAndTooltipForImage(context, shortDesc);
        this.renderAttribute(context, "longdesc", longDesc);
        this.renderAttribute(context, "border", "0");
        this.renderHAlign(context, node);
        if (node.getAttributeValue(context, H_ALIGN_ATTR) == null && (valign = this.getVAlign(context, node)) != null) {
            this.renderAttribute(context, "align", valign);
        }
        int width = response.getWidth();
        int height = response.getHeight();
        if (width != -1) {
            this.renderAttribute(context, "width", IntegerUtils.getString((int)width));
        }
        if (height != -1) {
            this.renderAttribute(context, "height", IntegerUtils.getString((int)height));
        }
        if (hasMap) {
            writer.writeAttribute("usemap", (Object)("#" + mapName), null);
        }
        if (imageStyle != null) {
            this.renderAttribute(context, "style", imageStyle);
        }
        if (imageStyleClass != null) {
            GeneratedImageRenderer.renderStyleClassAttribute(context, imageStyleClass);
        }
        writer.endElement("img");
        if (hasLink) {
            writer.endElement("a");
        }
    }

    @Override
    protected Object getText(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, TEXT_ATTR);
    }

    @Override
    protected Object getShortDesc(UIXRenderingContext context, UINode node) {
        Object desc = node.getAttributeValue(context, SHORT_DESC_ATTR);
        if (desc == null && !GeneratedImageRenderer.isInaccessibleMode(context)) {
            return this.getText(context, node);
        }
        return desc;
    }

    protected Object getImageName(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ID_ATTR);
    }

    protected Object getLongDesc(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, LONG_DESC_URL_ATTR);
    }

    protected Object getDestination(UIXRenderingContext context, UINode node) {
        Object onClick;
        if (!GeneratedImageRenderer.supportsNavigation(context)) {
            return null;
        }
        Object destination = node.getAttributeValue(context, DESTINATION_ATTR);
        if (destination == null && GeneratedImageRenderer.supportsIntrinsicEvents(context) && (onClick = this.getOnClick(context, node)) != null) {
            destination = "#";
        }
        return destination;
    }

    protected String getImageStyle(UIXRenderingContext context, UINode node) {
        return null;
    }

    protected String getImageStyleClass(UIXRenderingContext context, UINode node) {
        return null;
    }

    protected void renderButtonAccessKey(UIXRenderingContext context, UINode node) throws IOException {
        this.renderAttribute(context, node, "accesskey", ACCESS_KEY_ATTR);
    }

    protected static String getURLAttribute(UIXRenderingContext context, UINode node, AttributeKey attrKey) {
        Object o = node.getAttributeValue(context, attrKey);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    protected static Style getStyle(UIXRenderingContext context, UINode node, String name) {
        if (name == null) {
            return null;
        }
        StyleMap map = context.getStyleContext().getStyleMap();
        if (map == null) {
            return null;
        }
        return map.getStyleByName(context.getStyleContext(), name);
    }

    protected Object getVAlign(UIXRenderingContext context, UINode node) {
        return null;
    }

    protected static int getFontStyle(UIXRenderingContext context, UINode node, Style classStyle, Style inlineStyle, String styleName) {
        int fontStyle = 0;
        int fontWeight = 0;
        boolean gotStyle = false;
        boolean gotWeight = false;
        Object value = null;
        if (inlineStyle != null) {
            value = GeneratedImageRenderer._parseValue(inlineStyle, null, Style.FONT_STYLE_KEY);
            if (value != null) {
                fontStyle = GeneratedImageRenderer._getAWTFontStyle(value);
                gotStyle = true;
            }
            if ((value = GeneratedImageRenderer._parseValue(inlineStyle, null, Style.FONT_WEIGHT_KEY)) != null) {
                fontWeight = GeneratedImageRenderer._getAWTFontWeight(value);
                gotWeight = true;
            }
        }
        if (classStyle != null) {
            if (!gotStyle && (value = GeneratedImageRenderer._parseValue(classStyle, styleName, Style.FONT_STYLE_KEY)) != null) {
                fontStyle = GeneratedImageRenderer._getAWTFontStyle(value);
            }
            if (!gotWeight && (value = GeneratedImageRenderer._parseValue(classStyle, styleName, Style.FONT_WEIGHT_KEY)) != null) {
                fontWeight = GeneratedImageRenderer._getAWTFontWeight(value);
            }
        }
        return fontStyle | fontWeight;
    }

    protected static int getFontSize(UIXRenderingContext context, UINode node, Style classStyle, Style inlineStyle, String styleName) {
        Object value;
        if (inlineStyle != null && (value = GeneratedImageRenderer._parseValue(inlineStyle, null, Style.FONT_SIZE_KEY)) instanceof Integer) {
            return (Integer)value;
        }
        if (styleName != null && (value = GeneratedImageRenderer._parseValue(classStyle, styleName, Style.FONT_SIZE_KEY)) instanceof Integer) {
            return (Integer)value;
        }
        return 12;
    }

    protected static Collection<Object> getFontFamilies(UIXRenderingContext context, UINode node, Style style, String styleName) {
        if (style != null) {
            if (GeneratedImageRenderer._parseValue(style, null, Style.FONT_FAMILIES_KEY) instanceof Collection) {
                return (Collection)GeneratedImageRenderer._parseValue(style, null, Style.FONT_FAMILIES_KEY);
            }
            ArrayList<Object> parsedValueList = new ArrayList<Object>();
            parsedValueList.add(GeneratedImageRenderer._parseValue(style, null, Style.FONT_FAMILIES_KEY));
            return parsedValueList;
        }
        return null;
    }

    protected static Color getBackground(UIXRenderingContext context, UINode node, Style classStyle, Style inlineStyle, String styleName) {
        Color background;
        if (inlineStyle != null && (background = (Color)GeneratedImageRenderer._parseValue(inlineStyle, null, Style.BACKGROUND_KEY)) != null) {
            return background;
        }
        return (Color)GeneratedImageRenderer._parseValue(classStyle, styleName, Style.BACKGROUND_KEY);
    }

    protected static Color getForeground(UIXRenderingContext context, UINode node, Style classStyle, Style inlineStyle, String styleName) {
        Color foreground;
        if (inlineStyle != null && (foreground = (Color)GeneratedImageRenderer._parseValue(inlineStyle, null, Style.FOREGROUND_KEY)) != null) {
            return foreground;
        }
        return (Color)GeneratedImageRenderer._parseValue(classStyle, styleName, Style.FOREGROUND_KEY);
    }

    protected static Color getSurroundingColor(UIXRenderingContext context) {
        if (BaseDesktopUtils.supportsTransparentImages(context)) {
            return null;
        }
        return BaseDesktopUtils.getBackgroundColor(context);
    }

    protected static boolean isTextAntialiased(UIXRenderingContext context, UINode node, Style classStyle, Style inlineStyle) {
        if (inlineStyle != null) {
            Object value = inlineStyle.getParsedProperty(Style.TEXT_ANTIALIAS_KEY);
            return Boolean.TRUE.equals(value);
        }
        if (classStyle != null) {
            Object value = classStyle.getParsedProperty(Style.TEXT_ANTIALIAS_KEY);
            return Boolean.TRUE.equals(value);
        }
        return false;
    }

    private static Object _parseValue(Style style, String styleName, ParsedPropertyKey key) {
        Object value;
        block3: {
            if (style == null) {
                return null;
            }
            value = null;
            try {
                value = style.getParsedProperty(key);
            }
            catch (PropertyParseException e) {
                if (!_LOG.isWarning()) break block3;
                _LOG.warning(styleName == null ? "Error while parsing inline style" : "Error while parsing style class \"" + styleName + "\"", (Throwable)e);
            }
        }
        return value;
    }

    private static int _getAWTFontStyle(Object style) {
        if (style == Style.ITALIC_FONT_STYLE) {
            return 2;
        }
        return 0;
    }

    private static int _getAWTFontWeight(Object weight) {
        if (weight == Style.BOLD_FONT_WEIGHT) {
            return 1;
        }
        return 0;
    }
}

