/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.util.ModeUtils;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetDocument {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    private StyleSheetNode[] _styleSheets;
    private final String _documentVersion;
    private final long _documentTimestamp;
    static final String _FONT_SIZE_NAME = "font-size";
    static final String _POINT_UNITS = "pt";
    static final String _PIXEL_UNITS = "px";
    private static final StyleNode _ERROR_STYLE_NODE = new StyleNode("error", "error", null, null, null, null);
    private static final String _CIRCULAR_INCLUDE_ERROR = "Circular dependency detected in style ";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetDocument.class);

    @Deprecated
    public StyleSheetDocument(StyleSheetNode[] styleSheets) {
        this(styleSheets, null, -1L);
    }

    @Deprecated
    public StyleSheetDocument(StyleSheetNode[] styleSheets, String documentVersion) {
        this(styleSheets, documentVersion, -1L);
    }

    public StyleSheetDocument(StyleSheetNode[] styleSheets, String documentVersion, long documentTimestamp) {
        if (styleSheets != null) {
            this._styleSheets = new StyleSheetNode[styleSheets.length];
            System.arraycopy(styleSheets, 0, this._styleSheets, 0, styleSheets.length);
        }
        this._documentVersion = documentVersion;
        this._documentTimestamp = documentTimestamp;
    }

    public String getDocumentId(StyleContext sContext) {
        int hashCode = 17;
        Iterator<StyleSheetNode> styleSheetNodes = this.getStyleSheets(sContext);
        while (styleSheetNodes.hasNext()) {
            hashCode = hashCode * 37 + styleSheetNodes.next().getStyleSheetId();
        }
        return Integer.toString(Math.abs(hashCode), 36);
    }

    public String getDocumentVersion() {
        return this._documentVersion;
    }

    public long getDocumentTimestamp() {
        return this._documentTimestamp;
    }

    public Iterator<StyleSheetNode> getStyleSheets() {
        if (this._styleSheets == null) {
            return Arrays.asList(new StyleSheetNode[0]).iterator();
        }
        return Arrays.asList(this._styleSheets).iterator();
    }

    public Iterator<StyleSheetNode> getStyleSheets(StyleContext context) {
        StyleSheetList styleSheets = this._getStyleSheets(context);
        return styleSheets.styleSheets().iterator();
    }

    public Iterator<StyleNode> getStyles(StyleContext context) {
        StyleSheetList styleSheets = this._getStyleSheets(context);
        if (styleSheets.isEmpty()) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        ArrayList<StyleNode> styles = new ArrayList<StyleNode>();
        HashMap<String, StyleNode> resolvedStyles = new HashMap<String, StyleNode>();
        HashMap<String, StyleNode> resolvedNamedStyles = new HashMap<String, StyleNode>();
        HashSet<String> foundSelectors = new HashSet<String>();
        HashSet<String> foundNames = new HashSet<String>();
        styleSheets.cacheIds();
        for (StyleSheetNode styleSheet : styleSheets.styleSheets()) {
            Collection<StyleNode> styleNodeList = styleSheet.getStyles();
            for (StyleNode node : styleNodeList) {
                StyleNode resolvedNode;
                boolean isFound;
                String id;
                boolean isNamed;
                if (node.getName() != null) {
                    isNamed = true;
                    id = node.getName();
                    isFound = foundNames.contains(id);
                } else {
                    isNamed = false;
                    id = node.getSelector();
                    isFound = foundSelectors.contains(id);
                }
                if (isFound || (resolvedNode = this._resolveStyle(context, styleSheets, resolvedStyles, resolvedNamedStyles, null, null, id, isNamed)) == null) continue;
                styles.add(resolvedNode);
                if (isNamed) {
                    foundNames.add(id);
                    continue;
                }
                foundSelectors.add(id);
            }
        }
        return styles.iterator();
    }

    public StyleNode getStyleBySelector(StyleContext context, String selector) {
        return this._getStyle(context, selector, false);
    }

    public StyleNode getStyleByName(StyleContext context, String name) {
        return this._getStyle(context, name, true);
    }

    private StyleSheetList _getStyleSheets(StyleContext context) {
        LocaleContext localeContext = context.getLocaleContext();
        Locale locale = localeContext.getTranslationLocale();
        int direction = LocaleUtils.getReadingDirection(localeContext);
        int mode = NameUtils.getMode(ModeUtils.getCurrentMode(context));
        TrinidadAgent agent = context.getAgent();
        AccessibilityProfile accProfile = context.getAccessibilityProfile();
        ArrayList<StyleSheetNode> v = new ArrayList<StyleSheetNode>();
        Iterator<StyleSheetNode> e = this.getStyleSheets();
        while (e.hasNext()) {
            StyleSheetNode styleSheet = e.next();
            if (styleSheet.compareVariants(locale, direction, agent, mode, accProfile) <= 0) continue;
            v.add(styleSheet);
        }
        int count = v.size();
        if (count == 0) {
            return new StyleSheetList(null);
        }
        StyleSheetNode[] styleSheets = v.toArray(new StyleSheetNode[count]);
        StyleSheetComparator comparator = new StyleSheetComparator(locale, direction, agent, mode, this._styleSheets, accProfile);
        Arrays.sort(styleSheets, comparator);
        return new StyleSheetList(styleSheets);
    }

    private StyleNode _getStyle(StyleContext context, String id, boolean isNamed) {
        StyleSheetList styleSheets = this._getStyleSheets(context);
        if (styleSheets.isEmpty()) {
            return null;
        }
        return this._resolveStyle(context, styleSheets, new HashMap<String, StyleNode>(19), new HashMap<String, StyleNode>(19), null, null, id, isNamed);
    }

    private StyleNode _resolveStyle(StyleContext context, StyleSheetList styleSheets, Map<String, StyleNode> resolvedStyles, Map<String, StyleNode> resolvedNamedStyles, Stack<String> includesStack, Stack<String> namedIncludesStack, String id, boolean isNamed) {
        assert (styleSheets != null);
        assert (resolvedStyles != null);
        assert (resolvedNamedStyles != null);
        assert (id != null);
        StyleNode style = null;
        String selector = null;
        String name = null;
        if (isNamed) {
            style = resolvedNamedStyles.get(id);
            name = id;
        } else {
            style = resolvedStyles.get(id);
            selector = id;
        }
        if (style != null) {
            if (style == _ERROR_STYLE_NODE) {
                return null;
            }
            return style;
        }
        if (isNamed && StyleSheetDocument._stackContains(namedIncludesStack, id) || !isNamed && StyleSheetDocument._stackContains(includesStack, id)) {
            if (_LOG.isWarning()) {
                _LOG.warning(_CIRCULAR_INCLUDE_ERROR + id);
            }
            return null;
        }
        StyleEntry entry = new StyleEntry(selector, name);
        if (isNamed) {
            if (namedIncludesStack == null) {
                namedIncludesStack = new Stack();
            }
            namedIncludesStack.push(id);
        } else {
            if (includesStack == null) {
                includesStack = new Stack();
            }
            includesStack.push(id);
        }
        List<StyleNode> nodeList = styleSheets.styleNodes(id, isNamed);
        if (nodeList != null) {
            for (StyleNode node : nodeList) {
                if (node.__getResetProperties() || node.isInhibitingAll()) {
                    entry.resetProperties();
                }
                Collection<IncludeStyleNode> includedStyles = node.getIncludedStyles();
                for (IncludeStyleNode includeStyle : includedStyles) {
                    StyleNode resolvedNode;
                    String includeID = null;
                    boolean includeIsNamed = false;
                    if (includeStyle.getName() != null) {
                        includeID = includeStyle.getName();
                        includeIsNamed = true;
                    } else {
                        includeID = includeStyle.getSelector();
                    }
                    if ((resolvedNode = this._resolveStyle(context, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, includeID, includeIsNamed)) == null) continue;
                    this._addIncludedProperties(entry, resolvedNode);
                }
                Collection<IncludePropertyNode> includedProperties = node.getIncludedProperties();
                for (IncludePropertyNode includeProperty : includedProperties) {
                    StyleNode resolvedNode;
                    String includeID = null;
                    boolean includeIsNamed = false;
                    if (includeProperty.getName() != null) {
                        includeID = includeProperty.getName();
                        includeIsNamed = true;
                    } else {
                        includeID = includeProperty.getSelector();
                    }
                    if ((resolvedNode = this._resolveStyle(context, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, includeID, includeIsNamed)) == null) continue;
                    this._addIncludedProperty(entry, resolvedNode, includeProperty.getPropertyName(), includeProperty.getLocalPropertyName());
                }
                Collection<String> inhibitedProperties = node.getInhibitedProperties();
                for (String inhibitedPropertyName : inhibitedProperties) {
                    entry.removeProperty(inhibitedPropertyName);
                }
                Collection<PropertyNode> properties = node.getProperties();
                for (PropertyNode propertyNode : properties) {
                    entry.addProperty(propertyNode);
                }
            }
        }
        if (isNamed) {
            namedIncludesStack.pop();
        } else {
            includesStack.pop();
        }
        StyleNode resolvedNode = entry.toStyleNode();
        if (resolvedNode != null) {
            String namedStyle = resolvedNode.getName();
            if (namedStyle != null) {
                resolvedNamedStyles.put(namedStyle, resolvedNode);
            } else {
                String selectorStyle = resolvedNode.getSelector();
                if (selectorStyle != null) {
                    resolvedStyles.put(selectorStyle, resolvedNode);
                }
            }
        }
        return resolvedNode;
    }

    private void _addIncludedProperties(StyleEntry entry, StyleNode node) {
        if (node == null) {
            return;
        }
        Collection<PropertyNode> properties = node.getProperties();
        for (PropertyNode propertyNode : properties) {
            entry.addIncludedProperty(propertyNode);
        }
    }

    private void _addIncludedProperty(StyleEntry entry, StyleNode node, String propertyName, String localPropertyName) {
        if (node == null) {
            return;
        }
        Collection<PropertyNode> properties = node.getProperties();
        for (PropertyNode property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            if (!propertyName.equals(localPropertyName)) {
                property = new PropertyNode(localPropertyName, property.getValue());
            }
            entry.addIncludedProperty(property);
        }
    }

    private static int _getNonNullCount(List<?> list) {
        if (list == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    static PropertyNode _getRealFontSize(PropertyNode property, int relativeFontSize) {
        if (relativeFontSize == 0) {
            return property;
        }
        String value = property.getValue();
        String units = _POINT_UNITS;
        if (value.endsWith(_POINT_UNITS)) {
            value = value.substring(0, value.length() - _POINT_UNITS.length());
            units = _POINT_UNITS;
        } else if (value.endsWith(_PIXEL_UNITS)) {
            value = value.substring(0, value.length() - _PIXEL_UNITS.length());
            units = _PIXEL_UNITS;
        }
        int size = 0;
        try {
            size = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            assert (false) : "Could not parse font size: " + value;
            return property;
        }
        String newValue = IntegerUtils.getString((int)(size += relativeFontSize)) + units;
        return new PropertyNode(_FONT_SIZE_NAME, newValue);
    }

    private static boolean _stackContains(Stack<?> stack, Object value) {
        if (stack == null) {
            return false;
        }
        return stack.contains(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FontSizeConverter
    implements Iterator<PropertyNode> {
        private Iterator<PropertyNode> _wrappedIterator;
        private int _relativeFontSize;

        public FontSizeConverter(Iterator<PropertyNode> wrappedIterator, int relativeFontSize) {
            this._wrappedIterator = wrappedIterator;
            this._relativeFontSize = relativeFontSize;
        }

        @Override
        public boolean hasNext() {
            return this._wrappedIterator.hasNext();
        }

        @Override
        public void remove() {
            this._wrappedIterator.remove();
        }

        @Override
        public PropertyNode next() {
            PropertyNode property = this._wrappedIterator.next();
            if (this._relativeFontSize == 0 || !StyleSheetDocument._FONT_SIZE_NAME.equals(property.getName())) {
                return property;
            }
            return StyleSheetDocument._getRealFontSize(property, this._relativeFontSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonNullIterator<T>
    implements Iterator<T> {
        private Iterator<T> _wrappedIterator;
        private T _next;

        public NonNullIterator(Iterator<T> wrappedIterator) {
            this._wrappedIterator = wrappedIterator;
            this._next = this._getNonNullNext();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public T next() {
            T next = this._next;
            this._next = this._getNonNullNext();
            return next;
        }

        @Override
        public void remove() {
            this._wrappedIterator.remove();
        }

        private T _getNonNullNext() {
            while (this._wrappedIterator.hasNext()) {
                T next = this._wrappedIterator.next();
                if (next == null) continue;
                return next;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StyleEntry {
        public final String selector;
        public final String name;
        private ArrayList<PropertyNode> _properties;
        private int _propertyCount;
        private int _relativeFontSize;

        private StyleEntry() {
            assert (false);
            this.selector = null;
            this.name = null;
        }

        public StyleEntry(String selector, String name) {
            this.selector = selector;
            this.name = name;
        }

        public void addProperty(PropertyNode property) {
            if (this._properties == null) {
                this._properties = new ArrayList(5);
            }
            if (this._isRelativeFontSize(property)) {
                this._addRelativeFontSize(property);
            } else if (this._isRelativeColor(property)) {
                this._addRelativeColor(property);
            } else {
                String name = property.getName();
                this.removeProperty(name);
                this._properties.add(property);
                ++this._propertyCount;
                if (name.equals(StyleSheetDocument._FONT_SIZE_NAME)) {
                    this._relativeFontSize = 0;
                }
            }
        }

        public void removeProperty(String name) {
            if (this._removeProperty(this._properties, name)) {
                --this._propertyCount;
            }
        }

        public void resetProperties() {
            this._properties = null;
            this._propertyCount = 0;
            this._relativeFontSize = 0;
        }

        public int getPropertyCount() {
            return this._propertyCount;
        }

        public Iterator<PropertyNode> getProperties() {
            if (this._properties == null) {
                return null;
            }
            return new FontSizeConverter(new NonNullIterator<PropertyNode>(this._properties.iterator()), this._relativeFontSize);
        }

        public void addIncludedProperty(PropertyNode property) {
            this.addProperty(property);
        }

        public StyleNode toStyleNode() {
            int count = StyleSheetDocument._getNonNullCount(this._properties);
            if (count == 0) {
                return null;
            }
            Object[] properties = new PropertyNode[count];
            this._nonNullCopyInto(this._properties, properties, 0);
            if (this._relativeFontSize != 0) {
                for (int i = 0; i < properties.length; ++i) {
                    Object property = properties[i];
                    if (!StyleSheetDocument._FONT_SIZE_NAME.equals(((PropertyNode)property).getName())) continue;
                    properties[i] = StyleSheetDocument._getRealFontSize((PropertyNode)property, this._relativeFontSize);
                    break;
                }
            }
            return new StyleNode(this.name, this.selector, (PropertyNode[])properties, null, null, null);
        }

        private boolean _removeProperty(ArrayList<PropertyNode> properties, String name) {
            if (properties == null) {
                return false;
            }
            for (int i = 0; i < properties.size(); ++i) {
                PropertyNode property = properties.get(i);
                if (property == null || !property.getName().equals(name)) continue;
                properties.set(i, null);
                return true;
            }
            return false;
        }

        private void _nonNullCopyInto(ArrayList<? extends Object> source, Object[] target, int start) {
            if (source == null) {
                return;
            }
            for (int i = 0; i < source.size(); ++i) {
                Object o = source.get(i);
                if (o == null) continue;
                target[start++] = o;
            }
        }

        private boolean _isRelativeFontSize(PropertyNode property) {
            if (!StyleSheetDocument._FONT_SIZE_NAME.equals(property.getName())) {
                return false;
            }
            String value = property.getValue();
            if (value != null && value.length() > 0) {
                char c = value.charAt(0);
                return c == '+' || c == '-';
            }
            return false;
        }

        private boolean _isRelativeColor(PropertyNode property) {
            String value = property.getValue();
            if (value == null) {
                return false;
            }
            int length = value.length();
            if (length != 8 && length != 5) {
                return false;
            }
            char c0 = value.charAt(0);
            return (c0 == '+' || c0 == '-') && value.charAt(1) == '#';
        }

        private void _addRelativeFontSize(PropertyNode property) {
            boolean increment;
            assert (this._isRelativeFontSize(property));
            String value = property.getValue();
            boolean bl = increment = value.charAt(0) == '+';
            value = value.endsWith(StyleSheetDocument._POINT_UNITS) ? value.substring(1, value.length() - StyleSheetDocument._POINT_UNITS.length()) : (value.endsWith(StyleSheetDocument._PIXEL_UNITS) ? value.substring(1, value.length() - StyleSheetDocument._PIXEL_UNITS.length()) : value.substring(1));
            int size = 0;
            try {
                size = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return;
            }
            this._relativeFontSize = increment ? (this._relativeFontSize += size) : (this._relativeFontSize -= size);
        }

        private void _addRelativeColor(PropertyNode property) {
            assert (this._isRelativeColor(property));
            String relativeValue = property.getValue();
            boolean increment = relativeValue.charAt(0) == '+';
            Color relativeColor = null;
            try {
                relativeColor = CSSUtils.parseColor(relativeValue.substring(1));
            }
            catch (PropertyParseException e) {
                // empty catch block
            }
            if (relativeColor == null) {
                return;
            }
            String absoluteValue = this._getPropertyValue(property.getName());
            if (absoluteValue == null) {
                return;
            }
            Color absoluteColor = null;
            try {
                absoluteColor = CSSUtils.parseColor(absoluteValue);
            }
            catch (PropertyParseException e) {
                // empty catch block
            }
            if (absoluteColor == null) {
                return;
            }
            int red = absoluteColor.getRed();
            int green = absoluteColor.getGreen();
            int blue = absoluteColor.getBlue();
            if (increment) {
                red = Math.min(red + relativeColor.getRed(), 255);
                green = Math.min(green + relativeColor.getGreen(), 255);
                blue = Math.min(blue + relativeColor.getBlue(), 255);
            } else {
                red = Math.max(red - relativeColor.getRed(), 0);
                green = Math.max(green - relativeColor.getGreen(), 0);
                blue = Math.max(blue - relativeColor.getBlue(), 0);
            }
            Color resolvedColor = new Color(red, green, blue);
            String resolvedValue = CSSUtils.getColorValue(resolvedColor);
            this.addProperty(new PropertyNode(property.getName(), resolvedValue));
        }

        private String _getPropertyValue(String name) {
            if (this._properties != null) {
                for (PropertyNode property : this._properties) {
                    if (property == null || !name.equals(property.getName())) continue;
                    return property.getValue();
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StyleSheetComparator
    implements Comparator<StyleSheetNode> {
        private Locale _locale;
        private int _direction;
        private TrinidadAgent _agent;
        private int _mode;
        private StyleSheetNode[] _styleSheets;
        private AccessibilityProfile _accProfile;

        public StyleSheetComparator(Locale locale, int direction, TrinidadAgent agent, int mode, StyleSheetNode[] styleSheets, AccessibilityProfile accessibilityProfile) {
            this._direction = direction;
            this._locale = locale;
            this._agent = agent;
            this._styleSheets = styleSheets;
            this._mode = mode;
            this._accProfile = accessibilityProfile;
        }

        @Override
        public int compare(StyleSheetNode item1, StyleSheetNode item2) {
            int match2;
            if (item1 == item2) {
                return 0;
            }
            int match1 = item1.compareVariants(this._locale, this._direction, this._agent, this._mode, this._accProfile);
            if (match1 == (match2 = item2.compareVariants(this._locale, this._direction, this._agent, this._mode, this._accProfile))) {
                return this._compareOrder(item1, item2);
            }
            if (match1 < match2) {
                return -1;
            }
            return 1;
        }

        private int _compareOrder(Object item1, Object item2) {
            assert (item1 != item2);
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                if (styleSheet == item1) {
                    return -1;
                }
                if (styleSheet != item2) continue;
                return 1;
            }
            assert (false);
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StyleSheetList {
        private Map<String, List<StyleNode>> _nameNodes;
        private Map<String, List<StyleNode>> _selectorNodes;
        private final StyleSheetNode[] _styleSheets;

        public StyleSheetList(StyleSheetNode[] styleSheets) {
            this._styleSheets = styleSheets;
        }

        public boolean isEmpty() {
            return this._styleSheets == null || this._styleSheets.length == 0;
        }

        public void cacheIds() {
            this._nameNodes = new HashMap<String, List<StyleNode>>(256);
            this._selectorNodes = new HashMap<String, List<StyleNode>>(1024);
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                Collection<StyleNode> styleNodeList = styleSheet.getStyles();
                for (StyleNode node : styleNodeList) {
                    if (node.getName() != null) {
                        StyleSheetList._addToMap(this._nameNodes, node, node.getName());
                        continue;
                    }
                    StyleSheetList._addToMap(this._selectorNodes, node, node.getSelector());
                }
            }
        }

        public List<StyleNode> styleNodes(String id, boolean isNamed) {
            Map<String, List<StyleNode>> m;
            if (this._styleSheets == null) {
                return Collections.emptyList();
            }
            Map<String, List<StyleNode>> map = m = isNamed ? this._nameNodes : this._selectorNodes;
            if (m != null) {
                return m.get(id);
            }
            ArrayList<StyleNode> l = new ArrayList<StyleNode>();
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                Collection<StyleNode> styleNodeList = styleSheet.getStyles();
                for (StyleNode node : styleNodeList) {
                    if (isNamed) {
                        if (!id.equals(node.getName())) continue;
                        l.add(node);
                        continue;
                    }
                    if (!id.equals(node.getSelector())) continue;
                    l.add(node);
                }
            }
            return l;
        }

        public List<StyleSheetNode> styleSheets() {
            if (this._styleSheets == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(Arrays.asList(this._styleSheets));
        }

        private static void _addToMap(Map<String, List<StyleNode>> m, StyleNode node, String id) {
            List<StyleNode> l = m.get(id);
            if (l == null) {
                l = new ArrayList<StyleNode>(4);
                m.put(id, l);
            }
            l.add(node);
        }
    }
}

