/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.util.SubKeyMap;
import org.apache.myfaces.trinidadinternal.util.TokenCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageFlowScopeMap
implements Map<String, Object>,
Serializable {
    boolean __invalid;
    private SharedData _sharedData;
    private String _token;
    private HashMap<String, Object> _map;
    private static final String _PAGE_FLOW_SCOPE_CACHE = "org.apache.myfaces.trinidadinternal.application.PageFlowScope";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PageFlowScopeMap.class);

    public static PageFlowScopeMap getPageFlowScopeMap(FacesContext context, String token, int lifetime) {
        TokenCache cache = PageFlowScopeMap._getRootTokenCache(context, lifetime);
        PageFlowScopeMap map = PageFlowScopeMap._getPageFlowScopeMap(context, cache, token);
        if (_LOG.isFine()) {
            _LOG.fine("pageFlowScope: found map {0} at token {1}", new Object[]{map == null ? "null" : map, token});
        }
        if (map == null) {
            return null;
        }
        return new PageFlowScopeMap(map._map, token, map._sharedData);
    }

    private static PageFlowScopeMap _getPageFlowScopeMap(FacesContext context, TokenCache cache, String token) {
        String childToken;
        String parentToken;
        if (token == null) {
            throw new NullPointerException();
        }
        int lastSeparator = token.lastIndexOf(46);
        if (lastSeparator < 0) {
            parentToken = null;
            childToken = token;
        } else {
            parentToken = token.substring(0, lastSeparator);
            childToken = token.substring(lastSeparator + 1);
        }
        Map<String, Object> storeMap = PageFlowScopeMap._createMapToStore(context, parentToken);
        return (PageFlowScopeMap)storeMap.get(childToken);
    }

    public PageFlowScopeMap() {
    }

    public PageFlowScopeMap(int lifetime) {
        this(new HashMap<String, Object>(13), null, new SharedData(lifetime));
    }

    private PageFlowScopeMap(HashMap<String, Object> map, String token, SharedData sharedData) {
        this._map = map;
        this._sharedData = sharedData;
        this._token = token;
    }

    private PageFlowScopeMap(PageFlowScopeMap parent, boolean copyParent) {
        assert (parent != null);
        this._sharedData = new SharedData(parent._sharedData._lifetime);
        this._sharedData._parent = parent;
        this._map = new HashMap();
        if (copyParent) {
            this._map.putAll(parent._map);
        }
    }

    public PageFlowScopeMap getParent() {
        return this._sharedData._parent;
    }

    public synchronized String getToken(FacesContext context) {
        TokenCache cache;
        String parentToken;
        if (this._token != null) {
            return this._token;
        }
        if (this.isEmpty() && this._sharedData._children == null && this._sharedData._parent == null) {
            return null;
        }
        if (this._sharedData._parent != null) {
            parentToken = this._sharedData._parent.getToken(context);
            cache = this._sharedData._parent._getTokenCache();
        } else {
            parentToken = null;
            cache = PageFlowScopeMap._getRootTokenCache(context, this._sharedData._lifetime);
        }
        Map<String, Object> store = PageFlowScopeMap._createMapToStore(context, parentToken);
        String token = cache.addNewEntry(this, store);
        if (parentToken != null) {
            token = parentToken + '.' + token;
        }
        this._token = token;
        if (this._sharedData._children != null) {
            _LOG.fine("Discarding child PageFlowScopes; new token is {0}", (Object)token);
            this._sharedData._children = null;
        }
        return this._token;
    }

    private static Map<String, Object> _createMapToStore(FacesContext context, String parentToken) {
        String fullToken = parentToken == null ? "org.apache.myfaces.trinidadinternal.application.PageFlowScope." : "org.apache.myfaces.trinidadinternal.application.PageFlowScope." + parentToken + '.';
        return new SubKeyMap<Object>(context.getExternalContext().getSessionMap(), fullToken);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PageFlowScopeMap) {
            o = ((PageFlowScopeMap)((Object)o))._map;
        }
        return this._map.equals(o);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this._map.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this._map.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    @Override
    public Object get(Object key) {
        return this._map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        this._detachIfNeeded();
        if (_LOG.isFine()) {
            _LOG.fine("pageFlowScope: put({0}, {1})", new Object[]{key, value});
        }
        return this._map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this._detachIfNeeded();
        if (_LOG.isFine()) {
            _LOG.fine("pageFlowScope: remove({0})", key);
        }
        return this._map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this._detachIfNeeded();
        if (_LOG.isFine()) {
            _LOG.fine("pageFlowScope: putAll({0})", t);
        }
        this._map.putAll(t);
    }

    @Override
    public void clear() {
        this._detachIfNeeded();
        if (_LOG.isFine()) {
            _LOG.fine("pageFlowScope: clear()");
        }
        this._map.clear();
    }

    public PageFlowScopeMap createChild(boolean copyParent) {
        return new PageFlowScopeMap(this, copyParent);
    }

    public void discard() {
        String childToken;
        String parentToken;
        FacesContext context = FacesContext.getCurrentInstance();
        String token = this.getToken(context);
        int lastSeparator = token.lastIndexOf(46);
        if (lastSeparator < 0) {
            parentToken = null;
            childToken = token;
        } else {
            parentToken = token.substring(0, lastSeparator);
            childToken = token.substring(lastSeparator + 1);
        }
        if (this._sharedData._parent != null) {
            Map<String, Object> storeMap = PageFlowScopeMap._createMapToStore(context, parentToken);
            ((SharedData)this._sharedData)._parent._sharedData._children.removeOldEntry(childToken, storeMap);
        }
        this._removeAllChildren(context, token);
    }

    private void _removeAllChildren(FacesContext context, String token) {
        Map<String, Object> store = PageFlowScopeMap._createMapToStore(context, token);
        store.clear();
        this._sharedData._children = null;
    }

    public String toString() {
        return "PageFlowScopeMap@" + System.identityHashCode(this) + "[_map=" + this._map + ", _token=" + this._token + ",_children=" + this._sharedData._children + "]";
    }

    private static TokenCache _getRootTokenCache(FacesContext context, int lifetime) {
        return TokenCache.getTokenCacheFromSession(context, _PAGE_FLOW_SCOPE_CACHE, true, lifetime);
    }

    private TokenCache _getTokenCache() {
        if (this._sharedData._children == null) {
            this._sharedData._children = new TokenCache(this._sharedData._lifetime);
        }
        return this._sharedData._children;
    }

    private void _detachIfNeeded() {
        if (this._token != null) {
            this._map = (HashMap)this._map.clone();
            this._token = null;
        }
    }

    public static class SharedData
    implements Serializable {
        private int _lifetime;
        private PageFlowScopeMap _parent;
        private TokenCache _children;

        public SharedData() {
        }

        public SharedData(int lifetime) {
            this._lifetime = lifetime;
        }
    }
}

