/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ErrorMessages;

class LocaleUtils {
    private static final String _APACHE_TRINIDAD_MESSAGE_BUNDLE = "org.apache.myfaces.trinidad.resource.MessageBundle";
    private static Map<Locale, ResourceBundle> _bundleCache = Collections.synchronizedMap(new HashMap(13));
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(LocaleUtils.class);

    private LocaleUtils() {
    }

    static ErrorMessages __getErrorMessages(FacesContext context, String resourceId) {
        ResourceBundle bundle;
        BundleSummaryInfo info = LocaleUtils._identifyBundleSummaryInfo(context, resourceId);
        String summary = info.getSummary();
        if (summary == null) {
            summary = "???" + resourceId + "???";
        }
        if (null == (bundle = info.getBundle())) {
            throw new NullPointerException(_LOG.getMessage("BUNDLE_NOT_FOUND"));
        }
        String detailKey = LocaleUtils._getDetailKey(resourceId);
        String detail = LocaleUtils._getBundleString(bundle, detailKey);
        if (detail == null) {
            detail = "???" + resourceId + "_detail???";
        }
        return new ErrorMessages(summary, detail);
    }

    static String __getSummaryString(FacesContext context, String messageId) {
        BundleSummaryInfo info = LocaleUtils._identifyBundleSummaryInfo(context, messageId);
        return info.getSummary();
    }

    static String __getDetailString(FacesContext context, String messageId) {
        BundleSummaryInfo info = LocaleUtils._identifyBundleSummaryInfo(context, messageId);
        ResourceBundle bundle = info.getBundle();
        if (null == bundle) {
            throw new NullPointerException(_LOG.getMessage("BUNDLE_NOT_FOUND"));
        }
        String detailKey = LocaleUtils._getDetailKey(messageId);
        return LocaleUtils._getBundleString(bundle, detailKey);
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    private static String _getDetailKey(String messageId) {
        return messageId + "_detail";
    }

    private static BundleSummaryInfo _identifyBundleSummaryInfo(FacesContext context, String resourceId) {
        ClassLoader loader;
        LocaleUtils._assertContextNotNull(context);
        if (resourceId == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_RESOURCEID"));
        }
        Locale locale = LocaleUtils._getLocale(context);
        ResourceBundle bundle = LocaleUtils._getApplicationFacesMessageBundle(context, locale, loader = LocaleUtils._getClassLoader());
        BundleSummaryInfo summary = LocaleUtils._getBundleSummaryInfo(bundle, resourceId);
        if (summary == null && (summary = LocaleUtils._getBundleSummaryInfo(bundle = LocaleUtils._getTrinidadMessageBundle(locale, loader), resourceId)) == null) {
            bundle = LocaleUtils._getDefaultFacesMessageBundle(locale, loader);
            if (bundle == null) {
                throw new NullPointerException(_LOG.getMessage("CANNOT_FIND_DEFAULT_FACESMESSAGE"));
            }
            summary = LocaleUtils._getBundleSummaryInfo(bundle, resourceId);
            if (summary == null) {
                summary = new BundleSummaryInfo(null, "???" + resourceId + "???");
            }
        }
        return summary;
    }

    private static ResourceBundle _getTrinidadMessageBundle(Locale locale, ClassLoader loader) {
        ResourceBundle bundle = LocaleUtils._getCachedBundle(locale);
        if (null == bundle) {
            try {
                bundle = ResourceBundle.getBundle(_APACHE_TRINIDAD_MESSAGE_BUNDLE, locale, loader);
                LocaleUtils._cacheBundle(locale, bundle);
            }
            catch (MissingResourceException missingResource) {
                _LOG.severe("UNABLE_LOAD_MESSAGE_BUNDLE", _APACHE_TRINIDAD_MESSAGE_BUNDLE);
                _LOG.severe(missingResource);
            }
        }
        return bundle;
    }

    private static BundleSummaryInfo _getBundleSummaryInfo(ResourceBundle bundle, String resourceId) {
        String summary;
        assert (resourceId != null);
        if (bundle != null && (summary = LocaleUtils._getBundleString(bundle, resourceId)) != null) {
            return new BundleSummaryInfo(bundle, summary);
        }
        return null;
    }

    private static ResourceBundle _getApplicationFacesMessageBundle(FacesContext context, Locale locale, ClassLoader loader) {
        assert (context != null);
        assert (locale != null);
        assert (loader != null);
        Application application = context.getApplication();
        if (application == null) {
            return null;
        }
        String bundleName = application.getMessageBundle();
        if (bundleName == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(bundleName, locale, loader);
        }
        catch (MissingResourceException missingResource) {
            _LOG.warning("Unable to load faces-config.xml defined message bundle {0}", bundleName);
            _LOG.warning(missingResource);
            return null;
        }
    }

    private static ResourceBundle _getDefaultFacesMessageBundle(Locale locale, ClassLoader loader) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("javax.faces.Messages", locale, loader);
        }
        catch (MissingResourceException missingResource) {
            _LOG.severe("UNABLE_LOAD_FACES_BUNDLE", "javax.faces.Messages");
            _LOG.severe(missingResource);
        }
        return bundle;
    }

    private static Locale _getLocale(FacesContext context) {
        Locale locale = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private static ResourceBundle _getCachedBundle(Locale locale) {
        return _bundleCache.get(locale);
    }

    private static void _cacheBundle(Locale locale, ResourceBundle bundle) {
        _bundleCache.put(locale, bundle);
    }

    private static void _assertContextNotNull(FacesContext context) {
        if (null == context) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT"));
        }
    }

    private static String _getBundleString(ResourceBundle bundle, String key) {
        try {
            Object localeStr = bundle.getObject(key);
            return localeStr == null ? null : localeStr.toString();
        }
        catch (MissingResourceException mre) {
            _LOG.finer("Key {0} not found in {1}", new Object[]{key, bundle});
            return null;
        }
    }

    private static class BundleSummaryInfo {
        private ResourceBundle _bundle;
        private String _summary;

        BundleSummaryInfo(ResourceBundle bundle, String summary) {
            this._bundle = bundle;
            this._summary = summary;
        }

        public ResourceBundle getBundle() {
            return this._bundle;
        }

        public String getSummary() {
            return this._summary;
        }
    }
}

