/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.event.RangeChangeListener;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXSelectRange
extends UIXComponentBase {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey VAR_KEY = TYPE.registerKey("var", String.class, 1);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class, Boolean.FALSE);
    public static final PropertyKey RANGE_CHANGE_LISTENER_KEY = TYPE.registerKey("rangeChangeListener", MethodBinding.class, 9);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value");
    public static final PropertyKey ROWS_KEY = TYPE.registerKey("rows", Integer.class, (Object)25);
    public static final PropertyKey FIRST_KEY = TYPE.registerKey("first", Integer.class, (Object)0);
    public static final String RANGE_LABEL_FACET = "rangeLabel";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.SelectRange";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.SelectRange";
    private transient CollectionModel _dataModel = null;

    public UIXSelectRange() {
        super("org.apache.myfaces.trinidad.ChoiceBar");
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this._flushCachedDataModel();
        super.encodeBegin(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof RangeChangeEvent) {
            RangeChangeEvent gtEvent = (RangeChangeEvent)event;
            this.setFirst(gtEvent.getNewStart());
            this.broadcastToMethodBinding(event, this.getRangeChangeListener());
        }
        super.broadcast(event);
    }

    public void queueEvent(FacesEvent e) {
        if (e instanceof RangeChangeEvent && e.getSource() == this) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.ANY_PHASE);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    public final void setRowIndex(int rowIndex) {
        this._getDataModel().setRowIndex(rowIndex);
    }

    public final int getRowIndex() {
        return this._getDataModel().getRowIndex();
    }

    public final int getRowCount() {
        return this._getDataModel().getRowCount();
    }

    public final boolean isRowAvailable() {
        return this._getDataModel().isRowAvailable();
    }

    public final boolean isRowAvailable(int rowIndex) {
        return this._getDataModel().isRowAvailable(rowIndex);
    }

    public final Object getRowData() {
        CollectionModel model = this._getDataModel();
        return model.isRowAvailable() ? model.getRowData() : null;
    }

    public final Object getRowData(int rowIndex) {
        CollectionModel model = this._getDataModel();
        return model.isRowAvailable(rowIndex) ? model.getRowData(rowIndex) : null;
    }

    private CollectionModel _getDataModel() {
        if (this._dataModel == null) {
            Object value = this.getValue();
            this._dataModel = ModelUtils.toCollectionModel(value);
        }
        return this._dataModel;
    }

    private void _flushCachedDataModel() {
        this._dataModel = null;
    }

    public final UIComponent getRangeLabel() {
        return this.getFacet(RANGE_LABEL_FACET);
    }

    public final void setRangeLabel(UIComponent rangeLabelFacet) {
        this.getFacets().put(RANGE_LABEL_FACET, rangeLabelFacet);
    }

    public final String getVar() {
        return ComponentUtils.resolveString(this.getProperty(VAR_KEY));
    }

    public final void setVar(String var) {
        this.setProperty(VAR_KEY, var);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY), false);
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final MethodBinding getRangeChangeListener() {
        return (MethodBinding)this.getProperty(RANGE_CHANGE_LISTENER_KEY);
    }

    public final void setRangeChangeListener(MethodBinding rangeChangeListener) {
        this.setProperty(RANGE_CHANGE_LISTENER_KEY, rangeChangeListener);
    }

    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final int getRows() {
        return ComponentUtils.resolveInteger(this.getProperty(ROWS_KEY), 25);
    }

    public final void setRows(int rows) {
        this.setProperty(ROWS_KEY, rows);
    }

    public final int getFirst() {
        return ComponentUtils.resolveInteger(this.getProperty(FIRST_KEY), 0);
    }

    public final void setFirst(int first) {
        this.setProperty(FIRST_KEY, first);
    }

    public final void addRangeChangeListener(RangeChangeListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeRangeChangeListener(RangeChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public final RangeChangeListener[] getRangeChangeListeners() {
        return (RangeChangeListener[])this.getFacesListeners(RangeChangeListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.SelectRange";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXSelectRange(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.SelectRange", "org.apache.myfaces.trinidad.ChoiceBar");
    }
}

