/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUISelectItemsFiltered
extends UISelectItems {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private transient String query;
    private transient List<SelectItem> itemList = null;

    public String getQuery() {
        ValueExpression expression = this.getValueExpression("query");
        if (expression != null) {
            try {
                return (String)expression.getValue(FacesContext.getCurrentInstance().getELContext());
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                return null;
            }
        }
        return this.query;
    }

    public void setQuery(String query) {
        ValueExpression expression = this.getValueExpression("query");
        if (expression != null) {
            try {
                expression.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)query);
            }
            catch (Exception e) {
                LOG.error("query='{}'", (Object)query, (Object)e);
            }
        } else {
            this.query = query;
        }
    }

    public abstract Integer getDelay();

    public abstract Integer getMinimumCharacters();

    private List<?> getDeferredSelectedValues(FacesContext facesContext, UIComponent parent) {
        UISelectItems selectItems;
        String deferredSelectedKey = "deferredSelectedClientId";
        String clientId = (String)this.getAttributes().get("deferredSelectedClientId");
        UISelectItems uISelectItems = selectItems = clientId != null ? (UISelectItems)parent.findComponent(clientId) : null;
        if (selectItems != null) {
            return (List)selectItems.getValue();
        }
        UISelectItems selectedItems = (UISelectItems)ComponentUtils.createComponent(facesContext, Tags.selectItems.componentType(), null, null);
        this.getAttributes().put("deferredSelectedClientId", selectedItems.getClientId(facesContext));
        this.copyAttribute(this, selectedItems, "binding");
        this.copyAttribute(this, selectedItems, "itemDisabled");
        this.copyAttribute(this, selectedItems, "itemLabel");
        this.copyAttribute(this, selectedItems, "itemValue");
        this.copyAttribute(this, selectedItems, "var");
        parent.getChildren().add(0, selectedItems);
        selectedItems.setValue(new ArrayList());
        return (List)selectedItems.getValue();
    }

    private void copyAttribute(UISelectItems from, UISelectItems to, String name) {
        ValueExpression fromValueExpression = from.getValueExpression(name);
        if (fromValueExpression != null) {
            to.setValueExpression(name, fromValueExpression);
        } else {
            Object value = from.getAttributes().get(name);
            if (value != null) {
                to.getAttributes().put(name, value);
            }
        }
    }

    public void updateDeferredSelectedItems(FacesContext facesContext, UIComponent parent, Object selectedValue) {
        List<?> deferredSelectedValues = this.getDeferredSelectedValues(facesContext, parent);
        deferredSelectedValues.clear();
        if (selectedValue != null) {
            deferredSelectedValues.add(selectedValue);
        }
    }

    public void updateDeferredSelectedItems(FacesContext facesContext, UIComponent parent, Object[] selectedValues) {
        List<?> deferredSelectedValues = this.getDeferredSelectedValues(facesContext, parent);
        deferredSelectedValues.clear();
        if (selectedValues != null) {
            Collections.addAll(deferredSelectedValues, selectedValues);
        }
    }

    public List<SelectItem> getItemList(FacesContext facesContext, UIComponent parent) {
        if (this.itemList == null) {
            this.itemList = SelectItemUtils.getItemList(facesContext, parent);
            List<?> deferredSelectedValues = this.getDeferredSelectedValues(facesContext, parent);
            ArrayList<SelectItem> duplicateSelectItems = new ArrayList<SelectItem>();
            for (SelectItem selectItem : this.itemList.subList(deferredSelectedValues.size(), this.itemList.size())) {
                if (!deferredSelectedValues.contains(selectItem.getValue())) continue;
                duplicateSelectItems.add(selectItem);
            }
            block1: for (SelectItem duplicateSelectItem : duplicateSelectItems) {
                deferredSelectedValues.remove(duplicateSelectItem.getValue());
                for (SelectItem selectItem : this.itemList) {
                    if (!selectItem.getValue().equals(duplicateSelectItem.getValue())) continue;
                    this.itemList.remove(selectItem);
                    continue block1;
                }
            }
        }
        return this.itemList;
    }

    public List<SelectItem> getFilteredItemList(FacesContext facesContext, UIComponent parent) {
        List<?> deferredSelectedValues = this.getDeferredSelectedValues(facesContext, parent);
        List<SelectItem> allSelectItems = this.getItemList(facesContext, parent);
        return allSelectItems.subList(deferredSelectedValues.size(), allSelectItems.size());
    }
}

