/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIImage;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ImageRenderer<T extends AbstractUIImage>
extends RendererBase<T> {
    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String value = component.getUrl();
        boolean isIcon = Icons.matches(value);
        boolean disabled = ((AbstractUIImage)component).isDisabled() || component.getParent() instanceof AbstractUICommandBase && ((AbstractUICommandBase)component.getParent()).isDisabled();
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        Markup markup = component.getMarkup();
        if (isIcon) {
            writer.startElement(HtmlElements.I);
            writer.writeIdAttribute(component.getClientId(facesContext));
            writer.writeClassAttribute(Icons.custom(value), disabled ? BootstrapClass.DISABLED : null, component.getCustomClass());
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            writer.endElement(HtmlElements.I);
        } else {
            String alt = ((AbstractUIImage)component).getAlt();
            writer.startElement(HtmlElements.TOBAGO_IMAGE);
            writer.writeIdAttribute(component.getClientId(facesContext));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
            writer.writeClassAttribute(disabled ? BootstrapClass.DISABLED : null, component.getCustomClass());
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            writer.startElement(HtmlElements.IMG);
            writer.writeAttribute(HtmlAttributes.SRC, value, true);
            writer.writeAttribute(HtmlAttributes.ALT, alt != null ? alt : "", true);
            writer.endElement(HtmlElements.IMG);
            writer.endElement(HtmlElements.TOBAGO_IMAGE);
        }
    }
}

