/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit;

import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.util.StringUtils;

public class Command {
    private String clientId;
    private String fieldId;
    private Boolean transition;
    private String target;
    private String execute;
    private String render;
    private String confirmation;
    private Integer delay;
    private Collapse collapse;
    private Boolean omit;

    public Command(String clientId, String fieldId, Boolean transition, String target, String execute, String render, String confirmation, Integer delay, Collapse collapse, Boolean omit) {
        this.clientId = clientId;
        this.fieldId = fieldId;
        this.transition = transition != null ? transition : true;
        this.target = target;
        this.setExecute(execute);
        this.setRender(render);
        this.confirmation = confirmation;
        this.delay = delay;
        this.collapse = collapse;
        this.omit = omit;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public Boolean getTransition() {
        return this.transition;
    }

    public void setTransition(Boolean transition) {
        this.transition = transition;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getExecute() {
        return this.execute;
    }

    public void setExecute(String execute) {
        if (StringUtils.isNotBlank(execute)) {
            this.execute = execute;
        }
    }

    public String getRender() {
        return this.render;
    }

    public void setRender(String render) {
        if (StringUtils.isNotBlank(render)) {
            this.render = render;
        }
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Collapse getCollapse() {
        return this.collapse;
    }

    public void setCollapse(Collapse collapse) {
        this.collapse = collapse;
    }

    public Boolean getOmit() {
        return this.omit;
    }

    public void setOmit(Boolean omit) {
        this.omit = omit;
    }

    public void merge(Command c) {
        if (this.clientId == null) {
            this.clientId = c.clientId;
        }
        if (this.fieldId == null) {
            this.fieldId = c.fieldId;
        }
        if (this.transition == null) {
            this.transition = c.transition;
        }
        if (this.target == null) {
            this.target = c.target;
        }
        if (this.execute != null) {
            if (c.execute != null) {
                this.execute = this.execute + " " + c.execute;
            }
        } else {
            this.execute = c.execute;
        }
        if (this.render != null) {
            if (c.render != null) {
                this.render = this.render + " " + c.render;
            }
        } else {
            this.render = c.render;
        }
        if (this.confirmation == null) {
            this.confirmation = c.confirmation;
        }
        if (this.delay == null) {
            this.delay = c.delay;
        }
        if (this.collapse == null) {
            this.collapse = c.collapse;
        }
        if (this.omit == null) {
            this.omit = c.omit;
        }
    }
}

