/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUILinks;
import org.apache.myfaces.tobago.layout.Orientation;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class LinksRenderer<T extends AbstractUILinks>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        boolean insideBar = this.isInside(facesContext, HtmlElements.TOBAGO_BAR);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean autoSpacing = component.getAutoSpacing(facesContext);
        writer.startElement(HtmlElements.TOBAGO_LINKS);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(Orientation.vertical.equals((Object)((AbstractUILinks)component).getOrientation()) ? BootstrapClass.FLEX_COLUMN : null, autoSpacing ? TobagoClass.AUTO__SPACING : null, component.getCustomClass());
        writer.startElement(HtmlElements.UL);
        writer.writeClassAttribute(insideBar ? BootstrapClass.NAVBAR_NAV : BootstrapClass.NAV);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        this.insideBegin(facesContext, HtmlElements.TOBAGO_LINKS);
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement(HtmlElements.LI);
            writer.writeClassAttribute(BootstrapClass.NAV_ITEM);
            child.encodeAll(facesContext);
            writer.endElement(HtmlElements.LI);
        }
        this.insideEnd(facesContext, HtmlElements.TOBAGO_LINKS);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.UL);
        writer.endElement(HtmlElements.TOBAGO_LINKS);
    }
}

