/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Resource {
    private static final Logger LOG = LoggerFactory.getLogger(Resource.class);

    private Resource() {
    }

    public static URL getResourceUrl(FacesContext ctx, String path) throws MalformedURLException {
        ExternalContext externalContext = ctx.getExternalContext();
        URL url = externalContext.getResource(path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resource-Url from external context: " + url);
        }
        if (url == null && Resource.resourceExist(externalContext, path)) {
            url = Resource.getUrlForResourceAsStream(externalContext, path);
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean resourceExist(ExternalContext externalContext, String path) {
        if ("/".equals(path)) {
            return true;
        }
        Object ctx = externalContext.getContext();
        if (!(ctx instanceof ServletContext)) return false;
        ServletContext servletContext = (ServletContext)ctx;
        try (InputStream stream = servletContext.getResourceAsStream(path);){
            boolean bl = stream != null;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static URL getUrlForResourceAsStream(final ExternalContext externalContext, String path) throws MalformedURLException {
        URLStreamHandler handler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                final String file = u.getFile();
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        Object ctx;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Opening internal url to " + file);
                        }
                        if ((ctx = externalContext.getContext()) instanceof ServletContext) {
                            ServletContext servletContext = (ServletContext)ctx;
                            InputStream stream = servletContext.getResourceAsStream(file);
                            if (stream == null) {
                                throw new FileNotFoundException("Cannot open resource " + file);
                            }
                            return stream;
                        }
                        throw new IOException("Cannot open resource for an context of " + (ctx != null ? ctx.getClass() : null));
                    }
                };
            }
        };
        return new URL("internal", null, 0, path, handler);
    }
}

